package com.ejianc.business.othprice.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 材料询价定标-报价记录
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zypms_othprice_picketage_quote")
public class PicketageQuoteEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @TableField(value="picketage_id")
    private Long picketageId; // 主表id
    @TableField(value="inquiry_id")
    private Long inquiryId; // 询价单id
    @TableField(value="quote_id")
    private Long quoteId; // 报价Id
    @TableField(value="quote_time")
    private Date quoteTime; // 报价时间
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商Id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="social_credit_code")
    private String socialCreditCode; // 纳税人识别号
    @TableField(value="legal")
    private String legal; // 联系人
    @TableField(value="telephone")
    private String telephone; // 联系电话
    @TableField(value="purchase_mny")
    private BigDecimal purchaseMny; // 报价总金额
    @TableField(value="quote_memo")
    private String quoteMemo; // 备注
    @TableField(value="quote_phone")
    private String quotePhone; // 报价手机号（登录的手机号）
    @TableField(value="bid_flag")
    private Integer bidFlag; // 是否中标 0-未定标，1-已定标
    @TableField(value="bid_mny")
    private BigDecimal bidMny; // 中标金额
    @TableField(value="bid_memo")
    private String bidMemo; // 中标说明
    @TableField(value="supplier_name_view")
    private String supplierNameView; //  供应商展示名称
    @TableField(value="view_version")
    private String viewVersion; // 方案记录


    @TableField(exist=false)
    @SubEntity(serviceName="picketageQuoteDetailService",pidName = "picketageQuoteId")//此处有pid="xxx"，默认值pid="pid"
    private List<PicketageQuoteDetailEntity> quoteDetailList = new ArrayList<>(); // 报价记录-采购清单

    @TableField(value="purchase_mny_no_tax")
    private BigDecimal purchaseMnyNoTax; // 报价总金额

    public BigDecimal getPurchaseMnyNoTax() {
        return purchaseMnyNoTax;
    }

    public void setPurchaseMnyNoTax(BigDecimal purchaseMnyNoTax) {
        this.purchaseMnyNoTax = purchaseMnyNoTax;
    }

    public String getSupplierNameView() {
        return supplierNameView;
    }

    public void setSupplierNameView(String supplierNameView) {
        this.supplierNameView = supplierNameView;
    }

    public String getViewVersion() {
        return viewVersion;
    }

    public void setViewVersion(String viewVersion) {
        this.viewVersion = viewVersion;
    }

    public Long getPicketageId() {
        return picketageId;
    }

    public void setPicketageId(Long picketageId) {
        this.picketageId = picketageId;
    }

    public Long getInquiryId() {
        return inquiryId;
    }

    public void setInquiryId(Long inquiryId) {
        this.inquiryId = inquiryId;
    }
    public Long getQuoteId() {
        return quoteId;
    }

    public void setQuoteId(Long quoteId) {
        this.quoteId = quoteId;
    }
    public Date getQuoteTime() {
        return quoteTime;
    }

    public void setQuoteTime(Date quoteTime) {
        this.quoteTime = quoteTime;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSocialCreditCode() {
        return socialCreditCode;
    }

    public void setSocialCreditCode(String socialCreditCode) {
        this.socialCreditCode = socialCreditCode;
    }
    public String getLegal() {
        return legal;
    }

    public void setLegal(String legal) {
        this.legal = legal;
    }
    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }
    public BigDecimal getPurchaseMny() {
        return purchaseMny;
    }

    public void setPurchaseMny(BigDecimal purchaseMny) {
        this.purchaseMny = purchaseMny;
    }
    public String getQuoteMemo() {
        return quoteMemo;
    }

    public void setQuoteMemo(String quoteMemo) {
        this.quoteMemo = quoteMemo;
    }
    public String getQuotePhone() {
        return quotePhone;
    }

    public void setQuotePhone(String quotePhone) {
        this.quotePhone = quotePhone;
    }
    public Integer getBidFlag() {
        return bidFlag;
    }

    public void setBidFlag(Integer bidFlag) {
        this.bidFlag = bidFlag;
    }
    public BigDecimal getBidMny() {
        return bidMny;
    }

    public void setBidMny(BigDecimal bidMny) {
        this.bidMny = bidMny;
    }
    public String getBidMemo() {
        return bidMemo;
    }

    public void setBidMemo(String bidMemo) {
        this.bidMemo = bidMemo;
    }

    public List<PicketageQuoteDetailEntity> getQuoteDetailList() {
        return quoteDetailList;
    }

    public void setQuoteDetailList(List<PicketageQuoteDetailEntity> quoteDetailList) {
        this.quoteDetailList = quoteDetailList;
    }


}
