/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.service.impl;

import com.ejianc.business.asset.bean.AssetInDetailEntity;
import com.ejianc.business.asset.bean.AssetInEntity;
import com.ejianc.business.asset.bean.AssetOutDetailEntity;
import com.ejianc.business.asset.bean.AssetOutEntity;
import com.ejianc.business.asset.pub.ReceiveState;
import com.ejianc.business.asset.service.IAssetInService;
import com.ejianc.business.asset.service.IAssetOutService;
import com.ejianc.business.material.pub.MessageUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="assetOut")
public class AssetOutBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    MessageUtil messageUtil;
    @Autowired
    private IAssetOutService assetOutService;
    @Autowired
    private IAssetInService assetInService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "ZY_ASSET_IN";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5ba1\u6279\u901a\u8fc7\u540e\u7684\u56de\u8c03\u5f00\u59cb-------------------");
        AssetOutEntity entity = (AssetOutEntity)((Object)this.assetOutService.selectById(billId));
        AssetInEntity assetInEntity = new AssetInEntity();
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        assetInEntity.setBillCode((String)billCode.getData());
        assetInEntity.setId(IdWorker.getId());
        assetInEntity.setOutId(entity.getId());
        assetInEntity.setOutOrgId(entity.getOrgId());
        assetInEntity.setOutOrgName(entity.getOrgName());
        assetInEntity.setOrgId(entity.getInOrgId());
        assetInEntity.setOrgName(entity.getInOrgName());
        assetInEntity.setOutProjectId(entity.getProjectId());
        assetInEntity.setOutProjectCode(entity.getProjectCode());
        assetInEntity.setOutProjectName(entity.getProjectName());
        assetInEntity.setProjectId(entity.getInProjectId());
        assetInEntity.setProjectName(entity.getInProjectName());
        assetInEntity.setProjectCode(entity.getInProjectCode());
        assetInEntity.setBillState(1);
        assetInEntity.setReceiveDate(entity.getOutDate());
        assetInEntity.setReceivePersonId(entity.getReceivePersonId());
        assetInEntity.setReceivePersonName(entity.getReceivePersonName());
        assetInEntity.setOutDate(entity.getOutDate());
        assetInEntity.setOutMny(entity.getOutMny());
        assetInEntity.setOutDependOnProject(entity.getDependOnProject());
        assetInEntity.setDependOnProject(entity.getInDependOnProject());
        assetInEntity.setReceiveState(ReceiveState.TO_RECEIVING.getCode());
        assetInEntity.setMemo(entity.getMemo());
        entity.setReceiveState(ReceiveState.TO_RECEIVING.getCode());
        List<AssetInDetailEntity> inDetailList = assetInEntity.getDetailList();
        List<AssetOutDetailEntity> outDetailList = entity.getDetailList();
        if (!ListUtil.isEmpty(outDetailList)) {
            outDetailList.forEach(o -> {
                AssetInDetailEntity inDetailEntity = (AssetInDetailEntity)((Object)((Object)BeanMapper.map((Object)o, AssetInDetailEntity.class)));
                inDetailEntity.setId(null);
                inDetailEntity.setVersion(null);
                inDetailEntity.setAssetInId(assetInEntity.getId());
                inDetailList.add(inDetailEntity);
            });
        }
        this.assetInService.saveOrUpdate((Object)assetInEntity, false);
        this.assetOutService.saveOrUpdate((Object)entity, false);
        this.sendMessageToReceivePerson(entity.getReceivePersonId(), assetInEntity.getBillCode(), assetInEntity.getId());
        return CommonResponse.success();
    }

    private void sendMessageToReceivePerson(Long receivePersonId, String billCode, Long id) {
        if (receivePersonId != null) {
            ArrayList<String> messageType = new ArrayList<String>();
            ArrayList<String> receivers = new ArrayList<String>();
            messageType.add("sys");
            receivers.add(receivePersonId.toString());
            String formUrl = this.baseHost + "ejc-zypms-frontend/#/assetIn/card?id=" + id;
            String subject = "\u56fa\u5b9a\u8d44\u4ea7\u8c03\u5165\u63d0\u9192";
            String content = "\u6536\u5230\u56fa\u5b9a\u8d44\u4ea7\u8c03\u5165\u5355\u3010" + billCode + "\u3011\u8bf7\u53ca\u65f6\u5904\u7406\uff01\u3002<a href=" + '\"' + formUrl + '\"' + ">\u7acb\u5373\u5904\u7406</a>";
            this.messageUtil.sendMsg(messageType, receivers, "notice", subject, content);
        }
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        AssetOutEntity entity = (AssetOutEntity)((Object)this.assetOutService.selectById(billId));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u5f53\u524d\u5355\u636e\u4fe1\u606f\uff0c\u65e0\u6cd5\u5f03\u5ba1\uff01");
        }
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            this.logger.info("\u51fa\u5e93\u5355\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u64a4\u56de\u64cd\u4f5c\u6821\u9a8c\u7ed3\u675f\uff0c\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u539f\u56e0\uff1a{}", new Object[]{billId, billTypeCode, resp.getMsg()});
            return CommonResponse.error((String)resp.getMsg());
        }
        return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u56fa\u5b9a\u8d44\u4ea7\u8c03\u5165\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

