package com.ejianc.business.asset.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.asset.bean.AssetOutDetailEntity;
/**
 * 固定资产调出
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zypms_asset_out")
public class AssetOutEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="depend_on_project")
    private Integer dependOnProject; // 是否属于项目: 默认为true
    @TableField(value="project_name")
    private String projectName; // 出库项目名称
    @TableField(value="project_code")
    private String projectCode; // 出库项目编码
    @TableField(value="project_id")
    private Long projectId; // 出库项目id
    @TableField(value="org_id")
    private Long orgId; // 出库组织id
    @TableField(value="org_name")
    private String orgName; // 出库组织名称
    @TableField(value="out_date")
    private Date outDate; // 调出日期
    @TableField(value="out_mny")
    private BigDecimal outMny; // 调出金额
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="make_date")
    private Date makeDate; // 编制日期
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="in_depend_on_project")
    private Integer inDependOnProject; // 是否属于项目: 默认为true
    @TableField(value="in_project_name")
    private String inProjectName; // 调入项目名称
    @TableField(value="in_project_code")
    private String inProjectCode; // 调入项目编码
    @TableField(value="in_project_id")
    private Long inProjectId; // 调入项目id
    @TableField(value="in_org_id")
    private Long inOrgId; // 调入组织id
    @TableField(value="in_org_name")
    private String inOrgName; // 调入组织名称
    @TableField(value="receive_person_id")
    private Long receivePersonId; // 通知接收人
    @TableField(value="receive_person_name")
    private String receivePersonName; // 通知接收人
    @TableField(value="receive_state")
    private String receiveState; // 调入组织收料状态 1-待收料 2-已收料 3-已退回
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="assetOutDetailService", pidName = "assetOutId")
    private List<AssetOutDetailEntity> detailList = new ArrayList<>(); // 固定资产调出-子实体
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(Integer dependOnProject) {
        this.dependOnProject = dependOnProject;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    public BigDecimal getOutMny() {
        return outMny;
    }

    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getInDependOnProject() {
        return inDependOnProject;
    }

    public void setInDependOnProject(Integer inDependOnProject) {
        this.inDependOnProject = inDependOnProject;
    }
    public String getInProjectName() {
        return inProjectName;
    }

    public void setInProjectName(String inProjectName) {
        this.inProjectName = inProjectName;
    }
    public String getInProjectCode() {
        return inProjectCode;
    }

    public void setInProjectCode(String inProjectCode) {
        this.inProjectCode = inProjectCode;
    }
    public Long getInProjectId() {
        return inProjectId;
    }

    public void setInProjectId(Long inProjectId) {
        this.inProjectId = inProjectId;
    }
    public Long getInOrgId() {
        return inOrgId;
    }

    public void setInOrgId(Long inOrgId) {
        this.inOrgId = inOrgId;
    }
    public String getInOrgName() {
        return inOrgName;
    }

    public void setInOrgName(String inOrgName) {
        this.inOrgName = inOrgName;
    }
    public Long getReceivePersonId() {
        return receivePersonId;
    }

    public void setReceivePersonId(Long receivePersonId) {
        this.receivePersonId = receivePersonId;
    }
    public String getReceivePersonName() {
        return receivePersonName;
    }

    public void setReceivePersonName(String receivePersonName) {
        this.receivePersonName = receivePersonName;
    }
    public String getReceiveState() {
        return receiveState;
    }

    public void setReceiveState(String receiveState) {
        this.receiveState = receiveState;
    }

    public List<AssetOutDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<AssetOutDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
