package com.ejianc.business.othprice.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;


/**
 * 其他询价-询价清单
 * 
 * @author generator
 * 
 */
@ApiModel("其他询价-询价清单")
public class OtherInquiryDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long inquiryId; // 询价id
    private String detailCode; // 编码
    private String detailName; // 名称
    private String spec; // 规格型号/特征
    private String unit; // 计量单位
    private BigDecimal num; // 数量
    private BigDecimal referPrice; // 参考价
    private BigDecimal mny; // 金额
    private String memo; // 备注
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planUseDate; // 计划使用日期
    private Long sourceId; // 来源id
    private Integer sourceType; // 物资来源类型：1-新增，2-导入

   // 针对于这个材料各个供应商报价数据
    List<OtherQuoteDetailVO> otherQuoteDetailVOList;


    //报价最小值
    private BigDecimal  minBidPrice;

    //报价最大值
    private BigDecimal  maxBidPrice;

    /**
     * 询价id
     */
    public Long getInquiryId() {
        return inquiryId;
    }

    /**
     * 询价id
     */
    public void setInquiryId(Long inquiryId) {
        this.inquiryId = inquiryId;
    }


    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 数量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }
    /**
     * 参考价
     */
    public BigDecimal getReferPrice() {
        return referPrice;
    }

    /**
     * 参考价
     */
    public void setReferPrice(BigDecimal referPrice) {
        this.referPrice = referPrice;
    }
    /**
     * 金额
     */
    public BigDecimal getMny() {
        return mny;
    }

    /**
     * 金额
     */
    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 计划使用日期
     */
    public Date getPlanUseDate() {
        return planUseDate;
    }

    /**
     * 计划使用日期
     */
    public void setPlanUseDate(Date planUseDate) {
        this.planUseDate = planUseDate;
    }

    public String getDetailCode() {
        return detailCode;
    }

    public void setDetailCode(String detailCode) {
        this.detailCode = detailCode;
    }

    public String getDetailName() {
        return detailName;
    }

    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public BigDecimal getMinBidPrice() {
        return minBidPrice;
    }

    public void setMinBidPrice(BigDecimal minBidPrice) {
        this.minBidPrice = minBidPrice;
    }

    public BigDecimal getMaxBidPrice() {
        return maxBidPrice;
    }

    public void setMaxBidPrice(BigDecimal maxBidPrice) {
        this.maxBidPrice = maxBidPrice;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public List<OtherQuoteDetailVO> getOtherQuoteDetailVOList() {
        return otherQuoteDetailVOList;
    }

    public void setOtherQuoteDetailVOList(List<OtherQuoteDetailVO> otherQuoteDetailVOList) {
        this.otherQuoteDetailVOList = otherQuoteDetailVOList;
    }
}
