/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.other.bean.OtherContractChangeEntity;
import com.ejianc.business.other.bean.OtherContractClauseChangeEntity;
import com.ejianc.business.other.bean.OtherContractDetailChangeEntity;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.OtherContractPayPlanChangeEntity;
import com.ejianc.business.other.mapper.OtherContractChangeMapper;
import com.ejianc.business.other.mapper.OtherContractMapper;
import com.ejianc.business.other.service.IOtherContractChangeService;
import com.ejianc.business.other.service.IOtherContractClauseChangeService;
import com.ejianc.business.other.service.IOtherContractDetailChangeService;
import com.ejianc.business.other.service.IOtherContractPayPlanChangeService;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.utils.ComputeUtil;
import com.ejianc.business.other.vo.ChangeHistoryVO;
import com.ejianc.business.other.vo.OtherContractChangeVO;
import com.ejianc.business.other.vo.OtherContractClauseChangeVO;
import com.ejianc.business.other.vo.OtherContractDetailChangeVO;
import com.ejianc.business.other.vo.OtherContractDetailVO;
import com.ejianc.business.other.vo.OtherContractPayPlanChangeVO;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.business.other.vo.ParamsCheckDsVO;
import com.ejianc.business.other.vo.ParamsCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="otherContractChangeService")
public class OtherContractChangeServiceImpl
extends BaseServiceImpl<OtherContractChangeMapper, OtherContractChangeEntity>
implements IOtherContractChangeService {
    private static final String BILL_CODE = "OTHER_CONTRACT_CHANGE";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PARAM_TOTAL_MNY = "P-6zD11147";
    @Autowired
    private IOtherContractService contractService;
    @Autowired
    private IOtherContractDetailChangeService detailChangeService;
    @Autowired
    private IOtherContractPayPlanChangeService payPlanChangeService;
    @Autowired
    private IOtherContractClauseChangeService clauseChangeService;
    @Autowired
    private IOtherContractChangeService changeService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String SGHTZJE_K_SJZCJE = "P-nkX4Sk61";
    @Autowired
    private OtherContractMapper otherContractMapper;

    @Override
    public CommonResponse<OtherContractChangeVO> saveOrUpdate(OtherContractChangeVO changeVo) {
        List entities;
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        OtherContractChangeEntity entity = null;
        String operateType = null;
        if (changeVo.getId() != null && changeVo.getId() > 0L && this.changeService.getById(changeVo.getId()) != null) {
            if (StringUtils.isEmpty((CharSequence)changeVo.getBillCode())) {
                changeVo.setBillCode(null);
            }
            entity = (OtherContractChangeEntity)((Object)BeanMapper.map((Object)((Object)changeVo), OtherContractChangeEntity.class));
            operateType = "edit";
        } else {
            if (null == changeVo.getChangeVersion() || changeVo.getChangeVersion() == 0) {
                changeVo.setChangeVersion(1);
            } else {
                changeVo.setChangeVersion(changeVo.getChangeVersion() + 1);
            }
            if (2 == changeVo.getChangeStatus()) {
                throw new BusinessException("\u5408\u540c\u5b58\u5728\u53d8\u66f4\u4e2d\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            if (StringUtils.isEmpty((CharSequence)changeVo.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
                if (billCode.isSuccess()) {
                    changeVo.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity = (OtherContractChangeEntity)((Object)BeanMapper.map((Object)((Object)changeVo), OtherContractChangeEntity.class));
            operateType = "add";
        }
        if (changeVo.getId() != null && changeVo.getId() > 0L && this.changeService.getById(changeVo.getId()) != null) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(OtherContractChangeEntity::getBillCode, (Object)changeVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)changeVo.getId());
            lambda.ne(OtherContractChangeEntity::getContractId, (Object)changeVo.getContractId());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(OtherContractChangeEntity::getBillCode, (Object)changeVo.getBillCode());
            lambda.ne(OtherContractChangeEntity::getContractId, (Object)changeVo.getContractId());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
        queryParam.getParams().put("bill_code", new Parameter("eq", (Object)changeVo.getBillCode()));
        queryParam.getParams().put("id", new Parameter("ne", (Object)changeVo.getContractId()));
        List entitiesc = this.contractService.queryList(queryParam, false);
        if (entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        super.saveOrUpdate((Object)entity);
        this.saveChildren(changeVo, entity.getId(), operateType);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(OtherContractEntity::getChangingTaxMny, (Object)changeVo.getContractTaxMny());
        updateWrapper.set(OtherContractEntity::getChangingMny, (Object)changeVo.getContractMny());
        updateWrapper.set(OtherContractEntity::getChangeId, (Object)entity.getId());
        updateWrapper.set(OtherContractEntity::getChangeStatus, (Object)2);
        updateWrapper.set(OtherContractEntity::getChangeCode, (Object)entity.getBillCode());
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getContractId());
        this.contractService.update((Wrapper)updateWrapper);
        return CommonResponse.success((Object)((Object)this.queryDetail(entity.getId())));
    }

    @Override
    public void deleteChange(List<OtherContractChangeVO> vos) {
        for (OtherContractChangeVO vo : vos) {
            OtherContractChangeEntity changeEntity = (OtherContractChangeEntity)((Object)super.selectById((Serializable)vo.getId()));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(OtherContractEntity::getChangingTaxMny, (Object)BigDecimal.ZERO);
            updateWrapper.set(OtherContractEntity::getChangingMny, (Object)BigDecimal.ZERO);
            if (changeEntity.getChangeVersion() == 1) {
                updateWrapper.set(OtherContractEntity::getChangeStatus, (Object)1);
            } else {
                updateWrapper.set(OtherContractEntity::getChangeStatus, (Object)3);
            }
            updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getContractId());
            this.contractService.update((Wrapper)updateWrapper);
            super.removeById((Serializable)((Object)vo), false);
        }
    }

    @Override
    public ChangeHistoryVO queryChangeHistory(Long id) {
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        List changeEntities = this.changeService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)id)).in((Object)"bill_state", billStatus)).orderByDesc((Object)"used_time"));
        OtherContractEntity contractEntity = (OtherContractEntity)((Object)this.contractService.selectById(id));
        ChangeHistoryVO vo = new ChangeHistoryVO();
        vo.setIsFinish(contractEntity.getIsFinish());
        vo.setChangeStatus(contractEntity.getChangeStatus());
        vo.setSupplementFlag(0);
        vo.setContractStatus(contractEntity.getContractStatus());
        vo.setContractId(id);
        vo.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());
        vo.setBaseTaxMoney(contractEntity.getBaseTaxMoney() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMoney());
        BigDecimal changeMny = vo.getContractTaxMny().subtract(vo.getBaseTaxMoney());
        vo.setSumChangeMny(changeMny);
        BigDecimal sumChangeRate = BigDecimal.ZERO;
        if (vo.getBaseTaxMoney().compareTo(BigDecimal.ZERO) != 0) {
            sumChangeRate = changeMny.divide(vo.getBaseTaxMoney(), 8, 4).multiply(new BigDecimal(100));
        }
        vo.setSumScale(sumChangeRate);
        if (null != changeEntities && changeEntities.size() > 0) {
            List changeVos = BeanMapper.mapList((Iterable)changeEntities, OtherContractChangeVO.class);
            for (OtherContractChangeVO cvo : changeVos) {
                String changeTime = new SimpleDateFormat("yyyyMMdd").format(cvo.getChangeTime());
                String historyBillCode = cvo.getBeforeContractName() + "-" + changeTime + "-" + cvo.getChangeVersion();
                cvo.setHistoryBillCode(historyBillCode);
                BigDecimal subtract = ComputeUtil.safeSub(cvo.getContractTaxMny(), cvo.getBeforeChangeTaxMny());
                BigDecimal changeRate = BigDecimal.ZERO;
                if (cvo.getBeforeChangeTaxMny() != null && cvo.getBeforeChangeTaxMny().compareTo(BigDecimal.ZERO) != 0) {
                    changeRate = ComputeUtil.safeDiv(subtract, cvo.getBeforeChangeTaxMny()).setScale(8, 4).multiply(new BigDecimal(100));
                }
                cvo.setScale(changeRate);
            }
            vo.setChangeRecord(changeVos);
        }
        return vo;
    }

    private void saveChildren(OtherContractChangeVO changeVo, Long changeId, String operateType) {
        List<OtherContractDetailChangeVO> detailVos = changeVo.getDetailVos();
        List<OtherContractPayPlanChangeVO> payPlanVos = changeVo.getPayPlanVos();
        List<OtherContractClauseChangeVO> clauseVos = changeVo.getClauseVos();
        List<BaseEntity> detailSave = new ArrayList();
        ArrayList<Object> payPlanSave = new ArrayList<Object>();
        ArrayList<Object> clauseSave = new ArrayList<Object>();
        ArrayList<Long> detailDel = new ArrayList<Long>();
        ArrayList<Long> payPlanDel = new ArrayList<Long>();
        ArrayList<Long> clauseDel = new ArrayList<Long>();
        if (operateType.equals("add")) {
            if (detailVos != null && detailVos.size() > 0) {
                for (OtherContractDetailChangeVO otherContractDetailChangeVO : detailVos) {
                    otherContractDetailChangeVO.setId(null);
                    otherContractDetailChangeVO.setChangeId(changeId);
                }
                detailSave = BeanMapper.mapList(detailVos, OtherContractDetailChangeEntity.class);
            }
            if (payPlanVos != null && payPlanVos.size() > 0) {
                for (OtherContractPayPlanChangeVO otherContractPayPlanChangeVO : payPlanVos) {
                    if ("del".equals(otherContractPayPlanChangeVO.getRowState())) continue;
                    otherContractPayPlanChangeVO.setId(null);
                    otherContractPayPlanChangeVO.setChangeId(changeId);
                    payPlanSave.add(BeanMapper.map((Object)((Object)otherContractPayPlanChangeVO), OtherContractPayPlanChangeEntity.class));
                }
            }
            if (clauseVos != null && clauseVos.size() > 0) {
                for (OtherContractClauseChangeVO otherContractClauseChangeVO : clauseVos) {
                    if ("del".equals(otherContractClauseChangeVO.getRowState())) continue;
                    otherContractClauseChangeVO.setId(null);
                    otherContractClauseChangeVO.setChangeId(changeId);
                    clauseSave.add(BeanMapper.map((Object)((Object)otherContractClauseChangeVO), OtherContractClauseChangeEntity.class));
                }
            }
        } else {
            BaseEntity map;
            if (detailVos != null && detailVos.size() > 0) {
                for (OtherContractDetailChangeVO otherContractDetailChangeVO : detailVos) {
                    if ("del".equals(otherContractDetailChangeVO.getRowState())) {
                        detailDel.add(otherContractDetailChangeVO.getId());
                        continue;
                    }
                    if ("add".equals(otherContractDetailChangeVO.getRowState())) {
                        otherContractDetailChangeVO.setId(null);
                        otherContractDetailChangeVO.setChangeId(changeId);
                        map = (OtherContractDetailChangeEntity)((Object)BeanMapper.map((Object)((Object)otherContractDetailChangeVO), OtherContractDetailChangeEntity.class));
                        detailSave.add(map);
                        continue;
                    }
                    if (!"edit".equals(otherContractDetailChangeVO.getRowState())) continue;
                    map = (OtherContractDetailChangeEntity)((Object)BeanMapper.map((Object)((Object)otherContractDetailChangeVO), OtherContractDetailChangeEntity.class));
                    detailSave.add(map);
                }
            }
            if (payPlanVos != null && payPlanVos.size() > 0) {
                for (OtherContractPayPlanChangeVO otherContractPayPlanChangeVO : payPlanVos) {
                    if ("del".equals(otherContractPayPlanChangeVO.getRowState())) {
                        payPlanDel.add(otherContractPayPlanChangeVO.getId());
                        continue;
                    }
                    if ("add".equals(otherContractPayPlanChangeVO.getRowState())) {
                        otherContractPayPlanChangeVO.setId(null);
                        otherContractPayPlanChangeVO.setChangeId(changeId);
                        map = (OtherContractPayPlanChangeEntity)((Object)BeanMapper.map((Object)((Object)otherContractPayPlanChangeVO), OtherContractPayPlanChangeEntity.class));
                        payPlanSave.add(map);
                        continue;
                    }
                    if (!"edit".equals(otherContractPayPlanChangeVO.getRowState())) continue;
                    map = (OtherContractPayPlanChangeEntity)((Object)BeanMapper.map((Object)((Object)otherContractPayPlanChangeVO), OtherContractPayPlanChangeEntity.class));
                    payPlanSave.add(map);
                }
            }
            if (clauseVos != null && clauseVos.size() > 0) {
                for (OtherContractClauseChangeVO otherContractClauseChangeVO : clauseVos) {
                    if ("del".equals(otherContractClauseChangeVO.getRowState())) {
                        clauseDel.add(otherContractClauseChangeVO.getId());
                        continue;
                    }
                    if ("add".equals(otherContractClauseChangeVO.getRowState())) {
                        otherContractClauseChangeVO.setId(null);
                        otherContractClauseChangeVO.setChangeId(changeId);
                        map = (OtherContractClauseChangeEntity)((Object)BeanMapper.map((Object)((Object)otherContractClauseChangeVO), OtherContractClauseChangeEntity.class));
                        clauseSave.add(map);
                        continue;
                    }
                    if (!"edit".equals(otherContractClauseChangeVO.getRowState())) continue;
                    map = (OtherContractClauseChangeEntity)((Object)BeanMapper.map((Object)((Object)otherContractClauseChangeVO), OtherContractClauseChangeEntity.class));
                    clauseSave.add(map);
                }
            }
        }
        if (detailSave.size() > 0) {
            this.detailChangeService.saveOrUpdateBatch(detailSave);
        }
        if (payPlanSave.size() > 0) {
            this.payPlanChangeService.saveOrUpdateBatch(payPlanSave);
        }
        if (clauseSave.size() > 0) {
            this.clauseChangeService.saveOrUpdateBatch(clauseSave);
        }
        if (detailDel.size() > 0) {
            this.detailChangeService.removeByIds(detailDel);
        }
        if (payPlanDel.size() > 0) {
            this.payPlanChangeService.removeByIds(payPlanDel);
        }
        if (clauseDel.size() > 0) {
            this.clauseChangeService.removeByIds(clauseDel);
        }
    }

    @Override
    public OtherContractChangeVO queryDetail(Long id) {
        OtherContractChangeEntity entity = (OtherContractChangeEntity)((Object)super.selectById((Serializable)id));
        OtherContractChangeVO changeVo = (OtherContractChangeVO)((Object)BeanMapper.map((Object)((Object)entity), OtherContractChangeVO.class));
        return changeVo;
    }

    @Override
    public OtherContractVO queryDetailChange(Long id) {
        OtherContractEntity entity = (OtherContractEntity)((Object)this.contractService.selectById(id));
        if (entity != null) {
            OtherContractVO contractVo = (OtherContractVO)((Object)BeanMapper.map((Object)((Object)entity), OtherContractVO.class));
            contractVo.setBeforeChangeTaxMny(entity.getContractTaxMny());
            contractVo.setBillState(null);
            contractVo.setCreateUserCode(null);
            contractVo.setCreateTime(null);
            contractVo.setUpdateUserCode(null);
            contractVo.setUpdateTime(null);
            contractVo.setChangeReason(null);
            List<OtherContractDetailVO> detailVos = contractVo.getDetailVos();
            if (detailVos != null && detailVos.size() > 0) {
                Iterator<OtherContractDetailVO> iterator = detailVos.iterator();
                while (iterator.hasNext()) {
                    OtherContractDetailVO next = iterator.next();
                    if (next.getChangeType() == null || next.getChangeType() != 5) continue;
                    iterator.remove();
                }
            }
            contractVo.setDetailVos(detailVos);
            contractVo.setId(IdWorker.getId());
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id), "BT210916000000001", "otherContractBill", String.valueOf(contractVo.getId()), "BT210916000000002", "otherContractChangeBill");
            return contractVo;
        }
        return null;
    }

    public BigDecimal totalContractMny(OtherContractChangeVO vo) {
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        QueryWrapper contractQuery = new QueryWrapper();
        contractQuery.eq((Object)"project_Id", (Object)vo.getProjectId());
        if (vo.getContractId() != null) {
            contractQuery.ne((Object)"id", (Object)vo.getContractId());
        }
        if (vo.getContractTaxMny() != null) {
            contractTaxMny = contractTaxMny.add(vo.getContractTaxMny());
        }
        contractQuery.ne((Object)"change_status", (Object)2);
        contractQuery.select(new String[]{"sum(contract_tax_mny) as contractTaxMny"});
        OtherContractEntity contractEntity = (OtherContractEntity)((Object)this.contractService.getOne((Wrapper)contractQuery));
        if (contractEntity != null && null != contractEntity.getContractTaxMny() && !"0".equals(contractEntity.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(contractEntity.getContractTaxMny());
        }
        QueryWrapper changeQuery = new QueryWrapper();
        changeQuery.eq((Object)"project_Id", (Object)vo.getProjectId());
        changeQuery.in((Object)"bill_state", Arrays.asList(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
        if (vo.getId() != null) {
            changeQuery.ne((Object)"id", (Object)vo.getId());
        }
        changeQuery.select(new String[]{"sum(contract_tax_mny) as contractTaxMny"});
        OtherContractChangeEntity changeEntity = (OtherContractChangeEntity)((Object)this.changeService.getOne((Wrapper)changeQuery));
        if (changeEntity != null && null != changeEntity.getContractTaxMny() && !"0".equals(changeEntity.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(changeEntity.getContractTaxMny());
        }
        return contractTaxMny;
    }

    @Override
    public ParamsCheckVO checkParams(OtherContractChangeVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap paramsCheckVOMap = new HashMap();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            paramsCheckVO.setWarnType("none");
            paramsCheckVO.setDataSource(null);
        }
        return paramsCheckVO;
    }

    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }
}

