package com.ejianc.business.sub.vo;

import com.ejianc.business.sub.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 分包变更明细表
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
public class SubChangeDetailVO extends BaseVO implements ITreeNodeB{

    private static final long serialVersionUID = 1L;

    /**
     * 变更主键
     */
    private Long changeId;

    /**
     * 合同ID
     */
    private Long contractId;

    /**
     * 合同子表ID
     */
    private Long srcBid;

    /**
     * 序号
     */
    private String treeIndex;

    /**
     * 清单编码
     */
    private String code;

    /**
     * 清单名称
     */
    private String name;

    /**
     * 计量单位
     */
    private String unit;

    /**
     * 工程量
     */
    private BigDecimal num;

    /**
     * 综合单价
     */
    private BigDecimal price;

    /**
     * 合价
     */
    private BigDecimal money;

    /**
     * 变更前工程量
     */
    private BigDecimal beforeChangeNum;

    /**
     * 变更前综合单价
     */
    private BigDecimal beforeChangePrice;

    /**
     * 变更前合计
     */
    private BigDecimal beforeChangeMny;

    /**
     * 备注
     */
    private String memo;

    /**
     * 父ID
     */
    private Long parentId;

    /**
     * 是否末级
     */
    private Boolean leafFlag;

    /**
     * 变更类型
     */
    private Integer changeType;
    /**
     * 结算类型 1结算 0没有结算
     */
    private Integer settleType;
    /**
     *结算数量
     */
    private BigDecimal settleNum;

    /**
     * 项目预算ID
     */
    private Long budgetId;

    /**
     * 预算明细ID
     */
    private Long budgetDetailId;

    /**
     * 来源类型(1:新增，2:导入，3:专业预算，4:项目预算)
     */
    private Integer sourceType;

    private String tid;
    private String tpid;
    //错误类型
    private String warnType;
    private List<ITreeNodeB> children;
    private String spec;//特征

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }
    private BigDecimal projectTaskPrice;

    public BigDecimal getProjectTaskPrice() {
        return projectTaskPrice;
    }

    public void setProjectTaskPrice(BigDecimal projectTaskPrice) {
        this.projectTaskPrice = projectTaskPrice;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getSrcBid() {
        return srcBid;
    }

    public void setSrcBid(Long srcBid) {
        this.srcBid = srcBid;
    }

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    public BigDecimal getBeforeChangeNum() {
        return beforeChangeNum;
    }

    public void setBeforeChangeNum(BigDecimal beforeChangeNum) {
        this.beforeChangeNum = beforeChangeNum;
    }
    public BigDecimal getBeforeChangePrice() {
        return beforeChangePrice;
    }

    public void setBeforeChangePrice(BigDecimal beforeChangePrice) {
        this.beforeChangePrice = beforeChangePrice;
    }
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }
    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public Long getBudgetId() {
        return budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public Long getBudgetDetailId() {
        return budgetDetailId;
    }

    public void setBudgetDetailId(Long budgetDetailId) {
        this.budgetDetailId = budgetDetailId;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }

    public Integer getSettleType() {
        return settleType;
    }

    public void setSettleType(Integer settleType) {
        this.settleType = settleType;
    }

    public BigDecimal getSettleNum() {
        return settleNum;
    }

    public void setSettleNum(BigDecimal settleNum) {
        this.settleNum = settleNum;
    }
}
