package com.ejianc.business.bidprice.material.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bidprice.common.vo.InquiryCommonVO;
import com.ejianc.business.bidprice.consts.InquiryStateEnum;
import com.ejianc.business.bidprice.material.bean.*;
import com.ejianc.business.bidprice.material.mapper.MaterialPicketageMapper;
import com.ejianc.business.bidprice.material.service.*;
import com.ejianc.business.bidprice.material.vo.*;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.utils.DateUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

/**
 * 材料定标
 *
 * @author generator
 *
 */
@Service("materialPicketageService")
public class MaterialPicketageServiceImpl extends BaseServiceImpl<MaterialPicketageMapper, MaterialPicketageEntity> implements IMaterialPicketageService{

    private static final Logger logger = LoggerFactory.getLogger(MaterialQuoteServiceImpl.class);
    private static final String DEFAULT_TEMPLATE_CODE = "SMS_273725524";
    private static final String TEMPLATE_CODE = "templateCode";
    @Autowired
    private IMaterialPicketageSupplierService supplierService;
    @Autowired
    private IMaterialPicketageService service;
    @Autowired
    private IMaterialResultService materialResultService;
    @Autowired
    private IMaterialInquiryService inquiryService;
    @Autowired
    private IMaterialPicketageSupplierService materialPicketageSupplierService;
    @Autowired
    private InquiryCommonService inquiryCommonService;
    @Autowired
    private IMaterialContractService iMaterialContractService;

    @Autowired
    private IPicketageQuotePurchaseDetailService purchaseDetailService;
    @Autowired
    private IPicketageQuoteRentDetailService rentDetailService;

    @Autowired
    private IMaterialResultPurchaseDetailService resultPurchaseDetailService;
    @Autowired
    private IMaterialResultRentDetailService resultRentDetailService;
    @Autowired
    private EnvironmentTools environmentTools;

    @Autowired
    private IMaterialPicketageQuoteService quoteService;
    @Override
    public boolean insertOrUpdate(MaterialPicketageEntity entity) {
        List<MaterialPicketageSupplierEntity> supplierEntities  = new ArrayList<>();
        List<MaterialPicketageSupplierEntity> supplierList = new ArrayList<>();
        Boolean success = super.saveOrUpdate(entity,false);
        if(success){
            if(!ListUtil.isEmpty(entity.getMaterialPicketagePurchaseDetailList()) || !ListUtil.isEmpty(entity.getMaterialPicketageRentDetailList()) ){
                entity.getMaterialPicketagePurchaseDetailList().forEach(sub->{
                    supplierList.addAll(sub.getMaterialPicketageSupplierList());
                });
                if (entity.getPricingType()==1){
                    List<MaterialPicketagePurchaseDetailEntity> purchaseList = entity.getMaterialPicketagePurchaseDetailList();
                    List<Long> ids = purchaseList.stream().map(MaterialPicketagePurchaseDetailEntity::getId).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(ids)){
                        QueryParam param = new QueryParam();
                        param.getParams().put("picketageDetailId",new Parameter(QueryParam.IN,ids));
                        List<MaterialPicketageSupplierEntity> suppliers = supplierService.queryList(param,false);
                        if(!ListUtil.isEmpty(suppliers)){
                            supplierService.removeByIds(suppliers.stream().map(MaterialPicketageSupplierEntity::getId).collect(Collectors.toList()),false);
                        }
                        purchaseList.forEach(sub-> {
                            sub.getMaterialPicketageSupplierList().forEach(supplier-> {
                                supplier.setPicketageId(entity.getId());
                                supplier.setPicketageDetailId(sub.getId());
                                supplierEntities.add(supplier);
                            });
                        });
                    }
                }else {
                    List<MaterialPicketageRentDetailEntity> rentList = entity.getMaterialPicketageRentDetailList();
                    List<Long> ids = rentList.stream().map(MaterialPicketageRentDetailEntity::getId).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(ids)){
                        QueryParam param = new QueryParam();
                        param.getParams().put("picketageDetailId",new Parameter(QueryParam.IN,ids));
                        List<MaterialPicketageSupplierEntity> suppliers = supplierService.queryList(param,false);
                        if(!ListUtil.isEmpty(suppliers)){
                            supplierService.removeByIds(suppliers.stream().map(MaterialPicketageSupplierEntity::getId).collect(Collectors.toList()),false);
                        }
                        rentList.forEach(sub-> {
                            sub.getMaterialPicketageSupplierList().forEach(supplier-> {
                                supplier.setPicketageId(entity.getId());
                                supplier.setPicketageDetailId(sub.getId());
                                supplierEntities.add(supplier);
                            });
                        });
                    }
                }
                if (CollectionUtils.isNotEmpty(supplierEntities)){
                    supplierService.saveOrUpdateBatch(supplierEntities,supplierEntities.size());
                }
            }
        }
        return true;
    }

    @Override
    public void  checkRefSave(MaterialPicketageEntity entity){
        QueryWrapper<MaterialPicketageEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("inquiry_id",entity.getInquiryId());
        if (entity.getId()!=null){
            queryWrapper.ne("id",entity.getId());
        }
        int count = super.count(queryWrapper);
        if (count>0){
            throw new BusinessException("一个询价申请单只能有一个自由态的定标单！");
        }
    }
    @Override
    public boolean insertOrUpdateRef(MaterialPicketageEntity entity) {
        if (!ListUtil.isEmpty(entity.getMaterialPicketageQuoteList())){
            List<Long> collect = entity.getMaterialPicketageQuoteList().stream().filter(e->(e.getBidFlag()==1)).map(MaterialPicketageQuoteEntity::getSupplierId).collect(toList());
            String bidWinnerIdStr = collect.stream().map(String::valueOf).collect(joining(","));
            List<String> nameList = entity.getMaterialPicketageQuoteList().stream().filter(e->(e.getBidFlag()==1)).map(MaterialPicketageQuoteEntity::getSupplierNameView).collect(toList());
            String bidWinnerNameStr = nameList.stream().map(String::valueOf).collect(joining(","));
            entity.setBidWinnerId(bidWinnerIdStr);
            entity.setBidWinnerName(bidWinnerNameStr);
        }
        Boolean success = super.saveOrUpdate(entity,false);
        if (success){
            //清楚孙表
            QueryWrapper<PicketageQuotePurchaseDetailEntity> purchaseWrapper  = new QueryWrapper<>();
            purchaseWrapper.eq("picketage_id",entity.getId());
            List<PicketageQuotePurchaseDetailEntity> delPurchaseList = purchaseDetailService.list(purchaseWrapper);
            if (CollectionUtils.isNotEmpty(delPurchaseList)){
                purchaseDetailService.removeByIds(delPurchaseList.stream().map(PicketageQuotePurchaseDetailEntity::getId).collect(Collectors.toList()),false);

            }
            QueryWrapper<PicketageQuoteRentDetailEntity> rentWrapper  = new QueryWrapper<>();
            rentWrapper.eq("picketage_id",entity.getId());
            List<PicketageQuoteRentDetailEntity> delRentList = rentDetailService.list(rentWrapper);
            if (CollectionUtils.isNotEmpty(delRentList)){
                rentDetailService.removeByIds(delRentList.stream().map(PicketageQuoteRentDetailEntity::getId).collect(Collectors.toList()),false);
            }

            if (CollectionUtils.isNotEmpty(entity.getMaterialPicketageQuoteList())){
                List<PicketageQuotePurchaseDetailEntity> savePurchaseDetail = new ArrayList<>();
                List<PicketageQuoteRentDetailEntity> saveRentDetail = new ArrayList<>();

                //报价记录
                List<MaterialPicketageQuoteEntity> quoteList = entity.getMaterialPicketageQuoteList();
                //保存报价记录子表
                for (MaterialPicketageQuoteEntity quote:quoteList){
                    if (CollectionUtils.isNotEmpty(quote.getPurchaseDetailList())){
                        for (PicketageQuotePurchaseDetailEntity detail:quote.getPurchaseDetailList()){
                            detail.setPicketageQuoteId(quote.getId());
                            detail.setPicketageId(entity.getId());
                            detail.setId(IdWorker.getId());
                        }
                        savePurchaseDetail.addAll(quote.getPurchaseDetailList());
                    }
                    if (CollectionUtils.isNotEmpty(quote.getRentDetailList())){
                        for (PicketageQuoteRentDetailEntity detail:quote.getRentDetailList()){
                            detail.setPicketageQuoteId(quote.getId());
                            detail.setPicketageId(entity.getId());
                            detail.setId(IdWorker.getId());
                        }
                        saveRentDetail.addAll(quote.getRentDetailList());
                    }

                }
                if (CollectionUtils.isNotEmpty(savePurchaseDetail)){
                    purchaseDetailService.saveOrUpdateBatch(savePurchaseDetail);
                }
                if (CollectionUtils.isNotEmpty(saveRentDetail)){
                    rentDetailService.saveOrUpdateBatch(saveRentDetail);
                }
            }

        }
        return true;
    }
    @Override
    public void pushPicketage(Long billId) {
        MaterialPicketageEntity entity = service.selectById(billId);
        //自制
        if (entity.getSelfFlag()==1){
            MaterialResultEntity materialResultEntity = builderResultEntity(entity);
            materialResultService.saveOrUpdate(materialResultEntity,false);
        }else {
            //审批通过回写询价状态
            builderResultRef(entity);
        }

    }

    @Override
    public void rollBackPicketage(Long billId) {
        QueryWrapper<MaterialResultEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("picketage_id",billId);
        List<MaterialResultEntity> list = materialResultService.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)){
            materialResultService.removeByIds(list.stream().map(MaterialResultEntity::getId).collect(Collectors.toList()),true);
        }
    }

    public MaterialResultEntity builderResultEntity( MaterialPicketageEntity entity){
        MaterialResultEntity result = new MaterialResultEntity();
        List<MaterialResultPurchaseDetailEntity> purchaseList = new ArrayList<>();
        List<MaterialResultRentDetailEntity> rentList = new ArrayList<>();

        result.setPicketageId(entity.getId());
        result.setPicketageSelfFlag(entity.getSelfFlag());
        if (StringUtils.isNotEmpty(entity.getBidWinnerId())){
            result.setSupplierId(Long.parseLong(entity.getBidWinnerId()));
            result.setSupplierName(entity.getBidWinnerName());
        }
        result.setProjectId(entity.getProjectId());
        result.setProjectName(entity.getProjectName());
        result.setOrgId(entity.getOrgId());
        result.setOrgName(entity.getOrgName());
        result.setPurchaseSubject(entity.getName());
        result.setPricingType(entity.getPricingType());
        result.setPricingTypeName(entity.getPricingType()==1 ? "采购" : "租赁");

        result.setPurchaseType(entity.getPurchaseType());
        result.setPurchaseTypeName(entity.getPurchaseType()==1 ? "项目自采" : "公司集采");
        result.setBillCode(entity.getBillCode());

        result.setInquiryMny(entity.getInquiryMny());
        result.setBidFlag(1);
        result.setHandleDate(entity.getHandleDate());
        result.setBidMny(entity.getBidWinMny());
        if (CollectionUtils.isNotEmpty(entity.getMaterialPicketagePurchaseDetailList()) || CollectionUtils.isNotEmpty(entity.getMaterialPicketageRentDetailList())){
            Map<Long, MaterialPicketageSupplierEntity> winSupplierMap=new HashMap<>();
            if (StringUtils.isNotEmpty(entity.getBidWinnerId())){
                QueryParam param = new QueryParam();
                param.getParams().put("supplierId",new Parameter(QueryParam.EQ,Long.parseLong(entity.getBidWinnerId())));
                List<MaterialPicketageSupplierEntity> supplierEntities = supplierService.queryList(param, false);
                 winSupplierMap = supplierEntities.stream().collect(Collectors.toMap(k->k.getPicketageDetailId(),(k)->k));
            }
            for (MaterialPicketagePurchaseDetailEntity purchase : entity.getMaterialPicketagePurchaseDetailList()) {
                MaterialResultPurchaseDetailEntity resultPurchase = new MaterialResultPurchaseDetailEntity();
                resultPurchase.setMaterialCategoryId(purchase.getMaterialCategoryId());
                resultPurchase.setMaterialCategoryName(purchase.getMaterialCategoryName());
                resultPurchase.setMaterialId(purchase.getMaterialId());
                resultPurchase.setMaterialName(purchase.getMaterialName());
                resultPurchase.setSpec(purchase.getSpec());
                resultPurchase.setUnit(purchase.getUnit());
                resultPurchase.setResidueNum(purchase.getNum());
                resultPurchase.setReferPrice(purchase.getReferPrice());
                resultPurchase.setSourceId(purchase.getId());
                resultPurchase.setFixedMaterial(purchase.getFixedMaterial());
                if (!winSupplierMap.isEmpty()){
                    MaterialPicketageSupplierEntity materialPicketageSupplierEntity = winSupplierMap.get(purchase.getId());
                    resultPurchase.setBidNum(purchase.getNum());
                    resultPurchase.setBidPrice(materialPicketageSupplierEntity.getPrice());
                    BigDecimal mny= ComputeUtil.safeMultiply(materialPicketageSupplierEntity.getPrice(),purchase.getNum());
                    resultPurchase.setBidMny(mny);
                }
                purchaseList.add(resultPurchase);
            }
            for (MaterialPicketageRentDetailEntity rent : entity.getMaterialPicketageRentDetailList()) {
                MaterialResultRentDetailEntity resultRent = new MaterialResultRentDetailEntity();
                resultRent.setMaterialCategoryId(rent.getMaterialCategoryId());
                resultRent.setMaterialCategoryName(rent.getMaterialCategoryName());
                resultRent.setMaterialId(rent.getMaterialId());
                resultRent.setMaterialName(rent.getMaterialName());
                resultRent.setSpec(rent.getSpec());
                resultRent.setUnit(rent.getUnit());
                resultRent.setResidueNum(rent.getNum());
                resultRent.setReferPrice(rent.getReferPrice());
                resultRent.setRentTerm(rent.getRentTerm());
                resultRent.setRentMode(rent.getRentMode());
                resultRent.setSourceId(rent.getId());

                if (!winSupplierMap.isEmpty()){
                    MaterialPicketageSupplierEntity materialPicketageSupplierEntity = winSupplierMap.get(rent.getId());
                    resultRent.setBidNum(rent.getNum());
                    resultRent.setBidPrice(materialPicketageSupplierEntity.getPrice());
                    BigDecimal perMny= ComputeUtil.safeMultiply(materialPicketageSupplierEntity.getPrice(),rent.getNum());
                    resultRent.setBidMny(ComputeUtil.safeMultiply(perMny, rent.getRentTerm()));
                }
                rentList.add(resultRent);
            }
        }
        if (CollectionUtils.isNotEmpty(rentList) || CollectionUtils.isNotEmpty(purchaseList)){
            result.setMaterialResultRentDetailList(rentList);
            result.setMaterialResultPurchaseDetailList(purchaseList);
        }
        return result;
    }

    @Override
    public CommonResponse<JSONObject> queryByInquiryToDetailAndQuote(String inquiryId) {
        JSONObject jsonObject = new JSONObject();
        Map<Long, BigDecimal> collect = new HashMap<>();
        //查询询价
        MaterialInquiryEntity materialInquiryEntity = inquiryService.selectById(inquiryId);
        MaterialInquiryVO inquiryVO = BeanMapper.map(materialInquiryEntity, MaterialInquiryVO.class);
        InquiryCommonVO inquiryCommonVO = inquiryCommonService.queryDetailByInquiry(materialInquiryEntity.getId(), materialInquiryEntity.getInquiryState(), materialInquiryEntity.getPricingType().toString(), false);

        jsonObject.put("quoteList",inquiryCommonVO.getMaterialQuoteVOList());
        jsonObject.put("inquiry",BeanMapper.map(materialInquiryEntity,MaterialInquiryVO.class));
        if (inquiryCommonVO.getPricingType().equals(new Integer(1))){
            collect = inquiryCommonVO.getMaterialInquiryPurchaseDetailList().stream().collect(
                    Collectors.toMap(MaterialInquiryPurchaseDetailVO::getId, MaterialInquiryPurchaseDetailVO::getNum));
            jsonObject.put("materialInquiryPurchaseDetailList",inquiryCommonVO.getMaterialInquiryPurchaseDetailList());
        }else {
            collect = inquiryCommonVO.getMaterialInquiryRentDetailList().stream().collect(
                    Collectors.toMap(MaterialInquiryRentDetailVO::getId, MaterialInquiryRentDetailVO::getNum));
            jsonObject.put("materialInquiryRentDetailList",inquiryCommonVO.getMaterialInquiryRentDetailList());
        }
        jsonObject.put("totalMap",collect);
        return CommonResponse.success("查询数据成功！",jsonObject);

    }

    public JSONObject queryDetailToRef(Long id){

        MaterialPicketageEntity picketageEntity = service.selectById(id);
        //获取报价子表
        Map<Long, BigDecimal> collect = new HashMap<>();
        MaterialInquiryEntity byId = inquiryService.selectById(picketageEntity.getInquiryId());
        MaterialInquiryVO materialInquiry = BeanMapper.map(byId, MaterialInquiryVO.class);
        if (materialInquiry.getPricingType().equals(new Integer(1))){
            collect = materialInquiry.getMaterialInquiryPurchaseDetailList().stream().collect(
                    Collectors.toMap(MaterialInquiryPurchaseDetailVO::getId, MaterialInquiryPurchaseDetailVO::getNum));
        }else {
            collect = materialInquiry.getMaterialInquiryRentDetailList().stream().collect(
                    Collectors.toMap(MaterialInquiryRentDetailVO::getId, MaterialInquiryRentDetailVO::getNum));
        }
        for (Object key : collect.keySet()) {
            //统计当前清单 占用数量
            QueryWrapper<PicketageQuotePurchaseDetailEntity> ew = new QueryWrapper<>();
            ew.eq("inquiry_id", picketageEntity.getInquiryId());
            ew.eq("source_id",key);
            ew.select("IFNULL(sum(bid_num),0) AS num");
            Map<String, Object> map = purchaseDetailService.getMap(ew);
            BigDecimal num = collect.get(key).subtract((BigDecimal) map.get("num"));
            collect.put((Long) key,num);
        }

        Map<Long, List<PicketageQuotePurchaseDetailEntity>> purchaseListMap = new HashMap<>();
        Map<Long, List<PicketageQuoteRentDetailEntity>> rentListMap = new HashMap<>();


        QueryWrapper<PicketageQuotePurchaseDetailEntity> quotePurchaseWrapper = new QueryWrapper<>();
        quotePurchaseWrapper.eq("picketage_id",id);
        List<PicketageQuotePurchaseDetailEntity> purchaseDetailEntities = purchaseDetailService.list(quotePurchaseWrapper);
        if (CollectionUtils.isNotEmpty(purchaseDetailEntities)){
             purchaseListMap = purchaseDetailEntities.stream().collect(Collectors.groupingBy(PicketageQuotePurchaseDetailEntity::getPicketageQuoteId));
        }

        QueryWrapper<PicketageQuoteRentDetailEntity> quoteRentWrapper = new QueryWrapper<>();
        quoteRentWrapper.eq("picketage_id",id);
        List<PicketageQuoteRentDetailEntity> rentDetailEntities = rentDetailService.list();
        if (CollectionUtils.isNotEmpty(rentDetailEntities)){
            rentListMap = rentDetailEntities.stream().collect(Collectors.groupingBy(PicketageQuoteRentDetailEntity::getPicketageQuoteId));
        }

        for (MaterialPicketageQuoteEntity quote:picketageEntity.getMaterialPicketageQuoteList()){
            if (quote.getBidFlag()==1){
                if (CollectionUtils.isNotEmpty(purchaseDetailEntities)){
                    quote.setPurchaseDetailList(purchaseListMap.get(quote.getId()));
                }
                if (CollectionUtils.isNotEmpty(rentDetailEntities)){
                    quote.setRentDetailList(rentListMap.get(quote.getId()));
                }
            }
        }
        MaterialPicketageVO picketageVO = BeanMapper.map(picketageEntity, MaterialPicketageVO.class);
        JSONObject jsonObject = (JSONObject) JSONObject.toJSON(picketageVO);
        if (picketageVO.getHandleDate()!=null){
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            jsonObject.put("handleDate",sdf.format( picketageVO.getHandleDate()));
        }
        //获取清单
        InquiryCommonVO inquiryCommonVO = inquiryCommonService.queryDetailByInquiry(picketageEntity.getInquiryId(), materialInquiry.getInquiryState(), materialInquiry.getPricingType().toString(), false);
        if (CollectionUtils.isNotEmpty(inquiryCommonVO.getMaterialInquiryPurchaseDetailList())){
            jsonObject.put("picketagePurchaseDetailList",inquiryCommonVO.getMaterialInquiryPurchaseDetailList());
        }
        if (CollectionUtils.isNotEmpty(inquiryCommonVO.getMaterialInquiryRentDetailList())){
            jsonObject.put("picketageRentDetailList",inquiryCommonVO.getMaterialInquiryRentDetailList());

        }
        jsonObject.put("totalMap",collect);

        return jsonObject;
    }

    @Override
    public MaterialPicketageVO queryMaterialPicketageDetail(Long id) {
        MaterialPicketageEntity entity = service.selectById(id);
        MaterialPicketageVO vo=new MaterialPicketageVO();
        //查询孙级供应商
        entity=querySupplier(entity);
        vo = BeanMapper.map(entity, MaterialPicketageVO.class);
        //查询价格区间
//        vo= service.queryMaterialPriceArea(vo);
        return vo;
    }

    /**
     * 查询供应商
     * @param entity
     * @return
     */
    private MaterialPicketageEntity querySupplier(MaterialPicketageEntity entity) {
        if(!ListUtil.isEmpty(entity.getMaterialPicketagePurchaseDetailList()) || !ListUtil.isEmpty(entity.getMaterialPicketageRentDetailList())){
            List<Long> detailIds = new ArrayList<>();
            List<Long> purchaseIds = entity.getMaterialPicketagePurchaseDetailList().stream().map(MaterialPicketagePurchaseDetailEntity::getId).collect(Collectors.toList());
            List<Long> rentIds = entity.getMaterialPicketageRentDetailList().stream().map(MaterialPicketageRentDetailEntity::getId).collect(Collectors.toList());
            detailIds.addAll(purchaseIds);
            detailIds.addAll(rentIds);
            Map<Long, List<MaterialPicketageSupplierEntity>> supplierMap=new HashMap<>();
            if (CollectionUtils.isNotEmpty(detailIds)){
                QueryParam param = new QueryParam();
                param.getParams().put("picketageDetailId",new Parameter(QueryParam.IN,detailIds));
                List<MaterialPicketageSupplierEntity> supplierEntities = materialPicketageSupplierService.queryList(param, false);
                if (CollectionUtils.isNotEmpty(supplierEntities)){
                    supplierMap = supplierEntities.stream().collect(Collectors.groupingBy(MaterialPicketageSupplierEntity::getPicketageDetailId));
                }
                if (!supplierMap.isEmpty()){
                    for (MaterialPicketageRentDetailEntity rent : entity.getMaterialPicketageRentDetailList()) {
                        rent.setMaterialPicketageSupplierList(supplierMap.get(rent.getId()));
                    }
                    for (MaterialPicketagePurchaseDetailEntity purchase : entity.getMaterialPicketagePurchaseDetailList()) {
                        purchase.setMaterialPicketageSupplierList(supplierMap.get(purchase.getId()));
                    }
                }
            }
        }
        return entity;
    }

    /**
     * 查询历史价格区间
     * @param vo
     * @return
     */
    @Override
    public MaterialPicketageVO queryMaterialPriceArea(MaterialPicketageVO vo) {
        /**
         * 填充参数
         */
        MaterialPriceVO priceVO = new MaterialPriceVO(vo.getProjectId());
        List<MaterialPriceVO> detail = new ArrayList<>();
        List<MaterialPicketagePurchaseDetailVO> purchaseDetailList = vo.getMaterialPicketagePurchaseDetailList();
        if (CollectionUtils.isNotEmpty(purchaseDetailList)){
            for (MaterialPicketagePurchaseDetailVO materialPicketagePurchaseDetailVO : purchaseDetailList) {
                MaterialPriceVO materialPriceVO = new MaterialPriceVO();
                materialPriceVO.setMaterialId(Long.valueOf(materialPicketagePurchaseDetailVO.getMaterialId()));
                detail.add(materialPriceVO);
            }
        }
        //填充价格区间
        if (CollectionUtils.isNotEmpty(detail)){
            priceVO.setDetail(detail);
            MaterialPriceVO materialPriceVO = iMaterialContractService.queryPrice(0, null, priceVO);
            List<MaterialPriceVO> materialPriceVOS = materialPriceVO.getDetail();
            if (CollectionUtils.isNotEmpty(materialPriceVOS)){
                Map<Long, MaterialPriceVO> priceVOMap = materialPriceVOS.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account,(v1, v2) -> v2));
                List<MaterialPicketagePurchaseDetailVO> vos = vo.getMaterialPicketagePurchaseDetailList();
                if (CollectionUtils.isNotEmpty(vos)){
                    for (MaterialPicketagePurchaseDetailVO materialPicketagePurchaseDetailVO : vos) {
                        Long materialId = materialPicketagePurchaseDetailVO.getMaterialId();
                        MaterialPriceVO p = priceVOMap.get(materialId);
                        if (!Objects.isNull(p)) {
                            materialPicketagePurchaseDetailVO.setMinPrice(p.getMinPrice());
                            materialPicketagePurchaseDetailVO.setMaxPrice(p.getMaxPrice());
                            materialPicketagePurchaseDetailVO.setPriceArea(p.getMinPrice().setScale(2,BigDecimal.ROUND_HALF_UP) + "~" + p.getMaxPrice().setScale(2,BigDecimal.ROUND_HALF_UP));
                        }
                    }
                    vo.setMaterialPicketagePurchaseDetailList(vos);
                }
            }
        }
        return vo;
    }


    public List<MaterialResultEntity> builderResultRef(MaterialPicketageEntity entity){

        List<MaterialResultEntity> resultList= new ArrayList<>();
        if (CollectionUtils.isNotEmpty(entity.getMaterialPicketageQuoteList())){
            List<MaterialPicketageQuoteEntity> quoteList = entity.getMaterialPicketageQuoteList();
            Map<Long, List<PicketageQuotePurchaseDetailEntity>> purchaseListMap = new HashMap<>();
            Map<Long, List<PicketageQuoteRentDetailEntity>> rentListMap = new HashMap<>();
            List<MaterialResultPurchaseDetailEntity> savePurchaseList = new ArrayList<>();
            List<MaterialResultRentDetailEntity> saveRentList = new ArrayList<>();

            QueryWrapper<PicketageQuotePurchaseDetailEntity> quotePurchaseWrapper = new QueryWrapper<>();
            quotePurchaseWrapper.eq("picketage_id",entity.getId());
            List<PicketageQuotePurchaseDetailEntity> purchaseDetailEntities = purchaseDetailService.list(quotePurchaseWrapper);
            if (CollectionUtils.isNotEmpty(purchaseDetailEntities)){
                purchaseListMap = purchaseDetailEntities.stream().collect(Collectors.groupingBy(PicketageQuotePurchaseDetailEntity::getPicketageQuoteId));
            }

            QueryWrapper<PicketageQuoteRentDetailEntity> quoteRentWrapper = new QueryWrapper<>();
            quoteRentWrapper.eq("picketage_id",entity.getId());
            List<PicketageQuoteRentDetailEntity> rentDetails = rentDetailService.list(quoteRentWrapper);
            if (CollectionUtils.isNotEmpty(rentDetails)){
                rentListMap = rentDetails.stream().collect(Collectors.groupingBy(PicketageQuoteRentDetailEntity::getPicketageQuoteId));
            }
            for(MaterialPicketageQuoteEntity quote:quoteList){
                if (quote.getBidFlag()==1){
                    MaterialResultEntity result = new MaterialResultEntity();
                    result.setId(IdWorker.getId());
                    result.setPicketageId(entity.getId());
                    result.setPicketageSelfFlag(entity.getSelfFlag());
                    result.setProjectId(entity.getProjectId());
                    result.setProjectName(entity.getProjectName());
                    result.setOrgId(entity.getOrgId());
                    result.setOrgName(entity.getOrgName());
                    result.setPurchaseSubject(entity.getName());
                    result.setPricingType(entity.getPricingType());
                    result.setPricingTypeName(entity.getPricingType()==1 ? "采购" : "租赁");

                    result.setPurchaseType(entity.getPurchaseType());
                    result.setPurchaseTypeName(entity.getPurchaseType()==1 ? "项目自采" : "公司集采");
                    result.setBillCode(entity.getBillCode());
                    result.setInquiryMny(entity.getInquiryMny());
                    result.setBidFlag(1);
                    result.setHandleDate(entity.getHandleDate());
                    result.setBidMny(quote.getBidMny());

                    result.setSupplierId(quote.getSupplierId());
                    result.setSupplierName(quote.getSupplierName());
                    result.setSocialCreditCode(quote.getSocialCreditCode());
                    result.setLegal(quote.getLegal());
                    result.setInquiryId(entity.getInquiryId());
                    result.setQuoteId(quote.getQuoteId());
                    result.setTelephone(quote.getTelephone());
                    result.setBidMemo(quote.getBidMemo());
                    result.setBidFlag(quote.getBidFlag());
                    result.setQuoteMemo(quote.getQuoteMemo());
                    result.setHandleDate(quote.getQuoteTime());
                    result.setTotalMny(quote.getPurchaseMny());

                    if (entity.getPricingType()==1){
                        if (CollectionUtils.isNotEmpty(purchaseListMap.get(quote.getId()))){

                            List<PicketageQuotePurchaseDetailEntity> purchaseDetailList = purchaseListMap.get(quote.getId());
                            List<MaterialResultPurchaseDetailEntity> materialResultPurchaseDetail = new ArrayList<>();
                            for (PicketageQuotePurchaseDetailEntity purchase:purchaseDetailList){
                                MaterialResultPurchaseDetailEntity purchaseDetail = new MaterialResultPurchaseDetailEntity();
                                purchaseDetail.setId(IdWorker.getId());
                                purchaseDetail.setPid(result.getId());
                                purchaseDetail.setSourceId(purchase.getId());
                                purchaseDetail.setMaterialCategoryId(purchase.getMaterialCategoryId());
                                purchaseDetail.setMaterialCategoryName(purchase.getMaterialCategoryName());
                                purchaseDetail.setMaterialId(purchase.getMaterialId());
                                purchaseDetail.setMaterialName(purchase.getMaterialName());
                                purchaseDetail.setSpec(purchase.getSpec());
                                purchaseDetail.setUnit(purchase.getUnit());
                                purchaseDetail.setResidueNum(purchase.getResidueNum());
                                purchaseDetail.setReferPrice(purchase.getReferPrice());
                                purchaseDetail.setBidNum(purchase.getBidNum());
                                purchaseDetail.setBidPrice(purchase.getBidPrice());
                                purchaseDetail.setBidMny(purchase.getBidMny());
                                materialResultPurchaseDetail.add(purchaseDetail);
                            }
                            savePurchaseList.addAll(materialResultPurchaseDetail);
//                            result.setMaterialResultPurchaseDetailList(materialResultPurchaseDetail);
                        }
                    }else {
                        if (CollectionUtils.isNotEmpty(rentListMap.get(quote.getId()))){
                            List<PicketageQuoteRentDetailEntity> rentDetailList = rentListMap.get(quote.getId());
                            List<MaterialResultRentDetailEntity> rentDetailEntities = new ArrayList<>();
                            for (PicketageQuoteRentDetailEntity rent:rentDetailList){
                                MaterialResultRentDetailEntity rentDetailEntity = new MaterialResultRentDetailEntity();
                                rentDetailEntity.setPid(result.getId());
                                rentDetailEntity.setId(IdWorker.getId());
                                rentDetailEntity.setSourceId(rent.getId());
                                rentDetailEntity.setMaterialCategoryId(rent.getMaterialCategoryId());
                                rentDetailEntity.setMaterialCategoryName(rent.getMaterialCategoryName());
                                rentDetailEntity.setMaterialId(rent.getMaterialId());
                                rentDetailEntity.setMaterialName(rent.getMaterialName());
                                rentDetailEntity.setSpec(rent.getSpec());
                                rentDetailEntity.setUnit(rent.getUnit());
                                rentDetailEntity.setResidueNum(rent.getResidueNum());
                                rentDetailEntity.setReferPrice(rent.getReferPrice());
                                rentDetailEntity.setBidNum(rent.getBidNum());
                                rentDetailEntity.setBidPrice(rent.getBidPrice());
                                rentDetailEntity.setBidMny(rent.getBidMny());
                                rentDetailEntity.setRentTerm(rent.getRentTerm());
                                rentDetailEntity.setRentMode(rent.getRentMode());
                                rentDetailEntities.add(rentDetailEntity);
                            }
                            saveRentList.addAll(rentDetailEntities);
//                            result.setMaterialResultRentDetailList(rentDetailEntities);

                        }
                    }
                    resultList.add(result);
                }
            }
            if (CollectionUtils.isNotEmpty(savePurchaseList)){
                resultPurchaseDetailService.saveOrUpdateBatch(savePurchaseList);
                logger.info("savePurchaseList--{}",JSONObject.toJSONString(savePurchaseList));
            }
            if (CollectionUtils.isNotEmpty(saveRentList)){
                resultRentDetailService.saveOrUpdateBatch(saveRentList);
                logger.info("saveRentList--{}",JSONObject.toJSONString(saveRentList));

            }
            if (CollectionUtils.isNotEmpty(resultList)){
                materialResultService.saveOrUpdateBatch(resultList);
                logger.info("materialResultData--{}",JSONObject.toJSONString(resultList));


            }
        }
        return resultList;

    }


    /**
     * 定标单生效后，给中标供应商手机号发信息.
     * 消息模板：【联系人】您好，您在【报价时间】的针对【采购主题】的投标报价已中标，中标金额为【中标金额】元，可联系客户方负责人了解中标详情！
     */
    @Override
    public void sendMsg(Long id) {
        MaterialPicketageEntity entity = super.selectById(id);
        //查询到对应的供应商 条件 已中标
        QueryWrapper<MaterialPicketageQuoteEntity> quoteWrapper = new QueryWrapper<>();
        quoteWrapper.eq("picketage_id",entity.getId());
        quoteWrapper.eq("bid_flag",1);
        List<MaterialPicketageQuoteEntity> quoteList = quoteService.list(quoteWrapper);
        for (MaterialPicketageQuoteEntity quote:quoteList){
            if(StringUtils.isNotEmpty(quote.getLegal())&&StringUtils.isNotEmpty(quote.getTelephone())){
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                DecimalFormat decimalFormat = new DecimalFormat("0.00");
                try {
                    sendVerifyCode(quote.getTelephone(),quote.getLegal(),sdf.format(quote.getQuoteTime()),entity.getName(),
                            decimalFormat.format(quote.getBidMny()),null);
                } catch (Exception e) {
                    logger.error("定标生效给中标供应商手机号:{}发送短信失败！时间：{}", quote.getTelephone(), DateUtil.getCurrentDay(DateUtil.DATE_TIME));
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     *  发送短信
     * @param phone 手机号
     * @param userName 联系人姓名
     * @param publishTime 时间
     * @param title 询价主题
     * @param amount 金额
     * @param templateCode 模板编号
     * @throws Exception 异常
     */
    public void sendVerifyCode(String phone, String userName, String publishTime, String title, String amount, String templateCode) throws Exception {
        Assert.hasText(phone, "电话号码不能为空！");
        JSONObject messageParam = new JSONObject();
        messageParam.put("phone", phone);
        Map<String, String> params = new HashMap<>();
        params.put("userName", userName);
        params.put("publishTime", publishTime);
        params.put("title", title);
        params.put("amount", amount);
        messageParam.put("params", params);
        if (org.apache.commons.lang3.StringUtils.isBlank(templateCode)) {
            messageParam.put(TEMPLATE_CODE, DEFAULT_TEMPLATE_CODE);
        } else {
            messageParam.put(TEMPLATE_CODE, templateCode);
        }
        logger.info("发送短信参数：[{}]", messageParam);
        String messageUrl = environmentTools.getBaseHost() + "/ejc-message-web/no_auth/sms/sendMessage";
        String responseStr = HttpTookit.postByJson(messageUrl, JSON.toJSONString(messageParam));
        logger.info("向手机号[{}]发送短信结果：[{}]", phone, responseStr);
        CommonResponse<String> response = JSON.parseObject(responseStr, CommonResponse.class);
        if (!response.isSuccess()) {
            throw new BusinessException("短信发送失败！");
        }
    }

    /**
     * 定标打印模板配置
     * @param detailJsonStr
     * @return
     */
    @Override
    public CommonResponse<JSONObject> handlePrintDetail(String detailJsonStr) {
        if(StringUtils.isBlank(detailJsonStr)) {
            return CommonResponse.success(null);
        }
        JSONObject data = JSONObject.parseObject(detailJsonStr);
        if(null == data) {
            return CommonResponse.success(null);
        }
        JSONObject detailJson = data.getJSONObject("detailJson");
        if(null == detailJson) {
            return CommonResponse.success(null);
        }
        JSONObject picketage = detailJson.getJSONObject("MaterialPicketage");
        if (null == picketage) {
            return CommonResponse.success(null);
        }
       Long id = (Long) picketage.get("id");
        if (null==picketage.get("MaterialPicketageQuote")){
            List<JSONObject> picketageQuoteList = (List<JSONObject>) picketage.get("MaterialPicketageQuote");
            Map<Long, List<PicketageQuotePurchaseDetailEntity>> purchaseListMap = new HashMap<>();
            Map<Long, List<PicketageQuoteRentDetailEntity>> rentListMap = new HashMap<>();
            QueryWrapper<PicketageQuotePurchaseDetailEntity> quotePurchaseWrapper = new QueryWrapper<>();
            quotePurchaseWrapper.eq("picketage_id",id);
            List<PicketageQuotePurchaseDetailEntity> purchaseDetailEntities = purchaseDetailService.list(quotePurchaseWrapper);
            if (CollectionUtils.isNotEmpty(purchaseDetailEntities)){
                purchaseListMap = purchaseDetailEntities.stream().collect(Collectors.groupingBy(PicketageQuotePurchaseDetailEntity::getPicketageQuoteId));
            }
            QueryWrapper<PicketageQuoteRentDetailEntity> quoteRentWrapper = new QueryWrapper<>();
            quoteRentWrapper.eq("picketage_id",id);
            List<PicketageQuoteRentDetailEntity> rentDetailEntities = rentDetailService.list();
            if (CollectionUtils.isNotEmpty(rentDetailEntities)){
                rentListMap = rentDetailEntities.stream().collect(Collectors.groupingBy(PicketageQuoteRentDetailEntity::getPicketageQuoteId));
            }
            for (JSONObject quote:picketageQuoteList){
                Integer bidFlag = (Integer) quote.get("bidFlag");
                if (bidFlag==1){
                    if (CollectionUtils.isNotEmpty(purchaseDetailEntities)){
                        quote.put("PicketageQuotePurchaseDetail",purchaseListMap.get(quote.get("id")));
                    }
                    if (CollectionUtils.isNotEmpty(rentDetailEntities)){
                        quote.put("PicketageQuoteRentDetail",rentListMap.get(quote.get("id")));
                    }
                }
            }
            picketage.put("MaterialPicketageQuote",picketageQuoteList);
        }
       picketage.put("AAA","picketageQuoteList");

       detailJson.put("MaterialPicketage", picketage);
       return CommonResponse.success(detailJson);
    }

    @Override
    public CommonResponse<String> updateContractSignMny(MaterialPicketageVO vo) {
        //定标结果id
        Long resultId = vo.getId();
        if (resultId != null) {
            MaterialResultEntity materialResultEntity = materialResultService.getById(resultId);
            // 通过定标结果更新定标合同签订数量和金额
            if (materialResultEntity != null) {
                materialResultEntity.setContractSign(vo.getContractSign());
                materialResultEntity.setContractSignMny(vo.getContractSignMny());
                boolean b = materialResultService.updateById(materialResultEntity);
                logger.info("------定标结果id:{}, 合同签订数量:{}" + resultId, vo.getContractSign());
                if (b) {
                    Long picketageId = materialResultEntity.getPicketageId();
                    QueryWrapper<MaterialResultEntity> queryWrapper = new QueryWrapper<>();
                    queryWrapper.select("IFNULL(sum(contract_sign),0) as num, IFNULL(sum(contract_sign_mny),0) as money")
                            .eq("picketage_id", picketageId);
                    Map<String, Object> map = materialResultService.getMap(queryWrapper);
                    Integer num = map.get("num") != null ?  Integer.valueOf(map.get("num").toString()) : 0;
                    BigDecimal money = com.ejianc.business.utils.ComputeUtil.toBigDecimal(map.get("money"));
                    LambdaUpdateWrapper<MaterialPicketageEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.eq(MaterialPicketageEntity::getId, picketageId);
                    updateWrapper.set(MaterialPicketageEntity::getContractSign, num);
                    updateWrapper.set(MaterialPicketageEntity::getContractSignMny, money);
                    update(updateWrapper);
                    logger.info("------定标id:{}, 合同签订数量:{}" + picketageId, num);
                    //合同签订后回写询价单状态,合同签订数量大于0为已签订，否则改为已定标
                    LambdaUpdateWrapper<MaterialInquiryEntity> inquiryUpdateWrapper = new LambdaUpdateWrapper<>();
                    inquiryUpdateWrapper.eq(MaterialInquiryEntity::getId, materialResultEntity.getInquiryId());
                    logger.info("------询价申请id:{}, 合同签订数量:{}" + materialResultEntity.getInquiryId(), num);
                    if (num > 0) {
                        inquiryUpdateWrapper.set(MaterialInquiryEntity::getInquiryState, InquiryStateEnum.SIGN_STATE.getCode());
                    } else {
                        inquiryUpdateWrapper.set(MaterialInquiryEntity::getInquiryState, InquiryStateEnum.WIN_STATE.getCode());
                    }
                    inquiryService.update(inquiryUpdateWrapper);
                }
            }
        }
        return CommonResponse.success("修改合同签订数成功！");
    }
}
