package com.ejianc.business.income.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * （项目/厂矿/车间）生产情况统计表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zypms_production_info")
public class ProductionInfoEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="code")
    private String code; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 生产单位
    @TableField(value="org_name")
    private String orgName; // 生产单位
    @TableField(value="name")
    private String name; // 项目/厂矿/车间名称
    @TableField(value="pro_state")
    private String proState; // 状态:新开new、在施build、暂停stop、复工rework、完工finish
    @TableField(value="pro_type")
    private String proType; // 类别：项目project、厂矿factory、车间shop
    @TableField(value="project_type")
    private String projectType; // 项目类型：地下管网net、测绘地理信息earth、软件系统soft
    @TableField(value="contract_money")
    private BigDecimal contractMoney; // 合同额（万元）
    @TableField(value="start_date")
    private Date startDate; // 开工日期
    @TableField(value="rework_date")
    private Date reworkDate; // 复工日期
    @TableField(value="plan_end_date")
    private Date planEndDate; // 竣工计划日期
    @TableField(value="do_sign")
    private Boolean doSign; // 是否签订合同及安全生产协议
    @TableField(value="do_check")
    private Boolean doCheck; // 是否开展安全生产开/复工检查
    @TableField(value="do_edu")
    private Boolean doEdu; // 是否进行安全教育培训
    @TableField(value="scene_manger_num")
    private Integer sceneMangerNum; // 现场管理人员人数
    @TableField(value="scene_work_num")
    private Integer sceneWorkNum; // 现场施工作业人员人数
    @TableField(value="done_week")
    private String doneWeek; // 本周完成工作量
    @TableField(value="done_total")
    private String doneTotal; // 累计完成工作量
    @TableField(value="product_week")
    private BigDecimal productWeek; // 本周完成产值（万元）
    @TableField(value="product_total")
    private BigDecimal productTotal; // 累计完成产值（万元）
    @TableField(value="next_week_plan")
    private String nextWeekPlan; // 下周工作计划
    @TableField(value="connect_info")
    private String connectInfo; // 联系人及电话
    @TableField(value="job_do_unit")
    private String jobDoUnit; // 任务承接单位
    @TableField(value="scene_safer")
    private String sceneSafer; // 现场专（兼）职安全员及联系方式
    @TableField(value="belong_danger")
    private Boolean belongDanger; // 是否属于有限空间作业等危险作业
    @TableField(value="join_manger")
    private Boolean joinManger; // 是否纳入有限空间作业管理台账
    @TableField(value="main_danger")
    private String mainDanger; // 主要危险有限因素
    @TableField(value="tech_manger")
    private String techManger; // 技术负责人
    @TableField(value="main_equipment")
    private String mainEquipment; // 主要设备投入
    @TableField(value="designer")
    private String designer; // 设计编审
    @TableField(value="quality_jiaodi")
    private String qualityJiaodi; // 质量技术交底人
    @TableField(value="total_progress")
    private String totalProgress; // 整体进度（%）
    @TableField(value="project_receive")
    private String projectReceive; // 项目验收（外部验收）
    @TableField(value="make_person")
    private Long makePerson; // 编制人
    @TableField(value="make_person_name")
    private String makePersonName; // 编制人
    @TableField(value="make_date")
    private Date makeDate; // 编制时间
    @TableField(value="address")
    private String address; // 详细地址
    @TableField(value="production_job")
    private String productionJob; // 生产任务
    @TableField(value="project_qestions")
    private String projectQestions; // 项目存在的问题及解决措施
    @TableField(value="scene_stu_info")
    private String sceneStuInfo; // 现场实习学生信息
    @TableField(value="scene_labor_info")
    private String sceneLaborInfo; // 现场劳务人员信息
    @TableField(value="last_check")
    private String lastCheck; // 过程检查、最终检查
    @TableField(value="memo")
    private String memo; // 备注
    
    
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getProState() {
        return proState;
    }

    public void setProState(String proState) {
        this.proState = proState;
    }
    public String getProType() {
        return proType;
    }

    public void setProType(String proType) {
        this.proType = proType;
    }
    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }
    public BigDecimal getContractMoney() {
        return contractMoney;
    }

    public void setContractMoney(BigDecimal contractMoney) {
        this.contractMoney = contractMoney;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getReworkDate() {
        return reworkDate;
    }

    public void setReworkDate(Date reworkDate) {
        this.reworkDate = reworkDate;
    }
    public Date getPlanEndDate() {
        return planEndDate;
    }

    public void setPlanEndDate(Date planEndDate) {
        this.planEndDate = planEndDate;
    }
    public Boolean getDoSign() {
        return doSign;
    }

    public void setDoSign(Boolean doSign) {
        this.doSign = doSign;
    }
    public Boolean getDoCheck() {
        return doCheck;
    }

    public void setDoCheck(Boolean doCheck) {
        this.doCheck = doCheck;
    }
    public Boolean getDoEdu() {
        return doEdu;
    }

    public void setDoEdu(Boolean doEdu) {
        this.doEdu = doEdu;
    }
    public Integer getSceneMangerNum() {
        return sceneMangerNum;
    }

    public void setSceneMangerNum(Integer sceneMangerNum) {
        this.sceneMangerNum = sceneMangerNum;
    }
    public Integer getSceneWorkNum() {
        return sceneWorkNum;
    }

    public void setSceneWorkNum(Integer sceneWorkNum) {
        this.sceneWorkNum = sceneWorkNum;
    }
    public String getDoneWeek() {
        return doneWeek;
    }

    public void setDoneWeek(String doneWeek) {
        this.doneWeek = doneWeek;
    }
    public String getDoneTotal() {
        return doneTotal;
    }

    public void setDoneTotal(String doneTotal) {
        this.doneTotal = doneTotal;
    }
    public BigDecimal getProductWeek() {
        return productWeek;
    }

    public void setProductWeek(BigDecimal productWeek) {
        this.productWeek = productWeek;
    }
    public BigDecimal getProductTotal() {
        return productTotal;
    }

    public void setProductTotal(BigDecimal productTotal) {
        this.productTotal = productTotal;
    }
    public String getNextWeekPlan() {
        return nextWeekPlan;
    }

    public void setNextWeekPlan(String nextWeekPlan) {
        this.nextWeekPlan = nextWeekPlan;
    }
    public String getConnectInfo() {
        return connectInfo;
    }

    public void setConnectInfo(String connectInfo) {
        this.connectInfo = connectInfo;
    }
    public String getJobDoUnit() {
        return jobDoUnit;
    }

    public void setJobDoUnit(String jobDoUnit) {
        this.jobDoUnit = jobDoUnit;
    }
    public String getSceneSafer() {
        return sceneSafer;
    }

    public void setSceneSafer(String sceneSafer) {
        this.sceneSafer = sceneSafer;
    }
    public Boolean getBelongDanger() {
        return belongDanger;
    }

    public void setBelongDanger(Boolean belongDanger) {
        this.belongDanger = belongDanger;
    }
    public Boolean getJoinManger() {
        return joinManger;
    }

    public void setJoinManger(Boolean joinManger) {
        this.joinManger = joinManger;
    }
    public String getMainDanger() {
        return mainDanger;
    }

    public void setMainDanger(String mainDanger) {
        this.mainDanger = mainDanger;
    }
    public String getTechManger() {
        return techManger;
    }

    public void setTechManger(String techManger) {
        this.techManger = techManger;
    }
    public String getMainEquipment() {
        return mainEquipment;
    }

    public void setMainEquipment(String mainEquipment) {
        this.mainEquipment = mainEquipment;
    }
    public String getDesigner() {
        return designer;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }
    public String getQualityJiaodi() {
        return qualityJiaodi;
    }

    public void setQualityJiaodi(String qualityJiaodi) {
        this.qualityJiaodi = qualityJiaodi;
    }
    public String getTotalProgress() {
        return totalProgress;
    }

    public void setTotalProgress(String totalProgress) {
        this.totalProgress = totalProgress;
    }
    public String getProjectReceive() {
        return projectReceive;
    }

    public void setProjectReceive(String projectReceive) {
        this.projectReceive = projectReceive;
    }
    public Long getMakePerson() {
        return makePerson;
    }

    public void setMakePerson(Long makePerson) {
        this.makePerson = makePerson;
    }
    public String getMakePersonName() {
        return makePersonName;
    }

    public void setMakePersonName(String makePersonName) {
        this.makePersonName = makePersonName;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public String getProductionJob() {
        return productionJob;
    }

    public void setProductionJob(String productionJob) {
        this.productionJob = productionJob;
    }
    public String getProjectQestions() {
        return projectQestions;
    }

    public void setProjectQestions(String projectQestions) {
        this.projectQestions = projectQestions;
    }
    public String getSceneStuInfo() {
        return sceneStuInfo;
    }

    public void setSceneStuInfo(String sceneStuInfo) {
        this.sceneStuInfo = sceneStuInfo;
    }
    public String getSceneLaborInfo() {
        return sceneLaborInfo;
    }

    public void setSceneLaborInfo(String sceneLaborInfo) {
        this.sceneLaborInfo = sceneLaborInfo;
    }
    public String getLastCheck() {
        return lastCheck;
    }

    public void setLastCheck(String lastCheck) {
        this.lastCheck = lastCheck;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
