/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.material.mapper.StoreTopMapper;
import com.ejianc.business.material.service.IStoreTopService;
import com.ejianc.business.material.vo.ConstructionStoreVo;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StoreTopServiceImpl
implements IStoreTopService {
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private StoreTopMapper storeTopMapper;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<JSONObject> storeTop(ConstructionStoreVo constructionStoreVo) {
        JSONObject jsonObject = new JSONObject();
        return CommonResponse.success((Object)jsonObject);
    }

    private JSONObject queryProjectTop(String orgIds, Long materialId, JSONObject json) {
        List<JSONObject> projectTop = this.storeTopMapper.constructionStoreTopProject(orgIds, materialId);
        if (CollectionUtils.isNotEmpty(projectTop)) {
            List projectId = projectTop.stream().map(e -> e.get((Object)"projectId")).collect(Collectors.toList());
            String projectIds = "(" + String.join((CharSequence)",", projectId.stream().map(Object::toString).collect(Collectors.toList())) + ")";
            List<JSONObject> contractTop = this.storeTopMapper.constructionStoreTopContract(projectIds, materialId, orgIds);
            Map<Object, Object> contractTopData = new HashMap();
            if (CollectionUtils.isNotEmpty(contractTop)) {
                contractTopData = contractTop.stream().collect(Collectors.toMap(e -> e.get((Object)"projectId"), e -> e));
            }
            for (JSONObject js : projectTop) {
                js.put("contractTop", contractTopData.get(js.get((Object)"projectId")) == null ? JSONObject.parseObject((String)"{\"avgPrice\":0,\"minPrice\":0,\"maxPrice\":0}") : contractTopData.get(js.get((Object)"projectId")));
            }
            json.put("projectTop5", projectTop);
        } else {
            json.put("projectTop5", null);
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        BigDecimal companyTop = this.storeTopMapper.constructionStoreTopContractCompany(tenantId, materialId);
        json.put("storeTopCompany", (Object)(companyTop == null ? Integer.valueOf(0) : companyTop));
        return json;
    }

    @Override
    public CommonResponse<JSONObject> storeData(ConstructionStoreVo constructionStoreVo) {
        JSONObject jsonObject = new JSONObject();
        if (null == constructionStoreVo.getPlanSort()) {
            constructionStoreVo.setPlanSort("desc");
        }
        if (null == constructionStoreVo.getInStoreSort()) {
            constructionStoreVo.setInStoreSort("desc");
        }
        if (null == constructionStoreVo.getInStoreSort()) {
            constructionStoreVo.setInStoreSort("desc");
        }
        return CommonResponse.success((Object)jsonObject);
    }
}

