/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sub.bean.SubContractDetailEntity;
import com.ejianc.business.sub.bean.SubContractEntity;
import com.ejianc.business.sub.enums.ChangeStatusEnum;
import com.ejianc.business.sub.enums.ChangeTypeEnum;
import com.ejianc.business.sub.mapper.SubContractMapper;
import com.ejianc.business.sub.service.IChangeService;
import com.ejianc.business.sub.service.IContractDetailService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISubSettleService;
import com.ejianc.business.sub.utils.BigDecimalUtils;
import com.ejianc.business.sub.utils.ExcelImportUtil;
import com.ejianc.business.sub.utils.TreeNodeBUtil;
import com.ejianc.business.sub.vo.SubContractDetailVO;
import com.ejianc.business.sub.vo.SubContractVO;
import com.ejianc.business.sub.vo.SubProjectReportVo;
import com.ejianc.business.sub.vo.SubProjectSettleNumVO;
import com.ejianc.business.sub.vo.SubSqlParam;
import com.ejianc.business.sub.vo.warn.SubWarnVo;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class SubContractServiceImpl
extends BaseServiceImpl<SubContractMapper, SubContractEntity>
implements IContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SUB_CONTRACT_BILL_CODE = "SUB_CONTRACT";
    private static final String SGHTZJE_K_SJZCJE = "P-nkX4Sk61";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private ISubSettleService settleService;
    @Autowired
    private IChangeService changeService;
    private static String PARAM_LABOR_MNY = "P-9P63m148";
    private static String PARAM_LABOR_DETAIL_NUM = "P-J7c50750";
    private static String PARAM_LABOR_DETAIL_MNY = "P-rj09ju51";
    private static String PARAM_MAJOR_MNY = "P-k3cSoQ49";
    private static String PARAM_MAJOR_DETAIL_NUM = "P-5Z9ASh54";
    private static String PARAM_MAJOR_DETAIL_MNY = "P-RjM0C653";
    private static final String PARAM_BUDGE_MNY = "P-z3eQ6q89";

    @Override
    public SubContractVO insertOrUpdate(SubContractVO contractVO) {
        if (StringUtils.isBlank((CharSequence)contractVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(SUB_CONTRACT_BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                contractVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.eq(SubContractEntity::getBillCode, (Object)contractVO.getBillCode());
        lambda.ne(contractVO.getId() != null && contractVO.getId() > 0L, BaseEntity::getId, (Object)contractVO.getId());
        List entities = super.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        SubContractEntity contractEntity = (SubContractEntity)((Object)BeanMapper.map((Object)((Object)contractVO), SubContractEntity.class));
        contractEntity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        contractEntity.setBeforeChangeMny(contractEntity.getContractMny());
        contractEntity.setBeforeChangeTaxMny(contractEntity.getContractTaxMny());
        contractEntity.setBaseMoney(contractEntity.getContractMny());
        contractEntity.setBaseTaxMoney(contractEntity.getContractTaxMny());
        boolean b = this.saveOrUpdateNoES((Object)contractEntity);
        List<SubContractDetailEntity> contractDetailEntityList = contractEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(contractDetailEntityList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (SubContractDetailEntity cdEntity : contractDetailEntityList) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (SubContractDetailEntity cdEntity : contractDetailEntityList) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.contractDetailService.saveOrUpdateBatch(contractDetailEntityList);
        }
        return this.queryDetail(contractEntity.getId(), true);
    }

    @Override
    public SubContractVO queryDetail(Long id, Boolean detailHasChildren) {
        SubContractEntity contractEntity = (SubContractEntity)((Object)super.selectById((Serializable)id));
        SubContractVO contractVO = (SubContractVO)((Object)BeanMapper.map((Object)((Object)contractEntity), SubContractVO.class));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List detailEntityListDb = this.contractDetailService.queryList(queryParam, false);
        ArrayList detailEntityList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailEntityListDb)) {
            detailEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType() || ChangeTypeEnum.\u4e2d\u6b62.getCode() != entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (SubContractDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList(detailEntityList, SubContractDetailVO.class);
            SubContractServiceImpl.sortIntMethod(resultMapList);
            if (detailHasChildren.booleanValue()) {
                contractVO.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
            } else {
                contractVO.setDetailList(resultMapList);
            }
        } else {
            contractVO.setDetailList(BeanMapper.mapList(detailEntityList, SubContractDetailVO.class));
        }
        return contractVO;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<SubContractVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(BaseEntity::getId, ids);
            queryWrapper.isNotNull(SubContractEntity::getEnquiryPriceBillId);
            List materialContractEntities = this.list((Wrapper)queryWrapper);
            boolean bl = this.removeByIds(ids, false);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<IPage<SubContractVO>> queryListVOs(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        IPage page = this.queryPage(param, false);
        List contractVOList = BeanMapper.mapList((Iterable)page.getRecords(), SubContractVO.class);
        Page contractVOIPage = new Page();
        contractVOIPage.setCurrent(page.getCurrent());
        contractVOIPage.setRecords(contractVOList);
        contractVOIPage.setSize(page.getSize());
        contractVOIPage.setTotal(page.getTotal());
        contractVOIPage.setPages(page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)contractVOIPage);
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Integer> resp = new HashMap();
        QueryWrapper wrapper = SubContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(base_tax_money) as baseTaxMoney, sum(contract_tax_mny) as contractTaxMny"});
        resp = super.getMap((Wrapper)wrapper);
        if (null == resp) {
            resp = new HashMap();
            resp.put("baseTaxMoney", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;
    }

    @Override
    public SubContractVO queryRecordDetail(Long id, boolean b) {
        return null;
    }

    @Override
    public List<SubContractDetailVO> refContractDetail(Long contractId, String condition) {
        String code = null;
        String name = null;
        boolean filterFlag = false;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            String codeStr = (String)conditionMap.get("code");
            String nameStr = (String)conditionMap.get("name");
            code = StringUtils.isNotBlank((CharSequence)codeStr) ? codeStr : null;
            name = StringUtils.isNotBlank((CharSequence)nameStr) ? nameStr : null;
            filterFlag = code != null || name != null;
        }
        HashMap<Long, SubContractDetailEntity> leafMap = new HashMap<Long, SubContractDetailEntity>();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        List detailEntityListDb = this.contractDetailService.list((Wrapper)wrapper);
        ArrayList<SubContractDetailEntity> entities = new ArrayList<SubContractDetailEntity>();
        if (CollectionUtils.isNotEmpty((Collection)detailEntityListDb)) {
            for (SubContractDetailEntity entity : detailEntityListDb) {
                if (entity.getLeafFlag().booleanValue() && (code != null && StringUtils.isNotEmpty((CharSequence)entity.getCode()) && !entity.getCode().contains(code) || name != null && StringUtils.isNotEmpty((CharSequence)entity.getName()) && !entity.getName().contains(name)) || null != entity.getChangeType() && ChangeTypeEnum.\u4e2d\u6b62.getCode() == entity.getChangeType()) continue;
                entities.add(entity);
                if (!entity.getLeafFlag().booleanValue()) continue;
                leafMap.put(entity.getId(), entity);
            }
        }
        List<SubContractDetailEntity> resList = null;
        resList = filterFlag ? this.handleFilterData(entities, leafMap) : entities;
        List detailVos = BeanMapper.mapList(resList, SubContractDetailVO.class);
        if (CollectionUtils.isNotEmpty((Collection)detailVos)) {
            for (SubContractDetailVO cdEntity : detailVos) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
            }
        }
        this.settleService.getSumSettleNum(detailVos);
        List<SubContractDetailVO> contractDetailVOS = TreeNodeBUtil.buildTree(detailVos);
        SubContractServiceImpl.sortIntMethod(contractDetailVOS);
        return contractDetailVOS;
    }

    private static void sortIntMethod(List<SubContractDetailVO> list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] strs2;
                ObjectMapper objectMapper = new ObjectMapper();
                SubContractDetailVO o1Detail = (SubContractDetailVO)objectMapper.convertValue(o1, SubContractDetailVO.class);
                SubContractDetailVO o2Detail = (SubContractDetailVO)objectMapper.convertValue(o2, SubContractDetailVO.class);
                String[] strs1 = o1Detail.getTreeIndex().split("\\.");
                int length = strs1.length > (strs2 = o2Detail.getTreeIndex().split("\\.")).length ? strs1.length : strs2.length;
                for (int i = 0; i < length; ++i) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (num1 < num2) {
                        return -1;
                    }
                    if (num1 <= num2) continue;
                    return 1;
                }
                return 0;
            }
        });
    }

    private List<SubContractDetailEntity> handleFilterData(List<SubContractDetailEntity> entities, HashMap<Long, SubContractDetailEntity> leafMap) {
        if (MapUtils.isEmpty(leafMap)) {
            entities.clear();
            return entities;
        }
        Map<Long, SubContractDetailEntity> map = entities.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        ArrayList<SubContractDetailEntity> resList = new ArrayList<SubContractDetailEntity>();
        for (Long id : leafMap.keySet()) {
            SubContractDetailEntity leafContractDetailEntity = leafMap.get(id);
            resList.add(leafContractDetailEntity);
            this.getContractDetaiParent(leafContractDetailEntity, map, resList);
        }
        return resList;
    }

    private void getContractDetaiParent(SubContractDetailEntity leafContractDetailEntity, Map<Long, SubContractDetailEntity> map, List<SubContractDetailEntity> resList) {
        Long parentId = leafContractDetailEntity.getParentId();
        if (null != parentId) {
            resList.add(map.get(parentId));
            this.getContractDetaiParent(map.get(parentId), map, resList);
        }
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<SubContractDetailVO> detailVoList = new ArrayList<SubContractDetailVO>();
            HashMap<String, String> tidMap = new HashMap<String, String>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                SubContractDetailVO vo = new SubContractDetailVO();
                boolean flag = false;
                boolean parentWarn = false;
                String warnType = "";
                String detailIndex = (String)datas.get(0);
                vo.setTreeIndex(detailIndex);
                String id = UUID.randomUUID().toString().replaceAll("-", "");
                if (StringUtils.isNotEmpty((CharSequence)detailIndex)) {
                    String[] split = detailIndex.split("[-/.]");
                    vo.setTid(id);
                    tidMap.put(detailIndex, id);
                    if (split.length > 1) {
                        vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                    }
                } else {
                    vo.setTid(id);
                    vo.setTpid("");
                }
                if (indexMap.containsKey(detailIndex)) {
                    return CommonResponse.error((String)("\u7b2c" + (i + 2) + "\u884c\u5e8f\u53f7\u548c\u7b2c" + ((Integer)indexMap.get(detailIndex) + 2) + "\u884c\u91cd\u590d"));
                }
                indexMap.put(detailIndex, i);
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    vo.setCode(null);
                    warnType = warnType + "\u6e05\u5355\u7f16\u7801\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setCode((String)datas.get(1));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    vo.setName(null);
                    warnType = warnType + "\u6e05\u5355\u540d\u79f0\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setName((String)datas.get(2));
                }
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(3))) && ((String)datas.get(3)).length() > 2000) {
                    flag = true;
                    warnType = warnType + "\u7279\u5f81\u63cf\u8ff0/\u89c4\u683c\u578b\u53f7\u8d85\u8fc72000\u5b57,";
                }
                vo.setSpec((String)datas.get(3));
                vo.setUnit((String)datas.get(4));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(5)))) {
                    vo.setNum(null);
                    warnType = warnType + "\u5de5\u7a0b\u91cf\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setNum(new BigDecimal((String)datas.get(5)));
                    }
                    catch (Exception e) {
                        vo.setNum(null);
                        warnType = warnType + "\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(6)))) {
                    vo.setPrice(null);
                    warnType = warnType + "\u7efc\u5408\u5355\u4ef7\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setPrice(new BigDecimal((String)datas.get(6)));
                    }
                    catch (Exception e) {
                        vo.setPrice(null);
                        warnType = warnType + "\u7efc\u5408\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (!flag) {
                    vo.setMoney(vo.getPrice().multiply(vo.getNum()).setScale(2, 4));
                }
                if ((null == vo.getPrice() || vo.getPrice().compareTo(BigDecimal.ZERO) == 0) && null != vo.getMoney()) {
                    vo.setPrice(BigDecimalUtils.safeDiv(vo.getMoney(), vo.getNum()).setScale(2, 4));
                }
                if ((null == vo.getMoney() || vo.getMoney().compareTo(BigDecimal.ZERO) == 0) && null != vo.getPrice()) {
                    BigDecimal decimal = BigDecimalUtils.safeMultiply(vo.getNum(), vo.getPrice()).setScale(2, 4);
                    vo.setMoney(ComputeUtil.scale((BigDecimal)decimal, (int)2));
                }
                vo.setMemo((String)datas.get(8));
                vo.setImportFlag(!flag);
                vo.setParentWarn(parentWarn);
                if (flag) {
                    warnType = warnType.substring(0, warnType.length() - 1);
                }
                vo.setWarnType(warnType);
                vo.setRowState("add");
                vo.setShadowId(vo.getTid());
                vo.setChangeType(3);
                detailVoList.add(vo);
            }
            for (SubContractDetailVO tVo : detailVoList) {
                tVo.setTpid((String)tidMap.get(tVo.getTpid()));
            }
            List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
            List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
            ArrayList<Map<String, Object>> falseList = new ArrayList<Map<String, Object>>();
            List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
            List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
            resp.put("successList", allList.get(0));
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)(result.size() - errorList.size()));
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @Override
    public List<Map<String, Object>> payMnyWarn(List<SubSqlParam> sqlParamList) {
        return ((SubContractMapper)this.baseMapper).payMnyWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> prePayMnyWarn(List<SubSqlParam> sqlParamList) {
        return ((SubContractMapper)this.baseMapper).prePayMnyWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> finishMnyWarn(List<SubSqlParam> sqlParamList) {
        return ((SubContractMapper)this.baseMapper).finishMnyWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> invoicePayMnyWarn(List<SubSqlParam> sqlParamList) {
        return ((SubContractMapper)this.baseMapper).invoicePayMnyWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> invoiceContractMnyWarn(List<SubSqlParam> sqlParamList) {
        return ((SubContractMapper)this.baseMapper).invoiceContractMnyWarn(sqlParamList);
    }

    @Override
    public List<SubWarnVo> subProjectOutMny(List<Long> tenantIds) {
        return ((SubContractMapper)this.baseMapper).subProjectOutMny(tenantIds);
    }

    @Override
    public List<SubProjectReportVo> getMonthSubMny(Long projectId, Integer lastDay) {
        return ((SubContractMapper)this.baseMapper).getMonthSubMny(projectId, lastDay);
    }

    @Override
    public SubProjectReportVo getSubContract(Long projectId) {
        BigDecimal mny = BigDecimal.ZERO;
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(SubContractEntity::getProjectId, (Object)projectId);
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.in(SubContractEntity::getBillState, billStatus);
        List entities = super.list((Wrapper)lambda);
        for (SubContractEntity ce : entities) {
            mny = mny.add(ce.getContractTaxMny() == null ? BigDecimal.ZERO : ce.getContractTaxMny());
        }
        BigDecimal settleMny = ((SubContractMapper)this.baseMapper).getSubContract(projectId);
        SubProjectReportVo vo = new SubProjectReportVo();
        vo.setNum(entities.size());
        vo.setMny(mny);
        vo.setSettleMny(settleMny);
        return vo;
    }

    @Override
    public List<SubProjectSettleNumVO> getSubSettleNum(List<Long> projectIds) {
        return ((SubContractMapper)this.baseMapper).getSubSettleNum(projectIds);
    }

    @Override
    public BigDecimal fetchSjzcje(Long projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        return ((SubContractMapper)this.baseMapper).fetchSjzcje(projectId, null, null);
    }

    @Override
    public List<SubContractDetailVO> queryApplySubCount(IPage page, QueryParam queryApplySubParam) {
        QueryWrapper qw = SubContractServiceImpl.changeToQueryWrapper((QueryParam)queryApplySubParam);
        List<SubContractDetailVO> list = ((SubContractMapper)this.baseMapper).queryApplySubCount(page, qw);
        return list;
    }
}

