package com.ejianc.business.labprice.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ejianc.business.othprice.bean.OtherQuoteEntity;
import com.ejianc.business.othprice.service.IOtherQuoteService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.labprice.bean.LaborQuoteEntity;
import com.ejianc.business.labprice.service.ILaborQuoteService;
import com.ejianc.business.labprice.vo.LaborQuoteVO;

/**
 * 劳务询价报价
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("laborQuote")
public class LaborQuoteController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String RULE_CODE = "ZYDX_LABOR_QUOTE";
    private static final String BILL_CODE = "EJCBT202502000027";
    @Resource
    private IBillTypeApi billTypeApi;
    @Resource
    private IBillCodeApi billCodeApi;
    @Resource
    private IOrgApi iOrgApi;
    @Resource
    private ILaborQuoteService service;
    @Autowired
    private SessionManager sessionManager;
    @Resource
    private IAttachmentApi attachmentApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LaborQuoteVO> saveOrUpdate(@RequestBody LaborQuoteVO saveOrUpdateVO) {
    	LaborQuoteEntity entity = BeanMapper.map(saveOrUpdateVO, LaborQuoteEntity.class);
        // 校验当前时间是否超过询价单报价截止时间
        service.checkQuoteEndDate(entity.getInquiryId());
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(RULE_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	LaborQuoteVO vo = BeanMapper.map(entity, LaborQuoteVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LaborQuoteVO> queryDetail(Long id) {
    	LaborQuoteEntity entity = service.selectById(id);
    	LaborQuoteVO vo = BeanMapper.map(entity, LaborQuoteVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LaborQuoteVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (LaborQuoteVO vo : vos) {
                CommonResponse<String> resp = billTypeApi.checkQuote(BILL_CODE, vo.getId());
                if (!resp.isSuccess()) {
                    return CommonResponse.error("删除失败！" + resp.getMsg());
                }
            }
        }
        service.removeByIds(vos.stream().map(LaborQuoteVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LaborQuoteVO>> queryList(@RequestBody QueryParam param) {
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("create_time", "desc");
        param.getOrderMap().putAll(orderMap);
        IPage<LaborQuoteEntity> page = service.queryPage(param, false);
        IPage<LaborQuoteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<LaborQuoteVO> materialQuoteVOS = BeanMapper.mapList(page.getRecords(), LaborQuoteVO.class);
        if (CollectionUtils.isNotEmpty(materialQuoteVOS)) {
            List<Long> quoteIds = materialQuoteVOS.stream().map(LaborQuoteVO::getId).collect(Collectors.toList());
            JSONObject fileParam = new JSONObject();
            fileParam.put("sourceIds", quoteIds);
            JSONArray sourceTypeArr = new JSONArray();
            sourceTypeArr.add("quote");
            fileParam.put("sourceTypeList", JSON.toJSONString(sourceTypeArr));
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(fileParam);
            List<AttachmentVO> fileData = listCommonResponse.getData();
            Map<Long, AttachmentVO> fileMap = new HashMap<>();
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty(fileData)) {
                fileMap = fileData.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity(), (e1, e2) -> e1));
            }

            for (LaborQuoteVO materialQuoteVO : materialQuoteVOS) {
                if (fileMap.containsKey(materialQuoteVO.getId())) {
                    AttachmentVO attachmentVO = fileMap.get(materialQuoteVO.getId());
                    materialQuoteVO.setQuoteFileId(attachmentVO.getId());
                    materialQuoteVO.setQuoteFileName(attachmentVO.getFileName());
                }
            }
        }
        pageData.setRecords(materialQuoteVOS);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * 指定供应商登录、所有供应商登录校验查看权限
     *
     * @param inquiryId   询价单id
     * @param phoneNumber 电话号码
     *
     * @return {@link CommonResponse}<{@link Void}>
     */
    @GetMapping(value = "/checkViewAuthority")
    public CommonResponse<Void> checkViewAuthority(@RequestParam(value = "inquiryId") Long inquiryId,
                                                   @RequestParam(value = "phoneNumber") String phoneNumber) {
        service.checkViewAuthority(inquiryId, phoneNumber);
        return CommonResponse.success();
    }

    /**
     * 指定供应商报价校验报价权限
     *
     * @param inquiryId   询价单id
     * @param phoneNumber 电话号码
     *
     * @return {@link CommonResponse}<{@link Void}>
     */
    @GetMapping(value = "/checkQuotationAuthority")
    public CommonResponse<Void> checkQuotationAuthority(@RequestParam(value = "inquiryId") Long inquiryId,
                                                        @RequestParam(value = "phoneNumber") String phoneNumber) {
        service.checkQuotationAuthority(inquiryId, phoneNumber);
        return CommonResponse.success();
    }

    /**
     * 获取验证码
     *
     * @param inquiryId   询价单id
     * @param phoneNumber 电话号码
     *
     * @return {@link CommonResponse}<{@link Void}>
     *
     * @throws Exception 异常
     */
    @GetMapping(value = "/fetchVerifyCode")
    public CommonResponse<Void> fetchVerifyCode(@RequestParam(value = "inquiryId") Long inquiryId,
                                                @RequestParam(value = "phoneNumber") String phoneNumber) throws Exception {
        service.fetchVerifyCode(inquiryId, phoneNumber);
        return CommonResponse.success("验证码发送成功！");
    }


    /**
     * 登录
     *
     * @param phoneNumber 电话号码
     * @param validate    验证码
     *
     * @return {@link CommonResponse}<{@link String}>
     */
    @ApiOperation(value = "登录")
    @GetMapping(value = "/login")
    public CommonResponse<String> login(@RequestParam(value = "phoneNumber") String phoneNumber,
                                        @RequestParam(value = "validate") String validate) {
        service.login(phoneNumber, validate);
        return CommonResponse.success("登录成功！", phoneNumber);
    }

    /**
     * 收回
     *
     * @param id 报价单id
     *
     * @return {@link CommonResponse}<{@link String}>
     */
    @ApiOperation(value = "收回")
    @GetMapping(value = "/withdraw")
    public CommonResponse<String> withdraw(@RequestParam(value = "id") Long id) {
        service.withdraw(id);
        return CommonResponse.success("收回成功！");
    }

    /**
     * 修改单据状态
     *
     * @param id        id
     * @param billState 单据状态
     *
     * @return {@link CommonResponse}<{@link String}>
     */
    @ApiOperation(value = "修改单据状态")
    @GetMapping(value = "/changeStatus")
    public CommonResponse<String> changeStatus(@RequestParam(value = "id") Long id,
                                               @RequestParam(value = "billState") Integer billState) {
        service.changeStatus(id, billState);
        return CommonResponse.success("单据状态修改成功！");
    }
    /**
     * 最近一次的报价记录
     *
     * @param phoneNumber 报价手机号码（当前登录的手机号码）
     *
     * @return {@link CommonResponse}<{@link LaborQuoteVO}>
     */
    @ApiOperation(value = "最近一次的报价记录")
    @GetMapping(value = "/recentQuote")
    public CommonResponse<LaborQuoteVO> recentQuote(@RequestParam(value = "phoneNumber") String phoneNumber) {
        return CommonResponse.success("单据状态修改成功！", service.recentQuote(phoneNumber));
    }
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<LaborQuoteEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("LaborQuote-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refLaborQuoteData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<LaborQuoteVO>> refLaborQuoteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<LaborQuoteEntity> page = service.queryPage(param,false);
        IPage<LaborQuoteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), LaborQuoteVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
