package com.ejianc.business.othprice.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bidprice.consts.InquiryStateEnum;
//import com.ejianc.business.finance.util.MathUtil;
//import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.material.utlis.ArchivesUtil;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.othprice.bean.OtherInquiryEntity;
import com.ejianc.business.othprice.bean.PicketageEntity;
import com.ejianc.business.othprice.service.IOtherInquiryService;
import com.ejianc.business.othprice.service.impl.PicketageServiceImpl;
import com.ejianc.business.othprice.vo.ImportOtherInquiryDetailVO;
import com.ejianc.business.othprice.vo.OtherInquiryVO;
import com.ejianc.business.utils.MathUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 其他询价
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("otherInquiry")
@Api(value = "其他询价", tags = {"其他询价"})
public class OtherInquiryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZYDX_OTHER_INQUIRY";//此处需要根据实际修改

    @Autowired
    private IOtherInquiryService service;

    @Autowired
    private PicketageServiceImpl picketageService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ArchivesUtil archivesUtil;

//    @Autowired
//    private IMaterialSettlementApi materialSettlementApi;

    @Autowired
    private IEmployeeApi employeeApi;

    //流程标识1询价2开标
    private static final String PARAM_BID_PROCESS = "P-k8181N67";

    @Autowired
    private IParamConfigApi paramConfigApi;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OtherInquiryVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody OtherInquiryVO saveOrUpdateVO) {
    	OtherInquiryEntity entity = BeanMapper.map(saveOrUpdateVO, OtherInquiryEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                entity.setInquiryState(InquiryStateEnum.DEFAULT_STATE.getCode());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(entity.getBidProcess() == null){
            //放置流程标识1询价2开标
            CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(PARAM_BID_PROCESS);
            if (byCode.isSuccess() && null != byCode.getData()) {
                ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
                String valueData = paramRegisterSetVO.getValueData();
                entity.setBidProcess(Integer.valueOf(valueData));
            }
        }
        //默认开标状态
        if(entity.getBidOpenState() == null){
            entity.setBidOpenState(0);
        }
    	service.saveOrUpdate(entity, false);
    	OtherInquiryVO vo = BeanMapper.map(entity, OtherInquiryVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * 截止报价，修改供应商
     * @param updateVo
     * @return
     */
    @RequestMapping(value = "/updateInquiry", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OtherInquiryVO> updateInquiry(@RequestBody OtherInquiryVO updateVo){
        LambdaQueryWrapper<PicketageEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(PicketageEntity::getInquiryId,updateVo.getId());
        List<PicketageEntity> list = picketageService.list(queryWrapper);
        if(list.size()>0){
            return CommonResponse.error("修改失败，当前单据已定标！");
        }

        OtherInquiryVO vo = service.updateInquiry(updateVo);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherInquiryVO> queryDetail(@RequestParam Long id) {
    	OtherInquiryEntity entity = service.selectById(id);
    	if(entity == null){
    	    return CommonResponse.error("查询详情失败，数据不存在！",null);
        }
    	OtherInquiryVO vo = BeanMapper.map(entity, OtherInquiryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

//    /**
//     * 查询历史价，参照新增时使用
//     * @param vo
//     * @return
//     */
//    @PostMapping("queryPrice")
//    @ResponseBody
//    public CommonResponse<List<MaterialPriceVO>> queryPrice(@RequestBody MaterialPriceVO vo) {
//        //service.queryPrice(vo);
//        CommonResponse<MaterialPriceVO> commonResponse = materialSettlementApi.queryPrice(vo);
//        if(commonResponse.isSuccess()){
//            MaterialPriceVO materialPriceVO = commonResponse.getData();
//            return CommonResponse.success("查询成功！", materialPriceVO.getDetail());
//        }else{
//            return CommonResponse.error("查询失败！");
//        }
//    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OtherInquiryVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (OtherInquiryVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(OtherInquiryVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OtherInquiryVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("purchaseSubject");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        if(param.getParams().containsKey("inquiryState")){
            Integer inquiryState = Integer.parseInt(param.getParams().get("inquiryState").getValue().toString());
            //筛选条件为报价中时，同时查询报价中、已截止但还未到截止报价时间的
            if(InquiryStateEnum.QUOTATION_STATE.getCode() == inquiryState){
                param.getParams().put("inquiryState",new Parameter(QueryParam.IN,Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(),InquiryStateEnum.EXPIRATION_STATE.getCode())));
                param.getParams().put("quoteEndDate",new Parameter(QueryParam.GT,new Date()));
            }
            //判断当前筛选条件询价状态是已截止的，同时查询询价状态为报价中但截止报价时间小于当前时间的
            if(InquiryStateEnum.EXPIRATION_STATE.getCode() == inquiryState){
                param.getParams().put("inquiryState",new Parameter(QueryParam.IN,Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(),InquiryStateEnum.EXPIRATION_STATE.getCode())));
                param.getParams().put("quoteEndDate",new Parameter(QueryParam.LT,new Date()));
            }
            //筛选条件为已定标，同时查询已定标和已签订
            if(InquiryStateEnum.WIN_STATE.getCode() == inquiryState){
                param.getParams().put("inquiryState",new Parameter(QueryParam.IN,Arrays.asList(InquiryStateEnum.WIN_STATE.getCode(),InquiryStateEnum.SIGN_STATE.getCode())));
            }
        }

        IPage<OtherInquiryEntity> page = service.queryPage(param,false);
        IPage<OtherInquiryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<OtherInquiryVO> vos = BeanMapper.mapList(page.getRecords(), OtherInquiryVO.class);
        for (OtherInquiryVO vo : vos) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            vo.setInquiryStateName(InquiryStateEnum.getTypeNameByCode(vo.getInquiryState()));
            //报价中但已超时的询价申请，需要显示为已截止
            if(InquiryStateEnum.QUOTATION_STATE.getCode().equals(vo.getInquiryState()) && vo.getQuoteEndDate().compareTo(new Date()) < 0){
                vo.setInquiryStateName(InquiryStateEnum.EXPIRATION_STATE.getDescription());
            }
            //已截止并且截止时间大于当前时间，显示为报价中
            if(InquiryStateEnum.EXPIRATION_STATE.getCode().equals(vo.getInquiryState()) && vo.getQuoteEndDate().compareTo(new Date()) > 0){
                vo.setInquiryStateName(InquiryStateEnum.QUOTATION_STATE.getDescription());
            }
            //询价状态为已签订的，显示为已定标
            if(InquiryStateEnum.SIGN_STATE.getCode().equals(vo.getInquiryState())){
                vo.setInquiryStateName(InquiryStateEnum.WIN_STATE.getDescription());
            }
        }
        pageData.setRecords(vos);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("purchaseSubject");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        if(param.getParams().containsKey("inquiryState")){
            Integer inquiryState = Integer.parseInt(param.getParams().get("inquiryState").getValue().toString());
            //筛选条件为报价中时，同时查询报价中、已截止但还未到截止报价时间的
            if(InquiryStateEnum.QUOTATION_STATE.getCode() == inquiryState){
                param.getParams().put("inquiryState",new Parameter(QueryParam.IN,Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(),InquiryStateEnum.EXPIRATION_STATE.getCode())));
                param.getParams().put("quoteEndDate",new Parameter(QueryParam.GT,new Date()));
            }
            //判断当前筛选条件询价状态是已截止的，同时查询询价状态为报价中但截止报价时间小于当前时间的
            if(InquiryStateEnum.EXPIRATION_STATE.getCode() == inquiryState){
                param.getParams().put("inquiryState",new Parameter(QueryParam.IN,Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(),InquiryStateEnum.EXPIRATION_STATE.getCode())));
                param.getParams().put("quoteEndDate",new Parameter(QueryParam.LT,new Date()));
            }
            //筛选条件为已定标，同时查询已定标和已签订
            if(InquiryStateEnum.WIN_STATE.getCode() == inquiryState){
                param.getParams().put("inquiryState",new Parameter(QueryParam.IN,Arrays.asList(InquiryStateEnum.WIN_STATE.getCode(),InquiryStateEnum.SIGN_STATE.getCode())));
            }
        }
        List<OtherInquiryEntity> list = service.queryList(param);
        List<OtherInquiryVO> vos = BeanMapper.mapList(list, OtherInquiryVO.class);
        for (OtherInquiryVO vo : vos) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            vo.setInquiryStateName(InquiryStateEnum.getTypeNameByCode(vo.getInquiryState()));
            //报价中但已超时的询价申请，需要显示为已截止
            if(InquiryStateEnum.QUOTATION_STATE.getCode().equals(vo.getInquiryState()) && vo.getQuoteEndDate().compareTo(new Date()) < 0){
                vo.setInquiryStateName(InquiryStateEnum.EXPIRATION_STATE.getDescription());
            }
            //已截止并且截止时间大于当前时间，显示为报价中
            if(InquiryStateEnum.EXPIRATION_STATE.getCode().equals(vo.getInquiryState()) && vo.getQuoteEndDate().compareTo(new Date()) > 0){
                vo.setInquiryStateName(InquiryStateEnum.QUOTATION_STATE.getDescription());
            }
            //询价状态为已签订的，显示为已定标
            if(InquiryStateEnum.SIGN_STATE.getCode().equals(vo.getInquiryState())){
                vo.setInquiryStateName(InquiryStateEnum.WIN_STATE.getDescription());
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("OtherInquiry-export.xlsx", beans, response);
    }

    /**
     * 其他询价导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "other-inquiry-import.xlsx", "其他询价申请导入模板");
    }


    /**
     * 其他询价excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<ImportOtherInquiryDetailVO> successList = new ArrayList<>();
            List<ImportOtherInquiryDetailVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 9) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    ImportOtherInquiryDetailVO inquiryDetailVO = new ImportOtherInquiryDetailVO();
                    if (StringUtils.isBlank(datas.get(0))) {
                        inquiryDetailVO.setErrorMessage("编码为必填项");
                    }  else {
                        inquiryDetailVO.setDetailCode(datas.get(0).trim());
                    }
                    if (StringUtils.isBlank(datas.get(1))) {
                        inquiryDetailVO.setErrorMessage("名称为必填项");
                    } else if (datas.get(1).length() > 20) {
                        inquiryDetailVO.setErrorMessage("名称填写长度为0~20字");
                    } else {
                        inquiryDetailVO.setDetailName(datas.get(1).trim());
                    }
                    if (StringUtils.isNotBlank(datas.get(2))) {
                        inquiryDetailVO.setSpec(datas.get(2).trim());
                    }
                    if (org.apache.commons.lang.StringUtils.isNotEmpty(datas.get(3))){
                        inquiryDetailVO.setUnit(datas.get(3).trim());
                    }
                    if (StringUtils.isNotBlank(datas.get(8)) && datas.get(8).length() > 50) {
                        inquiryDetailVO.setErrorMessage("备注填写长度为0~50字");
                    } else {
                        inquiryDetailVO.setMemo(datas.get(8));
                    }
                    if (StringUtils.isNotBlank(datas.get(4))) {
                        try {
                            inquiryDetailVO.setNum(ComputeUtil.scale(new BigDecimal(datas.get(4)), 8));
                            if (inquiryDetailVO.getNum().longValue() < 0) {
                                inquiryDetailVO.setErrorMessage("数量必须大于0");
                            }
                        } catch (Exception e) {
                            inquiryDetailVO.setErrorMessage("数量必须为数字");
                        }
                    }
                    if (StringUtils.isNotBlank(datas.get(5))) {
                        try {
                            inquiryDetailVO.setReferPrice(ComputeUtil.scale(new BigDecimal(datas.get(5)), 8));
                            if (inquiryDetailVO.getReferPrice().doubleValue() < 0) {
                                inquiryDetailVO.setErrorMessage("参考价必须大于0");
                            }
                        } catch (Exception e) {
                            inquiryDetailVO.setErrorMessage("参考价必须为数字");
                        }
                    } else {
                        inquiryDetailVO.setReferPrice(new BigDecimal(0));
                    }
                    /*if (org.apache.commons.lang3.StringUtils.isNotBlank(datas.get(6))) {
                        try {
                            inquiryDetailVO.setMny(new BigDecimal(datas.get(6)));
                            if (inquiryDetailVO.getMny().doubleValue() < 0) {
                                inquiryDetailVO.setErrorMessage("金额必须大于0");
                            }
                        } catch (Exception e) {
                            inquiryDetailVO.setErrorMessage("金额必须为数字");
                        }
                    } else {
                        inquiryDetailVO.setMny(new BigDecimal(0));
                    }*/
                    //金额计算
                    inquiryDetailVO.setMny(ComputeUtil.scaleTwo(MathUtil.safeMultiply(inquiryDetailVO.getReferPrice(),inquiryDetailVO.getNum())));
                    if (StringUtils.isNotBlank(datas.get(7))) {
                        try {
                            SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
                            String time = datas.get(7);
                            Date date = ft.parse(time);
                            inquiryDetailVO.setPlanUseDate(date);
                        } catch (Exception e) {
                            inquiryDetailVO.setErrorMessage("计划使用日期格式有误，例如2022-01-01");
                        }
                    }
                    if (org.apache.commons.lang.StringUtils.isNotEmpty(inquiryDetailVO.getErrorMessage())) {
                        errorList.add(inquiryDetailVO);
                    } else {
                        successList.add(inquiryDetailVO);
                    }
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    @ApiOperation("参照")
    @RequestMapping(value = "/refMaterialInquiryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OtherInquiryVO>> refMaterialInquiryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchObject(searchObject);
        if (StringUtils.isNotBlank(searchText)) {
            param.setSearchText(searchText);
            /** 模糊搜索配置字段示例 */
            List<String> fuzzyFields = param.getFuzzyFields();
            fuzzyFields.add("purchaseSubject");
            fuzzyFields.add("projectName");
            fuzzyFields.add("orgName");
        }
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("inquiryState",new Parameter(QueryParam.IN,Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(),InquiryStateEnum.EXPIRATION_STATE.getCode())));
        param.getParams().put("quoteEndDate",new Parameter(QueryParam.LT,new Date()));
        param.getParams().put("billState",new Parameter(QueryParam.IN,Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode())));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("inquiry_date", "desc");
        param.getOrderMap().putAll(orderMap);
        IPage<OtherInquiryEntity> page = service.queryPage(param,false);
        IPage<OtherInquiryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<OtherInquiryVO> vos = BeanMapper.mapList(page.getRecords(), OtherInquiryVO.class);
        for (OtherInquiryVO vo : vos) {
            vo.setInquiryStateName(InquiryStateEnum.EXPIRATION_STATE.getDescription());
        }
        pageData.setRecords(vos);

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    @ApiOperation("获取当前登录人手机号")
    @RequestMapping(value = "/queryPhone", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryPhone() {
        String mobilePhone = employeeApi.getById(sessionManager.getUserContext().getEmployeeId()).getData().getMobilePhone();
        return CommonResponse.success("查询列表数据成功！",mobilePhone);
    }


    @ApiOperation("开标")
    @RequestMapping(value = "/openBid", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherInquiryVO> openBid(@RequestParam Long id) {
        LambdaUpdateWrapper<OtherInquiryEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(OtherInquiryEntity::getId, id);
        updateWrapper.set(OtherInquiryEntity::getBidOpenState, 1);
        service.update(updateWrapper);
        return CommonResponse.success("开标成功！");
    }
}
