/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.UseApplyEntity;
import com.ejianc.business.material.bean.UseApplySubEntity;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.business.material.service.IUseApplySubService;
import com.ejianc.business.material.utlis.ArchivesUtil;
import com.ejianc.business.material.vo.ImportUseApplySubVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.UseApplyExportVO;
import com.ejianc.business.material.vo.UseApplySubVO;
import com.ejianc.business.material.vo.UseApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/apply/"})
public class UseApplyController
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 2779265683203439571L;
    private static final String BILL_CODE = "zydx_materialUseApply";
    @Autowired
    IUseApplyService iUseApplyService;
    @Autowired
    IUseApplySubService iUseApplySubService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private ArchivesUtil archivesUtil;
    private static final String PARAM_USE_APPLY = "P-J2u0z870";
    @Autowired
    private IParamConfigApi paramConfigApi;

    @RequestMapping(value={"/getSumNumCommon"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<UseApplyVO> getSumNumCommon(@RequestBody UseApplyVO vo) {
        return this.iUseApplyService.getSumNumCommon(vo);
    }

    @RequestMapping(value={"/checkAllParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkAllParams(@RequestBody UseApplyVO vo) {
        ParamsCheckVO paramsCheckVO = this.iUseApplyService.checkAllParams(vo);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<UseApplyVO> saveOrUpdate(@RequestBody UseApplyVO vo) {
        CommonResponse defDocById;
        UseApplyEntity entity;
        String billCode;
        CommonResponse byCode;
        if (CollectionUtils.isNotEmpty(vo.getUseApplySubEntities())) {
            long count = vo.getUseApplySubEntities().stream().filter(d -> !"del".equals(d.getRowState()) && ComputeUtil.isGreaterThan((BigDecimal)d.getOrderNum(), (BigDecimal)d.getPlanNum())).count();
            vo.setIsAbove(count > 0L ? 1 : 0);
            long count1 = vo.getUseApplySubEntities().stream().filter(d -> !"del".equals(d.getRowState()) && ComputeUtil.isGreaterThan((BigDecimal)d.getOrderNum(), (BigDecimal)d.getMasterPlanNum())).count();
            vo.setIsExceed(count1 > 0L ? 1 : 0);
        }
        if ((byCode = this.paramConfigApi.getByCode(PARAM_USE_APPLY)).isSuccess() && null != byCode.getData()) {
            ParamRegisterSetVO paramRegisterSetVO = (ParamRegisterSetVO)byCode.getData();
            String valueData = paramRegisterSetVO.getValueData();
            List collect = vo.getUseApplySubEntities().stream().filter(d -> !"del".equals(d.getRowState())).collect(Collectors.toList());
            if ("2".equals(valueData) && collect.size() == 0) {
                throw new BusinessException("\u8bf7\u5f55\u5165\u6750\u6599\u6e05\u5355!");
            }
        }
        if (StringUtils.isNotBlank((String)(billCode = (entity = (UseApplyEntity)((Object)BeanMapper.map((Object)((Object)vo), UseApplyEntity.class))).getBillCode()))) {
            Long id = entity.getId();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            queryWrapper.eq(UseApplyEntity::getBillCode, (Object)billCode);
            queryWrapper.ne(id != null, BaseEntity::getId, (Object)id);
            int count = this.iUseApplyService.count((Wrapper)queryWrapper);
            if (count > 0) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u5355\u636e\u7f16\u7801\u91cd\u590d");
            }
        } else {
            CommonResponse billCodeRes = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCodeRes.isSuccess()) {
                entity.setBillCode((String)billCodeRes.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (StringUtils.isBlank((String)entity.getName())) {
            SimpleDateFormat format = new SimpleDateFormat("YYYY-MM-dd");
            String name = entity.getApplyPerson() + format.format(entity.getApplyDate()) + "\u9700\u6c42\u7533\u8bf7";
            entity.setName(name);
        }
        if (entity.getPurchaseTypeId() != null && (defDocById = this.defdocApi.getDefDocById(entity.getPurchaseTypeId())).isSuccess() && defDocById.getData() != null) {
            DefdocDetailVO data = (DefdocDetailVO)defDocById.getData();
            entity.setPurchaseTypeCode(data.getCode());
            entity.setPurchaseTypeName(data.getName());
        }
        if (CollectionUtils.isNotEmpty(vo.getUseApplySubEntities())) {
            List<UseApplySubVO> useApplySubEntities = vo.getUseApplySubEntities();
            for (UseApplySubVO useApplySubVO : useApplySubEntities) {
                String onlykey = useApplySubVO.getMaterialTypeName() + useApplySubVO.getMaterialName() + useApplySubVO.getUnit() + useApplySubVO.getModel() + useApplySubVO.getMaterialCode();
                useApplySubVO.setOnlyKey(onlykey);
            }
            JSONObject jsonObject = this.archivesUtil.batchSaveArchive(useApplySubEntities, "materialTypeId", "materialId", "materialTypeName", "materialName", "materialCode", "unit", "model", "errorMessage");
            String sourceList = JSON.toJSONString((Object)jsonObject.get((Object)"sourceList"), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat});
            List list = JSONObject.parseArray((String)sourceList, UseApplySubVO.class);
            List useApplySubEntities1 = BeanMapper.mapList((Iterable)list, UseApplySubEntity.class);
            entity.setUseApplySubEntities(useApplySubEntities1);
        }
        entity.setPurchaseFlag(0);
        this.iUseApplyService.saveOrUpdate((Object)entity, false);
        UseApplyVO backVo = (UseApplyVO)((Object)BeanMapper.map((Object)((Object)entity), UseApplyVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)backVo));
    }

    @RequestMapping(value={"/updatePurchaseFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<UseApplyVO> updatePurchaseFlag(Long id, Integer purchaseFlag) {
        this.iUseApplyService.updatePurchaseFlag(id, purchaseFlag);
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<UseApplyVO> queryDetail(Long id) {
        UseApplyEntity entity = (UseApplyEntity)((Object)this.iUseApplyService.selectById(id));
        UseApplyVO vo = (UseApplyVO)((Object)BeanMapper.map((Object)((Object)entity), UseApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<UseApplyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("applyPerson");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        this.logger.info(">>>>>>>>>>>>>>>>>>>>>>1authOrgIds:{}", (Object)authOrgIds);
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            this.logger.info(">>>>>>>>>>>>>>>>>>>>>>2authOrgIds:{}, authResponse.getData():{}", (Object)authOrgIds, authResponse.getData() == null ? null : Integer.valueOf(((List)authResponse.getData()).size()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", this.iUseApplyService.queryForList(param, false));
    }

    @RequestMapping(value={"/queryPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("UseApply", this.iUseApplyService.selectById(id));
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<UseApplyVO> vos) {
        this.iUseApplyService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(10000);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("applyPerson");
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage<UseApplyVO> voPage = this.iUseApplyService.queryForList(queryParam, false);
        List list = voPage.getRecords();
        ArrayList exportVOS = new ArrayList();
        list.forEach(vo -> {
            UseApplyExportVO exportVO = (UseApplyExportVO)BeanMapper.map((Object)vo, UseApplyExportVO.class);
            exportVO.setCreateTime(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)vo.getCreateTime()));
            if (vo.getPlanEnterDate() != null) {
                exportVO.setPlanEnterDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getPlanEnterDate()));
            }
            if (vo.getBillState() == BillStateEnum.UNCOMMITED_STATE.getBillStateCode()) {
                exportVO.setBillState("\u81ea\u7531\u6001");
            }
            if (vo.getBillState() == BillStateEnum.COMMITED_STATE.getBillStateCode()) {
                exportVO.setBillState("\u5df2\u63d0\u4ea4");
            }
            if (vo.getBillState() == BillStateEnum.APPROVING_HAS_STATE.getBillStateCode()) {
                exportVO.setBillState("\u5ba1\u6279\u4e2d");
            }
            if (vo.getBillState() == BillStateEnum.PASSED_STATE.getBillStateCode()) {
                exportVO.setBillState("\u5ba1\u6279\u901a\u8fc7");
            }
            if (vo.getBillState() == BillStateEnum.UNAPPROVED.getBillStateCode()) {
                exportVO.setBillState("\u5ba1\u6279\u9a73\u56de");
            }
            if (vo.getBillState() == BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()) {
                exportVO.setBillState("\u5ba1\u6279\u4e2d");
            }
            if (vo.getEstimateMoney() != null) {
                exportVO.setEstimateMoney(vo.getEstimateMoney().setScale(2, 4));
            } else {
                exportVO.setEstimateMoney(new BigDecimal("0"));
            }
            if (vo.getSporadicMaterialFlag() == 0) {
                exportVO.setSporadicMaterialFlagName("\u5426");
            } else {
                exportVO.setSporadicMaterialFlagName("\u662f");
            }
            exportVOS.add(exportVO);
        });
        HashMap beans = new HashMap();
        beans.put("records", exportVOS);
        ExcelExport.getInstance().export("useApplyListExport.xlsx", beans, response);
    }

    @PostMapping(value={"excelExportMaterialList"})
    public void excelExportMaterialList(@RequestBody UseApplyVO useApplyVO, HttpServletResponse response) {
        UseApplyEntity entity = (UseApplyEntity)((Object)this.iUseApplyService.selectById(useApplyVO.getId()));
        HashMap<String, Object> beans = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<UseApplySubEntity> data = entity.getUseApplySubEntities();
        if (CollectionUtils.isNotEmpty(data)) {
            data.forEach(item -> {
                UseApplySubVO vo = (UseApplySubVO)((Object)((Object)BeanMapper.map((Object)item, UseApplySubVO.class)));
                if (vo.getSubPlanEnterDate() != null) {
                    vo.setSubPlanEnterDateStr(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getSubPlanEnterDate()));
                }
                vo.setApplyNum(vo.getApplyNum().setScale(4, 4).stripTrailingZeros());
                vo.setEstimatePrice(ComputeUtil.nullToZero((BigDecimal)vo.getEstimatePrice()).setScale(4, 4).stripTrailingZeros());
                list.add(vo);
            });
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String planEnterDate = "";
        String applyDate = "";
        if (null != entity.getPlanEnterDate()) {
            planEnterDate = sdf.format(entity.getPlanEnterDate());
        }
        if (null != entity.getApplyDate()) {
            applyDate = sdf.format(entity.getApplyDate());
        }
        beans.put("records", list);
        beans.put("entity", (Object)entity);
        beans.put("planEnterDate", planEnterDate);
        beans.put("applyDate", applyDate);
        ExcelExport.getInstance().export("useApplySubExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/referTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> referTree(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam String condition) {
        if (StringUtils.isEmpty((String)condition) || !condition.contains("orgId")) {
            throw new BusinessException("\u67e5\u8be2\u53c2\u6570\u4e0d\u6b63\u786e\uff01");
        }
        JSONObject conditionJson = JSONObject.parseObject((String)condition);
        Long orgId = conditionJson.getLong("orgId");
        Long projectId = conditionJson.getLong("projectId");
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("createTime", "desc");
        if (null != projectId) {
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        queryParam.setOrderMap(orderMap);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("applyPerson");
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List dataList = this.iUseApplyService.queryList(queryParam, false);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        List<Object> noApplyIds = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            QueryParam queryApplySubParam = new QueryParam();
            queryApplySubParam.getParams().put("pid", new Parameter("in", dataList.stream().map(BaseEntity::getId).collect(Collectors.toList())));
            List<UseApplySubEntity> useApplySubEntities = this.iUseApplyService.queryApplySubCount(queryApplySubParam);
            noApplyIds = useApplySubEntities.stream().map(UseApplySubEntity::getPid).collect(Collectors.toList());
        }
        for (UseApplyEntity entity : dataList) {
            if (!noApplyIds.contains(entity.getId())) continue;
            map = new HashMap();
            map.put("id", entity.getId());
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", entity.getId());
            map.put("name", entity.getName() + "-" + entity.getBillCode());
            map.put("code", entity.getBillCode());
            map.put("parentId", "000001");
            resultMapList.add(map);
        }
        if (CollectionUtils.isNotEmpty(resultMapList)) {
            map = new HashMap<String, Object>();
            map.put("id", "000001");
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", "000001");
            map.put("name", "\u5168\u90e8");
            map.put("code", "000001");
            map.put("parentId", null);
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    @RequestMapping(value={"/refSubData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<UseApplySubVO>> refdata(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String relyCondition, @RequestParam(required=false) String condition, String relyNode, String searchText, @RequestParam(required=false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("model");
        fuzzyFields.add("unit");
        Map param = queryParam.getParams();
        boolean queryAllFlag = false;
        if (!StringUtils.isEmpty((String)relyCondition)) {
            String pid = relyCondition.split("=")[1];
            if (!"000001".equals(pid)) {
                param.put("pid", new Parameter("eq", (Object)pid));
            } else {
                queryAllFlag = true;
            }
        } else {
            queryAllFlag = true;
        }
        if (StringUtils.isNotBlank((String)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            for (String key : search.keySet()) {
                queryParam.getParams().put(key, new Parameter("like", (Object)search.get((Object)key).toString()));
            }
        }
        Page pageData = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        List<UseApplySubEntity> list = null;
        if (queryAllFlag) {
            JSONObject conditionJson = JSONObject.parseObject((String)condition);
            Long orgId = conditionJson.getLong("orgId") != null ? conditionJson.getLong("orgId") : InvocationInfoProxy.getOrgId();
            Long projectId = conditionJson.getLong("projectId");
            queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            queryParam.getParams().put("applyNum", new Parameter("gt", (Object)0));
            list = this.iUseApplyService.queryAllApplyData((IPage<UseApplySubEntity>)pageData, queryParam, projectId);
        } else {
            list = this.iUseApplyService.queryApplySubList((IPage<UseApplySubEntity>)pageData, queryParam);
        }
        Page voPage = null;
        if (pageData != null) {
            voPage = new Page();
            voPage.setCurrent(pageData.getCurrent());
            voPage.setPages(pageData.getPages());
            voPage.setTotal(pageData.getTotal());
            voPage.setSize((long)queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList(list, UseApplySubVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u8868\u53c2\u7167\u6210\u529f", voPage);
    }

    @RequestMapping(value={"/referTreeForPurchaseOrder"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> referTreeForPurchaseOrder(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam String condition) {
        if (StringUtils.isEmpty((String)condition) || !condition.contains("orgId")) {
            throw new BusinessException("\u67e5\u8be2\u53c2\u6570\u4e0d\u6b63\u786e\uff01");
        }
        JSONObject conditionJson = JSONObject.parseObject((String)condition);
        Long orgId = conditionJson.getLong("orgId");
        Long projectId = conditionJson.getLong("projectId");
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("createTime", "desc");
        if (null != projectId) {
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        queryParam.setOrderMap(orderMap);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("applyPerson");
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List dataList = this.iUseApplyService.queryList(queryParam, false);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (UseApplyEntity entity : dataList) {
            QueryParam queryApplySubParam = new QueryParam();
            queryApplySubParam.getParams().put("pid", new Parameter("eq", (Object)entity.getId()));
            List<UseApplySubEntity> useApplySubEntities = this.iUseApplyService.queryApplySubListForPurchaseOrder(null, queryApplySubParam);
            if (CollectionUtils.isEmpty(useApplySubEntities)) continue;
            map = new HashMap();
            map.put("id", entity.getId());
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", entity.getId());
            map.put("name", entity.getName());
            map.put("code", entity.getBillCode());
            map.put("parentId", "000001");
            resultMapList.add(map);
        }
        if (CollectionUtils.isNotEmpty(resultMapList)) {
            map = new HashMap<String, Object>();
            map.put("id", "000001");
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", "000001");
            map.put("name", "\u5168\u90e8");
            map.put("code", "000001");
            map.put("parentId", null);
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    @RequestMapping(value={"/refSubDataForPurchaseOrder"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<UseApplySubVO>> refSubDataForPurchaseOrder(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String condition, @RequestParam(required=false) String relyNode, @RequestParam(required=false) String searchText, @RequestParam(required=false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("model");
        fuzzyFields.add("unit");
        Map param = queryParam.getParams();
        JSONObject conditionJson = JSONObject.parseObject((String)condition);
        Long orgId = conditionJson.getLong("orgId") != null ? conditionJson.getLong("orgId") : InvocationInfoProxy.getOrgId();
        Long projectId = conditionJson.getLong("projectId");
        boolean queryAllFlag = false;
        if (StringUtils.isNotEmpty((String)relyCondition)) {
            String pid = relyCondition.split("=")[1];
            if (!"000001".equals(pid)) {
                param.put("pid", new Parameter("eq", (Object)pid));
            } else {
                queryAllFlag = true;
            }
        } else {
            param.put("projectId", new Parameter("eq", (Object)projectId));
        }
        if (StringUtils.isNotBlank((String)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            for (String key : search.keySet()) {
                queryParam.getParams().put(key, new Parameter("like", (Object)search.get((Object)key).toString()));
            }
        }
        Page pageData = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        List<UseApplySubEntity> list = null;
        if (queryAllFlag) {
            queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            queryParam.getParams().put("applyNum", new Parameter("gt", (Object)0));
            list = this.iUseApplyService.queryAllApplyDataForPurchaseOrder((IPage<UseApplySubEntity>)pageData, queryParam, projectId);
        } else {
            list = this.iUseApplyService.queryApplySubListForPurchaseOrder((IPage<UseApplySubEntity>)pageData, queryParam);
        }
        Page voPage = null;
        if (pageData != null) {
            voPage = new Page();
            voPage.setCurrent(pageData.getCurrent());
            voPage.setPages(pageData.getPages());
            voPage.setTotal(pageData.getTotal());
            voPage.setSize((long)queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList(list, UseApplySubVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u8868\u53c2\u7167\u6210\u529f", voPage);
    }

    @RequestMapping(value={"/referTreeForInstore"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> referTreeForInstore(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam String condition) {
        if (StringUtils.isEmpty((String)condition) || !condition.contains("orgId")) {
            throw new BusinessException("\u67e5\u8be2\u53c2\u6570\u4e0d\u6b63\u786e\uff01");
        }
        JSONObject conditionJson = JSONObject.parseObject((String)condition);
        Long orgId = conditionJson.getLong("orgId");
        Long projectId = conditionJson.getLong("projectId");
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("createTime", "desc");
        if (null != projectId) {
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        queryParam.setOrderMap(orderMap);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("applyPerson");
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List dataList = this.iUseApplyService.queryList(queryParam, false);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (UseApplyEntity entity : dataList) {
            QueryParam queryApplySubParam = new QueryParam();
            queryApplySubParam.getParams().put("pid", new Parameter("eq", (Object)entity.getId()));
            List<UseApplySubEntity> useApplySubEntities = this.iUseApplyService.queryApplySubListForInstore(null, queryApplySubParam);
            if (CollectionUtils.isEmpty(useApplySubEntities)) continue;
            map = new HashMap();
            map.put("id", entity.getId());
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", entity.getId());
            map.put("name", entity.getName() + "-" + entity.getBillCode());
            map.put("code", entity.getBillCode());
            map.put("parentId", "000001");
            resultMapList.add(map);
        }
        if (CollectionUtils.isNotEmpty(resultMapList)) {
            map = new HashMap<String, Object>();
            map.put("id", "000001");
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", "000001");
            map.put("name", "\u5168\u90e8");
            map.put("code", "000001");
            map.put("parentId", null);
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    @RequestMapping(value={"/refSubDataForInstore"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<UseApplySubVO>> refSubDataForInstore(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String condition, @RequestParam(required=false) String relyNode, @RequestParam(required=false) String searchText, @RequestParam(required=false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("model");
        fuzzyFields.add("unit");
        Map param = queryParam.getParams();
        JSONObject conditionJson = JSONObject.parseObject((String)condition);
        Long orgId = conditionJson.getLong("orgId") != null ? conditionJson.getLong("orgId") : InvocationInfoProxy.getOrgId();
        Long projectId = conditionJson.getLong("projectId");
        boolean queryAllFlag = false;
        if (StringUtils.isNotEmpty((String)relyCondition)) {
            String pid = relyCondition.split("=")[1];
            if (!"000001".equals(pid)) {
                param.put("pid", new Parameter("eq", (Object)pid));
            } else {
                queryAllFlag = true;
            }
        } else {
            param.put("projectId", new Parameter("eq", (Object)projectId));
        }
        if (StringUtils.isNotBlank((String)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            for (String key : search.keySet()) {
                queryParam.getParams().put(key, new Parameter("like", (Object)search.get((Object)key).toString()));
            }
        }
        Page pageData = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        List<UseApplySubEntity> list = null;
        if (queryAllFlag) {
            queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            queryParam.getParams().put("applyNum", new Parameter("gt", (Object)0));
            list = this.iUseApplyService.queryAllApplyDataForInstore((IPage<UseApplySubEntity>)pageData, queryParam, projectId);
        } else {
            list = this.iUseApplyService.queryApplySubListForInstore((IPage<UseApplySubEntity>)pageData, queryParam);
        }
        Page voPage = null;
        if (pageData != null) {
            voPage = new Page();
            voPage.setCurrent(pageData.getCurrent());
            voPage.setPages(pageData.getPages());
            voPage.setTotal(pageData.getTotal());
            voPage.setSize((long)queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList(list, UseApplySubVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u8868\u53c2\u7167\u6210\u529f", voPage);
    }

    @RequestMapping(value={"/referTable"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<UseApplySubVO>> referTable(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, String condition, String searchText) {
        if (StringUtils.isEmpty((String)condition) || !condition.contains("orgId")) {
            throw new BusinessException("\u67e5\u8be2\u53c2\u6570\u4e0d\u6b63\u786e\uff01");
        }
        JSONObject conditionJson = JSONObject.parseObject((String)condition);
        Long orgId = conditionJson.getLong("orgId");
        Long projectId = conditionJson.getLong("projectId");
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("createTime", "desc");
        if (null != projectId) {
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        queryParam.setOrderMap(orderMap);
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("applyPerson");
        CommonResponse childrenByParentId = this.iOrgApi.findChildrenByParentId(orgId);
        if (CollectionUtils.isNotEmpty((Collection)((Collection)childrenByParentId.getData()))) {
            queryParam.getParams().put("orgId", new Parameter("in", ((List)childrenByParentId.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List dataList = this.iUseApplyService.queryList(queryParam, false);
        Page voPage = null;
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            QueryParam SubParam = new QueryParam();
            List Ids = dataList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            Map<Long, String> collect = dataList.stream().collect(Collectors.toMap(e -> e.getId(), e -> e.getBillCode()));
            SubParam.getParams().put("pid", new Parameter("in", Ids));
            SubParam.setPageIndex(pageNumber);
            SubParam.setPageSize(pageSize);
            IPage pageData = this.iUseApplySubService.queryPage(SubParam, false);
            if (pageData != null) {
                voPage = new Page();
                voPage.setCurrent(pageData.getCurrent());
                voPage.setPages(pageData.getPages());
                voPage.setTotal(pageData.getTotal());
                voPage.setSize((long)queryParam.getPageSize());
                List useApplySubVOS = BeanMapper.mapList((Iterable)pageData.getRecords(), UseApplySubVO.class);
                for (UseApplySubVO vo : useApplySubVOS) {
                    vo.setBillCode(collect.get(vo.getPid()));
                }
                voPage.setRecords(useApplySubVOS);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u8868\u53c2\u7167\u6210\u529f", voPage);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"apply-material-import.xlsx", (String)"\u7269\u6599\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        List<ImportUseApplySubVO> successList = new ArrayList();
        ArrayList<ImportUseApplySubVO> errorList = new ArrayList<ImportUseApplySubVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 11) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                ImportUseApplySubVO useApplySubVO = new ImportUseApplySubVO();
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    useApplySubVO.setErrorMessage("\u7269\u8d44\u5206\u7c7b\u540d\u79f0\u4e3a\u5fc5\u586b\u9879");
                } else {
                    useApplySubVO.setMaterialTypeName(((String)datas.get(0)).trim());
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    useApplySubVO.setErrorMessage("\u7269\u8d44\u540d\u79f0\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(1)).length() > 20) {
                    useApplySubVO.setErrorMessage("\u7269\u8d44\u540d\u79f0\u586b\u5199\u957f\u5ea6\u4e3a0~20\u5b57");
                } else {
                    useApplySubVO.setMaterialName(((String)datas.get(1)).trim());
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    useApplySubVO.setErrorMessage("\u89c4\u683c\u578b\u53f7\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(2)).length() > 200) {
                    useApplySubVO.setErrorMessage("\u89c4\u683c\u578b\u53f7\u586b\u5199\u957f\u5ea6\u4e3a0~200\u5b57");
                } else {
                    useApplySubVO.setModel(((String)datas.get(2)).trim());
                }
                if (StringUtils.isNotEmpty((String)((String)datas.get(3)))) {
                    useApplySubVO.setUnit(((String)datas.get(3)).trim());
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) && ((String)datas.get(4)).length() > 64) {
                    useApplySubVO.setErrorMessage("\u7269\u6599\u7f16\u7801\u586b\u5199\u957f\u5ea6\u4e3a0~64\u5b57");
                } else {
                    useApplySubVO.setMaterialCode((String)datas.get(4));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) && ((String)datas.get(5)).length() > 64) {
                    useApplySubVO.setErrorMessage("\u54c1\u724c\u586b\u5199\u957f\u5ea6\u4e3a0~64\u5b57");
                } else {
                    useApplySubVO.setSupplierName((String)datas.get(5));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    try {
                        useApplySubVO.setApplyNum(ComputeUtil.toBigDecimal((String)ComputeUtil.scaleStripTrailingZeros((BigDecimal)new BigDecimal((String)datas.get(6)), (int)8)));
                        if (useApplySubVO.getApplyNum().longValue() < 0L) {
                            useApplySubVO.setErrorMessage("\u7533\u8bf7\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
                        }
                    }
                    catch (Exception e) {
                        useApplySubVO.setErrorMessage("\u7533\u8bf7\u6570\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    try {
                        useApplySubVO.setEstimatePrice(ComputeUtil.toBigDecimal((String)ComputeUtil.scaleStripTrailingZeros((BigDecimal)new BigDecimal((String)datas.get(7)), (int)8)));
                        if (useApplySubVO.getEstimatePrice().doubleValue() < 0.0) {
                            useApplySubVO.setErrorMessage("\u6682\u4f30\u5355\u4ef7\u5fc5\u987b\u5927\u4e8e0");
                        }
                    }
                    catch (Exception e) {
                        useApplySubVO.setErrorMessage("\u6682\u4f30\u5355\u4ef7\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    useApplySubVO.setEstimatePrice(new BigDecimal(0));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8)))) {
                    try {
                        useApplySubVO.setEstimateMoney(ComputeUtil.toBigDecimal((String)ComputeUtil.scaleStripTrailingZeros((BigDecimal)new BigDecimal((String)datas.get(8)), (int)2)));
                        if (useApplySubVO.getEstimateMoney().doubleValue() < 0.0) {
                            useApplySubVO.setErrorMessage("\u6682\u4f30\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
                        }
                    }
                    catch (Exception e) {
                        useApplySubVO.setErrorMessage("\u6682\u4f30\u91d1\u989d\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    useApplySubVO.setEstimateMoney(new BigDecimal(0));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9)))) {
                    try {
                        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
                        String time = (String)datas.get(9);
                        Date date = ft.parse(time);
                        useApplySubVO.setSubPlanEnterDate(time);
                    }
                    catch (Exception e) {
                        useApplySubVO.setErrorMessage("\u8ba1\u5212\u8fdb\u573a\u65e5\u671f\u683c\u5f0f\u6709\u8bef\uff0c\u4f8b\u59822022-01-01");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10))) && ((String)datas.get(10)).length() > 200) {
                    useApplySubVO.setErrorMessage("\u5907\u6ce8\u586b\u5199\u957f\u5ea6\u4e3a0~200\u5b57");
                } else {
                    useApplySubVO.setMemo((String)datas.get(10));
                }
                if (StringUtils.isNotEmpty((String)useApplySubVO.getErrorMessage())) {
                    errorList.add(useApplySubVO);
                    continue;
                }
                String onlykey = useApplySubVO.getMaterialTypeName() + useApplySubVO.getMaterialName() + useApplySubVO.getUnit() + useApplySubVO.getModel();
                useApplySubVO.setOnlyKey(onlykey);
                successList.add(useApplySubVO);
            }
        }
        if (CollectionUtils.isNotEmpty(successList)) {
            JSONObject match = this.archivesUtil.findMatch(successList, "materialTypeId", "materialId", "materialTypeName", "materialName", "materialCode", "unit", "model", "errorMessage");
            successList = (List)match.get((Object)"sourceList");
            List errorList1 = (List)match.get((Object)"errorList");
            errorList.addAll(errorList1);
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }
}

