/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.mapper.UseApplyMapper;
import com.ejianc.business.material.vo.MaterialContractDetailSubVO;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.UseApplySubVO;
import com.ejianc.business.plan.bean.BatchPlanEntity;
import com.ejianc.business.plan.bean.BatchPlanSubEntity;
import com.ejianc.business.plan.mapper.BatchPlanMapper;
import com.ejianc.business.plan.mapper.BatchPlanSubMapper;
import com.ejianc.business.plan.mapper.MaterialMasterPlanMapper;
import com.ejianc.business.plan.mapper.MaterialMasterPlanSubMapper;
import com.ejianc.business.plan.service.IBatchPlanService;
import com.ejianc.business.plan.vo.BatchPlanSubVO;
import com.ejianc.business.plan.vo.BatchPlanVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="batchPlanService")
public class BatchPlanServiceImpl
extends BaseServiceImpl<BatchPlanMapper, BatchPlanEntity>
implements IBatchPlanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BatchPlanMapper batchPlanMapper;
    @Autowired
    private BatchPlanSubMapper batchPlanSubMapper;
    @Autowired
    private UseApplyMapper useApplyMapper;
    @Autowired
    private MaterialContractMapper materialContractMapper;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private MaterialMasterPlanMapper materialMasterPlanMapper;
    @Autowired
    private MaterialMasterPlanSubMapper materialMasterPlanSubMapper;
    private static String PARAM_PLAN_ALL_COUNT = "P-sa751728";

    @Override
    public BatchPlanVO queryByCode(String billCode) {
        BatchPlanVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"bill_code", (Object)billCode);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        BatchPlanEntity entity = (BatchPlanEntity)((Object)this.batchPlanMapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (BatchPlanVO)((Object)BeanMapper.map((Object)((Object)entity), BatchPlanVO.class));
        }
        return resp;
    }

    @Override
    public List<BatchPlanEntity> queryByProjectId(Long projectId, Long id) {
        Object resp = null;
        QueryWrapper query = new QueryWrapper();
        if (id != null) {
            query.notIn((Object)"id", new Object[]{id});
        }
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.notIn((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List entitys = this.batchPlanMapper.selectList((Wrapper)query);
        return entitys;
    }

    @Override
    public BigDecimal getSurplusNum(BatchPlanSubVO vo) {
        ArrayList<Integer> approvedBillState = new ArrayList<Integer>();
        approvedBillState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        approvedBillState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        queryParam.put("materialId", vo.getMaterialId());
        queryParam.put("materialTypeId", vo.getMaterialCategoryId());
        queryParam.put("sourceId", vo.getId());
        List<UseApplySubVO> applylist = this.useApplyMapper.queryListByMaterial(queryParam);
        List<MaterialContractDetailSubVO> contractList = this.materialContractMapper.queryListByMaterial(queryParam);
        BigDecimal applyNum = applylist.stream().map(UseApplySubVO::getApplyNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal contractNum = contractList.stream().map(MaterialContractDetailSubVO::getCount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal num_temp = ComputeUtil.safeSub(vo.getNum(), applyNum);
        BigDecimal surplusNum = ComputeUtil.safeSub(num_temp, contractNum);
        return surplusNum;
    }

    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public ParamsCheckVO checkAllParams(BatchPlanVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        List<BatchPlanSubVO> batchPlanSubList = vo.getBatchPlanSubList();
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap paramsCheckVOMap = new HashMap();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        if (CollectionUtils.isNotEmpty(batchPlanSubList) && (int)batchPlanSubList.stream().filter(in -> in.getMaterialId() != null).count() > 0) {
            batchPlanSubList = batchPlanSubList.stream().filter(in -> in.getMaterialId() != null).collect(Collectors.toList());
            CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_ALL_COUNT, curOrgId);
            if (!response.isSuccess()) {
                throw new BusinessException("\u3010\u7269\u8d44\u603b\u8ba1\u5212\u91cf\u3011\u63a7\u3010\u6279\u6b21\u8ba1\u5212\u91cf\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
            }
            List billParamVOS = (List)response.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS)) {
                for (BillParamVO billParamVO : billParamVOS) {
                    BigDecimal manageRate = billParamVO.getRoleValue();
                    Long projectId = vo.getProjectId();
                    QueryWrapper wrapper = new QueryWrapper();
                    wrapper.eq((Object)"project_id", (Object)projectId);
                    wrapper.eq((Object)"dr", (Object)0);
                    List materialMasterPlanEntities = this.materialMasterPlanMapper.selectList((Wrapper)wrapper);
                    QueryWrapper planSubWrapper = new QueryWrapper();
                    ArrayList<Long> ids = new ArrayList<Long>();
                    materialMasterPlanEntities.forEach(item -> ids.add(item.getId()));
                    ids.add(1L);
                    planSubWrapper.in((Object)"material_master_plan_id", ids);
                    planSubWrapper.eq((Object)"dr", (Object)0);
                    List materialMasterPlanSubEntities = this.materialMasterPlanSubMapper.selectList((Wrapper)planSubWrapper);
                    HashMap planMap = new HashMap();
                    materialMasterPlanSubEntities.forEach(item -> {
                        Double num = item.getNum();
                        if (planMap.containsKey(item.getMaterialId())) {
                            planMap.put(item.getMaterialId(), ComputeUtil.safeAdd((BigDecimal)planMap.get(item.getMaterialId()), BigDecimal.valueOf(num)));
                        } else {
                            planMap.put(item.getMaterialId(), BigDecimal.valueOf(num));
                        }
                    });
                    QueryWrapper appWrapper = new QueryWrapper();
                    appWrapper.eq((Object)"project_id", (Object)projectId);
                    appWrapper.eq((Object)"dr", (Object)0);
                    List batchPlanEntities = this.batchPlanMapper.selectList((Wrapper)appWrapper);
                    ids.clear();
                    batchPlanEntities.forEach(item -> ids.add(item.getId()));
                    ArrayList noIds = new ArrayList();
                    batchPlanSubList.forEach(item -> {
                        if (item.getId() != null) {
                            noIds.add(item.getId());
                        }
                    });
                    ids.add(1L);
                    QueryWrapper appSubWrapper = new QueryWrapper();
                    appSubWrapper.in((Object)"plan_id", ids);
                    appSubWrapper.notIn((Object)"id", noIds);
                    appSubWrapper.eq((Object)"dr", (Object)0);
                    List batchPlanSubEntities1 = this.batchPlanSubMapper.selectList((Wrapper)appSubWrapper);
                    List batchPlanSubEntities2 = BeanMapper.mapList(batchPlanSubList, BatchPlanSubEntity.class);
                    HashMap<Long, BatchPlanSubEntity> thisMap = new HashMap<Long, BatchPlanSubEntity>();
                    batchPlanSubEntities2.forEach(item -> {
                        if (thisMap.containsKey(item.getMaterialId())) {
                            BatchPlanSubEntity batchPlanSubEntity = (BatchPlanSubEntity)((Object)((Object)thisMap.get(item.getMaterialId())));
                            batchPlanSubEntity.setNum(batchPlanSubEntity.getNum().add(item.getNum()));
                        } else {
                            thisMap.put(item.getMaterialId(), (BatchPlanSubEntity)((Object)item));
                        }
                    });
                    HashMap oldAppMap = new HashMap();
                    batchPlanSubEntities1.forEach(item -> {
                        BigDecimal applyNum = item.getNum();
                        if (oldAppMap.containsKey(item.getMaterialId())) {
                            BigDecimal bigDecimal = (BigDecimal)oldAppMap.get(item.getMaterialId());
                            oldAppMap.put(item.getMaterialId(), applyNum.add(bigDecimal));
                        } else {
                            oldAppMap.put(item.getMaterialId(), applyNum);
                        }
                    });
                    thisMap.forEach((k, item) -> {
                        BigDecimal batNumber;
                        Long materialId = item.getMaterialId();
                        BigDecimal batNum = item.getNum();
                        BigDecimal oldBatNum = oldAppMap.get(materialId) == null ? BigDecimal.ZERO : (BigDecimal)oldAppMap.get(materialId);
                        BigDecimal planNum = planMap.get(materialId) == null ? BigDecimal.ZERO : (BigDecimal)planMap.get(materialId);
                        BigDecimal planNumber = planNum.multiply(manageRate).divide(BigDecimal.valueOf(100L));
                        if (planNumber.compareTo(batNumber = ComputeUtil.nullToZero(ComputeUtil.safeAdd(oldBatNum, batNum))) == -1) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(item.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)item.getSpec()) ? " [" + item.getSpec() + "]" : ""));
                            paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u6279\u6b21\u8ba1\u5212\u91cf\u5927\u4e8e\u603b\u8ba1\u5212\u91cf");
                            paramsCheckDsVO.setContent("\u672c\u6b21\u8ba1\u5212\u6570\u91cf:" + batNum.setScale(4, 4).stripTrailingZeros().toPlainString() + ",\u542b\u672c\u6b21\u7d2f\u8ba1\u8ba1\u5212\u6570\u91cf:" + batNumber.setScale(4, 4).stripTrailingZeros().toPlainString() + ",\u603b\u8ba1\u5212\u6570\u91cf*" + manageRate.setScale(8, 4).stripTrailingZeros().toPlainString() + "%:" + planNumber.setScale(4, 4).stripTrailingZeros().toPlainString() + ",\u8d85\u51fa\u6570\u91cf:" + ComputeUtil.safeSub(batNumber, planNumber).setScale(4, 4).stripTrailingZeros().toPlainString());
                            BatchPlanServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    });
                }
            }
        }
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            pc.setWarnType("alert");
            pc.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            pc.setWarnType("warn");
            pc.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }
}

