package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 标前测算
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zypms_prebid_costcalc")
public class PreBidCostCalcEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据审批状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="pub_unit_name")
    private String pubUnitName; // 发包单位名称
    @TableField(value="contract_unit_name")
    private String contractUnitName; // 承包单位名称
    @TableField(value="project_manage_name")
    private String projectManageName; // 项目管理
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="org_id")
    private Long orgId; // 组织ID
    @TableField(value = "contract_tax_mny")
    private BigDecimal contractTaxMny; // 含税合同额
    @TableField(value = "contract_mny")
    private BigDecimal contractMny; // 不含税合同额
    @TableField(value = "start_date")
    private Date startDate; // 项目开工时间
    @TableField(value = "finish_date")
    private Date finishDate; // 项目完工时间
    @TableField(value = "address")
    private String address; // 施工地点
    @TableField(value="establishment_org_id")
    private Long establishmentOrgId; // 编制单位ID
    @TableField(value="establishment_org_name")
    private String establishmentOrgName; // 编制单位名称
    @TableField(value="establishment_user_id")
    private Long establishmentUserId; // 编制人ID
    @TableField(value="establishment_user_name")
    private String establishmentUserName; // 编制人名称
    @TableField(value="establishment_date")
    private Date establishmentDate; // 编制日期
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="labor_cost")
    private BigDecimal laborCost; // 直接人工费
    @TableField(value="material_cost")
    private BigDecimal materialCost; // 直接材料费
    @TableField(value="equipment_cost")
    private BigDecimal equipmentCost; // 机械使用费
    @TableField(value="direct_cost")
    private BigDecimal directCost; // 其他直接费
    @TableField(value="coalition_cost")
    private BigDecimal coalitionCost; // 外协成本
    @TableField(value="other_cost")
    private BigDecimal otherCost; // 其他费用支出
    @TableField(value="cost_notax_total")
    private BigDecimal costNotaxTotal; // 标前成本测算小计（不含税）
    @TableField(value="tax_cost")
    private BigDecimal taxCost; // 增值税及附加
    @TableField(value="cost_tax_total")
    private BigDecimal costTaxTotal; // 标前成本测算小计（含税）
    @TableField(value="capital_cost")
    private BigDecimal capitalCost; // 垫资资金成本
    @TableField(value="dynamic_cost_total")
    private BigDecimal dynamicCostTotal; // 动态成本测算合计
    @TableField(value="income_notax")
    private BigDecimal incomeNotax; // 不含税收入
    @TableField(value="project_profit_rate")
    private BigDecimal projectProfitRate; // 项目利润率
    @TableField(value="source_id")
    private String sourceId; // 来源id
    @TableField(exist=false)
    @SubEntity(serviceName="preBidCostCalcDetailService", pidName="costsId")
    private List<PreBidCostCalcDetailEntity> preBidCostCalcDetailList = new ArrayList<>();

    public List<PreBidCostCalcDetailEntity> getPreBidCostCalcDetailList() {
        return preBidCostCalcDetailList;
    }

    public void setPreBidCostCalcDetailList(List<PreBidCostCalcDetailEntity> preBidCostCalcDetailList) {
        this.preBidCostCalcDetailList = preBidCostCalcDetailList;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getPubUnitName() {
        return pubUnitName;
    }

    public void setPubUnitName(String pubUnitName) {
        this.pubUnitName = pubUnitName;
    }
    public String getContractUnitName() {
        return contractUnitName;
    }

    public void setContractUnitName(String contractUnitName) {
        this.contractUnitName = contractUnitName;
    }
    public String getProjectManageName() {
        return projectManageName;
    }

    public void setProjectManageName(String projectManageName) {
        this.projectManageName = projectManageName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Long getEstablishmentOrgId() {
        return establishmentOrgId;
    }

    public void setEstablishmentOrgId(Long establishmentOrgId) {
        this.establishmentOrgId = establishmentOrgId;
    }
    public String getEstablishmentOrgName() {
        return establishmentOrgName;
    }

    public void setEstablishmentOrgName(String establishmentOrgName) {
        this.establishmentOrgName = establishmentOrgName;
    }
    public Long getEstablishmentUserId() {
        return establishmentUserId;
    }

    public void setEstablishmentUserId(Long establishmentUserId) {
        this.establishmentUserId = establishmentUserId;
    }
    public String getEstablishmentUserName() {
        return establishmentUserName;
    }

    public void setEstablishmentUserName(String establishmentUserName) {
        this.establishmentUserName = establishmentUserName;
    }
    public Date getEstablishmentDate() {
        return establishmentDate;
    }

    public void setEstablishmentDate(Date establishmentDate) {
        this.establishmentDate = establishmentDate;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public BigDecimal getLaborCost() {
        return laborCost;
    }

    public void setLaborCost(BigDecimal laborCost) {
        this.laborCost = laborCost;
    }
    public BigDecimal getMaterialCost() {
        return materialCost;
    }

    public void setMaterialCost(BigDecimal materialCost) {
        this.materialCost = materialCost;
    }
    public BigDecimal getEquipmentCost() {
        return equipmentCost;
    }

    public void setEquipmentCost(BigDecimal equipmentCost) {
        this.equipmentCost = equipmentCost;
    }
    public BigDecimal getDirectCost() {
        return directCost;
    }

    public void setDirectCost(BigDecimal directCost) {
        this.directCost = directCost;
    }
    public BigDecimal getCoalitionCost() {
        return coalitionCost;
    }

    public void setCoalitionCost(BigDecimal coalitionCost) {
        this.coalitionCost = coalitionCost;
    }
    public BigDecimal getOtherCost() {
        return otherCost;
    }

    public void setOtherCost(BigDecimal otherCost) {
        this.otherCost = otherCost;
    }
    public BigDecimal getCostNotaxTotal() {
        return costNotaxTotal;
    }

    public void setCostNotaxTotal(BigDecimal costNotaxTotal) {
        this.costNotaxTotal = costNotaxTotal;
    }
    public BigDecimal getTaxCost() {
        return taxCost;
    }

    public void setTaxCost(BigDecimal taxCost) {
        this.taxCost = taxCost;
    }
    public BigDecimal getCostTaxTotal() {
        return costTaxTotal;
    }

    public void setCostTaxTotal(BigDecimal costTaxTotal) {
        this.costTaxTotal = costTaxTotal;
    }
    public BigDecimal getCapitalCost() {
        return capitalCost;
    }

    public void setCapitalCost(BigDecimal capitalCost) {
        this.capitalCost = capitalCost;
    }
    public BigDecimal getDynamicCostTotal() {
        return dynamicCostTotal;
    }

    public void setDynamicCostTotal(BigDecimal dynamicCostTotal) {
        this.dynamicCostTotal = dynamicCostTotal;
    }
    public BigDecimal getIncomeNotax() {
        return incomeNotax;
    }

    public void setIncomeNotax(BigDecimal incomeNotax) {
        this.incomeNotax = incomeNotax;
    }
    public BigDecimal getProjectProfitRate() {
        return projectProfitRate;
    }

    public void setProjectProfitRate(BigDecimal projectProfitRate) {
        this.projectProfitRate = projectProfitRate;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
}
