package com.ejianc.business.material.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.material.bean.PurchaseOrderDetailEntity;
import com.ejianc.business.material.bean.PurchaseOrderEntity;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.PurchaseOrderDetailVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 采购订单
 * 
 * @author generator
 * 
 */
@Mapper
public interface PurchaseOrderMapper extends BaseCrudMapper<PurchaseOrderEntity> {

    /**
     * @param projectId
     * @param materialIds
     *
     * @description: 根据项目查询已经生效的订单数量
     * @return: java.util.List<com.ejianc.business.material.vo.MaterialPriceVO>
     * @author songlx
     */
    List<MaterialPriceVO> queryMaterialOrderCount(@Param(value = "id") Long id, @Param(value = "projectId") Long projectId, @Param(value = "materialIds") List<Long> materialIds);

    /**
     * @description: 订单物资明细参照,剩余数量= 订单数量 - 占有量(收料入库,直入直出)
     *
     * @param pageData
     * @param wrapper
     * @return {@link List< PurchaseOrderDetailVO>}
     * @author songlx
     * @date: 2023/4/20
     */
    List<PurchaseOrderDetailVO> querySubData(IPage<PurchaseOrderDetailEntity> pageData, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * @description: 根据订单id，获取该订单的入库（未结算过的）明细
     *
     * @param orderIdList
     * @return {@link List< InstoreMaterialVO>}
     * @author songlx
     * @date: 2023/4/21
     */
    List<InstoreMaterialVO> getInstoreMaterialByPurchaseOrder(@Param(value = "orderIdList") List<Long> orderIdList);
}
