package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sub.bean.SubContractEntity;
import com.ejianc.business.sub.bean.SubSettleDetailEntity;
import com.ejianc.business.sub.bean.SubSettleEntity;
import com.ejianc.business.sub.bean.SubSettleOtherEntity;
import com.ejianc.business.sub.mapper.SubSettleMapper;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISubSettleDetailService;
import com.ejianc.business.sub.service.ISubSettleOtherService;
import com.ejianc.business.sub.service.ISubSettleService;
import com.ejianc.business.sub.utils.BigDecimalUtils;
import com.ejianc.business.sub.utils.ExcelImportUtil;
import com.ejianc.business.sub.utils.TreeNodeBUtil;
import com.ejianc.business.sub.vo.*;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 分包过程结算表 服务实现类
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@Service("SubSettleServiceImpl")
public class SubSettleServiceImpl extends BaseServiceImpl<SubSettleMapper, SubSettleEntity> implements ISubSettleService {

    private static final String SUB_SETTLE_BILL_CODE = "SUB_SETTLE";
    private static final String SUB_SETTLE = "SUB_SETTLE";
    private static final String SUB_SETTLE_DETAIL = "SUB_SETTLE_DETAIL";
    private static final String SUB_SETTLE_ODDJOB = "SUB_SETTLE_ODDJOB";
    private static final String SUB_SETTLE_OTHER = "SUB_SETTLE_OTHER";
    private static final String CHECK_PARAM_CODE = "P-A9232233";

    //【合同量】控制【过程结算量】
    private static final String CHECK_PARAM_CODE_NUM = "P-2IJ8Cs27";

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IContractService contractService;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private ISubSettleDetailService settleDetailService;

    @Autowired
    private ISubSettleOtherService settleOtherService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private JedisPool jedisPool;

    @Autowired
    private SessionManager sessionManager;

    // 分包过程结算单预付款抵扣功能中的预付款取数方式
    private static final String PREPAY_PARAM = "P-zu6b9071";

    @Override
    public SubSettleVO insertOrUpdate(SubSettleVO settleVO) {
        if (checkFinishContract(settleVO)) {
            throw new BusinessException("该合同在相同组织下已经完工，不允许新增！");
        }
        //保存时校验合同version是否一致
        if (settleVO.getContractVersion() != null && settleVO.getContractVersion() != 0) {
            Jedis jedis = jedisPool.getResource();
            boolean locked = false;
            try {
                locked = RedisTool.tryLock(jedis, String.valueOf(settleVO.getContractId()), "saveOrUpdate", 1000);
                logger.info("判断单据单据锁结果------" + locked);
                if (locked) {
                    SubContractEntity contractEntity = contractService.selectById(settleVO.getContractId());
                    Integer version = contractEntity.getVersion() == null ? 0 : contractEntity.getVersion();
                    Integer conVersion = settleVO.getContractVersion();
                    if (!version.equals(conVersion)) {
                        throw new BusinessException("该合同已被更新，请刷新后重做！");
                    }
                } else {
                    throw new BusinessException("出现并发操作,请稍后重试！");
                }
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                if (locked) {
                    RedisTool.releaseLock(jedis, String.valueOf(settleVO.getContractId()), "saveOrUpdate");
                }
                jedis.close();
            }

        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (checkSameContract(settleVO)) {
            throw new BusinessException("同一合同只能存在一份自由态或审批中的分包过程结算单");
        }
        if (StringUtils.isEmpty(settleVO.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(SUB_SETTLE_BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                settleVO.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if (checkSameBillCode(settleVO)) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }

        settleVO.setRelationFlag("0");
        settleVO.setProportionFlag("0");
        SubSettleEntity settleEntity = BeanMapper.map(settleVO, SubSettleEntity.class);
        //保存前清空主键和父主键，重新生成
        List<SubSettleDetailEntity> beforeDetails = settleEntity.getSettleDetailList();
        if (CollectionUtils.isNotEmpty(beforeDetails) && null == settleEntity.getId()) {
            for (SubSettleDetailEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        LambdaQueryWrapper<SubSettleEntity> lambdachange2 = Wrappers.<SubSettleEntity>lambdaQuery();
        lambdachange2.eq(SubSettleEntity::getTenantId, tenantId);
        lambdachange2.eq(SubSettleEntity::getContractId, settleVO.getContractId());
        lambdachange2.eq(SubSettleEntity::getOrgId, settleVO.getOrgId());
        if (null != settleVO.getId() && settleVO.getId() > 0) {
            lambdachange2.ne(SubSettleEntity::getId, settleVO.getId());
        }
        lambdachange2.in(SubSettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambdachange2.gt(SubSettleEntity::getSettleDate, settleVO.getSettleDate());
        int num2 = super.count(lambdachange2);
        if (num2 > 0) {
            throw new BusinessException("结算日期必须大于等于该合同对应最新结算日期!");
        }
        BigDecimal settlementTaxMny = settleVO.getSettleTaxMny() == null ? BigDecimal.ZERO : settleVO.getSettleTaxMny();
        BigDecimal offsetMny = settleVO.getOffsetMny() == null ? BigDecimal.ZERO : settleVO.getOffsetMny();//本次冲抵金额
        BigDecimal syMny = settleVO.getSymny() == null ? BigDecimal.ZERO : settleVO.getSymny();//剩余冲抵金额
        if (offsetMny.compareTo(syMny) > 0) {
            throw new BusinessException("本次冲抵金额不允许大于剩余可冲抵金额!");
        }
        if (settlementTaxMny.compareTo(BigDecimal.ZERO) > 0 && offsetMny.compareTo(settlementTaxMny) > 0) {
            throw new BusinessException("本次冲抵金额不允许大于本期结算金额");
        }

        super.saveOrUpdate(settleEntity, false);

        List<SubSettleDetailEntity> settleDetailEntities = settleEntity.getSettleDetailList();
        if (CollectionUtils.isNotEmpty(settleDetailEntities)) {
            Map<String, Long> idMap = new HashMap<>();
            for (SubSettleDetailEntity cdEntity : settleDetailEntities) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (SubSettleDetailEntity cdEntity : settleDetailEntities) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            settleDetailService.saveOrUpdateBatch(settleDetailEntities, settleDetailEntities.size(), false);
        }

        return queryDetail(settleEntity.getId(), true);
    }

    private Boolean checkSameBillCode(SubSettleVO settleVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<SubSettleEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(SubSettleEntity::getBillCode, settleVO.getBillCode());
        lambda.eq(SubSettleEntity::getTenantId, tenantId);
        if (null != settleVO.getId() && settleVO.getId() > 0) {
            lambda.ne(SubSettleEntity::getId, settleVO.getId());
        }
        return super.list(lambda).size() > 0;
    }

    private Boolean checkSameContract(SubSettleVO settleVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<SubSettleEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(SubSettleEntity::getContractId, settleVO.getContractId());
        lambda.eq(SubSettleEntity::getOrgId, settleVO.getOrgId());
        lambda.notIn(SubSettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambda.eq(SubSettleEntity::getTenantId, tenantId);
        if (null != settleVO.getId() && settleVO.getId() > 0) {
            lambda.ne(SubSettleEntity::getId, settleVO.getId());
        }
        return super.list(lambda).size() > 0;
    }

    @Override
    public SubSettleVO queryDetail(Long id, Boolean detailHasChildren) {
        SubSettleEntity settleEntity = super.selectById(id);
        SubSettleVO settleVO = BeanMapper.map(settleEntity, SubSettleVO.class);
        BigDecimal c = settleVO.getContractTaxMny() == null ? BigDecimal.ZERO : settleVO.getContractTaxMny();
        settleVO.setContractTaxMny(c);
        BigDecimal cc = settleVO.getSumSettleTaxMny() == null ? BigDecimal.ZERO : settleVO.getSumSettleTaxMny();
        settleVO.setSumSettleTaxMny(cc);
        if (c.compareTo(BigDecimal.ZERO) != 0 && cc.compareTo(BigDecimal.ZERO) != 0) {
            settleVO.setSumSettleScale(new BigDecimal(100).multiply(BigDecimalUtils.safeDiv(cc, c)));
        }
        BigDecimal settleTaxMny = settleVO.getSettleTaxMny() == null ? BigDecimal.ZERO : settleVO.getSettleTaxMny();
        if (c.compareTo(BigDecimal.ZERO) != 0 && settleTaxMny.compareTo(BigDecimal.ZERO) != 0) {
            settleVO.setSettleScale(new BigDecimal(100).multiply(BigDecimalUtils.safeDiv(settleTaxMny, c)));
        }
        /** 剩余冲抵金额 = 累计预付款 - 累计已冲抵 */
        BigDecimal sumPrePayMny = settleEntity.getSumPrepayMny() == null ? BigDecimal.ZERO : settleEntity.getSumPrepayMny();
        BigDecimal sumOffsetMny = settleEntity.getSumOffsetMny() == null ? BigDecimal.ZERO : settleEntity.getSumOffsetMny();
        settleVO.setSymny(sumPrePayMny.subtract(sumOffsetMny));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("settleId", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List<SubSettleDetailEntity> detailEntityList = settleDetailService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (SubSettleDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List<SubSettleDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, SubSettleDetailVO.class);
            sortIntMethod(resultMapList);
            if (detailHasChildren) {
                settleVO.setSettleDetailList(TreeNodeBUtil.buildTree(resultMapList));
            } else {
                settleVO.setSettleDetailList(resultMapList);
            }
        }
        return settleVO;
    }
    private static void sortIntMethod(List<SubSettleDetailVO> list){
        Collections.sort(list, new Comparator(){
            @Override
            public int compare(Object o1, Object o2) {
                ObjectMapper objectMapper = new ObjectMapper();
                SubSettleDetailVO o1Detail = objectMapper.convertValue(o1, SubSettleDetailVO.class);
                SubSettleDetailVO o2Detail = objectMapper.convertValue(o2, SubSettleDetailVO.class);
                String[] strs1 = o1Detail.getTreeIndex().split("\\.");
                String[] strs2 = o2Detail.getTreeIndex().split("\\.");
                int length = strs1.length > strs2.length ? strs1.length : strs2.length;
                for (int i = 0; i < length; i++) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    } catch (Exception e) {

                    }
                    if (num1 < num2)
                        return -1;
                    if (num1 > num2)
                        return 1;
                }
                return 0;
            }
        });
    }

    @Override
    public CommonResponse<IPage<SubSettleVO>> queryListVOs(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        IPage<SubSettleEntity> page = queryPage(param, false);
        List<SubSettleVO> settleVOList = BeanMapper.mapList(page.getRecords(), SubSettleVO.class);
        IPage<SubSettleVO> settleVOIPage = new Page<>();
        settleVOIPage.setCurrent(page.getCurrent());
        settleVOIPage.setRecords(settleVOList);
        settleVOIPage.setSize(page.getSize());
        settleVOIPage.setTotal(page.getTotal());
        settleVOIPage.setPages(page.getPages());
        return CommonResponse.success("查询成功！", settleVOIPage);
    }

    @Override
    public CommonResponse<String> deleteByIds(List<SubSettleVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            this.removeByIds(vos.stream().map(SubSettleVO::getId).collect(Collectors.toList()), false);
        }
        return CommonResponse.success("删除成功！");
    }

    @Override
    public SubSettleRecordVO queryDetailRecord(Long id) {
        SubContractEntity contractEntity = contractService.selectById(id);
        SubSettleRecordVO settleRecordVO = new SubSettleRecordVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        settleRecordVO.setContractId(id);
        settleRecordVO.setFinishFlag(contractEntity.getFinishFlag());
        settleRecordVO.setContractStatus(Integer.valueOf(contractEntity.getContractStatus()));
        settleRecordVO.setContractTaxMny(contractTaxMny);

        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        LambdaQueryWrapper<SubSettleEntity> lambda = Wrappers.<SubSettleEntity>lambdaQuery();
        lambda.eq(SubSettleEntity::getContractId, id);
        lambda.in(SubSettleEntity::getOrgId, commonOrgIds);
        List<SubSettleEntity> entitiesAllState = super.list(lambda);
        lambda.in(SubSettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambda.orderByDesc(SubSettleEntity::getCreateTime);
        List<SubSettleEntity> entities = super.list(lambda);
        if (CollectionUtils.isNotEmpty(entities)) {
            List<SubSettleRecordDetailVO> settleRecordDetailVOList = BeanMapper.mapList(entities, SubSettleRecordDetailVO.class);
            final BigDecimal[] settlementMoney = {new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP)};
            settleRecordDetailVOList.forEach(entity -> {
                settlementMoney[0] = settlementMoney[0].add(entity.getSettleTaxMny() == null ? BigDecimal.ZERO : entity.getSettleTaxMny());
                BigDecimal dSumSettleTaxMny = entity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : entity.getSumSettleTaxMny();
                BigDecimal scale = BigDecimalUtils.safeDiv(dSumSettleTaxMny, contractTaxMny).multiply(new BigDecimal(100));
                entity.setSumScale(scale);
            });
            //累计结算金额
            settleRecordVO.setSumSettleTaxMny(settlementMoney[0]);
            BigDecimal sumSettlementTaxMny = settleRecordVO.getSumSettleTaxMny() == null ? BigDecimal.ZERO : settleRecordVO.getSumSettleTaxMny();//累计结算金额
//            if(sumSettlementTaxMny.compareTo(BigDecimal.ZERO) > 0 && contractTaxMny.compareTo(BigDecimal.ZERO) > 0){
//                settleRecordVO.setSumScale(new BigDecimal(100).multiply(sumSettlementTaxMny.divide(contractTaxMny,8,ROUND_HALF_DOWN)));
//            }else{
//                settleRecordVO.setSumScale(BigDecimal.ZERO);
//            }
            settleRecordVO.setSumScale(new BigDecimal(100).multiply(BigDecimalUtils.safeDiv(sumSettlementTaxMny, contractTaxMny)));
        }
        settleRecordVO.setDetailList(BeanMapper.mapList(entitiesAllState, SubSettleRecordDetailVO.class));
        return settleRecordVO;
    }

    @Override
    public SubSettleVO queryDetailAdd(Long contractId) {
        SubContractEntity contractEntity = contractService.selectById(contractId);
        SubSettleVO settleVO = BeanMapper.map(contractEntity, SubSettleVO.class);
        settleVO.setBillCode(null);
        settleVO.setEmployeeId(null);
        settleVO.setEmployeeName(null);
        settleVO.setContractId(contractEntity.getId());
        settleVO.setBillState(null);
        settleVO.setCreateUserCode(null);
        settleVO.setCreateTime(null);
        settleVO.setUpdateUserCode(null);
        settleVO.setUpdateTime(null);
        settleVO.setId(null);
        settleVO.setVersion(null);
        settleVO.setTaxMny(null);
        settleVO.setSumInvoiceTaxMny(null);

        LambdaQueryWrapper<SubSettleEntity> lambdachange = Wrappers.<SubSettleEntity>lambdaQuery();
        lambdachange.eq(SubSettleEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambdachange.eq(SubSettleEntity::getContractId, contractId);
        lambdachange.eq(SubSettleEntity::getOrgId, contractEntity.getOrgId());
        lambdachange.in(SubSettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<SubSettleEntity> list = super.list(lambdachange);
        if (CollectionUtils.isNotEmpty(list)) {
            final BigDecimal[] settlementMoney = {new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP), new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP)};
            list.forEach(e -> {
                settlementMoney[0] = settlementMoney[0].add(e.getSettleTaxMny() == null ? BigDecimal.ZERO : e.getSettleTaxMny());
                settlementMoney[1] = settlementMoney[1].add(e.getOffsetMny() == null ? BigDecimal.ZERO : e.getOffsetMny());
            });
            //累计结算金额
            settleVO.setSumSettleTaxMny(settlementMoney[0]);
            //累计冲抵金额
            settleVO.setSumOffsetMny(settlementMoney[1]);
        }
        BigDecimal sumOffsetMnys = settleVO.getSumOffsetMny() == null ? BigDecimal.ZERO : settleVO.getSumOffsetMny();
        if (settleVO.getSumPrepayMny().compareTo(BigDecimal.ZERO) >= 0 && sumOffsetMnys.compareTo(BigDecimal.ZERO) >= 0) {
            settleVO.setSymny(settleVO.getSumPrepayMny().subtract(sumOffsetMnys));
        }

        BigDecimal c = settleVO.getContractTaxMny() == null ? BigDecimal.ZERO : settleVO.getContractTaxMny();
        BigDecimal cc = settleVO.getSumSettleTaxMny() == null ? BigDecimal.ZERO : settleVO.getSumSettleTaxMny();
        if (c.compareTo(BigDecimal.ZERO) > 0 && cc.compareTo(BigDecimal.ZERO) > 0) {
            settleVO.setSumSettleScale(new BigDecimal(100).multiply(BigDecimalUtils.safeDiv(cc, c)));
        }
        return settleVO;
    }

    @Override
    public JSONObject querySubSettleVOList(QueryParam param, boolean isEs) {
        Page<SubSettleVO> pages = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<SubSettleVO> list = baseMapper.querySubSettleVOList(pages, wrapper);
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", pages.getTotal());
        page.put("current", pages.getCurrent());
        page.put("size", pages.getSize());
        page.put("pages", pages.getPages());
        return page;
    }

    @Override
    public CommonResponse<SubSettleVO> pushCost(SubSettleVO settleVO) {
        SubSettleEntity settleEntity = baseMapper.selectById(settleVO.getId());
        if (CollectionUtils.isNotEmpty(settleVO.getSettleDetailList())) {
            List<SubSettleDetailEntity> detailEntities = BeanMapper.mapList(settleVO.getSettleDetailList(), SubSettleDetailEntity.class);
            settleEntity.setSettleDetailList(detailEntities);
        }
        if (CollectionUtils.isNotEmpty(settleVO.getSettleOtherList())) {
            List<SubSettleOtherEntity> otherEntities = BeanMapper.mapList(settleVO.getSettleOtherList(), SubSettleOtherEntity.class);
            settleEntity.setSettleOtherList(otherEntities);
        }
        super.saveOrUpdate(settleEntity, false);
        //推送数据
        costPush(settleEntity);
        return CommonResponse.success(queryDetail(settleVO.getId(), true));
    }

    @Override
    public void costPush(SubSettleEntity settleEntity) {
        Boolean isPush = true;
        LambdaQueryWrapper<SubSettleDetailEntity> detailWrapper = new LambdaQueryWrapper<>();
        detailWrapper.eq(SubSettleDetailEntity::getSettleId, settleEntity.getId());
        List<SubSettleDetailEntity> detailEntities = settleDetailService.list(detailWrapper);
        LambdaQueryWrapper<SubSettleOtherEntity> othWrapper = new LambdaQueryWrapper<>();
        othWrapper.eq(SubSettleOtherEntity::getSettleId, settleEntity.getId());
        List<SubSettleOtherEntity> otherEntities = settleOtherService.list(othWrapper);
        if (CollectionUtils.isNotEmpty(detailEntities) && isPush) {
            for (SubSettleDetailEntity detailEntity : detailEntities) {
                if (detailEntity.getLeafFlag() && null == detailEntity.getSubjectId()) {
                    isPush = false;
                    break;
                }
            }
        }
        if (CollectionUtils.isNotEmpty(otherEntities) && isPush) {
            for (SubSettleOtherEntity otherEntity : otherEntities) {
                if (null == otherEntity.getSubjectId()) {
                    isPush = false;
                    break;
                }
            }
        }

        settleEntity.setSettleDetailList(detailEntities);
        settleEntity.setSettleOtherList(otherEntities);
        logger.info("----------------------isPush："+isPush+"----------------------");
        //更新是否关联
        LambdaUpdateWrapper<SubSettleEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(SubSettleEntity::getId, settleEntity.getId());
        updateWrapper.set(SubSettleEntity::getRelationFlag, isPush ? "1" : "0");//(1:是，0：否)
        super.update(updateWrapper);

        //判断之前的单据是否关联
        String oldRelationFlag = settleEntity.getRelationFlag();
        //之前已关联
        if (oldRelationFlag.equals("1")) {
            if (isPush) {
                saveCost(settleEntity);
            }
        }
        //之前未关联
        if (oldRelationFlag.equals("0")) {
            //if (isPush) {
                saveCost(settleEntity);
            //}
        }

    }

    @Override
    public void pullCost(Long id) {
        //更新是否关联
        LambdaUpdateWrapper<SubSettleEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(SubSettleEntity::getId, id);
        updateWrapper.set(SubSettleEntity::getRelationFlag, "0");//(1:是，0：否)
        super.update(updateWrapper);
    }

    @Override
    public SubParamsCheckVO checkParams(Integer purchaseType, BigDecimal sumSettleMentTaxMny, BigDecimal contractTaxMny) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        SubParamsCheckVO paramsCheckVO = new SubParamsCheckVO();
        List<SubParamsCheckDsVO> checkDsVOS = new ArrayList<>();
        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            BillParamVO billParamVO = billParamByCode.getData();
            BigDecimal roleValue = billParamVO.getRoleValue();
            BigDecimal comMny = contractTaxMny.multiply(roleValue.divide(BigDecimal.valueOf(100)
                    , 2, BigDecimal.ROUND_HALF_UP));

            if (2 == purchaseType) {
                // 集采合同直接赋值为不控制
                paramsCheckVO.setWarnType(paramsArray[0]);
                return paramsCheckVO;
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }

            if (sumSettleMentTaxMny.compareTo(comMny) > 0) {
                SubParamsCheckDsVO paramsCheckDsVO = new SubParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("合同超结");
                paramsCheckDsVO.setWarnName("结算金额大于合同金额");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("本次结算金额：").append(sumSettleMentTaxMny.toString())
                        .append("元，合同金额*").append(roleValue).append("%:")
                        .append(comMny).append("元。超出金额：")
                        .append(sumSettleMentTaxMny.subtract(comMny)).append("元");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                checkDsVOS.add(paramsCheckDsVO);
            }
            paramsCheckVO.setDataSource(checkDsVOS);
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        return paramsCheckVO;
    }

    @Override
    public SubSettleVO getSumSettleNumInfo(SubSettleVO settleVO) {
        List<SubSettleDetailVO> settleDetailList = settleVO.getSettleDetailList();
        if (CollectionUtils.isNotEmpty(settleDetailList)) {
            List<Long> cids = settleDetailList.stream().map(SubSettleDetailVO::getContractDetailId).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("contractDetailId", new Parameter(QueryParam.IN, cids));
            QueryWrapper wrapper = changeToQueryWrapper(param);
            List<SubSettleDetailVO> list = baseMapper.getSumSettleNumInfo(wrapper);
            Map<Long, SubSettleDetailVO> voMap = list.stream().collect(Collectors.toMap(SubSettleDetailVO::getContractDetailId, a -> a, (k1, k2) -> k1));
            if (voMap != null && voMap.size() > 0) {
                settleDetailList.forEach(
                        t -> {
                            if (t.getLeafFlag()) {
                                Long contractDetailId = t.getContractDetailId();
                                SubSettleDetailVO settleDetailVO = voMap.get(contractDetailId);
                                t.setSumSettleNum(settleDetailVO.getSumSettleNum() != null ? settleDetailVO.getSumSettleNum() : BigDecimal.ZERO);
                                t.setSumSettleNumEndthis(settleDetailVO.getSumSettleNum() != null ? settleDetailVO.getSumSettleNum() : BigDecimal.ZERO);
                            }
                        }
                );
            }
        }
        return settleVO;
    }

    @Override
    public List<SubContractDetailVO> getSumSettleNum(List<SubContractDetailVO> contractDetailVOS) {
        if (CollectionUtils.isNotEmpty(contractDetailVOS)) {
            List<Long> cids = contractDetailVOS.stream().map(SubContractDetailVO::getId).collect(Collectors.toList());

            QueryParam param = new QueryParam();
            param.getParams().put("contractDetailId", new Parameter(QueryParam.IN, cids));
            QueryWrapper wrapper = changeToQueryWrapper(param);
            List<SubSettleDetailVO> list = baseMapper.getSumSettleNumInfo(wrapper);
            Map<Long, SubSettleDetailVO> voMap = list.stream().collect(Collectors.toMap(SubSettleDetailVO::getContractDetailId, a -> a, (k1, k2) -> k1));
            if (voMap != null && voMap.size() > 0) {
                contractDetailVOS.forEach(
                        t -> {
                            if (t.getLeafFlag()) {
                                Long contractDetailId = t.getId();
                                SubSettleDetailVO settleDetailVO = voMap.get(contractDetailId);
                                t.setSumSettleNum(settleDetailVO != null && settleDetailVO.getSumSettleNum() != null ? settleDetailVO.getSumSettleNum() : BigDecimal.ZERO);
                                t.setSumSettleNumEndthis(settleDetailVO != null && settleDetailVO.getSumSettleNum() != null ? settleDetailVO.getSumSettleNum() : BigDecimal.ZERO);

                            }
                        }
                );
            }
        }
        return contractDetailVOS;
    }

    private void saveCost(SubSettleEntity settleEntity) {
        //税率
        BigDecimal taxRate = settleEntity.getTaxRate().divide(new BigDecimal(100));
        BigDecimal number = taxRate.add(new BigDecimal(1));
        //明细
        List<SubSettleDetailEntity> detailEntities = settleEntity.getSettleDetailList();
        SubContractEntity contractEntity = contractService.selectById(settleEntity.getContractId());
        Long contractType = contractEntity.getContractType();
        String contractTypeName = "";
        Integer costType = null;
        String sourceType = SUB_SETTLE + "_PRO";
        //劳务分包
        if(contractType.equals(1270328729526124545l)){
            sourceType = SUB_SETTLE + "_LAB";
            contractTypeName = SubCostTypeEnum.LABOR_COST_TYPE.getName();
            costType = SubCostTypeEnum.LABOR_COST_TYPE.getType();
        }
        //专业分包
        else{
            contractTypeName = SubCostTypeEnum.MAJOR_COST_TYPE.getName();
            costType = SubCostTypeEnum.MAJOR_COST_TYPE.getType();
        }
        String period = "";
        if(settleEntity.getSettleDate() != null){
            SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM");
            period = ft.format(settleEntity.getSettleDate());
        }

    }

    private Boolean checkFinishContract(SubSettleVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<SubContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(SubContractEntity::getId, finishVO.getContractId());
        lambda.eq(SubContractEntity::getTenantId, tenantId);
        lambda.eq(SubContractEntity::getFinishFlag, true);
        return contractService.list(lambda).size() > 0;
    }

    /**
     * 根据清单编码和名称查询历史数据的含本期累计结算工程量
     *
     * @param
     * @param
     * @return
     */
    @Override
    public JSONObject querySettleDetailHistory(SubSettleDetailVO settleDetailVO) {
        QueryParam queryParam = new QueryParam();
        BigDecimal sumSettleNumEndthis = new BigDecimal(0);
        if (StringUtils.isNotBlank(settleDetailVO.getCode()) && StringUtils.isNotBlank(settleDetailVO.getName())) {
            settleDetailVO.setSourceType(2);
            List<SubSettleDetailVO> settleDetailList = baseMapper.querySettleDetailHistory(settleDetailVO);

            if (CollectionUtils.isNotEmpty(settleDetailList)) {
                //计算历史含本期金额
                for (SubSettleDetailVO settleDetailVO1 : settleDetailList) {
                    sumSettleNumEndthis = BigDecimalUtils.safeAdd(sumSettleNumEndthis, settleDetailVO1.getSettleNum());
                }
            }
        }
        JSONObject jo = new JSONObject();
        jo.put("sumSettleNumEndthis", sumSettleNumEndthis);
        System.out.print(sumSettleNumEndthis.toString());
        return jo;
    }


    /**
     * 查询合同内的历史数据集合，修改含本期累计结算工程量和不含本期累计结算工程量
     *
     * @return
     */
    @Override
    public void updateSettleDetailHistory() {
        SubSettleDetailVO settleDetailVO = new SubSettleDetailVO();
        //查出总数据
        //settleDetailVO.setContractDetailId(new Long("343460937532178490"));
        List<SubSettleDetailVO> settleDetailList = baseMapper.querySettleDetailList(settleDetailVO);

        for (SubSettleDetailVO sd : settleDetailList) {
            SubSettleDetailVO sd_tmp = new SubSettleDetailVO();
            sd_tmp.setContractDetailId(sd.getContractDetailId());
            sd_tmp.setCreateTime(sd.getSettleCreateTime());
            String settleNumSum = baseMapper.querySettleDetailSum(sd_tmp);
            if (StringUtils.isEmpty(settleNumSum)) {
                settleNumSum = "0";
            }
            LambdaUpdateWrapper<SubSettleDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(SubSettleDetailEntity::getSumSettleNumEndthis, BigDecimalUtils.safeAdd(new BigDecimal(settleNumSum), sd.getSettleNum()));
            updateWrapper.set(SubSettleDetailEntity::getSumSettleNum, settleNumSum);
            updateWrapper.eq(SubSettleDetailEntity::getId, sd.getId());
            boolean update = settleDetailService.update(updateWrapper);
            System.out.println("update:id=" + sd.getId() + ",settleNumSumEndthis=" + BigDecimalUtils.safeAdd(new BigDecimal(settleNumSum), sd.getSettleNum()) + ",settleNumSum=" + settleNumSum);
        }
    }

    @Override
    public SubSettleVO queryProjectAndLaborMny(Long projectId, String settleDate) {
        SubSettleVO settleVO = new SubSettleVO();
        BigDecimal total = BigDecimal.ZERO;
        List<Integer> stateList = new ArrayList<>();
        stateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        stateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        LambdaQueryWrapper<SubSettleEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SubSettleEntity::getProjectId, projectId);
        queryWrapper.in(SubSettleEntity::getBillState, stateList);
        List<SubSettleEntity> settleEntities = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(settleEntities)) {
            for (SubSettleEntity settleEntity : settleEntities) {
                total = BigDecimalUtils.safeAdd(total, settleEntity.getSettleTaxMny());
            }
        }
        settleVO.setProjectSumMny(total);
        return settleVO;
    }

    @Override
    public SubParamsCheckVO checkParamsByContractNumAndMny(SubSettleCheckParamsVO settleCheckParamsVO) {
        Long curOrgId = Optional.ofNullable(settleCheckParamsVO.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        // 存放预警结果
        Map<String, List<SubParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert",new ArrayList<>());
        paramsCheckVOMap.put("warn",new ArrayList<>());
        BigDecimal contractTaxMny = settleCheckParamsVO.getContractTaxMny();
        Integer purchaseType = settleCheckParamsVO.getPurchaseType();
        BigDecimal sumSettleMentTaxMny = settleCheckParamsVO.getSumSettleMentTaxMny();
        int controlTypeIndex = 0;

        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        SubParamsCheckVO paramsCheckVO = new SubParamsCheckVO();
        List<SubParamsCheckDsVO> checkDsVOS = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, curOrgId);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            for (BillParamVO datum : data) {
                if (0 != datum.getControlType()) {
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = contractTaxMny.multiply(roleValue.divide(BigDecimal.valueOf(100)
                            , 2, BigDecimal.ROUND_HALF_UP));

                    if (2 == purchaseType) {
                        // 集采合同直接赋值为不控制
                        paramsCheckVO.setWarnType(paramsArray[controlTypeIndex]);
                        return paramsCheckVO;
                    } else {
                        if (sumSettleMentTaxMny.compareTo(comMny) > 0) {
                            controlTypeIndex = datum.getControlType() > controlTypeIndex ? datum.getControlType() : controlTypeIndex;
                            SubParamsCheckDsVO paramsCheckDsVO = new SubParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("合同超结");
                            paramsCheckDsVO.setWarnName("过程结算金额超出合同金额");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("本次过程结算金额：").append(settleCheckParamsVO.getSettleTaxMny().setScale(2, BigDecimal.ROUND_HALF_UP)).append("元,")
                                    .append("含本次累计过程结算金额：").append(sumSettleMentTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                    .append("元，合同金额*").append(roleValue).append("%:")
                                    .append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP)).append("元。超结金额：")
                                    .append(sumSettleMentTaxMny.subtract(comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, datum, paramsCheckDsVO);
                        }
                    }
                }
            }



        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        // 【合同量】控制【过程结算量】
        List<SubSettleDetailVO> detail = settleCheckParamsVO.getDetail();
        if (CollectionUtils.isNotEmpty(detail)) {
            CommonResponse<List<BillParamVO>> billParamByCodeNum = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE_NUM, curOrgId);
            if (billParamByCodeNum.isSuccess() && null != billParamByCodeNum.getData()) {
                List<BillParamVO> data = billParamByCodeNum.getData();
                for (BillParamVO datum : data) {
                    if (0 != datum.getControlType()) {
                        BigDecimal roleValue = datum.getRoleValue();

                        BigDecimal ratio = roleValue.divide(BigDecimal.valueOf(100));

                        List<SubContractDetailVO> contractDetailVOList = new ArrayList<>();
                        detail.forEach(t->{
                            if(t.getContractDetailId() != null){
                                SubContractDetailVO contractDetailVO = new SubContractDetailVO();
                                contractDetailVO.setId(t.getContractDetailId());
                                contractDetailVO.setLeafFlag(t.getLeafFlag());
                                contractDetailVO.setNum(t.getNum());
                                contractDetailVOList.add(contractDetailVO);

                            }

                        });

                        this.getSumSettleNum(contractDetailVOList);

                        if (CollectionUtils.isNotEmpty(contractDetailVOList)) {
                            Map<Long, SubContractDetailVO> numMap = contractDetailVOList.stream().collect(Collectors.toMap(SubContractDetailVO::getId, a -> a, (k1, k2) -> k1));
                            for (SubSettleDetailVO settleDetailVO : detail) {
                                Long contractDetailId = settleDetailVO.getContractDetailId();
                                if (contractDetailId == null)
                                    continue;
                                BigDecimal settleNum = settleDetailVO.getSettleNum();
                                SubContractDetailVO contractDetailVO = numMap.get(contractDetailId);
                                BigDecimal contractSumSettleNum = contractDetailVO != null ? contractDetailVO.getSumSettleNum() : BigDecimal.ZERO;
                                BigDecimal contractNum = contractDetailVO != null ? contractDetailVO.getNum() : BigDecimal.ZERO;

                                BigDecimal sumHaveThis = ComputeUtil.safeAdd(settleNum, contractSumSettleNum);
                                BigDecimal contractNumRatio = ComputeUtil.safeMultiply(contractNum, ratio);


                                if (ComputeUtil.isGreaterThan(sumHaveThis, contractNumRatio)) {

                                    controlTypeIndex = datum.getControlType() > controlTypeIndex ? datum.getControlType() : controlTypeIndex;

                                    SubParamsCheckDsVO paramsCheckDsVO = new SubParamsCheckDsVO();
                                    paramsCheckDsVO.setOrgName(datum.getOrgName());
                                    paramsCheckDsVO.setWarnItem("清单名称：" + settleDetailVO.getName() + "，计量单位：" + (StringUtils.isNotEmpty(settleDetailVO.getUnit()) ? settleDetailVO.getUnit() : "无"));
                                    paramsCheckDsVO.setWarnName("过程结算数量大于合同数量");
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append("本次过程结算数量：").append(com.ejianc.framework.core.util.ComputeUtil.scaleStripTrailingZeros(settleNum,4))
                                            .append("，含本次累计过程结算数量：").append(com.ejianc.framework.core.util.ComputeUtil.scaleStripTrailingZeros(sumHaveThis,4))
                                            .append("，合同数量*").append(roleValue).append("%:")
                                            .append(com.ejianc.framework.core.util.ComputeUtil.scaleStripTrailingZeros(contractNumRatio,4)).append("。超出数量：")
                                            .append(com.ejianc.framework.core.util.ComputeUtil.scaleStripTrailingZeros(ComputeUtil.safeSub(sumHaveThis, contractNumRatio),4));
                                    paramsCheckDsVO.setContent(stringBuffer.toString());
                                    checkDsVOS.add(paramsCheckDsVO);
                                    updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, datum, paramsCheckDsVO);
                                }
                            }
                        }
                    }
                }
            } else {
                logger.info(billParamByCode.getMsg());
                throw new BusinessException("获取控制参数失败");
            }
        }

        //处理刚性、柔性预警
        SubParamsCheckVO pc = new SubParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            pc.setWarnType("alert");
            pc.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            pc.setWarnType("warn");
            pc.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //筛选重复序号
                Map<String, Integer> indexMap = new HashMap<>();
                List<SubSettleDetailVO> detailVoList = new ArrayList<>();
                Map<String, String> tidMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    SubSettleDetailVO vo = new SubSettleDetailVO();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";

                    String detailIndex = datas.get(0);
                    vo.setTreeIndex(detailIndex);
                    //维护父子关系
                    Long id = IdWorker.getId();
                    if (StringUtils.isNotEmpty(detailIndex)) {//序号不为空
                        String[] split = detailIndex.split("[-/.]");
                        vo.setTid(String.valueOf(id));
                        vo.setId(id);
                        tidMap.put(detailIndex, String.valueOf(id));
                        if (split.length > 1) {
                            vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                        }
                    } else {
                        vo.setTid(String.valueOf(id));
                        vo.setId(id);
                        vo.setTpid("");
                    }

                    if (indexMap.containsKey(detailIndex)) {//序号重复
                        return CommonResponse.error("第" + (i + 2) + "行序号和第" + (indexMap.get(detailIndex) + 2) + "行重复");
                    } else {
                        indexMap.put(detailIndex, i);
                    }
                    vo.setCode(datas.get(1));
                    vo.setName(datas.get(2));
                    vo.setSpec(datas.get(3));
                    vo.setUnit(datas.get(4));//计量单位
                    if (StringUtils.isEmpty(datas.get(5))) {
                        vo.setSettleNum(null);
                        warnType = warnType + "本期结算量为空,";
                        flag = true;
                    } else {
                        try {
                            vo.setSettleNum(new BigDecimal(datas.get(5)));
                        } catch (Exception e) {
                            vo.setSettleNum(null);
                            warnType = warnType + "本期结算量只能为数字或小数,";
                            flag = true;
                        }
                    }
                    try {
                        vo.setPrice(new BigDecimal(datas.get(6)));
                    } catch (Exception e) {
                        vo.setPrice(null);
                        warnType = warnType + "综合单价只能为数字或小数,";
                        flag = true;
                    }
                    if (!flag) {
                        BigDecimal scale = com.ejianc.framework.core.util.ComputeUtil.scale(ComputeUtil.safeMultiply(vo.getSettleNum(), vo.getPrice()), 2);
                        vo.setSettleMny(scale);
                    }
                    // end
                    vo.setMemo(datas.get(7));

                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    vo.setParentWarn(parentWarn);
                    if (flag) {
                        warnType = warnType.substring(0, warnType.length() - 1);
                    }
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    vo.setShadowId(vo.getTid());
                    vo.setSourceType(2);
                    detailVoList.add(vo);
                }

                for (SubSettleDetailVO tVo : detailVoList) {
                    tVo.setTpid(tidMap.get(tVo.getTpid()));
                }
                List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
                resp.put("successList", allList.get(0));
                resp.put("errorList", errorList);
                resp.put("successNum", result.size() - errorList.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }


    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<SubParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, SubParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<SubParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<SubParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }


}
