/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.asset.bean.AssetEntity;
import com.ejianc.business.asset.bean.AssetOutEntity;
import com.ejianc.business.asset.bean.AssetRecordEntity;
import com.ejianc.business.asset.mapper.AssetMapper;
import com.ejianc.business.asset.service.IAssetRecordService;
import com.ejianc.business.asset.service.IAssetService;
import com.ejianc.business.asset.vo.AssetVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="assetService")
public class AssetServiceImpl
extends BaseServiceImpl<AssetMapper, AssetEntity>
implements IAssetService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAssetRecordService assetRecordService;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public void updateAssetRecord(List<Long> assetIdList, AssetOutEntity outEntity) {
        super.update((Wrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().in((Object)"id", assetIdList)).set((Object)"out_occupy_flag", (Object)0)).set((Object)"project_id", (Object)outEntity.getInProjectId())).set((Object)"project_name", (Object)outEntity.getInProjectName())).set((Object)"project_code", (Object)outEntity.getInProjectCode())).set((Object)"org_id", (Object)outEntity.getInOrgId())).set((Object)"org_name", (Object)outEntity.getInOrgName()));
        ArrayList<AssetRecordEntity> assetRecordEntityList = new ArrayList<AssetRecordEntity>();
        for (Long assetId : assetIdList) {
            AssetRecordEntity assetRecordEntity = new AssetRecordEntity();
            assetRecordEntity.setId(IdWorker.getId());
            assetRecordEntity.setAssetId(assetId);
            assetRecordEntity.setOutProjectId(outEntity.getProjectId());
            assetRecordEntity.setOutProjectName(outEntity.getProjectName());
            assetRecordEntity.setOutProjectCode(outEntity.getProjectCode());
            assetRecordEntity.setOutOrgId(outEntity.getOrgId());
            assetRecordEntity.setOutOrgName(outEntity.getOrgName());
            assetRecordEntity.setSourceBillId(outEntity.getId());
            assetRecordEntity.setSourceBillCode(outEntity.getBillCode());
            assetRecordEntity.setOutDate(outEntity.getOutDate());
            assetRecordEntityList.add(assetRecordEntity);
        }
        this.assetRecordService.saveOrUpdateBatch(assetRecordEntityList, assetRecordEntityList.size(), false);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<AssetVO> successList = new ArrayList<AssetVO>();
        ArrayList<AssetVO> errorList = new ArrayList<AssetVO>();
        if (result != null && result.size() > 0) {
            if (result.size() >= 1000) {
                throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc71000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
            }
            CommonResponse defAssetTypeList = this.defdocApi.getDefDocByDefCode("zy-asset-type");
            this.logger.info("\u81ea\u5b9a\u4e49\u6863\u6848\u8d44\u4ea7\u7c7b\u522b\u67e5\u8be2\u4f7f\u7528\u65f6\u95f4----------->{}", (Object)new Date());
            CommonResponse defDepreciationList = this.defdocApi.getDefDocByDefCode("zydx-depreciation");
            this.logger.info("\u81ea\u5b9a\u4e49\u6863\u6848\u6298\u65e7\u65b9\u6cd5\u4f7f\u7528\u65f6\u95f4----------->{}", (Object)new Date());
            if (!defAssetTypeList.isSuccess()) {
                return CommonResponse.error((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u67e5\u8be2\u81ea\u5b9a\u4e49\u6863\u6848\u8d44\u4ea7\u7c7b\u522b\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            }
            if (!defDepreciationList.isSuccess()) {
                return CommonResponse.error((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u67e5\u8be2\u81ea\u5b9a\u4e49\u6863\u6848\u6298\u65e7\u65b9\u6cd5\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            }
            HashMap projectPoolSetVOMap = new HashMap();
            HashMap orgVOMap = new HashMap();
            Map defAssetTypeMap = ((List)defAssetTypeList.getData()).stream().collect(Collectors.toMap(DefdocDetailVO::getName, Function.identity(), (key1, key2) -> key2));
            Map defDepreciationMap = ((List)defDepreciationList.getData()).stream().collect(Collectors.toMap(DefdocDetailVO::getName, Function.identity(), (key1, key2) -> key2));
            Long employeeId = this.sessionManager.getUserContext().getEmployeeId();
            String employeeName = null;
            CommonResponse userData = this.employeeApi.getById(employeeId);
            if (userData.isSuccess()) {
                employeeName = ((EmployeeVO)userData.getData()).getName();
            }
            for (int i = 1; i < result.size(); ++i) {
                CommonResponse orgData;
                StringBuilder errorMessage = new StringBuilder();
                List datas = (List)result.get(i);
                AssetVO importVO = new AssetVO();
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    importVO.setBillCode((String)datas.get(0));
                } else {
                    CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode("ZY_ASSET", tenantId);
                    if (billCode.isSuccess()) {
                        importVO.setBillCode((String)billCode.getData());
                    } else {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u8c03\u5165\u5355\u53f7\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    errorMessage.append("[\u56fa\u5b9a\u8d44\u4ea7\u540d\u79f0\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    importVO.setAssetName((String)datas.get(1));
                    if (((String)datas.get(1)).length() > 200) {
                        importVO.setErrorMessage("[\u56fa\u5b9a\u8d44\u4ea7\u540d\u79f0\u957f\u5ea6\u4e3a1~200\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    importVO.setAssetTypeName((String)datas.get(2));
                    if (((String)datas.get(2)).length() > 100) {
                        errorMessage.append("[\u586b\u5199\u56fa\u5b9a\u8d44\u4ea7\u7c7b\u522b\u957f\u5ea6\u4e3a1~100\u5b57]");
                    } else if (defAssetTypeMap.get(datas.get(2)) == null) {
                        errorMessage.append("[\u81ea\u5b9a\u4e49\u6863\u6848\u4e0d\u5b58\u5728\u5f53\u524d\u56fa\u5b9a\u8d44\u4ea7\u7c7b\u522b]");
                    } else {
                        importVO.setAssetTypeId(((DefdocDetailVO)defAssetTypeMap.get(datas.get(2))).getId());
                    }
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    errorMessage.append("[\u8d22\u52a1\u5165\u8d26\u65e5\u671f\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    try {
                        importVO.setFinanceEntryDate(DateUtils.parseDate((String)((String)datas.get(4)), (String[])new String[]{"YYYY-MM-dd"}));
                    }
                    catch (ParseException e) {
                        errorMessage.append("[\u8d22\u52a1\u5165\u8d26\u65e5\u671f\u586b\u5199\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u586b\u5199 YYYY-MM-dd \u7c7b\u578b\u7684\u65e5\u671f\u683c\u5f0f]");
                        e.printStackTrace();
                    }
                }
                importVO.setDepositPlace((String)datas.get(5));
                importVO.setUseDept((String)datas.get(6));
                importVO.setUsePerson((String)datas.get(7));
                importVO.setSpec((String)datas.get(8));
                importVO.setOrigin((String)datas.get(9));
                importVO.setMaker((String)datas.get(10));
                importVO.setTecCode((String)datas.get(11));
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12)))) {
                    importVO.setDepreciationName((String)datas.get(12));
                    if (((String)datas.get(12)).length() > 100) {
                        errorMessage.append("[\u586b\u5199\u6298\u65e7\u65b9\u6cd5\u957f\u5ea6\u4e3a1~100\u5b57]");
                    } else if (defDepreciationMap.get(datas.get(12)) == null) {
                        errorMessage.append("[\u81ea\u5b9a\u4e49\u6863\u6848\u4e0d\u5b58\u5728\u5f53\u524d\u6298\u65e7\u65b9\u6cd5]");
                    } else {
                        importVO.setDepreciationId(((DefdocDetailVO)defDepreciationMap.get(datas.get(12))).getId());
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(13)))) {
                    try {
                        importVO.setInitCoinMny(new BigDecimal((String)datas.get(13)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u539f\u5e01\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(14)))) {
                    try {
                        importVO.setAssetInitMny(new BigDecimal((String)datas.get(14)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u8d44\u4ea7\u539f\u503c\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                importVO.setExpectUseTerm((String)datas.get(15));
                importVO.setDepreciationTerm((String)datas.get(16));
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(17)))) {
                    try {
                        importVO.setTotalDepreciationMny(new BigDecimal((String)datas.get(17)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u7d2f\u8ba1\u6298\u65e7\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(18)))) {
                    try {
                        importVO.setExpectSalvageMny(new BigDecimal((String)datas.get(18)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u9884\u8ba1\u51c0\u6b8b\u503c\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(19)))) {
                    try {
                        importVO.setNetMny(new BigDecimal((String)datas.get(19)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u51c0\u503c\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(20)))) {
                    importVO.setProjectName((String)datas.get(20));
                    importVO.setDependOnProject(1);
                    if (((String)datas.get(20)).length() > 128) {
                        errorMessage.append("[\u586b\u5199\u4f7f\u7528\u9879\u76ee\u957f\u5ea6\u4e3a1~128\u5b57]");
                    } else if (projectPoolSetVOMap.get(datas.get(20)) != null) {
                        importVO.setProjectId(((ProjectRegisterVO)projectPoolSetVOMap.get(datas.get(20))).getId());
                        importVO.setProjectCode(((ProjectRegisterVO)projectPoolSetVOMap.get(datas.get(20))).getCode());
                        importVO.setOrgId(((ProjectRegisterVO)projectPoolSetVOMap.get(datas.get(20))).getProjectDepartmentId());
                    } else {
                        CommonResponse projectData = this.projectApi.getDataByName((String)datas.get(20));
                        if (!projectData.isSuccess()) {
                            errorMessage.append("[\u9879\u76ee\u6c60\u4e0d\u5b58\u5728\u5f53\u524d\u4f7f\u7528\u9879\u76ee\u7684\u9879\u76ee]");
                        } else if (null != projectData.getData()) {
                            projectPoolSetVOMap.put(datas.get(20), projectData.getData());
                            importVO.setProjectId(((ProjectRegisterVO)projectPoolSetVOMap.get(datas.get(20))).getId());
                            importVO.setProjectCode(((ProjectRegisterVO)projectPoolSetVOMap.get(datas.get(20))).getCode());
                            importVO.setOrgId(((ProjectRegisterVO)projectPoolSetVOMap.get(datas.get(20))).getProjectDepartmentId());
                        } else {
                            errorMessage.append("[\u9879\u76ee\u6c60\u4e0d\u5b58\u5728\u5f53\u524d\u4f7f\u7528\u9879\u76ee\u7684\u9879\u76ee]");
                        }
                    }
                } else {
                    importVO.setDependOnProject(0);
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(20))) && StringUtils.isBlank((CharSequence)((CharSequence)datas.get(21)))) {
                    errorMessage.append("[\u4f7f\u7528\u9879\u76ee\u3001\u4f7f\u7528\u7ec4\u7ec7\u9700\u8981\u6709\u4e00\u4e2a\u5fc5\u586b]");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(21)))) {
                    importVO.setOrgName((String)datas.get(21));
                    if (((String)datas.get(21)).length() > 128) {
                        errorMessage.append("[\u4f7f\u7528\u7ec4\u7ec7\u586b\u5199\u957f\u5ea6\u4e3a1~128\u5b57]");
                    } else if (orgVOMap.get(datas.get(21)) != null) {
                        if (datas.get(20) != null && importVO.getOrgId() != null && importVO.getOrgId().longValue() != ((OrgVO)orgVOMap.get(datas.get(21))).getId().longValue()) {
                            errorMessage.append("[\u9879\u76ee\u6c60\u4e2d\u5f53\u524d\u6240\u5c5e\u7ec4\u7ec7\u548c\u6240\u5c5e\u9879\u76ee\u4e0d\u7b26\u5408]");
                        } else {
                            importVO.setOrgId(((OrgVO)orgVOMap.get(datas.get(21))).getId());
                        }
                    } else {
                        orgData = this.iOrgApi.findByNameAndTenantId((String)datas.get(21), tenantId);
                        if (!orgData.isSuccess()) {
                            errorMessage.append("[\u7ec4\u7ec7\u7ba1\u7406\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u4f7f\u7528\u7ec4\u7ec7]");
                        } else if (datas.get(20) != null && importVO.getOrgId() != null && importVO.getOrgId().longValue() != ((OrgVO)orgData.getData()).getId().longValue()) {
                            errorMessage.append("[\u9879\u76ee\u6c60\u4e2d\u5f53\u524d\u6240\u5c5e\u7ec4\u7ec7\u548c\u6240\u5c5e\u9879\u76ee\u4e0d\u7b26\u5408]");
                        } else {
                            orgVOMap.put(datas.get(21), orgData.getData());
                            importVO.setOrgId(((OrgVO)orgVOMap.get(datas.get(21))).getId());
                        }
                    }
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(22)))) {
                    errorMessage.append("[\u4ea7\u6743\u5355\u4f4d\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    importVO.setPropertyOrgName((String)datas.get(22));
                    if (((String)datas.get(22)).length() > 128) {
                        errorMessage.append("[\u4ea7\u6743\u5355\u4f4d\u586b\u5199\u957f\u5ea6\u4e3a1~128\u5b57]");
                    } else if (orgVOMap.get(datas.get(22)) != null) {
                        importVO.setPropertyOrgId(((OrgVO)orgVOMap.get(datas.get(22))).getId());
                    } else {
                        orgData = this.iOrgApi.findByNameAndTenantId((String)datas.get(22), tenantId);
                        if (!orgData.isSuccess()) {
                            errorMessage.append("[\u7ec4\u7ec7\u7ba1\u7406\u4e2d\u4e0d\u5b58\u5728\u8be5\u4ea7\u6743\u5355\u4f4d");
                        } else {
                            orgVOMap.put(datas.get(22), orgData.getData());
                            importVO.setPropertyOrgId(((OrgVO)orgVOMap.get(datas.get(22))).getId());
                        }
                    }
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(23)))) {
                    errorMessage.append("[\u7ba1\u7406\u5355\u4f4d\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    importVO.setManageOrgName((String)datas.get(23));
                    if (((String)datas.get(23)).length() > 128) {
                        errorMessage.append("[\u7ba1\u7406\u5355\u4f4d\u586b\u5199\u957f\u5ea6\u4e3a1~128\u5b57]");
                    } else if (orgVOMap.get(datas.get(23)) != null) {
                        importVO.setManageOrgId(((OrgVO)orgVOMap.get(datas.get(23))).getId());
                    } else {
                        orgData = this.iOrgApi.findByNameAndTenantId((String)datas.get(23), tenantId);
                        if (!orgData.isSuccess()) {
                            errorMessage.append("[\u7ec4\u7ec7\u7ba1\u7406\u4e2d\u4e0d\u5b58\u5728\u8be5\u7ba1\u7406\u5355\u4f4d");
                        } else {
                            orgVOMap.put(datas.get(23), orgData.getData());
                            importVO.setManageOrgId(((OrgVO)orgVOMap.get(datas.get(23))).getId());
                        }
                    }
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(24)))) {
                    errorMessage.append("[\u9a8c\u6536\u65e5\u671f\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    try {
                        importVO.setCheckDate(DateUtils.parseDate((String)((String)datas.get(24)), (String[])new String[]{"YYYY-MM-dd"}));
                    }
                    catch (ParseException e) {
                        errorMessage.append("[\u9a8c\u6536\u65e5\u671f\u586b\u5199\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u586b\u5199 YYYY-MM-dd \u7c7b\u578b\u7684\u65e5\u671f\u683c\u5f0f]");
                        e.printStackTrace();
                    }
                }
                importVO.setEmployeeId(employeeId);
                importVO.setEmployeeName(employeeName);
                importVO.setEquipmentState(1);
                importVO.setOutOccupyFlag(0);
                importVO.setAssetSourceType(2);
                importVO.setId(IdWorker.getId());
                if (StringUtils.isBlank((CharSequence)errorMessage)) {
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) && Integer.valueOf((String)datas.get(3)) > 1) {
                        for (int e = 0; e < Integer.valueOf((String)datas.get(3)); ++e) {
                            importVO.setId(IdWorker.getId());
                            successList.add(importVO);
                        }
                        continue;
                    }
                    successList.add(importVO);
                    continue;
                }
                importVO.setErrorMessage(String.valueOf(errorMessage));
                errorList.add(importVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<AssetVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        List billCodeList = importVOS.stream().filter(e -> null != e.getBillCode()).map(AssetVO::getBillCode).collect(Collectors.toList());
        List oldEntityList = super.list((Wrapper)new QueryWrapper().in((Object)"bill_code", billCodeList));
        if (CollectionUtils.isNotEmpty(billCodeList) && oldEntityList.size() > 0) {
            List oldBIllCode = oldEntityList.stream().map(AssetEntity::getBillCode).collect(Collectors.toList());
            throw new BusinessException("\u5bfc\u5165\u6570\u636e\u4e2d\u6709\u8d44\u4ea7\u7f16\u53f7\u91cd\u590d\u7684\u6570\u636e" + JSONObject.toJSONString(oldBIllCode));
        }
        importVOS.forEach(e -> e.setId(IdWorker.getId()));
        List entityList = BeanMapper.mapList(importVOS, AssetEntity.class);
        super.saveOrUpdateBatch(entityList, entityList.size(), false);
        return "\u4fdd\u5b58\u6210\u529f";
    }
}

