package com.ejianc.business.asset.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.asset.vo.AssetScrapDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 固定资产报废
 * 
 * @author generator
 * 
 */
public class AssetScrapVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 单据编号
    private Integer dependOnProject; // 是否属于项目: 默认为true
    private String projectName; // 报废项目名称
    private String projectCode; // 报废项目编码
    private Long projectId; // 报废项目id
    private Long orgId; // 报废组织id
    private String orgName; // 报废组织名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date disposeDate; // 报废日期
    private BigDecimal totalAssetInitMny; // 资产原值
    private BigDecimal totalNetMny; // 资产净值
    private Long employeeId; // 经办人
    private String employeeName; // 经办人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date makeDate; // 编制日期
    private String memo; // 备注
    private String billStateName; //单据编码名称
    private String dependOnProjectName; // 是否属于项目: 默认为true
    
    private List<AssetScrapDetailVO> detailList = new ArrayList<>(); // 固定资产报废-子实体

    public String getDependOnProjectName() {
        return dependOnProjectName;
    }

    public void setDependOnProjectName(String dependOnProjectName) {
        this.dependOnProjectName = dependOnProjectName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(Integer dependOnProject) {
        this.dependOnProject = dependOnProject;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getDisposeDate() {
        return disposeDate;
    }

    public void setDisposeDate(Date disposeDate) {
        this.disposeDate = disposeDate;
    }
    public BigDecimal getTotalAssetInitMny() {
        return totalAssetInitMny;
    }

    public void setTotalAssetInitMny(BigDecimal totalAssetInitMny) {
        this.totalAssetInitMny = totalAssetInitMny;
    }
    public BigDecimal getTotalNetMny() {
        return totalNetMny;
    }

    public void setTotalNetMny(BigDecimal totalNetMny) {
        this.totalNetMny = totalNetMny;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<AssetScrapDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<AssetScrapDetailVO> detailList) {
        this.detailList = detailList;
    }
}
