package com.ejianc.business.cost.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 标前测算
 * 
 * @author generator
 * 
 */
public class PreBidCostCalcVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据审批状态
    private String billCode; // 单据编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String pubUnitName; // 发包单位名称
    private String contractUnitName; // 承包单位名称
    private String projectManageName; // 项目管理
    private Long projectDepartmentId; // 项目部id
    private Long orgId; // 组织ID
    private BigDecimal contractTaxMny; // 含税合同额
    private BigDecimal contractMny; // 不含税合同额
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 项目开工时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishDate; // 项目完工时间
    private String address; // 施工地点

    private Long establishmentOrgId; // 编制单位ID
    private String establishmentOrgName; // 编制单位名称
    private Long establishmentUserId; // 编制人ID
    private String establishmentUserName; // 编制人名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date establishmentDate; // 编制日期
    private String remark; // 备注
    private BigDecimal laborCost; // 直接人工费
    private BigDecimal materialCost; // 直接材料费
    private BigDecimal equipmentCost; // 机械使用费
    private BigDecimal directCost; // 其他直接费
    private BigDecimal coalitionCost; // 外协成本
    private BigDecimal otherCost; // 其他费用支出
    private BigDecimal costNotaxTotal; // 标前成本测算小计（不含税）
    private BigDecimal taxCost; // 增值税及附加
    private BigDecimal costTaxTotal; // 标前成本测算小计（含税）
    private BigDecimal capitalCost; // 垫资资金成本
    private BigDecimal dynamicCostTotal; // 动态成本测算合计
    private BigDecimal incomeNotax; // 不含税收入
    private BigDecimal projectProfitRate; // 项目利润率
    private String sourceId; // 来源id

    private List<PreBidCostCalcDetailVO> preBidCostCalcDetailList = new ArrayList<>();

    public List<PreBidCostCalcDetailVO> getPreBidCostCalcDetailList() {
        return preBidCostCalcDetailList;
    }

    public void setPreBidCostCalcDetailList(List<PreBidCostCalcDetailVO> preBidCostCalcDetailList) {
        this.preBidCostCalcDetailList = preBidCostCalcDetailList;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getPubUnitName() {
        return pubUnitName;
    }

    public void setPubUnitName(String pubUnitName) {
        this.pubUnitName = pubUnitName;
    }
    public String getContractUnitName() {
        return contractUnitName;
    }

    public void setContractUnitName(String contractUnitName) {
        this.contractUnitName = contractUnitName;
    }
    public String getProjectManageName() {
        return projectManageName;
    }

    public void setProjectManageName(String projectManageName) {
        this.projectManageName = projectManageName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getEstablishmentOrgId() {
        return establishmentOrgId;
    }

    @ReferDeserialTransfer
    public void setEstablishmentOrgId(Long establishmentOrgId) {
        this.establishmentOrgId = establishmentOrgId;
    }
    public String getEstablishmentOrgName() {
        return establishmentOrgName;
    }

    public void setEstablishmentOrgName(String establishmentOrgName) {
        this.establishmentOrgName = establishmentOrgName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEstablishmentUserId() {
        return establishmentUserId;
    }

    @ReferDeserialTransfer
    public void setEstablishmentUserId(Long establishmentUserId) {
        this.establishmentUserId = establishmentUserId;
    }
    public String getEstablishmentUserName() {
        return establishmentUserName;
    }

    public void setEstablishmentUserName(String establishmentUserName) {
        this.establishmentUserName = establishmentUserName;
    }
    public Date getEstablishmentDate() {
        return establishmentDate;
    }

    public void setEstablishmentDate(Date establishmentDate) {
        this.establishmentDate = establishmentDate;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public BigDecimal getLaborCost() {
        return laborCost;
    }

    public void setLaborCost(BigDecimal laborCost) {
        this.laborCost = laborCost;
    }
    public BigDecimal getMaterialCost() {
        return materialCost;
    }

    public void setMaterialCost(BigDecimal materialCost) {
        this.materialCost = materialCost;
    }
    public BigDecimal getEquipmentCost() {
        return equipmentCost;
    }

    public void setEquipmentCost(BigDecimal equipmentCost) {
        this.equipmentCost = equipmentCost;
    }
    public BigDecimal getDirectCost() {
        return directCost;
    }

    public void setDirectCost(BigDecimal directCost) {
        this.directCost = directCost;
    }
    public BigDecimal getCoalitionCost() {
        return coalitionCost;
    }

    public void setCoalitionCost(BigDecimal coalitionCost) {
        this.coalitionCost = coalitionCost;
    }
    public BigDecimal getOtherCost() {
        return otherCost;
    }

    public void setOtherCost(BigDecimal otherCost) {
        this.otherCost = otherCost;
    }
    public BigDecimal getCostNotaxTotal() {
        return costNotaxTotal;
    }

    public void setCostNotaxTotal(BigDecimal costNotaxTotal) {
        this.costNotaxTotal = costNotaxTotal;
    }
    public BigDecimal getTaxCost() {
        return taxCost;
    }

    public void setTaxCost(BigDecimal taxCost) {
        this.taxCost = taxCost;
    }
    public BigDecimal getCostTaxTotal() {
        return costTaxTotal;
    }

    public void setCostTaxTotal(BigDecimal costTaxTotal) {
        this.costTaxTotal = costTaxTotal;
    }
    public BigDecimal getCapitalCost() {
        return capitalCost;
    }

    public void setCapitalCost(BigDecimal capitalCost) {
        this.capitalCost = capitalCost;
    }
    public BigDecimal getDynamicCostTotal() {
        return dynamicCostTotal;
    }

    public void setDynamicCostTotal(BigDecimal dynamicCostTotal) {
        this.dynamicCostTotal = dynamicCostTotal;
    }
    public BigDecimal getIncomeNotax() {
        return incomeNotax;
    }

    public void setIncomeNotax(BigDecimal incomeNotax) {
        this.incomeNotax = incomeNotax;
    }
    public BigDecimal getProjectProfitRate() {
        return projectProfitRate;
    }

    public void setProjectProfitRate(BigDecimal projectProfitRate) {
        this.projectProfitRate = projectProfitRate;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
}
