/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.cost.bean.ProjectTargetcostChangeEntity;
import com.ejianc.business.cost.bean.ProjectTargetcostDetailEntity;
import com.ejianc.business.cost.bean.ProjectTargetcostEntity;
import com.ejianc.business.cost.mapper.ProjectTargetcostChangeMapper;
import com.ejianc.business.cost.service.IEngdepartRespcostService;
import com.ejianc.business.cost.service.IProjectTargetcostChangeService;
import com.ejianc.business.cost.service.IProjectTargetcostRecordService;
import com.ejianc.business.cost.service.IProjectTargetcostService;
import com.ejianc.business.cost.utils.ProjectUtils;
import com.ejianc.business.cost.vo.ProjectTargetcostChangeDetailVO;
import com.ejianc.business.cost.vo.ProjectTargetcostChangeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectTargetcostChangeService")
public class ProjectTargetcostChangeServiceImpl
extends BaseServiceImpl<ProjectTargetcostChangeMapper, ProjectTargetcostChangeEntity>
implements IProjectTargetcostChangeService {
    @Autowired
    private IProjectTargetcostService projectTargetcostService;
    @Autowired
    private IProjectTargetcostRecordService recordService;
    @Autowired
    private IEngdepartRespcostService engdepartRespcostService;
    @Autowired
    private ProjectUtils projectUtils;

    @Override
    public CommonResponse<ProjectTargetcostChangeVO> saveChange(ProjectTargetcostChangeVO saveOrUpdateVO) {
        BigDecimal contractMny;
        List exit;
        ProjectTargetcostChangeEntity entity = (ProjectTargetcostChangeEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ProjectTargetcostChangeEntity.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"taskcost_id", (Object)saveOrUpdateVO.getTaskcostId());
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"bill_state", new Object[]{"[0,4]"});
        if (saveOrUpdateVO.getId() != null) {
            queryWrapper.ne((Object)"id", (Object)saveOrUpdateVO.getId());
        }
        if ((exit = this.list((Wrapper)queryWrapper)) != null && exit.size() > 0) {
            throw new BusinessException("\u5df2\u5b58\u5728\u672a\u5b8c\u6210\u7684\u53d8\u66f4\u5355\u636e\uff0c\u4e0d\u80fd\u65b0\u589e\u65b0\u7684\u53d8\u66f4\u5355\u636e");
        }
        BigDecimal bigDecimal = contractMny = saveOrUpdateVO.getContractTaxMny() != null ? saveOrUpdateVO.getContractTaxMny() : new BigDecimal(0);
        if ("\u5b50\u9879\u76ee".equals(saveOrUpdateVO.getProjectProperty())) {
            List<Long> projectIds = this.projectUtils.getProjectList(saveOrUpdateVO.getProjectId());
            if (projectIds != null && projectIds.size() > 0) {
                QueryWrapper wrappera = new QueryWrapper();
                wrappera.in((Object)"project_id", projectIds);
                List lsit = this.projectTargetcostService.list((Wrapper)wrappera);
                if (lsit != null && lsit.size() > 0) {
                    BigDecimal amont = saveOrUpdateVO.getAllocateContractMny() != null ? saveOrUpdateVO.getAllocateContractMny() : new BigDecimal(0);
                    for (ProjectTargetcostEntity vo : lsit) {
                        BigDecimal allocateContractMny = vo.getAllocateContractMny() != null ? vo.getAllocateContractMny() : new BigDecimal(0);
                        amont = amont.add(allocateContractMny);
                    }
                    if (amont.compareTo(contractMny) > 0) {
                        throw new BusinessException("\u5b50\u9879\u76ee\u7d2f\u8ba1\u5206\u914d\u989d\u3010" + amont.setScale(2, 4) + "\u3011\u4e0d\u5f97\u8d85\u5408\u540c\u989d\u3010" + contractMny.setScale(2, 4) + "\u3011");
                    }
                }
            } else {
                BigDecimal allocateContractMny;
                BigDecimal bigDecimal2 = allocateContractMny = saveOrUpdateVO.getAllocateContractMny() != null ? saveOrUpdateVO.getAllocateContractMny() : new BigDecimal(0);
                if (allocateContractMny.compareTo(contractMny) > 0) {
                    throw new BusinessException("\u5b50\u9879\u76ee\u7d2f\u8ba1\u5206\u914d\u989d\u3010" + allocateContractMny.setScale(2, 4) + "\u3011\u4e0d\u5f97\u8d85\u5408\u540c\u989d\u3010" + contractMny.setScale(2, 4) + "\u3011");
                }
            }
        } else {
            BigDecimal allocateContractMny;
            BigDecimal bigDecimal3 = allocateContractMny = saveOrUpdateVO.getAllocateContractMny() != null ? saveOrUpdateVO.getAllocateContractMny() : new BigDecimal(0);
            if (allocateContractMny.compareTo(contractMny) > 0) {
                throw new BusinessException("\u5b50\u9879\u76ee\u7d2f\u8ba1\u5206\u914d\u989d\u3010" + allocateContractMny.setScale(2, 4) + "\u3011\u4e0d\u5f97\u8d85\u5408\u540c\u989d\u3010" + contractMny.setScale(2, 4) + "\u3011");
            }
        }
        this.engdepartRespcostService.checkAmount(saveOrUpdateVO.getProjectId(), saveOrUpdateVO.getProjectProperty(), saveOrUpdateVO.getTargetcostTotal());
        if (entity.getProjectTargetcostChangeDetailList() != null && entity.getProjectTargetcostChangeDetailList().size() > 0) {
            HashMap map = new HashMap();
            entity.getProjectTargetcostChangeDetailList().forEach(item -> {
                if ("add".equals(item.getRowState())) {
                    item.setId(IdWorker.getId());
                    item.setTargetcostChangeId(entity.getId());
                }
                if (!"del".equals(item.getRowState())) {
                    map.put(item.getCode(), item.getId());
                }
            });
            entity.getProjectTargetcostChangeDetailList().forEach(item -> {
                if ("add".equals(item.getRowState()) && item.getCode().indexOf(".") != -1) {
                    String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
                    item.setPid((Long)map.get(code));
                }
            });
        }
        this.saveOrUpdate((Object)entity, false);
        ProjectTargetcostEntity targetcostEntity = (ProjectTargetcostEntity)((Object)this.projectTargetcostService.selectById(entity.getTaskcostId()));
        targetcostEntity.setChangeState("2");
        targetcostEntity.setChangeId(entity.getId());
        this.projectTargetcostService.saveOrUpdate((Object)targetcostEntity, false);
        ProjectTargetcostChangeVO vo = (ProjectTargetcostChangeVO)((Object)BeanMapper.map((Object)((Object)entity), ProjectTargetcostChangeVO.class));
        if (CollectionUtils.isNotEmpty(vo.getProjectTargetcostChangeDetailList())) {
            ProjectTargetcostChangeServiceImpl.sortIntMethod(vo.getProjectTargetcostChangeDetailList());
            List<ProjectTargetcostChangeDetailVO> detailVOS = ProjectTargetcostChangeServiceImpl.createTreeData(vo.getProjectTargetcostChangeDetailList());
            vo.setProjectTargetcostChangeDetailList(detailVOS);
        }
        return CommonResponse.success((Object)((Object)vo));
    }

    @Override
    public CommonResponse<String> delete(List<ProjectTargetcostChangeVO> vos) {
        for (ProjectTargetcostChangeVO vo : vos) {
            ProjectTargetcostChangeEntity entity = (ProjectTargetcostChangeEntity)((Object)this.getById(vo.getId()));
            ProjectTargetcostEntity targetcostEntity = (ProjectTargetcostEntity)((Object)this.projectTargetcostService.selectById(entity.getTaskcostId()));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"taskcost_id", (Object)targetcostEntity.getId());
            List records = this.recordService.list((Wrapper)queryWrapper);
            if (records != null && records.size() > 0) {
                targetcostEntity.setChangeState("3");
            } else {
                targetcostEntity.setChangeState("1");
            }
            targetcostEntity.setChangeId(null);
            this.projectTargetcostService.saveOrUpdate((Object)targetcostEntity, false);
        }
        this.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<ProjectTargetcostChangeVO> queryDetail(Long id) {
        ProjectTargetcostChangeEntity entity = (ProjectTargetcostChangeEntity)((Object)this.selectById(id));
        ProjectTargetcostChangeVO vo = (ProjectTargetcostChangeVO)((Object)BeanMapper.map((Object)((Object)entity), ProjectTargetcostChangeVO.class));
        if (CollectionUtils.isNotEmpty(vo.getProjectTargetcostChangeDetailList())) {
            ProjectTargetcostChangeServiceImpl.sortIntMethod(vo.getProjectTargetcostChangeDetailList());
            List<ProjectTargetcostChangeDetailVO> detailVOS = ProjectTargetcostChangeServiceImpl.createTreeData(vo.getProjectTargetcostChangeDetailList());
            vo.setProjectTargetcostChangeDetailList(detailVOS);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @Override
    public CommonResponse<ProjectTargetcostChangeVO> queryDetailByTargetcostId(Long targetcostId) {
        ProjectTargetcostEntity targetcostEntity = (ProjectTargetcostEntity)((Object)this.projectTargetcostService.selectById(targetcostId));
        QueryWrapper recordWrapper = new QueryWrapper();
        recordWrapper.eq((Object)"taskcost_id", (Object)targetcostId);
        recordWrapper.eq((Object)"dr", (Object)0);
        Integer count = this.recordService.count((Wrapper)recordWrapper);
        ProjectTargetcostChangeVO changeVO = (ProjectTargetcostChangeVO)((Object)BeanMapper.map((Object)((Object)targetcostEntity), ProjectTargetcostChangeVO.class));
        Long id = IdWorker.getId();
        changeVO.setTaskcostId(targetcostId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setCodeVersion(targetcostEntity.getBillCode() + "-" + (count + 1));
        changeVO.setBillCode(targetcostEntity.getBillCode());
        changeVO.setId(id);
        if (CollectionUtils.isNotEmpty(targetcostEntity.getProjectTargetcostDetailList())) {
            ArrayList<ProjectTargetcostChangeDetailVO> projectTargetcostChangeDetailList = new ArrayList<ProjectTargetcostChangeDetailVO>();
            HashMap<String, Long> map = new HashMap<String, Long>();
            for (ProjectTargetcostDetailEntity detail : targetcostEntity.getProjectTargetcostDetailList()) {
                ProjectTargetcostChangeDetailVO d = new ProjectTargetcostChangeDetailVO();
                d.setFeeType(detail.getFeeType());
                d.setRespcostDetailId(detail.getRespcostDetailId());
                d.setTargetcostDetailId(detail.getId());
                d.setRowState("add");
                d.setId(IdWorker.getId());
                d.setSubjectId(detail.getSubjectId());
                d.setSubjectCode(detail.getSubjectCode());
                d.setSubjectName(detail.getSubjectName());
                d.setFeeType(detail.getFeeType());
                d.setAmount(detail.getAmount());
                d.setCostAmount(detail.getCostAmount());
                d.setCode(detail.getCode());
                d.setAddState(detail.getAddState());
                d.setRemark(detail.getRemark());
                map.put(detail.getCode(), d.getId());
                projectTargetcostChangeDetailList.add(d);
            }
            projectTargetcostChangeDetailList.forEach(item -> {
                if (item.getCode().indexOf(".") != -1) {
                    String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
                    item.setPid((Long)map.get(code));
                }
            });
            ProjectTargetcostChangeServiceImpl.sortIntMethod(projectTargetcostChangeDetailList);
            List<ProjectTargetcostChangeDetailVO> detailVOS = ProjectTargetcostChangeServiceImpl.createTreeData(projectTargetcostChangeDetailList);
            changeVO.setProjectTargetcostChangeDetailList(detailVOS);
        }
        return CommonResponse.success((Object)((Object)changeVO));
    }

    private static void sortIntMethod(List<ProjectTargetcostChangeDetailVO> list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] strs2;
                ObjectMapper objectMapper = new ObjectMapper();
                ProjectTargetcostChangeDetailVO o1Detail = (ProjectTargetcostChangeDetailVO)((Object)objectMapper.convertValue(o1, ProjectTargetcostChangeDetailVO.class));
                ProjectTargetcostChangeDetailVO o2Detail = (ProjectTargetcostChangeDetailVO)((Object)objectMapper.convertValue(o2, ProjectTargetcostChangeDetailVO.class));
                String[] strs1 = o1Detail.getCode().split("\\.");
                int length = strs1.length > (strs2 = o2Detail.getCode().split("\\.")).length ? strs1.length : strs2.length;
                for (int i = 0; i < length; ++i) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (num1 < num2) {
                        return -1;
                    }
                    if (num1 <= num2) continue;
                    return 1;
                }
                return 0;
            }
        });
    }

    public static List<ProjectTargetcostChangeDetailVO> createTreeData(List<ProjectTargetcostChangeDetailVO> list) {
        ArrayList<ProjectTargetcostChangeDetailVO> resp = new ArrayList<ProjectTargetcostChangeDetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, ProjectTargetcostChangeDetailVO> listMap = new HashMap<String, ProjectTargetcostChangeDetailVO>();
        for (ProjectTargetcostChangeDetailVO item : list) {
            listMap.put(item.getId().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            ProjectTargetcostChangeDetailVO item;
            item = list.get(i);
            String parentId = item.getPid() != null ? item.getPid().toString() : "";
            ProjectTargetcostChangeDetailVO parent = (ProjectTargetcostChangeDetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<ProjectTargetcostChangeDetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<ProjectTargetcostChangeDetailVO> children = new ArrayList<ProjectTargetcostChangeDetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((ProjectTargetcostChangeDetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }
}

