/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.business.material.utlis.ArchivesUtil;
import com.ejianc.business.material.vo.ContractExportVO;
import com.ejianc.business.material.vo.MaterialContractDetailSubVO;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/materialContract/"})
public class MaterialContractController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static volatile HttpServletRequest request;
    @Autowired
    private IMaterialContractService materialContractService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi iProjectApi;
    @Autowired
    private IPurchaseSettlementService purchaseSettlementService;
    @Value(value="${common.env.base-host}")
    public String BASE_HOST;
    private final String DEFAULT_RULE_CODE = "zydx_materialContract";
    @Autowired
    private ArchivesUtil archivesUtil;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Resource
    private IMaterialApi materialApi;
    @Autowired
    private IBillTypeApi billTypeApi;

    @PostMapping(value={"checkParams/{isJc}"})
    public CommonResponse<ParamsCheckVO> checkParams(@PathVariable(name="isJc") Integer isJc, @RequestBody MaterialPriceVO vo) {
        ParamsCheckVO paramsCheckVO = this.materialContractService.checkParams(isJc, vo.getContractId(), vo);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @PostMapping(value={"queryPrice/{isJc}"})
    public CommonResponse<List<MaterialPriceVO>> queryPrice(@PathVariable(name="isJc") Integer isJc, @RequestBody MaterialPriceVO vo) {
        this.materialContractService.queryPrice(isJc, null, vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vo.getDetail());
    }

    @PostMapping(value={"pageList"})
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        JSONObject resp = new JSONObject();
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("supplierName");
        queryParam.getFuzzyFields().add("orgName");
        queryParam.getFuzzyFields().add("projectCode");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("contractorEnterpriseName");
        queryParam.getFuzzyFields().add("createUserName");
        queryParam.getFuzzyFields().add("amountWithTax");
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getComplexParams().add(this.getPageQueryParam(null));
        IPage pageData = this.materialContractService.queryPage(queryParam, false);
        Map<String, Object> contractAmountMap = this.materialContractService.countContractAmount(queryParam);
        resp.put("records", (Object)pageData.getRecords());
        resp.put("total", (Object)pageData.getTotal());
        resp.put("size", (Object)pageData.getSize());
        resp.put("current", (Object)pageData.getCurrent());
        resp.put("pages", (Object)pageData.getPages());
        resp.put("materialCount", contractAmountMap);
        return CommonResponse.success((String)"\u5408\u540c\u5206\u9875\u5217\u8868\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    public ComplexParam getPageQueryParam(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(orgId);
        CommonResponse parentOrgResp = this.orgApi.findParentsByOrgId(orgId);
        if (!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("\u5408\u540c\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList parentOrgIds = new ArrayList();
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentOrgIds.addAll(((List)parentOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentOrgIds.remove(orgId);
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("org_id", new Parameter("in", childIds));
        c1.getComplexParams().add(c2);
        if (CollectionUtils.isNotEmpty(parentOrgIds)) {
            ComplexParam c3 = new ComplexParam();
            c3.setLogic("or");
            c3.getParams().put("depend_on_project", new Parameter("eq", (Object)"0"));
            c3.getParams().put("org_id", new Parameter("in", parentOrgIds));
            c1.getComplexParams().add(c3);
            c3.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        }
        return c1;
    }

    @PostMapping(value={"saveOrUpdate"})
    public CommonResponse<MaterialContractVO> save(@RequestBody MaterialContractVO materialContractVO) {
        boolean checkResult;
        if (StringUtils.isBlank((CharSequence)materialContractVO.getCode())) {
            materialContractVO.setCode(this.getAutoCode());
        }
        if (!(checkResult = this.materialContractService.codeCheck(materialContractVO.getId(), materialContractVO.getCode()))) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5408\u540c\u7f16\u7801\u91cd\u590d");
        }
        List<MaterialContractDetailSubVO> materialDetailList = materialContractVO.getMaterialDetailList();
        if (CollectionUtils.isNotEmpty(materialDetailList)) {
            String materialTypeNames = "";
            HashSet<String> materialTypeNamesSet = new HashSet<String>();
            for (MaterialContractDetailSubVO materialContractDetailSubVO2 : materialDetailList) {
                String onlykey = materialContractDetailSubVO2.getMaterialTypeName() + materialContractDetailSubVO2.getMaterialName() + materialContractDetailSubVO2.getMeasureUnit() + materialContractDetailSubVO2.getSpec() + materialContractDetailSubVO2.getMaterialCode();
                materialContractDetailSubVO2.setOnlyKey(onlykey);
                if ("del".equals(materialContractDetailSubVO2.getRowState())) continue;
                if (StringUtils.isNotBlank((CharSequence)materialTypeNames)) {
                    if (materialTypeNamesSet.contains(materialContractDetailSubVO2.getMaterialTypeName())) continue;
                    materialTypeNames = materialTypeNames + "\u3001" + materialContractDetailSubVO2.getMaterialTypeName();
                    materialTypeNamesSet.add(materialContractDetailSubVO2.getMaterialTypeName());
                    continue;
                }
                materialTypeNames = materialTypeNames + materialContractDetailSubVO2.getMaterialTypeName();
                materialTypeNamesSet.add(materialContractDetailSubVO2.getMaterialTypeName());
            }
            materialContractVO.setMaterialTypeNames(materialTypeNames);
            JSONObject jsonObject = this.archivesUtil.batchSaveArchive(materialDetailList, "materialTypeId", "materialId", "materialTypeName", "materialName", "materialCode", "measureUnit", "spec", "errorMessage");
            String sourceList = JSON.toJSONString((Object)jsonObject.get((Object)"sourceList"), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat});
            List list = JSONObject.parseArray((String)sourceList, MaterialContractDetailSubVO.class);
            materialContractVO.setMaterialDetailList(list);
            List sourceIds = list.stream().map(materialContractDetailSubVO -> Long.parseLong(materialContractDetailSubVO.getMaterialId())).collect(Collectors.toList());
            List partition = Lists.partition(sourceIds, (int)300);
            ArrayList materialList = new ArrayList();
            for (int i = 0; i < partition.size(); ++i) {
                CommonResponse r = this.materialApi.queryMaterialByIds((List)partition.get(i));
                if (!r.isSuccess()) {
                    throw new BusinessException("\u4fdd\u5b58\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2\u7269\u8d44\u6863\u6848\u5931\u8d25\uff01");
                }
                materialList.addAll((Collection)r.getData());
            }
            Map materialMap = materialList.stream().collect(Collectors.toMap(MaterialVO::getId, Function.identity(), (key1, key2) -> key2));
            for (MaterialContractDetailSubVO detailSubVO : materialContractVO.getMaterialDetailList()) {
                if (!materialMap.containsKey(Long.parseLong(detailSubVO.getMaterialId()))) continue;
                MaterialVO vo = (MaterialVO)materialMap.get(Long.parseLong(detailSubVO.getMaterialId()));
                String assistUnitName = vo.getAssistUnitName();
                BigDecimal unitAssistUnit = vo.getUnitAssistUnit();
                if (!StringUtils.isNotBlank((CharSequence)assistUnitName) || unitAssistUnit == null) continue;
                detailSubVO.setAssistUnitName(assistUnitName);
                detailSubVO.setUnitAssistUnit(unitAssistUnit);
                detailSubVO.setNumAssistUnit(NumberUtil.mul((Number)detailSubVO.getCount(), (Number)unitAssistUnit));
                detailSubVO.setPriceAssistUnit(NumberUtil.div((BigDecimal)detailSubVO.getTotalAmount(), (BigDecimal)detailSubVO.getNumAssistUnit(), (int)4, (RoundingMode)RoundingMode.HALF_UP));
            }
        }
        MaterialContractVO resp = this.materialContractService.save(materialContractVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)((Object)resp));
    }

    private String getAutoCode() {
        String code = null;
        while (StringUtils.isBlank(code)) {
            CommonResponse resp = this.billCodeApi.getCodeBatchByRuleCode("zydx_materialContract", InvocationInfoProxy.getTenantid());
            if (!resp.isSuccess()) {
                throw new BusinessException("\u4fdd\u5b58\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u7f16\u7801\u5931\u8d25\uff01");
            }
            code = (String)resp.getData();
        }
        return code;
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("supplierName");
        queryParam.getFuzzyFields().add("orgName");
        queryParam.getFuzzyFields().add("projectCode");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("contractorEnterpriseName");
        queryParam.getFuzzyFields().add("createUserName");
        queryParam.getFuzzyFields().add("amountWithTax");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(-1);
        queryParam.getComplexParams().add(this.getPageQueryParam(null));
        IPage pageData = this.materialContractService.queryPage(queryParam, false);
        HashMap beans = new HashMap();
        ArrayList list = new ArrayList();
        List data = pageData.getRecords();
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            data.forEach(contract -> {
                ContractExportVO vo = (ContractExportVO)BeanMapper.map((Object)contract, ContractExportVO.class);
                vo.setCreateTime(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)contract.getCreateTime()));
                vo.setSignDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)contract.getSignDate()));
                vo.setChangeStateName(contract.getChangeState().equals(MaterialContractVO.CONTRACT_CHANGE_STATE_UNCHANGED) ? "\u672a\u53d8\u66f4" : (contract.getChangeState().equals(MaterialContractVO.CONTRACT_CHANGE_STATE_CHANGING) ? "\u53d8\u66f4\u4e2d" : "\u5df2\u53d8\u66f4"));
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)contract.getBillState()).getDescription());
                list.add(vo);
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("contract-export.xlsx", beans, response);
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> delete(@RequestBody List<MaterialContractVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(BaseEntity::getId, ids);
            queryWrapper.isNotNull(MaterialContractEntity::getEnquiryPriceBillId);
            List materialContractEntities = this.materialContractService.list((Wrapper)queryWrapper);
            boolean b = this.materialContractService.removeByIds(ids, false);
            if (b && CollectionUtils.isNotEmpty((Collection)materialContractEntities)) {
                List<Long> enquiryPriceBillIds = materialContractEntities.stream().map(MaterialContractEntity::getEnquiryPriceBillId).collect(Collectors.toList());
                this.materialContractService.countContractNumAndMnyByEnquiry(enquiryPriceBillIds.toArray(new Long[enquiryPriceBillIds.size()]));
            }
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @GetMapping(value={"queryDetail"})
    public CommonResponse<MaterialContractVO> queryDetail(@RequestParam(value="id") Long id) {
        MaterialContractVO vo = null;
        MaterialContractEntity dbEntity = (MaterialContractEntity)((Object)this.materialContractService.selectById(id));
        if (null != dbEntity) {
            vo = (MaterialContractVO)((Object)BeanMapper.map((Object)((Object)dbEntity), MaterialContractVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u7269\u8d44\u5408\u540c\u8be6\u60c5\u6210\u529f\uff01", vo);
    }

    @GetMapping(value={"queryDetailAndPrice"})
    public CommonResponse<MaterialContractVO> queryDetailAndPrice(@RequestParam(value="id") Long id) {
        MaterialContractVO vo = null;
        MaterialContractEntity dbEntity = (MaterialContractEntity)((Object)this.materialContractService.selectById(id));
        if (null != dbEntity) {
            vo = (MaterialContractVO)((Object)BeanMapper.map((Object)((Object)dbEntity), MaterialContractVO.class));
        }
        vo.setId(IdWorker.getId());
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id), "BT200608000000001", "materialContractBill", String.valueOf(vo.getId()), "BT200613000000001", "materialContractChange");
        return CommonResponse.success((String)"\u67e5\u8be2\u7269\u8d44\u5408\u540c\u8be6\u60c5\u6210\u529f\uff01", (Object)((Object)vo));
    }

    private void queryMaterialPrice(MaterialContractVO vo) {
        List<MaterialContractDetailSubVO> materialDetailList = vo.getMaterialDetailList();
        if (CollectionUtils.isNotEmpty(materialDetailList)) {
            MaterialPriceVO priceVO = new MaterialPriceVO(vo.getProjectId());
            ArrayList<MaterialPriceVO> detail = new ArrayList<MaterialPriceVO>();
            materialDetailList.forEach(item -> {
                if (StringUtils.isNotEmpty((CharSequence)item.getMaterialId())) {
                    MaterialPriceVO materialPriceVO = new MaterialPriceVO();
                    materialPriceVO.setMaterialId(Long.valueOf(item.getMaterialId()));
                    detail.add(materialPriceVO);
                }
            });
            priceVO.setDetail(detail);
            Integer isJc = "1".equals(vo.getPurchaseMode()) ? 1 : 0;
            MaterialPriceVO materialPriceVO = this.materialContractService.queryPrice(isJc, vo.getId(), priceVO);
            List<MaterialPriceVO> dd = materialPriceVO.getDetail();
            if (CollectionUtils.isNotEmpty(dd)) {
                Map<Long, MaterialPriceVO> priceVOMap = dd.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                for (MaterialContractDetailSubVO v : materialDetailList) {
                    MaterialPriceVO p;
                    String materialId = v.getMaterialId();
                    if (StringUtils.isEmpty((CharSequence)materialId) || null == (p = priceVOMap.get(Long.valueOf(materialId)))) continue;
                    v.setPlanNum(p.getPlanNum());
                    v.setPlanPrice(p.getPlanPrice());
                    v.setMinPrice(p.getMinPrice());
                    v.setMaxPrice(p.getMaxPrice());
                    v.setPriceArea(p.getPriceArea());
                }
            }
        }
    }

    @GetMapping(value={"contractListRefer"})
    public CommonResponse<IPage<MaterialContractEntity>> contractListRefer(@RequestParam(required=false) String condition, @RequestParam(required=false) String searchText, @RequestParam int pageSize, @RequestParam int pageNumber, @RequestParam(required=false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("supplier_name");
        queryParam.getFuzzyFields().add("material_type_names");
        queryParam.getOrderMap().put("effective_date", "desc");
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter("in", billStateList));
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            queryParam.setSearchText(searchText);
        }
        Long orgId = InvocationInfoProxy.getOrgId();
        queryParam.getParams().put("state", new Parameter("ne", (Object)3));
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("type") && "pay".equals(conditionMap.get("type").toString())) {
                queryParam.getParams().remove("state");
            }
            if (null != conditionMap.get("mobileLeave")) {
                if (null != conditionMap.get("orgId")) {
                    orgId = Long.valueOf(conditionMap.get("orgId").toString());
                    queryParam.getComplexParams().add(this.getPageQueryParam(orgId));
                }
                if (null != conditionMap.get("dependOnProject")) {
                    Integer dependOnProject = Integer.valueOf(conditionMap.get("dependOnProject").toString());
                    queryParam.getParams().put("dependOnProject", new Parameter("eq", (Object)dependOnProject));
                }
            } else {
                if (null != conditionMap.get("orgId")) {
                    orgId = Long.valueOf(conditionMap.get("orgId").toString());
                }
                if (conditionMap.containsKey("isJc") && conditionMap.get("isJc").equals("1")) {
                    queryParam.getParams().put("purchase_mode", new Parameter("eq", (Object)"1"));
                }
                if (null != conditionMap.get("supplierId")) {
                    queryParam.getParams().put("supplier_id", new Parameter("eq", (Object)Long.valueOf(conditionMap.get("supplierId").toString())));
                }
                if (StringUtils.isNotBlank((CharSequence)searchObject)) {
                    JSONObject search = JSONObject.parseObject((String)searchObject);
                    for (String key : search.keySet()) {
                        queryParam.getParams().put(key, new Parameter("like", (Object)search.get((Object)key).toString()));
                    }
                }
                queryParam.getComplexParams().add(this.getPageQueryParam(orgId));
            }
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                ComplexParam in = new ComplexParam();
                in.setLogic("and");
                ComplexParam c = new ComplexParam();
                c.setLogic("and");
                c.getParams().put("projectId", new Parameter("eq", (Object)projectId));
                ComplexParam p = new ComplexParam();
                p.setLogic("or");
                Long orgId1 = InvocationInfoProxy.getOrgId();
                List collect = ((List)this.orgApi.findParentsByOrgId(orgId1).getData()).stream().map(e -> e.getId()).collect(Collectors.toList());
                p.getParams().put("orgId", new Parameter("in", collect));
                ComplexParam t2 = new ComplexParam();
                t2.setLogic("and");
                t2.getParams().put("purchaseMode", new Parameter("eq", (Object)1));
                in.getComplexParams().add(c);
                in.getComplexParams().add(p);
                in.getComplexParams().add(t2);
                queryParam.getComplexParams().add(in);
            } else {
                queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)searchObject)) {
                JSONObject search = JSONObject.parseObject((String)searchObject);
                for (String key : search.keySet()) {
                    queryParam.getParams().put(key, new Parameter("like", (Object)search.get((Object)key).toString()));
                }
            }
            queryParam.getComplexParams().add(this.getPageQueryParam(orgId));
        }
        IPage pageData = this.materialContractService.queryPage(queryParam, false);
        for (MaterialContractEntity materialContractEntity : pageData.getRecords()) {
            materialContractEntity.setContractNameExtend(materialContractEntity.getCode() + "-" + materialContractEntity.getName() + "-" + materialContractEntity.getSupplierName() + "-" + ComputeUtil.scale((BigDecimal)materialContractEntity.getAmountWithTax(), (int)2));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5408\u540c\u5217\u8868\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"contractListReferPost"})
    @ResponseBody
    public CommonResponse<IPage<MaterialContractEntity>> contractListReferPost(@RequestBody QueryParam queryParam) {
        this.logger.info("POST \u65b9\u5f0f\u67e5\u8be2\u5408\u540c\u53c2\u7167\uff0c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)queryParam));
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("supplier_name");
        queryParam.getFuzzyFields().add("material_type_names");
        queryParam.getOrderMap().put("effective_date", "desc");
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter("in", billStateList));
        Long orgId = InvocationInfoProxy.getOrgId();
        queryParam.getParams().put("state", new Parameter("ne", (Object)3));
        if (StringUtils.isNotBlank((CharSequence)queryParam.getCondition())) {
            Map conditionMap = (Map)JSONObject.parseObject((String)queryParam.getCondition(), Map.class);
            if (null != conditionMap.get("type") && "pay".equals(conditionMap.get("type").toString())) {
                queryParam.getParams().remove("state");
            }
            if (null != conditionMap.get("mobileLeave")) {
                if (null != conditionMap.get("orgId")) {
                    orgId = Long.valueOf(conditionMap.get("orgId").toString());
                    queryParam.getComplexParams().add(this.getPageQueryParam(orgId));
                }
                if (null != conditionMap.get("dependOnProject")) {
                    Integer dependOnProject = Integer.valueOf(conditionMap.get("dependOnProject").toString());
                    queryParam.getParams().put("dependOnProject", new Parameter("eq", (Object)dependOnProject));
                }
            } else {
                if (null != conditionMap.get("orgId")) {
                    orgId = Long.valueOf(conditionMap.get("orgId").toString());
                }
                if (conditionMap.containsKey("isJc") && conditionMap.get("isJc").equals("1")) {
                    queryParam.getParams().put("purchase_mode", new Parameter("eq", (Object)"1"));
                }
                if (null != conditionMap.get("supplierId")) {
                    queryParam.getParams().put("supplier_id", new Parameter("eq", (Object)Long.valueOf(conditionMap.get("supplierId").toString())));
                }
                queryParam.getComplexParams().add(this.getPageQueryParam(orgId));
            }
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                ComplexParam in = new ComplexParam();
                in.setLogic("and");
                ComplexParam c = new ComplexParam();
                c.setLogic("and");
                c.getParams().put("projectId", new Parameter("eq", (Object)projectId));
                ComplexParam p = new ComplexParam();
                p.setLogic("or");
                Long orgId1 = InvocationInfoProxy.getOrgId();
                List collect = ((List)this.orgApi.findParentsByOrgId(orgId1).getData()).stream().map(e -> e.getId()).collect(Collectors.toList());
                p.getParams().put("orgId", new Parameter("in", collect));
                ComplexParam t2 = new ComplexParam();
                t2.setLogic("and");
                t2.getParams().put("purchaseMode", new Parameter("eq", (Object)1));
                in.getComplexParams().add(c);
                in.getComplexParams().add(p);
                in.getComplexParams().add(t2);
                queryParam.getComplexParams().add(in);
            } else {
                queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            }
        } else {
            queryParam.getComplexParams().add(this.getPageQueryParam(orgId));
        }
        IPage pageData = this.materialContractService.queryPage(queryParam, false);
        for (MaterialContractEntity materialContractEntity : pageData.getRecords()) {
            materialContractEntity.setContractNameExtend(materialContractEntity.getCode() + "-" + materialContractEntity.getName() + "-" + materialContractEntity.getSupplierName() + "-" + ComputeUtil.scale((BigDecimal)materialContractEntity.getAmountWithTax(), (int)2));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5408\u540c\u5217\u8868\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"changeState"})
    public CommonResponse<String> changeState(@RequestBody MaterialContractVO materialContractVO) {
        MaterialContractEntity contract = (MaterialContractEntity)((Object)this.materialContractService.selectById(materialContractVO.getId()));
        contract.setState(materialContractVO.getState());
        contract.setStateName(materialContractVO.getStateName());
        this.materialContractService.saveOrUpdate((Object)contract, false);
        return CommonResponse.success((String)"\u4fee\u6539\u5408\u540c\u72b6\u6001\u6210\u529f\uff01");
    }

    @PostMapping(value={"codeCheck"})
    public CommonResponse<String> checkContractCode(@RequestBody MaterialContractVO contract) {
        boolean result = this.materialContractService.codeCheck(contract.getId(), contract.getCode());
        if (!result) {
            return CommonResponse.error((String)"\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        return CommonResponse.success((String)"\u7f16\u7801\u53ef\u4ee5\u4f7f\u7528\uff01");
    }

    private BigDecimal getTotalSettleAmount(Long contractId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        MaterialContractEntity contract = (MaterialContractEntity)((Object)this.materialContractService.selectById(contractId));
        if (!"1".equals(contract.getDependOnProject())) {
            Long orgId = InvocationInfoProxy.getOrgId();
            CommonResponse orgResp = this.orgApi.findChildrenByParentId(orgId);
            if (!orgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u5408\u540c\u6536\u7968\u8bb0\u5f55\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u4fe1\u606f\u5931\u8d25\uff01");
            }
            List orgIds = ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            queryParam.getParams().put("orgId", new Parameter("in", orgIds));
        }
        return this.purchaseSettlementService.calculateTotalSettlement(queryParam);
    }

    @GetMapping(value={"getOutContractTotalAmount"})
    public CommonResponse<JSONObject> getOutContractTotalAmount(@RequestParam Integer type, @RequestParam(required=false) Long engineeringType, HttpServletRequest req) {
        CommonResponse commonResponse;
        request = req;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        List<Object> orgIds = new ArrayList();
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            orgIds = ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        } else {
            orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        List projectIds = new ArrayList();
        if (null != type && (commonResponse = this.iProjectApi.getProjectIdsByEngineeringType(type.intValue(), null == engineeringType ? null : engineeringType)).isSuccess()) {
            projectIds = (List)commonResponse.getData();
            if (ListUtil.isNotEmpty(projectIds)) {
                queryParam.getParams().put("projectId", new Parameter("in", projectIds));
            } else {
                JSONObject back = new JSONObject();
                back.put("contract", (Object)"0.00");
                back.put("settle", (Object)"0.00");
                back.put("invoiceTaxMny", (Object)"0.00");
                back.put("payApplyAmount", (Object)"0.00");
                return CommonResponse.success((Object)back);
            }
        }
        queryParam.getParams().put("org_id", new Parameter("in", orgIds));
        List contractEntities = this.materialContractService.queryList(queryParam, false);
        queryParam.getParams().remove("dependOnProject");
        queryParam.getParams().put("belongToProject", new Parameter("eq", (Object)"1"));
        List settlementEntities = this.purchaseSettlementService.queryList(queryParam, false);
        BigDecimal contract = new BigDecimal("0.00");
        BigDecimal settle = new BigDecimal("0.00");
        BigDecimal invoiceTaxMny = new BigDecimal("0.00");
        BigDecimal payApplyAmount = new BigDecimal("0.00");
        if (ListUtil.isNotEmpty((List)contractEntities)) {
            for (BaseEntity c : contractEntities) {
                contract = ComputeUtil.safeAdd((BigDecimal)contract, (BigDecimal)c.getAmountWithTax());
            }
        }
        if (ListUtil.isNotEmpty((List)settlementEntities)) {
            for (BaseEntity c : settlementEntities) {
                settle = ComputeUtil.safeAdd((BigDecimal)settle, (BigDecimal)c.getCurrentSettlementAmountTax());
            }
        }
        queryParam.getParams().remove("belongToProject");
        JSONObject back = this.getOtherContractAmount(projectIds);
        contract = contract.add(back.getBigDecimal("contract")).divide(new BigDecimal("10000")).setScale(2, 4);
        settle = settle.add(back.getBigDecimal("settle")).divide(new BigDecimal("10000")).setScale(2, 4);
        invoiceTaxMny = invoiceTaxMny.add(back.getBigDecimal("invoiceTaxMny")).divide(new BigDecimal("10000")).setScale(2, 4);
        payApplyAmount = payApplyAmount.add(back.getBigDecimal("payApplyAmount")).divide(new BigDecimal("10000")).setScale(2, 4);
        back = new JSONObject();
        back.put("contract", (Object)contract);
        back.put("settle", (Object)settle);
        back.put("invoiceTaxMny", (Object)invoiceTaxMny);
        back.put("payApplyAmount", (Object)payApplyAmount);
        return CommonResponse.success((Object)back);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject getOtherContractAmount(List<Long> projectIds) {
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        BigDecimal contract = new BigDecimal("0.00");
        BigDecimal settle = new BigDecimal("0.00");
        BigDecimal invoiceTaxMny = new BigDecimal("0.00");
        BigDecimal payApplyAmount = new BigDecimal("0.00");
        PostDataCallable equipmentContractAmountNum = new PostDataCallable(this.BASE_HOST + "ejc-equipment-web/purchaseContract/getEquipmentContractTotalAmount", projectIds);
        Future<JSONObject> future1 = threadPool.submit(equipmentContractAmountNum);
        PostDataCallable subContractAmountNum = new PostDataCallable(this.BASE_HOST + "ejc-sub-web/contract/getSubContractTotalAmount", projectIds);
        Future<JSONObject> future2 = threadPool.submit(subContractAmountNum);
        PostDataCallable tax = new PostDataCallable(this.BASE_HOST + "ejc-tax-web/invoiceReceive/getTotalInvoiceTaxMnyByProjectIds", projectIds);
        Future<JSONObject> future3 = threadPool.submit(tax);
        PostDataCallable finance = new PostDataCallable(this.BASE_HOST + "ejc-finance-web/payContract/getTotalPayApplyAmountByProjectIds", projectIds);
        Future<JSONObject> future4 = threadPool.submit(finance);
        try {
            JSONObject c4;
            JSONObject c3;
            JSONObject c1 = future1.get();
            if (c1.getInteger("code") == 0) {
                JSONObject data = c1.getJSONObject("data");
                contract = contract.add(data.getBigDecimal("contract"));
                settle = settle.add(data.getBigDecimal("settle"));
            }
            JSONObject c2 = future2.get();
            if (c1.getInteger("code") == 0) {
                JSONObject data = c2.getJSONObject("data");
                contract = contract.add(data.getBigDecimal("contract"));
                settle = settle.add(data.getBigDecimal("settle"));
            }
            if ((c3 = future3.get()).getInteger("code") == 0) {
                JSONObject data = c3.getJSONObject("data");
                invoiceTaxMny = invoiceTaxMny.add(data.getBigDecimal("invoiceTaxMny"));
            }
            if ((c4 = future4.get()).getInteger("code") == 0) {
                JSONObject data = c4.getJSONObject("data");
                payApplyAmount = payApplyAmount.add(data.getBigDecimal("payApplyAmount"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            threadPool.shutdown();
        }
        JSONObject back = new JSONObject();
        back.put("contract", (Object)contract);
        back.put("settle", (Object)settle);
        back.put("invoiceTaxMny", (Object)invoiceTaxMny);
        back.put("payApplyAmount", (Object)payApplyAmount);
        return back;
    }

    @PostMapping(value={"analysisContract"})
    public CommonResponse<BigDecimal> analysisContract(@RequestBody Map<String, Object> param) {
        Map<String, Object> result;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("dr", new Parameter("eq", (Object)BaseVO.DR_UNDELETE));
        queryParam.getParams().put("dependOnProject", new Parameter("eq", (Object)1));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        if (null != param && null != param.get("projectIds") && CollectionUtils.isNotEmpty((Collection)((List)param.get("projectIds")))) {
            queryParam.getParams().put("projectId", new Parameter("in", param.get("projectIds")));
        }
        List<Object> orgIds = new ArrayList();
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            orgIds = ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        } else {
            orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(orgIds)) {
            queryParam.getParams().put("orgId", new Parameter("in", orgIds));
        }
        String dataStr = null != (result = this.materialContractService.countContractAmount(queryParam)).get("curAmount") ? result.get("curAmount").toString() : "0";
        BigDecimal total = new BigDecimal(dataStr);
        return CommonResponse.success((Object)total.divide(new BigDecimal(10000), 2, 4));
    }

    @RequestMapping(value={"getMaterialDetailQueryParam"}, method={RequestMethod.GET})
    public CommonResponse<QueryParam> getMaterialDetailQueryParam() {
        try {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            queryParam.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            String orgType = InvocationInfoProxy.getOrgType();
            if ("5".equals(orgType)) {
                queryParam.getParams().put("dependOnProject", new Parameter("eq", (Object)1));
            }
            return CommonResponse.success((Object)queryParam);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    class PostDataCallable
    implements Callable<JSONObject> {
        private String url;
        private Object data;

        public PostDataCallable(String url, Object data) {
            this.data = data;
            this.url = url;
        }

        @Override
        public JSONObject call() throws Exception {
            System.out.println(InvocationInfoProxy.getTenantid());
            String responseStr = ReferHttpClientUtils.postByJson((String)this.url, (String)JSON.toJSONString((Object)this.data), (HttpServletRequest)request);
            System.out.println(responseStr);
            return JSONObject.parseObject((String)responseStr);
        }
    }
}

