package com.ejianc.business.cost.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.EngdepartRespcostEntity;
import com.ejianc.business.cost.bean.ProjectTargetcostEntity;
import com.ejianc.business.cost.service.IEngdepartRespcostService;
import com.ejianc.business.cost.vo.ProjectImplProtocolDetailVO;
import com.ejianc.business.cost.vo.ProjectTargetcostChangeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.cost.bean.ProjectImplProtocolEntity;
import com.ejianc.business.cost.service.IProjectImplProtocolService;
import com.ejianc.business.cost.vo.ProjectImplProtocolVO;

/**
 * 项目实施协议
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projectImplProtocol")
public class ProjectImplProtocolController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "zydxProjectImplProtocol";//此处需要根据实际修改

    @Autowired
    private IProjectImplProtocolService service;
    @Autowired
    private IEngdepartRespcostService engdepartRespcostService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectImplProtocolVO> saveOrUpdate(@RequestBody ProjectImplProtocolVO saveOrUpdateVO) {
    	ProjectImplProtocolEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectImplProtocolEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if(entity.getProjectImplProtocolDetailList()!=null && entity.getProjectImplProtocolDetailList().size()>0){
            Map<String, Long> map = new HashMap<>();
            entity.getProjectImplProtocolDetailList().forEach(item -> {
                if("add".equals(item.getRowState())){
                    item.setId(IdWorker.getId());
                    item.setPrjimplProtocolId(entity.getId());
                }
                if(!"del".equals(item.getRowState())){
                    map.put(item.getCode(), item.getId());
                }
            });
            entity.getProjectImplProtocolDetailList().forEach(item -> {
                if("add".equals(item.getRowState()) && item.getCode().indexOf(".")!=-1){
                    String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
                    item.setPid(map.get(code));
                }
            });
        }
    	service.saveOrUpdate(entity, false);
    	ProjectImplProtocolVO vo = BeanMapper.map(entity, ProjectImplProtocolVO.class);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(vo.getProjectImplProtocolDetailList())) {
            sortIntMethod(vo.getProjectImplProtocolDetailList());
            List<ProjectImplProtocolDetailVO> detailVOS = createTreeData(vo.getProjectImplProtocolDetailList());
            vo.setProjectImplProtocolDetailList(detailVOS);
        }
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectImplProtocolVO> queryDetail(Long id) {
    	ProjectImplProtocolEntity entity = service.selectById(id);
    	ProjectImplProtocolVO vo = BeanMapper.map(entity, ProjectImplProtocolVO.class);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(vo.getProjectImplProtocolDetailList())) {
            sortIntMethod(vo.getProjectImplProtocolDetailList());
            List<ProjectImplProtocolDetailVO> detailVOS = createTreeData(vo.getProjectImplProtocolDetailList());
            vo.setProjectImplProtocolDetailList(detailVOS);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectImplProtocolVO> vos) {
        service.removeByIds(vos.stream().map(ProjectImplProtocolVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectImplProtocolVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("pubUnitName");
        fuzzyFields.add("contractUnitName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ProjectImplProtocolEntity> page = service.queryPage(param,false);
        IPage<ProjectImplProtocolVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectImplProtocolVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProjectImplProtocolEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectImplProtocol-export.xlsx", beans, response);
    }

    private static void sortIntMethod(List<ProjectImplProtocolDetailVO> list){
        Collections.sort(list, new Comparator(){
            @Override
            public int compare(Object o1, Object o2) {
                ObjectMapper objectMapper = new ObjectMapper();
                ProjectImplProtocolDetailVO o1Detail = objectMapper.convertValue(o1, ProjectImplProtocolDetailVO.class);
                ProjectImplProtocolDetailVO o2Detail = objectMapper.convertValue(o2, ProjectImplProtocolDetailVO.class);
                String[] strs1 = o1Detail.getCode().split("\\.");
                String[] strs2 = o2Detail.getCode().split("\\.");
                int length = strs1.length > strs2.length ? strs1.length : strs2.length;
                for (int i = 0; i < length; i++) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    } catch (Exception e) {

                    }
                    if (num1 < num2)
                        return -1;
                    if (num1 > num2)
                        return 1;
                }
                return 0;
            }
        });
    }

    public static List<ProjectImplProtocolDetailVO> createTreeData(List<ProjectImplProtocolDetailVO> list) {
        List<ProjectImplProtocolDetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ProjectImplProtocolDetailVO> listMap = new HashMap<>();
        for(ProjectImplProtocolDetailVO item:list) {
            listMap.put(item.getId().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            ProjectImplProtocolDetailVO item = list.get(i);
            String parentId = (item.getPid() != null) ? item.getPid().toString():"";
            ProjectImplProtocolDetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<ProjectImplProtocolDetailVO> child = (List<ProjectImplProtocolDetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<ProjectImplProtocolDetailVO> children = new ArrayList<ProjectImplProtocolDetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getId().toString());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refProjectImplProtocolData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectImplProtocolVO>> refProjectImplProtocolData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProjectImplProtocolEntity> page = service.queryPage(param,false);
        IPage<ProjectImplProtocolVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectImplProtocolVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @RequestMapping(value = "/checkBillParam", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONArray> checkBillParam(@RequestBody ProjectImplProtocolVO vo) {
        JSONArray list = new JSONArray();
        QueryWrapper<EngdepartRespcostEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("project_id", vo.getProjectId());
        List<EngdepartRespcostEntity> engdepartList = engdepartRespcostService.list(wrapper);
        EngdepartRespcostEntity engdepartEntity = null;
        if(engdepartList!=null && engdepartList.size()>0){
            engdepartEntity = engdepartList.get(0);
        }else{
            JSONObject item = new JSONObject();
            item.put("type", "alert");
            item.put("warnItem", list.size()+1+"");
            item.put("warnName", "工程部责任成本控项目实施协议");
            item.put("content", "缺少对应项目的工程部责任成本");
            list.add(item);
            return CommonResponse.success(list);
        }
        //责任成本金额＞工程部责任成本成本金额
        if(vo.getWorkloadCost()==null){
            vo.setWorkloadCost(new BigDecimal(0));
        }
        if(engdepartEntity.getRespcostTotal()==null){
            engdepartEntity.setRespcostTotal(new BigDecimal(0));
        }
        if(vo.getWorkloadCost().compareTo(engdepartEntity.getRespcostTotal())>0){
            //小于配置值，提示
            JSONObject item = new JSONObject();
            item.put("type", "P-6659420313");
            item.put("warnItem", list.size()+1+"");
            item.put("warnName", "工程部责任成本项目成本金额控项目实施协议工作量金额");
            item.put("content", "【项目实施协议】工作量金额＞【工程部责任成本】项目成本总额，"+"【项目实施协议】的工作量金额："+vo.getWorkloadCost().setScale(2)+"元，大于【工程部责任成本】的项目成本总额："+engdepartEntity.getRespcostTotal().setScale(2)+"元");
            list.add(item);
        }
        //销售费用＞工程部责任成本销售费用
        if(vo.getPrjsaleCost() == null && engdepartEntity.getPrjsaleCost() !=null ){
            //小于配置值，提示
            JSONObject item = new JSONObject();
            item.put("type", "P-Ql4TY90314");
            item.put("warnItem", list.size()+1+"");
            item.put("warnName", "工程部责任成本销售费用控项目实施协议销售费用");
            item.put("content", "【项目实施协议】销售费用＞【工程部责任成本】销售费用，"+"【项目实施协议】的销售费用：0元，大于【工程部责任成本】的销售费用："+engdepartEntity.getPrjsaleCost().setScale(2)+"元");
            list.add(item);
        }else if(vo.getPrjsaleCost()!=null && engdepartEntity.getPrjsaleCost()!=null && vo.getPrjsaleCost().compareTo(engdepartEntity.getPrjsaleCost())>0){
            //小于配置值，提示
            JSONObject item = new JSONObject();
            item.put("type", "P-Ql4TY90314");
            item.put("warnItem", list.size()+1+"");
            item.put("warnName", "工程部责任成本销售费用控项目实施协议销售费用");
            item.put("content", "【项目实施协议】销售费用＞【工程部责任成本】销售费用，"+"【项目实施协议】的销售费用："+vo.getPrjsaleCost().setScale(2)+"元，大于【工程部责任成本】的销售费用："+engdepartEntity.getPrjsaleCost().setScale(2)+"元");
            list.add(item);
        }

        return CommonResponse.success(list);
    }
}
