package com.ejianc.business.income.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.income.bean.ContractDetailEntity;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.service.IContractDetailService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.vo.ContractDetailRefVo;
import com.ejianc.business.income.vo.ContractDetailVo;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author yuezx
 * @since 2020-05-28
 */
@RestController
@RequestMapping("/contract/detail")
public class ContractDetailController {
    @Autowired
    private IContractDetailService contractDetailService;

    @Autowired
    private IContractService contractService;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "contract-detail-import.xlsx", "合同清单导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return contractDetailService.excelImport(request,response);
    }

    @RequestMapping(value = "/detailRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ContractDetailVo>> detailRef(@RequestParam(value = "contractId")Long contractId) {
        return CommonResponse.success("查询清单参照成功！", contractDetailService.detailRef(contractId));
    }

    /**
     * @Description 参照施工合同物资明细
     */
    @RequestMapping(value = "/refContractMaterialDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractDetailRefVo>> refContractMaterialDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                LambdaQueryWrapper<ContractEntity> wrapper = new LambdaQueryWrapper<>();
                wrapper.eq(ContractEntity::getProjectId, projectId);
                List<ContractEntity> list = contractService.list(wrapper);
                if (CollectionUtils.isNotEmpty(list)) {
                    List<Long> contractIds = list.stream().map(t -> t.getId()).collect(Collectors.toList());
                    param.getParams().put("contractId", new Parameter(QueryParam.IN, contractIds));
                } else {
                    param.getParams().put("contractId", new Parameter(QueryParam.EQ, 1L));
                }
            } else {
                throw new BusinessException("项目id是必传条件！");
            }
        }
        param.getParams().put("materialId", new Parameter(QueryParam.NE, null));
        param.getParams().put("changeType", new Parameter(QueryParam.NE, 5));//中止不显示
        param.getOrderMap().put("detailIndex", QueryParam.ASC);
        IPage<ContractDetailEntity> page = contractDetailService.queryPage(param,false);
        IPage<ContractDetailRefVo> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractDetailRefVo.class));

        return CommonResponse.success("查询参照施工合同物资明细数据成功！",pageData);
    }


}

