package com.ejianc.business.income.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * <p>
 * 产值进度-产值明细
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@TableName("ejc_zypms_income_out_production_detail")
public class OutProductionDetailEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 产值进度主键
     */
    @TableField("production_id")
    private Long productionId;

    /**
     * 清单编号
     */
    @TableField("code")
    private String code;

    /**
     * parent_id
     */
    @TableField("parent_id")
    private Long parentId;

    /**
     * 序号
     */
    @TableField("detail_index")
    private String detailIndex;

    /**
     * 是否末级
     */
    @TableField("leaf_flag")
    private Boolean leafFlag;

    /**
     * 来源主键（合同清单）
     */
    @TableField("contract_detail_id")
    private Long contractDetailId;

    /**
     * 清单名称
     */
    @TableField("name")
    private String name;

    /**
     * 计量单位
     */
    @TableField("unit")
    private String unit;

    /**
     * 工程量
     */
    @TableField("num")
    private BigDecimal num;

    /**
     * 经营中单价
     */
    @TableField("price")
    private BigDecimal price;

    @TableField("contract_price")
    private BigDecimal contractPrice;//外包单价

    /**
     * 本期完成量
     */
    @TableField("finish_num")
    private BigDecimal finishNum;

    /**
     * 本期完成产值
     */
    @TableField("finish_mny")
    private BigDecimal finishMny;

    /**
     * 来源类型，1-合同内，2-合同外
     */
    @TableField("source_type")
    private Integer sourceType;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 累计完成量(不含本期)
     */
    @TableField("sum_finish_num")
    private BigDecimal sumFinishNum;
    /**
     * 累计完成量(含本期)
     */
    @TableField("sum_finish_num_endthis")
    private BigDecimal sumFinishNumEndthis;

    /**
     * 累计完成产值(不含本期)
     */
    @TableField("sum_finish_mny")
    private BigDecimal sumFinishMny;
    /**
     * 累计完成产值(含本期)
     */
    @TableField("sum_finish_mny_endthis")
    private BigDecimal sumFinishMnyEndthis;
    /**
     * 累计完成率
     */
    @TableField("sum_completion_rate")
    private BigDecimal sumCompletionRate;
    /**
     * 本期完成比例
     */
    @TableField("proportion_report")
    private BigDecimal proportionReport;

    @TableField(exist = false)
    private String tid;
    @TableField(exist = false)
    private String tpid;
    @TableField("supplier_id")
    private Long supplierId;

    @TableField("supplier_name")
    private String supplierName;

    public BigDecimal getContractPrice() {
        return contractPrice;
    }

    public void setContractPrice(BigDecimal contractPrice) {
        this.contractPrice = contractPrice;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public Long getProductionId() {
        return productionId;
    }

    public void setProductionId(Long productionId) {
        this.productionId = productionId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getDetailIndex() {
        return detailIndex;
    }

    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUnit() {
        return unit;
    }

    public BigDecimal getProportionReport() {
        return proportionReport;
    }

    public void setProportionReport(BigDecimal proportionReport) {
        this.proportionReport = proportionReport;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getFinishNum() {
        return finishNum;
    }

    public void setFinishNum(BigDecimal finishNum) {
        this.finishNum = finishNum;
    }

    public BigDecimal getFinishMny() {
        return finishMny;
    }

    public void setFinishMny(BigDecimal finishMny) {
        this.finishMny = finishMny;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getSumFinishNum() {
        return sumFinishNum;
    }

    public void setSumFinishNum(BigDecimal sumFinishNum) {
        this.sumFinishNum = sumFinishNum;
    }

    public BigDecimal getSumFinishNumEndthis() {
        return sumFinishNumEndthis;
    }

    public void setSumFinishNumEndthis(BigDecimal sumFinishNumEndthis) {
        this.sumFinishNumEndthis = sumFinishNumEndthis;
    }

    public BigDecimal getSumFinishMny() {
        return sumFinishMny;
    }

    public void setSumFinishMny(BigDecimal sumFinishMny) {
        this.sumFinishMny = sumFinishMny;
    }

    public BigDecimal getSumFinishMnyEndthis() {
        return sumFinishMnyEndthis;
    }

    public void setSumFinishMnyEndthis(BigDecimal sumFinishMnyEndthis) {
        this.sumFinishMnyEndthis = sumFinishMnyEndthis;
    }

    public BigDecimal getSumCompletionRate() {
        return sumCompletionRate;
    }

    public void setSumCompletionRate(BigDecimal sumCompletionRate) {
        this.sumCompletionRate = sumCompletionRate;
    }

    @Override
    public String toString() {
        return "ProductionDetailEntity{" +
                "productionId=" + productionId +
                ", code=" + code +
                ", parentId=" + parentId +
                ", detailIndex=" + detailIndex +
                ", leafFlag=" + leafFlag +
                ", contractDetailId=" + contractDetailId +
                ", name=" + name +
                ", unit=" + unit +
                ", num=" + num +
                ", price=" + price +
                ", finishNum=" + finishNum +
                ", finishMny=" + finishMny +
                ", sourceType=" + sourceType +
                ", memo=" + memo +
                "}";
    }
}
