package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * @Author mrsir_wxp
 * @Date 2020/6/10 采购询比价主表
 * @Description ComparePriceEntity
 */

@TableName("ejc_material_compare_price")
public class ComparePriceEntity extends BaseEntity {
    /**
     * 单据状态
     */
    @TableField(value = "bill_state")
    private Integer billState;

    /**
     * 询比价单号
     */
    @TableField(value = "bill_code")
    private String billCode;

    /**
     * 属于项目 ？ 0是，1不是
     */
    @TableField(value = "belong_to_project")
    private Integer belongToProject;

    /**
     * 项目名称
     */
    @TableField(value = "project_name")
    private String projectName;

    /**
     * 项目名称参照
     */
    @TableField(value = "project_id")
    private Long projectId;

    /**
     * 所属组织名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 所属组织参照
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 询价单名称
     */
    @TableField(value = "name")
    private String name;

    /**
     * 材料类别名称
     */
    @TableField(value = "material_type_name")
    private String materialTypeName;

    /**
     * 材料类别id
     */
    @TableField(value = "material_type_id")
    private Long materialTypeId;

    /**
     * 询价人
     */
    @TableField(value = "inquiry_person")
    private String inquiryPerson;

    /**
     * 询价时间
     */
    @TableField(value = "inquiry_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date inquiryDate;

    /**
     * 备注
     */
    @TableField(value = "memo")
    private String memo;

    /**
     * 推荐供应商id
     */
    @TableField(value = "recommend_supplier")
    private String recommendSupplier;

    /**
     * 推荐供应商
     */
    @TableField(value = "recommend_supplier_name")
    private String recommendSupplierName;

    /**
     * 供应商价格
     */
    @TableField(value = "recommend_price")
    private BigDecimal recommendPrice;

    @TableField(exist = false)
    @SubEntity(serviceName = "comparePriceSubService")
    private List<ComparePriceSubEntity> priceSubEntities = new ArrayList<>();

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBelongToProject() {
        return belongToProject;
    }

    public void setBelongToProject(Integer belongToProject) {
        this.belongToProject = belongToProject;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getInquiryPerson() {
        return inquiryPerson;
    }

    public void setInquiryPerson(String inquiryPerson) {
        this.inquiryPerson = inquiryPerson;
    }

    public Date getInquiryDate() {
        return inquiryDate;
    }

    public void setInquiryDate(Date inquiryDate) {
        this.inquiryDate = inquiryDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getRecommendSupplier() {
        return recommendSupplier;
    }

    public void setRecommendSupplier(String recommendSupplier) {
        this.recommendSupplier = recommendSupplier;
    }

    public String getRecommendSupplierName() {
        return recommendSupplierName;
    }

    public void setRecommendSupplierName(String recommendSupplierName) {
        this.recommendSupplierName = recommendSupplierName;
    }

    public BigDecimal getRecommendPrice() {
        return recommendPrice;
    }

    public void setRecommendPrice(BigDecimal recommendPrice) {
        this.recommendPrice = recommendPrice;
    }

    public List<ComparePriceSubEntity> getPriceSubEntities() {
        return priceSubEntities;
    }

    public void setPriceSubEntities(List<ComparePriceSubEntity> priceSubEntities) {
        this.priceSubEntities = priceSubEntities;
    }
}
