package com.ejianc.business.other.api;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.OtherSettleEntity;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.IOtherSettleService;
import com.ejianc.business.other.utils.ComputeUtil;
import com.ejianc.business.other.vo.ContractResVO;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.business.other.vo.OtherProjectReportVo;
import com.ejianc.business.other.vo.OtherSettleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.foundation.support.api.ICustomerApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/other/")
public class OtherContractApi {

    @Autowired
    private IOtherContractService otherContractService;

    @Autowired
    private IOtherSettleService otherSettleService;

    @Autowired
    private ISupplierApi supplierApi;

    @Autowired
    private ICustomerApi customerApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi orgApi;

    /**
     * 租赁合同跳转收票, 根据主键查询合同相关信息
     *
     * @param contractId
     * @return
     */
    @GetMapping(value = "/getOtherContractById")
    public CommonResponse<ContractResVO> getOtherContractById(@RequestParam("contractId") Long contractId) {
        OtherContractEntity otherContractEntity = otherContractService.selectById(contractId);
        ContractResVO otherContractVO = BeanMapper.map(otherContractEntity, ContractResVO.class);
        if (null != otherContractEntity) {
            CommonResponse<SupplierVO> supplierVOCommonResponse = supplierApi.queryById(otherContractEntity.getSupplierId());
            if (supplierVOCommonResponse.isSuccess() && supplierVOCommonResponse.getData() != null) {
                otherContractVO.setSupplierCreditCode(supplierVOCommonResponse.getData().getSocialCreditCode());
            }
            CommonResponse<CustomerVO> customerVOCommonResponse = customerApi.detailById(otherContractEntity.getCustomerId());
            if (supplierVOCommonResponse.isSuccess() && customerVOCommonResponse.getData() != null) {
                otherContractVO.setCustomerCreditCode(customerVOCommonResponse.getData().getSocialCreditCode());
            }
        } else {
            return CommonResponse.error("获取合同信息失败!");
        }
        return CommonResponse.success("获取合同信息成功", otherContractVO);
    }

    /**
     * 查其他合同结算
     *
     * @param projectId
     * @param lastDay
     * @return
     */
    @RequestMapping(value = "/getMonthOtherMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<OtherProjectReportVo>> getMonthOtherMny(@RequestParam(value = "projectId") Long projectId
            , @RequestParam(value = "lastDay") Integer lastDay) {

        return CommonResponse.success("查询列表数据成功", otherContractService.getMonthOtherMny(projectId, lastDay));
    }

    /**
     * 查其他支出合同数量，金额，结算金额
     *
     * @param projectId
     * @return
     */
    @GetMapping(value = "getOtherContract")
    @ResponseBody
    public CommonResponse<OtherProjectReportVo> getOtherContract(@RequestParam(value = "projectId") Long projectId) {

        return CommonResponse.success("查询列表数据成功", otherContractService.getOtherContract(projectId));
    }

    /**
     * @param prepayMny 本期预付款金额，正为回写，负为逆回写
     * @Description 回写其它支出合同累计付款金额、累计预付款金额
     * @Param contractId  合同id
     * @Param payMny  本期已付款金额，正为回写，负为逆回写
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @GetMapping(value = "updateOtherContractSumPayMny")
    public CommonResponse<String> updateOtherContractSumPayMny(@RequestParam(value = "contractId", required = true) Long contractId,
                                                               @RequestParam("payMny") BigDecimal payMny, @RequestParam("prepayMny") BigDecimal prepayMny) {
        OtherContractEntity entity = otherContractService.selectById(contractId);
        if (entity == null) {
            return CommonResponse.error("没有找到相应其它支出合同！");
        }
        //累计付款金额
        BigDecimal sumPayMny = entity.getSumPayMny();
        sumPayMny = ComputeUtil.safeAdd(sumPayMny, payMny);
        entity.setSumPayMny(sumPayMny);
        //累计预付款金额
        BigDecimal sumPrepayMny = entity.getSumPrepayMny();
        sumPrepayMny = ComputeUtil.safeAdd(sumPrepayMny, prepayMny);
        entity.setSumPrepayMny(sumPrepayMny);
        otherContractService.saveOrUpdate(entity, false);
        return CommonResponse.success("回写其它支出合同累计付款金额、累计预付款金额成功！");
    }

    /**
     * @Description 回写其它支出结算单累计付款金额
     * @Param settleId  结算单id
     * @Param payMny  本期已付款金额，正为回写，负为逆回写
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @GetMapping(value = "updateOtherSettleSumPayMny")
    public CommonResponse<String> updateOtherSettleSumPayMny(@RequestParam(value = "settleId", required = true) Long settleId,
                                                             @RequestParam("payMny") BigDecimal payMny) {
        OtherSettleEntity entity = otherSettleService.selectById(settleId);
        if (entity == null) {
            return CommonResponse.error("没有找到相应其它支出结算单！");
        }
        //累计付款金额
        BigDecimal sumPayMny = entity.getSumPayMny();
        sumPayMny = ComputeUtil.safeAdd(sumPayMny, payMny);
        entity.setSumPayMny(sumPayMny);
        otherSettleService.saveOrUpdate(entity, false);
        return CommonResponse.success("回写其它支出结算单累计付款金额成功！");
    }

    /**
     * @Description 回写其它支出结算单累计申请金额、剩余可申请金额
     * @Param settleId  结算单id
     * @Param payMny  本期已付款金额，正为回写，负为逆回写
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @GetMapping(value = "updateOtherSettleSumApplyMny")
    public CommonResponse<String> updateOtherSettleSumApplyMny(@RequestParam(value = "settleId", required = true) Long settleId,
                                                               @RequestParam("applyMny") BigDecimal applyMny) {
        OtherSettleEntity entity = otherSettleService.selectById(settleId);
        if (entity == null) {
            return CommonResponse.error("没有找到相应其它支出结算单！");
        }
        //累计申请金额
        BigDecimal sumApplyMny = entity.getSumApplyMny();
        sumApplyMny = ComputeUtil.safeAdd(sumApplyMny, applyMny);
        entity.setSumApplyMny(sumApplyMny);
        //剩余可申请金额
        BigDecimal surplusApplyMny = ComputeUtil.safeSub(ComputeUtil.safeSub(entity.getSettleTaxMny(), entity.getThisOffsetMny()), applyMny);
        entity.setSurplusApplyMny(surplusApplyMny);
        otherSettleService.saveOrUpdate(entity, false);
        return CommonResponse.success("回写其它支出结算单累计申请金额、剩余可申请金额成功！");
    }


    /**
     * @Description 根据条件查询结算单累计冲抵金额
     * @Param contractId  合同id
     */
    @GetMapping(value = "getOtherSettlementById")
    public CommonResponse<OtherSettleVO> getOtherSettlementById(@RequestParam(value = "contractId", required = true) Long contractId, @RequestParam(value = "orgId", required = true) Long orgId) {
        OtherSettleVO vo = new OtherSettleVO();
        vo.setSumOffsetMny(new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP));
        LambdaQueryWrapper<OtherSettleEntity> lambdachange = Wrappers.<OtherSettleEntity>lambdaQuery();
        lambdachange.eq(OtherSettleEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambdachange.eq(OtherSettleEntity::getContractId, contractId);
        lambdachange.eq(OtherSettleEntity::getOrgId, orgId);
        lambdachange.in(OtherSettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<OtherSettleEntity> list = otherSettleService.list(lambdachange);
        if (CollectionUtils.isNotEmpty(list)) {
            final BigDecimal[] sumOffsetMny = {new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP)};
            list.forEach(e -> {
                sumOffsetMny[0] = sumOffsetMny[0].add(e.getThisOffsetMny() == null ? BigDecimal.ZERO : e.getThisOffsetMny());
            });
            //累计冲抵金额
            vo.setSumOffsetMny(sumOffsetMny[0]);
        }
        return CommonResponse.success("获取信息成功", vo);
    }


    /**
     * @Description 收票审批通过后更新周转材租赁合同合同开票金额等字段
     * @Param contractId  合同id
     * @Param invoiceMny、invoiceTaxMny  收票金额
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @PostMapping(value = "otherAfterApproveInvoiceReceive")
    public CommonResponse<JSONObject> otherAfterApproveInvoiceReceive(@RequestParam("contractId") Long contractId, @RequestParam("invoiceMny") BigDecimal invoiceMny, @RequestParam("invoiceTaxMny") BigDecimal invoiceTaxMny) {
        OtherContractEntity entity = otherContractService.selectById(contractId);
        if (null != entity) {
            BigDecimal sumInvoiceMny = entity.getSumInvoicingMny() == null ? BigDecimal.ZERO : entity.getSumInvoicingMny();
            BigDecimal sumInvoiceTaxMny = entity.getSumInvoicingTaxMny() == null ? BigDecimal.ZERO : entity.getSumInvoicingTaxMny();
            LambdaUpdateWrapper<OtherContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(OtherContractEntity::getId, contractId);
            updateWrapper.set(OtherContractEntity::getSumInvoicingMny, sumInvoiceMny.add(invoiceMny));
            updateWrapper.set(OtherContractEntity::getSumInvoicingTaxMny, sumInvoiceTaxMny.add(invoiceTaxMny));
            boolean flag = otherContractService.update(updateWrapper);
            if (flag) {
                return CommonResponse.success("更新成功");
            } else {
                return CommonResponse.error("更新异常");
            }
        } else {
            return CommonResponse.error("更新异常!未获取到单据信息");
        }

    }
    @PostMapping(value = "getContractByCondition")
    @ResponseBody
    public CommonResponse<List<OtherContractVO>> getContractByCondition(@RequestBody List<Long> enquiryPriceBillIds) {
        LambdaUpdateWrapper<OtherContractEntity> lambdaUpdateWrapper = new LambdaUpdateWrapper<>();
        lambdaUpdateWrapper.in(OtherContractEntity::getEnquiryPriceBillId, enquiryPriceBillIds);
        lambdaUpdateWrapper.orderByDesc(OtherContractEntity::getSignDate);
        List<OtherContractEntity> list = otherContractService.list(lambdaUpdateWrapper);
        return CommonResponse.success(BeanMapper.mapList(list, OtherContractVO.class));
    }


    /**
     * @Description 收票弃审通过后更新周转材租赁合同开票金额等字段
     * @Param contractId  合同id
     * @Param invoiceMny、invoiceTaxMny  收票金额
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @PostMapping(value = "otherAfterRevocationInvoiceReceive")
    public CommonResponse<JSONObject> otherAfterRevocationInvoiceReceive(@RequestParam("contractId") Long contractId, @RequestParam("invoiceMny") BigDecimal invoiceMny, @RequestParam("invoiceTaxMny") BigDecimal invoiceTaxMny) {
        OtherContractEntity entity = otherContractService.selectById(contractId);
        if (null != entity) {
            BigDecimal sumInvoiceMny = entity.getSumInvoicingMny() == null ? BigDecimal.ZERO : entity.getSumInvoicingMny();
            BigDecimal sumInvoiceTaxMny = entity.getSumInvoicingTaxMny() == null ? BigDecimal.ZERO : entity.getSumInvoicingTaxMny();

            LambdaUpdateWrapper<OtherContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(OtherContractEntity::getId, contractId);
            updateWrapper.set(OtherContractEntity::getSumInvoicingMny, sumInvoiceMny.subtract(invoiceMny));
            updateWrapper.set(OtherContractEntity::getSumInvoicingTaxMny, sumInvoiceTaxMny.subtract(invoiceTaxMny));
            boolean flag = otherContractService.update(updateWrapper);
            if (flag) {
                return CommonResponse.success("更新成功");
            } else {
                return CommonResponse.error("更新异常");
            }
        } else {
            return CommonResponse.error("更新异常!未获取到单据信息");
        }
    }

    /**
     * 根据项目id统计费用报销、备用金报销、零星付款申请
     */
    @GetMapping(value = "budgetControlTotal")
    public CommonResponse<BigDecimal> budgetControlTotal(@RequestParam(value = "projectId", required = true)Long projectId) {
        OtherContractVO vo = new OtherContractVO();
        vo.setProjectId(projectId);
        BigDecimal bigDecimal = otherContractService.totalContractMny(vo);
        return CommonResponse.success(bigDecimal);
    }
    /**
     * 查其他支出合同金额
     *
     * @param projectIds
     *
     * @return
     */
    @PostMapping(value = "/getContractMnyByProjectIds")
    @ResponseBody
    public CommonResponse<OtherProjectReportVo> getContractMnyByProjectIds(@RequestBody List<Long> projectIds){
        List<Long> orgIds = new ArrayList<>();
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            orgIds = authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }  else {
            orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        OtherProjectReportVo otherProjectReportVo = new OtherProjectReportVo();
        QueryWrapper<OtherContractEntity> objectQueryWrapper = new QueryWrapper<>();
        objectQueryWrapper.select("IFNUll(sum(contract_tax_mny),0) as contractTaxMny");
        objectQueryWrapper.in(CollectionUtils.isNotEmpty(projectIds),"project_id",projectIds);
        objectQueryWrapper.in(CollectionUtils.isNotEmpty(orgIds),"org_id",orgIds);
        objectQueryWrapper.in("bill_state", Arrays.asList(1,3));

        OtherContractEntity one = otherContractService.getOne(objectQueryWrapper);
        if (!Objects.isNull(one)){
            otherProjectReportVo.setMny(one.getContractTaxMny());
        }
        QueryWrapper<OtherSettleEntity> settleQueryWrapper = new QueryWrapper<>();
        settleQueryWrapper.select("IFNUll(sum(settle_tax_mny),0) as settleTaxMny");
        settleQueryWrapper.in(CollectionUtils.isNotEmpty(projectIds), "project_id", projectIds);
        settleQueryWrapper.in(CollectionUtils.isNotEmpty(orgIds), "org_id", orgIds);
        settleQueryWrapper.in("bill_state", Arrays.asList(1, 3));
        OtherSettleEntity settle = otherSettleService.getOne(settleQueryWrapper);
        if (!Objects.isNull(settle)) {
            otherProjectReportVo.setSettleMny(settle.getSettleTaxMny());
        }
        return CommonResponse.success("", otherProjectReportVo);
    }

    @GetMapping(value = "fetchSjzcje")
    public CommonResponse<BigDecimal> fetchSjzcje(@RequestParam(value = "projectId") Long projectId) {
        return CommonResponse.success(otherContractService.fetchSjzcje(projectId));
    }

    @GetMapping(value = "queryFeeMny")
    public CommonResponse<BigDecimal> queryFeeMny(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "feeTypeId") Long feeTypeId) {
        BigDecimal result = BigDecimal.ZERO;
        LambdaQueryWrapper<OtherContractEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(OtherContractEntity::getProjectId, projectId);
        queryWrapper.in(OtherContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<OtherContractEntity> entities = otherContractService.list(queryWrapper);
        return CommonResponse.success("查询成功!", result);
    }
}
