/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bidprice.material.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryEntity;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryPurchaseDetailEntity;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryRentDetailEntity;
import com.ejianc.business.bidprice.material.bean.MaterialQuoteEntity;
import com.ejianc.business.bidprice.material.service.IMaterialInquiryService;
import com.ejianc.business.bidprice.material.service.IMaterialQuoteService;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryPurchaseDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryRentDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialQuotePurchaseDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialQuoteRentDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialQuoteVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"materialQuote"})
@Api(tags={"\u6750\u6599\u62a5\u4ef7\u8bb0\u5f55"})
public class MaterialQuoteController
implements Serializable {
    private static final long serialVersionUID = -6476701269896286249L;
    private static final String RULE_CODE = "ZYDX_MATERIAL_QUOTE";
    private static final String BILL_CODE = "EJCBT202502000017";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IBillTypeApi billTypeApi;
    @Resource
    private IBillCodeApi billCodeApi;
    @Resource
    private IOrgApi iOrgApi;
    @Resource
    private IMaterialQuoteService service;
    @Autowired
    private SessionManager sessionManager;
    @Resource
    private IAttachmentApi attachmentApi;
    @Resource
    private IMaterialInquiryService materialInquiryService;

    @ApiOperation(value="\u4fdd\u5b58\u6216\u66f4\u65b0")
    @PostMapping(value={"/saveOrUpdate"})
    public CommonResponse<MaterialQuoteVO> saveOrUpdate(@RequestBody MaterialQuoteVO materialQuoteVO) {
        MaterialQuoteEntity entity = (MaterialQuoteEntity)((Object)BeanMapper.map((Object)((Object)materialQuoteVO), MaterialQuoteEntity.class));
        this.service.checkQuoteEndDate(entity.getInquiryId());
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)RULE_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)materialQuoteVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        MaterialQuoteVO vo = (MaterialQuoteVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialQuoteVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/queryDetail"})
    public CommonResponse<MaterialQuoteVO> queryDetail(Long id) {
        MaterialQuoteEntity entity = (MaterialQuoteEntity)((Object)this.service.selectById(id));
        if (entity == null) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u62a5\u4ef7\u8bb0\u5f55\u6570\u636e\uff01");
        }
        MaterialQuoteVO vo = (MaterialQuoteVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialQuoteVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @PostMapping(value={"/delete"})
    public CommonResponse<String> delete(@RequestBody List<MaterialQuoteVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialQuoteVO vo : vos) {
                CommonResponse resp = this.billTypeApi.checkQuote(BILL_CODE, vo.getId());
                if (resp.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01" + resp.getMsg()));
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/queryList"})
    public CommonResponse<IPage<MaterialQuoteVO>> queryList(@RequestBody QueryParam param) {
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("create_time", "desc");
        param.getOrderMap().putAll(orderMap);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List materialQuoteVOS = BeanMapper.mapList((Iterable)page.getRecords(), MaterialQuoteVO.class);
        if (CollectionUtils.isNotEmpty((Collection)materialQuoteVOS)) {
            List quoteIds = materialQuoteVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            JSONObject fileParam = new JSONObject();
            fileParam.put("sourceIds", quoteIds);
            JSONArray sourceTypeArr = new JSONArray();
            sourceTypeArr.add((Object)"quote");
            fileParam.put("sourceTypeList", (Object)JSON.toJSONString((Object)sourceTypeArr));
            CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(fileParam);
            List fileData = (List)listCommonResponse.getData();
            Map<Object, Object> fileMap = new HashMap();
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)fileData)) {
                fileMap = fileData.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity(), (e1, e2) -> e1));
            }
            for (MaterialQuoteVO materialQuoteVO : materialQuoteVOS) {
                if (!fileMap.containsKey(materialQuoteVO.getId())) continue;
                AttachmentVO attachmentVO = (AttachmentVO)fileMap.get(materialQuoteVO.getId());
                materialQuoteVO.setQuoteFileId(attachmentVO.getId());
                materialQuoteVO.setQuoteFileName(attachmentVO.getFileName());
            }
        }
        pageData.setRecords(materialQuoteVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/checkViewAuthority"})
    public CommonResponse<Void> checkViewAuthority(@RequestParam(value="inquiryId") Long inquiryId, @RequestParam(value="phoneNumber") String phoneNumber) {
        this.service.checkViewAuthority(inquiryId, phoneNumber);
        return CommonResponse.success();
    }

    @GetMapping(value={"/checkQuotationAuthority"})
    public CommonResponse<Void> checkQuotationAuthority(@RequestParam(value="inquiryId") Long inquiryId, @RequestParam(value="phoneNumber") String phoneNumber) {
        this.service.checkQuotationAuthority(inquiryId, phoneNumber);
        return CommonResponse.success();
    }

    @GetMapping(value={"/fetchVerifyCode"})
    public CommonResponse<Void> fetchVerifyCode(@RequestParam(value="inquiryId") Long inquiryId, @RequestParam(value="phoneNumber") String phoneNumber) throws Exception {
        this.service.fetchVerifyCode(inquiryId, phoneNumber);
        return CommonResponse.success((String)"\u9a8c\u8bc1\u7801\u53d1\u9001\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u767b\u5f55")
    @GetMapping(value={"/login"})
    public CommonResponse<String> login(@RequestParam(value="phoneNumber") String phoneNumber, @RequestParam(value="validate") String validate) {
        this.service.login(phoneNumber, validate);
        return CommonResponse.success((String)"\u767b\u5f55\u6210\u529f\uff01", (Object)phoneNumber);
    }

    @ApiOperation(value="\u6536\u56de")
    @GetMapping(value={"/withdraw"})
    public CommonResponse<String> withdraw(@RequestParam(value="id") Long id) {
        this.service.withdraw(id);
        return CommonResponse.success((String)"\u6536\u56de\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u4fee\u6539\u5355\u636e\u72b6\u6001")
    @GetMapping(value={"/changeStatus"})
    public CommonResponse<String> changeStatus(@RequestParam(value="id") Long id, @RequestParam(value="billState") Integer billState) {
        this.service.changeStatus(id, billState);
        return CommonResponse.success((String)"\u5355\u636e\u72b6\u6001\u4fee\u6539\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6700\u8fd1\u4e00\u6b21\u7684\u62a5\u4ef7\u8bb0\u5f55")
    @GetMapping(value={"/recentQuote"})
    public CommonResponse<MaterialQuoteVO> recentQuote(@RequestParam(value="phoneNumber") String phoneNumber) {
        return CommonResponse.success((String)"\u5355\u636e\u72b6\u6001\u4fee\u6539\u6210\u529f\uff01", (Object)((Object)this.service.recentQuote(phoneNumber)));
    }

    @PostMapping(value={"excelExportPurchaseList"})
    public void excelExportPurchaseList(@RequestBody MaterialQuoteVO materialQuoteVO, HttpServletResponse response) {
        ArrayList list = new ArrayList();
        HashMap beans = new HashMap();
        Long materialQuoteVOId = materialQuoteVO.getId();
        if (materialQuoteVOId != null) {
            MaterialInquiryEntity entity = (MaterialInquiryEntity)((Object)this.materialInquiryService.selectById(materialQuoteVOId));
            List<MaterialInquiryPurchaseDetailEntity> data = entity.getMaterialInquiryPurchaseDetailList();
            if (CollectionUtils.isNotEmpty(data)) {
                data.forEach(materialSub -> {
                    MaterialInquiryPurchaseDetailVO vo = (MaterialInquiryPurchaseDetailVO)((Object)((Object)BeanMapper.map((Object)materialSub, MaterialInquiryPurchaseDetailVO.class)));
                    list.add(vo);
                });
            }
            beans.put("records", list);
            ExcelExport.getInstance().export("Materialpurchase-List-export.xlsx", beans, response);
        }
    }

    @PostMapping(value={"excelExportRentList"})
    public void excelExportRentList(@RequestBody MaterialQuoteVO materialQuoteVO, HttpServletResponse response) {
        ArrayList list = new ArrayList();
        HashMap beans = new HashMap();
        Long materialQuoteVOId = materialQuoteVO.getId();
        if (materialQuoteVOId != null) {
            MaterialInquiryEntity entity = (MaterialInquiryEntity)((Object)this.materialInquiryService.selectById(materialQuoteVOId));
            List<MaterialInquiryRentDetailEntity> data = entity.getMaterialInquiryRentDetailList();
            if (CollectionUtils.isNotEmpty(data)) {
                data.forEach(materialSub -> {
                    MaterialInquiryRentDetailVO vo = (MaterialInquiryRentDetailVO)((Object)((Object)BeanMapper.map((Object)materialSub, MaterialInquiryRentDetailVO.class)));
                    list.add(vo);
                });
            }
            beans.put("records", list);
            ExcelExport.getInstance().export("Materialrent-List-export.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"/purchaseDownload"})
    @ResponseBody
    public void purchaseDownload(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"Materialpurchase-List-import.xlsx", (String)"\u6e05\u5355\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelPurchaseImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelPurchaseImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<MaterialQuotePurchaseDetailVO> successList = new ArrayList<MaterialQuotePurchaseDetailVO>();
        ArrayList<MaterialQuotePurchaseDetailVO> errorList = new ArrayList<MaterialQuotePurchaseDetailVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(1)).size() != 12) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                MaterialQuotePurchaseDetailVO materialQuotePurchaseDetailVO = new MaterialQuotePurchaseDetailVO();
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    materialQuotePurchaseDetailVO.setErrorMessage("\u7269\u6599\u5206\u7c7b\u4e3a\u5fc5\u586b\u9879");
                } else {
                    String materialCategoryName = ((String)datas.get(0)).trim();
                    materialQuotePurchaseDetailVO.setMaterialCategoryName(materialCategoryName);
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    materialQuotePurchaseDetailVO.setErrorMessage("\u7269\u8d44\u540d\u79f0\u4e3a\u5fc5\u586b\u9879");
                } else {
                    materialQuotePurchaseDetailVO.setMaterialName(((String)datas.get(1)).trim());
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    materialQuotePurchaseDetailVO.setErrorMessage("\u89c4\u683c\u578b\u53f7\u4e3a\u5fc5\u586b\u9879");
                } else {
                    materialQuotePurchaseDetailVO.setSpec(((String)datas.get(2)).trim());
                }
                if (!Objects.isNull(datas.get(3))) {
                    materialQuotePurchaseDetailVO.setUnit(((String)datas.get(3)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        materialQuotePurchaseDetailVO.setPlanUseDate(format.parse((String)datas.get(4)));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    try {
                        materialQuotePurchaseDetailVO.setPurchaseQuotePriceNoTax(new BigDecimal((String)datas.get(6)));
                    }
                    catch (Exception e) {
                        materialQuotePurchaseDetailVO.setErrorMessage("\u62a5\u4ef7(\u65e0\u7a0e)\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    try {
                        materialQuotePurchaseDetailVO.setPurchaseRate(ComputeUtil.toBigDecimal((String)datas.get(7)));
                    }
                    catch (Exception e) {
                        materialQuotePurchaseDetailVO.setErrorMessage("\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8)))) {
                    try {
                        materialQuotePurchaseDetailVO.setPurchaseQuotePrice(ComputeUtil.toBigDecimal((String)datas.get(8)));
                    }
                    catch (Exception e) {
                        materialQuotePurchaseDetailVO.setErrorMessage("\u62a5\u4ef7\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (StringUtils.isBlank((CharSequence)materialQuotePurchaseDetailVO.getErrorMessage())) {
                    successList.add(materialQuotePurchaseDetailVO);
                } else {
                    errorList.add(materialQuotePurchaseDetailVO);
                }
                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11)))) continue;
                materialQuotePurchaseDetailVO.setPurchaseMemo((String)datas.get(11));
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/rentDownload"})
    @ResponseBody
    public void rentDownload(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"Materialrent-List-import.xlsx", (String)"\u7269\u6599\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelRentImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelRentImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<MaterialQuoteRentDetailVO> successList = new ArrayList<MaterialQuoteRentDetailVO>();
        ArrayList<MaterialQuoteRentDetailVO> errorList = new ArrayList<MaterialQuoteRentDetailVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(1)).size() != 14) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                MaterialQuoteRentDetailVO materialQuoteRentDetailVO = new MaterialQuoteRentDetailVO();
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    materialQuoteRentDetailVO.setErrorMessage("\u7269\u6599\u5206\u7c7b\u4e3a\u5fc5\u586b\u9879");
                } else {
                    String materialCategoryName = ((String)datas.get(0)).trim();
                    materialQuoteRentDetailVO.setMaterialCategoryName(materialCategoryName);
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    materialQuoteRentDetailVO.setErrorMessage("\u7269\u8d44\u540d\u79f0\u4e3a\u5fc5\u586b\u9879");
                } else {
                    materialQuoteRentDetailVO.setMaterialName(((String)datas.get(1)).trim());
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    materialQuoteRentDetailVO.setErrorMessage("\u89c4\u683c\u578b\u53f7\u4e3a\u5fc5\u586b\u9879");
                } else {
                    materialQuoteRentDetailVO.setSpec(((String)datas.get(2)).trim());
                }
                if (!Objects.isNull(datas.get(3))) {
                    materialQuoteRentDetailVO.setUnit(((String)datas.get(3)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        materialQuoteRentDetailVO.setPlanUseDate(format.parse((String)datas.get(5)));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8)))) {
                    try {
                        materialQuoteRentDetailVO.setRentQuotePriceNoTax(new BigDecimal((String)datas.get(8)));
                    }
                    catch (Exception e) {
                        materialQuoteRentDetailVO.setErrorMessage("\u62a5\u4ef7(\u65e0\u7a0e)\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9)))) {
                    try {
                        materialQuoteRentDetailVO.setRentRate(ComputeUtil.toBigDecimal((String)datas.get(9)));
                    }
                    catch (Exception e) {
                        materialQuoteRentDetailVO.setErrorMessage("\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10)))) {
                    try {
                        materialQuoteRentDetailVO.setRentQuotePrice(ComputeUtil.toBigDecimal((String)datas.get(10)));
                    }
                    catch (Exception e) {
                        materialQuoteRentDetailVO.setErrorMessage("\u62a5\u4ef7\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (StringUtils.isBlank((CharSequence)materialQuoteRentDetailVO.getErrorMessage())) {
                    successList.add(materialQuoteRentDetailVO);
                } else {
                    errorList.add(materialQuoteRentDetailVO);
                }
                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(13)))) continue;
                materialQuoteRentDetailVO.setRentMemo((String)datas.get(13));
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }
}

