/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sub.bean.SubContractEntity;
import com.ejianc.business.sub.bean.SubSettleDetailEntity;
import com.ejianc.business.sub.bean.SubSettleEntity;
import com.ejianc.business.sub.bean.SubSettleOtherEntity;
import com.ejianc.business.sub.mapper.SubSettleMapper;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISubSettleDetailService;
import com.ejianc.business.sub.service.ISubSettleOtherService;
import com.ejianc.business.sub.service.ISubSettleService;
import com.ejianc.business.sub.utils.BigDecimalUtils;
import com.ejianc.business.sub.utils.ExcelImportUtil;
import com.ejianc.business.sub.utils.TreeNodeBUtil;
import com.ejianc.business.sub.vo.SubContractDetailVO;
import com.ejianc.business.sub.vo.SubCostTypeEnum;
import com.ejianc.business.sub.vo.SubParamsCheckDsVO;
import com.ejianc.business.sub.vo.SubParamsCheckVO;
import com.ejianc.business.sub.vo.SubSettleCheckParamsVO;
import com.ejianc.business.sub.vo.SubSettleDetailVO;
import com.ejianc.business.sub.vo.SubSettleRecordDetailVO;
import com.ejianc.business.sub.vo.SubSettleRecordVO;
import com.ejianc.business.sub.vo.SubSettleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="SubSettleServiceImpl")
public class SubSettleServiceImpl
extends BaseServiceImpl<SubSettleMapper, SubSettleEntity>
implements ISubSettleService {
    private static final String SUB_SETTLE_BILL_CODE = "SUB_SETTLE";
    private static final String SUB_SETTLE = "SUB_SETTLE";
    private static final String SUB_SETTLE_DETAIL = "SUB_SETTLE_DETAIL";
    private static final String SUB_SETTLE_ODDJOB = "SUB_SETTLE_ODDJOB";
    private static final String SUB_SETTLE_OTHER = "SUB_SETTLE_OTHER";
    private static final String CHECK_PARAM_CODE = "P-A9232233";
    private static final String CHECK_PARAM_CODE_NUM = "P-2IJ8Cs27";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private ISubSettleDetailService settleDetailService;
    @Autowired
    private ISubSettleOtherService settleOtherService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private SessionManager sessionManager;
    private static final String PREPAY_PARAM = "P-zu6b9071";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubSettleVO insertOrUpdate(SubSettleVO settleVO) {
        BigDecimal syMny;
        block24: {
            if (this.checkFinishContract(settleVO).booleanValue()) {
                throw new BusinessException("\u8be5\u5408\u540c\u5728\u76f8\u540c\u7ec4\u7ec7\u4e0b\u5df2\u7ecf\u5b8c\u5de5\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff01");
            }
            if (settleVO.getContractVersion() != null && settleVO.getContractVersion() != 0) {
                Jedis jedis = this.jedisPool.getResource();
                boolean locked = false;
                try {
                    locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(settleVO.getContractId()), (String)"saveOrUpdate", (int)1000);
                    this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
                    if (locked) {
                        Integer conVersion;
                        SubContractEntity contractEntity = (SubContractEntity)((Object)this.contractService.selectById(settleVO.getContractId()));
                        Integer version = contractEntity.getVersion() == null ? 0 : contractEntity.getVersion();
                        if (!version.equals(conVersion = settleVO.getContractVersion())) {
                            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                        }
                        break block24;
                    }
                    throw new BusinessException("\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (locked) {
                        RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(settleVO.getContractId()), (String)"saveOrUpdate");
                    }
                    jedis.close();
                }
            }
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (this.checkSameContract(settleVO).booleanValue()) {
            throw new BusinessException("\u540c\u4e00\u5408\u540c\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u6216\u5ba1\u6279\u4e2d\u7684\u5206\u5305\u8fc7\u7a0b\u7ed3\u7b97\u5355");
        }
        if (StringUtils.isEmpty((CharSequence)settleVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode("SUB_SETTLE", InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                settleVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (this.checkSameBillCode(settleVO).booleanValue()) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        settleVO.setRelationFlag("0");
        settleVO.setProportionFlag("0");
        SubSettleEntity settleEntity = (SubSettleEntity)((Object)BeanMapper.map((Object)((Object)settleVO), SubSettleEntity.class));
        List<SubSettleDetailEntity> beforeDetails = settleEntity.getSettleDetailList();
        if (CollectionUtils.isNotEmpty(beforeDetails) && null == settleEntity.getId()) {
            for (SubSettleDetailEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        LambdaQueryWrapper lambdachange2 = Wrappers.lambdaQuery();
        lambdachange2.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange2.eq(SubSettleEntity::getContractId, (Object)settleVO.getContractId());
        lambdachange2.eq(SubSettleEntity::getOrgId, (Object)settleVO.getOrgId());
        if (null != settleVO.getId() && settleVO.getId() > 0L) {
            lambdachange2.ne(BaseEntity::getId, (Object)settleVO.getId());
        }
        lambdachange2.in(SubSettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambdachange2.gt(SubSettleEntity::getSettleDate, (Object)settleVO.getSettleDate());
        int num2 = super.count((Wrapper)lambdachange2);
        if (num2 > 0) {
            throw new BusinessException("\u7ed3\u7b97\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8be5\u5408\u540c\u5bf9\u5e94\u6700\u65b0\u7ed3\u7b97\u65e5\u671f!");
        }
        BigDecimal settlementTaxMny = settleVO.getSettleTaxMny() == null ? BigDecimal.ZERO : settleVO.getSettleTaxMny();
        BigDecimal offsetMny = settleVO.getOffsetMny() == null ? BigDecimal.ZERO : settleVO.getOffsetMny();
        BigDecimal bigDecimal = syMny = settleVO.getSymny() == null ? BigDecimal.ZERO : settleVO.getSymny();
        if (offsetMny.compareTo(syMny) > 0) {
            throw new BusinessException("\u672c\u6b21\u51b2\u62b5\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u5269\u4f59\u53ef\u51b2\u62b5\u91d1\u989d!");
        }
        if (settlementTaxMny.compareTo(BigDecimal.ZERO) > 0 && offsetMny.compareTo(settlementTaxMny) > 0) {
            throw new BusinessException("\u672c\u6b21\u51b2\u62b5\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u672c\u671f\u7ed3\u7b97\u91d1\u989d");
        }
        super.saveOrUpdate((Object)settleEntity, false);
        List<SubSettleDetailEntity> settleDetailEntities = settleEntity.getSettleDetailList();
        if (CollectionUtils.isNotEmpty(settleDetailEntities)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (SubSettleDetailEntity cdEntity : settleDetailEntities) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (SubSettleDetailEntity cdEntity : settleDetailEntities) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.settleDetailService.saveOrUpdateBatch(settleDetailEntities, settleDetailEntities.size(), false);
        }
        return this.queryDetail(settleEntity.getId(), true);
    }

    private Boolean checkSameBillCode(SubSettleVO settleVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SubSettleEntity::getBillCode, (Object)settleVO.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != settleVO.getId() && settleVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)settleVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    private Boolean checkSameContract(SubSettleVO settleVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SubSettleEntity::getContractId, (Object)settleVO.getContractId());
        lambda.eq(SubSettleEntity::getOrgId, (Object)settleVO.getOrgId());
        lambda.notIn(SubSettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != settleVO.getId() && settleVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)settleVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    @Override
    public SubSettleVO queryDetail(Long id, Boolean detailHasChildren) {
        BigDecimal settleTaxMny;
        SubSettleEntity settleEntity = (SubSettleEntity)((Object)super.selectById((Serializable)id));
        SubSettleVO settleVO = (SubSettleVO)((Object)BeanMapper.map((Object)((Object)settleEntity), SubSettleVO.class));
        BigDecimal c = settleVO.getContractTaxMny() == null ? BigDecimal.ZERO : settleVO.getContractTaxMny();
        settleVO.setContractTaxMny(c);
        BigDecimal cc = settleVO.getSumSettleTaxMny() == null ? BigDecimal.ZERO : settleVO.getSumSettleTaxMny();
        settleVO.setSumSettleTaxMny(cc);
        if (c.compareTo(BigDecimal.ZERO) != 0 && cc.compareTo(BigDecimal.ZERO) != 0) {
            settleVO.setSumSettleScale(new BigDecimal(100).multiply(BigDecimalUtils.safeDiv(cc, c)));
        }
        BigDecimal bigDecimal = settleTaxMny = settleVO.getSettleTaxMny() == null ? BigDecimal.ZERO : settleVO.getSettleTaxMny();
        if (c.compareTo(BigDecimal.ZERO) != 0 && settleTaxMny.compareTo(BigDecimal.ZERO) != 0) {
            settleVO.setSettleScale(new BigDecimal(100).multiply(BigDecimalUtils.safeDiv(settleTaxMny, c)));
        }
        BigDecimal sumPrePayMny = settleEntity.getSumPrepayMny() == null ? BigDecimal.ZERO : settleEntity.getSumPrepayMny();
        BigDecimal sumOffsetMny = settleEntity.getSumOffsetMny() == null ? BigDecimal.ZERO : settleEntity.getSumOffsetMny();
        settleVO.setSymny(sumPrePayMny.subtract(sumOffsetMny));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("settleId", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List detailEntityList = this.settleDetailService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
            for (SubSettleDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList((Iterable)detailEntityList, SubSettleDetailVO.class);
            SubSettleServiceImpl.sortIntMethod(resultMapList);
            if (detailHasChildren.booleanValue()) {
                settleVO.setSettleDetailList(TreeNodeBUtil.buildTree(resultMapList));
            } else {
                settleVO.setSettleDetailList(resultMapList);
            }
        }
        return settleVO;
    }

    private static void sortIntMethod(List<SubSettleDetailVO> list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] strs2;
                ObjectMapper objectMapper = new ObjectMapper();
                SubSettleDetailVO o1Detail = (SubSettleDetailVO)objectMapper.convertValue(o1, SubSettleDetailVO.class);
                SubSettleDetailVO o2Detail = (SubSettleDetailVO)objectMapper.convertValue(o2, SubSettleDetailVO.class);
                String[] strs1 = o1Detail.getTreeIndex().split("\\.");
                int length = strs1.length > (strs2 = o2Detail.getTreeIndex().split("\\.")).length ? strs1.length : strs2.length;
                for (int i = 0; i < length; ++i) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (num1 < num2) {
                        return -1;
                    }
                    if (num1 <= num2) continue;
                    return 1;
                }
                return 0;
            }
        });
    }

    @Override
    public CommonResponse<IPage<SubSettleVO>> queryListVOs(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        IPage page = this.queryPage(param, false);
        List settleVOList = BeanMapper.mapList((Iterable)page.getRecords(), SubSettleVO.class);
        Page settleVOIPage = new Page();
        settleVOIPage.setCurrent(page.getCurrent());
        settleVOIPage.setRecords(settleVOList);
        settleVOIPage.setSize(page.getSize());
        settleVOIPage.setTotal(page.getTotal());
        settleVOIPage.setPages(page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)settleVOIPage);
    }

    @Override
    public CommonResponse<String> deleteByIds(List<SubSettleVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            this.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public SubSettleRecordVO queryDetailRecord(Long id) {
        SubContractEntity contractEntity = (SubContractEntity)((Object)this.contractService.selectById(id));
        SubSettleRecordVO settleRecordVO = new SubSettleRecordVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        settleRecordVO.setContractId(id);
        settleRecordVO.setFinishFlag(contractEntity.getFinishFlag());
        settleRecordVO.setContractStatus(Integer.valueOf(contractEntity.getContractStatus()));
        settleRecordVO.setContractTaxMny(contractTaxMny);
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(SubSettleEntity::getContractId, (Object)id);
        lambda.in(SubSettleEntity::getOrgId, commonOrgIds);
        List entitiesAllState = super.list((Wrapper)lambda);
        lambda.in(SubSettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.orderByDesc(BaseEntity::getCreateTime);
        List entities = super.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            List settleRecordDetailVOList = BeanMapper.mapList((Iterable)entities, SubSettleRecordDetailVO.class);
            BigDecimal[] settlementMoney = new BigDecimal[]{new BigDecimal("0.00").setScale(2, 4)};
            settleRecordDetailVOList.forEach(entity -> {
                settlementMoney[0] = settlementMoney[0].add(entity.getSettleTaxMny() == null ? BigDecimal.ZERO : entity.getSettleTaxMny());
                BigDecimal dSumSettleTaxMny = entity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : entity.getSumSettleTaxMny();
                BigDecimal scale = BigDecimalUtils.safeDiv(dSumSettleTaxMny, contractTaxMny).multiply(new BigDecimal(100));
                entity.setSumScale(scale);
            });
            settleRecordVO.setSumSettleTaxMny(settlementMoney[0]);
            BigDecimal sumSettlementTaxMny = settleRecordVO.getSumSettleTaxMny() == null ? BigDecimal.ZERO : settleRecordVO.getSumSettleTaxMny();
            settleRecordVO.setSumScale(new BigDecimal(100).multiply(BigDecimalUtils.safeDiv(sumSettlementTaxMny, contractTaxMny)));
        }
        settleRecordVO.setDetailList(BeanMapper.mapList((Iterable)entitiesAllState, SubSettleRecordDetailVO.class));
        return settleRecordVO;
    }

    @Override
    public SubSettleVO queryDetailAdd(Long contractId) {
        BigDecimal cc;
        BigDecimal sumOffsetMnys;
        SubContractEntity contractEntity = (SubContractEntity)((Object)this.contractService.selectById(contractId));
        SubSettleVO settleVO = (SubSettleVO)((Object)BeanMapper.map((Object)((Object)contractEntity), SubSettleVO.class));
        settleVO.setBillCode(null);
        settleVO.setEmployeeId(null);
        settleVO.setEmployeeName(null);
        settleVO.setContractId(contractEntity.getId());
        settleVO.setBillState(null);
        settleVO.setCreateUserCode(null);
        settleVO.setCreateTime(null);
        settleVO.setUpdateUserCode(null);
        settleVO.setUpdateTime(null);
        settleVO.setId(null);
        settleVO.setVersion(null);
        settleVO.setTaxMny(null);
        settleVO.setSumInvoiceTaxMny(null);
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambdachange.eq(SubSettleEntity::getContractId, (Object)contractId);
        lambdachange.eq(SubSettleEntity::getOrgId, (Object)contractEntity.getOrgId());
        lambdachange.in(SubSettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = super.list((Wrapper)lambdachange);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal[] settlementMoney = new BigDecimal[]{new BigDecimal("0.00").setScale(2, 4), new BigDecimal("0.00").setScale(2, 4)};
            list.forEach(e -> {
                settlementMoney[0] = settlementMoney[0].add(e.getSettleTaxMny() == null ? BigDecimal.ZERO : e.getSettleTaxMny());
                settlementMoney[1] = settlementMoney[1].add(e.getOffsetMny() == null ? BigDecimal.ZERO : e.getOffsetMny());
            });
            settleVO.setSumSettleTaxMny(settlementMoney[0]);
            settleVO.setSumOffsetMny(settlementMoney[1]);
        }
        BigDecimal bigDecimal = sumOffsetMnys = settleVO.getSumOffsetMny() == null ? BigDecimal.ZERO : settleVO.getSumOffsetMny();
        if (settleVO.getSumPrepayMny().compareTo(BigDecimal.ZERO) >= 0 && sumOffsetMnys.compareTo(BigDecimal.ZERO) >= 0) {
            settleVO.setSymny(settleVO.getSumPrepayMny().subtract(sumOffsetMnys));
        }
        BigDecimal c = settleVO.getContractTaxMny() == null ? BigDecimal.ZERO : settleVO.getContractTaxMny();
        BigDecimal bigDecimal2 = cc = settleVO.getSumSettleTaxMny() == null ? BigDecimal.ZERO : settleVO.getSumSettleTaxMny();
        if (c.compareTo(BigDecimal.ZERO) > 0 && cc.compareTo(BigDecimal.ZERO) > 0) {
            settleVO.setSumSettleScale(new BigDecimal(100).multiply(BigDecimalUtils.safeDiv(cc, c)));
        }
        return settleVO;
    }

    @Override
    public JSONObject querySubSettleVOList(QueryParam param, boolean isEs) {
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = SubSettleServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<SubSettleVO> list = ((SubSettleMapper)this.baseMapper).querySubSettleVOList(pages, wrapper);
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    @Override
    public CommonResponse<SubSettleVO> pushCost(SubSettleVO settleVO) {
        SubSettleEntity settleEntity = (SubSettleEntity)((Object)((SubSettleMapper)this.baseMapper).selectById(settleVO.getId()));
        if (CollectionUtils.isNotEmpty(settleVO.getSettleDetailList())) {
            List detailEntities = BeanMapper.mapList(settleVO.getSettleDetailList(), SubSettleDetailEntity.class);
            settleEntity.setSettleDetailList(detailEntities);
        }
        if (CollectionUtils.isNotEmpty(settleVO.getSettleOtherList())) {
            List otherEntities = BeanMapper.mapList(settleVO.getSettleOtherList(), SubSettleOtherEntity.class);
            settleEntity.setSettleOtherList(otherEntities);
        }
        super.saveOrUpdate((Object)settleEntity, false);
        this.costPush(settleEntity);
        return CommonResponse.success((Object)((Object)this.queryDetail(settleVO.getId(), true)));
    }

    @Override
    public void costPush(SubSettleEntity settleEntity) {
        Boolean isPush = true;
        LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
        detailWrapper.eq(SubSettleDetailEntity::getSettleId, (Object)settleEntity.getId());
        List detailEntities = this.settleDetailService.list((Wrapper)detailWrapper);
        LambdaQueryWrapper othWrapper = new LambdaQueryWrapper();
        othWrapper.eq(SubSettleOtherEntity::getSettleId, (Object)settleEntity.getId());
        List otherEntities = this.settleOtherService.list((Wrapper)othWrapper);
        if (CollectionUtils.isNotEmpty((Collection)detailEntities) && isPush.booleanValue()) {
            for (SubSettleDetailEntity detailEntity : detailEntities) {
                if (!detailEntity.getLeafFlag().booleanValue() || null != detailEntity.getSubjectId()) continue;
                isPush = false;
                break;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)otherEntities) && isPush.booleanValue()) {
            for (SubSettleOtherEntity otherEntity : otherEntities) {
                if (null != otherEntity.getSubjectId()) continue;
                isPush = false;
                break;
            }
        }
        settleEntity.setSettleDetailList(detailEntities);
        settleEntity.setSettleOtherList(otherEntities);
        this.logger.info("----------------------isPush\uff1a" + isPush + "----------------------");
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)settleEntity.getId());
        updateWrapper.set(SubSettleEntity::getRelationFlag, (Object)(isPush != false ? "1" : "0"));
        super.update((Wrapper)updateWrapper);
        String oldRelationFlag = settleEntity.getRelationFlag();
        if (oldRelationFlag.equals("1") && isPush.booleanValue()) {
            this.saveCost(settleEntity);
        }
        if (oldRelationFlag.equals("0")) {
            this.saveCost(settleEntity);
        }
    }

    @Override
    public void pullCost(Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)id);
        updateWrapper.set(SubSettleEntity::getRelationFlag, (Object)"0");
        super.update((Wrapper)updateWrapper);
    }

    @Override
    public SubParamsCheckVO checkParams(Integer purchaseType, BigDecimal sumSettleMentTaxMny, BigDecimal contractTaxMny) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        SubParamsCheckVO paramsCheckVO = new SubParamsCheckVO();
        ArrayList<SubParamsCheckDsVO> checkDsVOS = new ArrayList<SubParamsCheckDsVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            BillParamVO billParamVO = (BillParamVO)billParamByCode.getData();
            BigDecimal roleValue = billParamVO.getRoleValue();
            BigDecimal comMny = contractTaxMny.multiply(roleValue.divide(BigDecimal.valueOf(100L), 2, 4));
            if (2 == purchaseType) {
                paramsCheckVO.setWarnType(paramsArray[0]);
                return paramsCheckVO;
            }
            paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            if (sumSettleMentTaxMny.compareTo(comMny) > 0) {
                SubParamsCheckDsVO paramsCheckDsVO = new SubParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("\u5408\u540c\u8d85\u7ed3");
                paramsCheckDsVO.setWarnName("\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\uff1a").append(sumSettleMentTaxMny.toString()).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(sumSettleMentTaxMny.subtract(comMny)).append("\u5143");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                checkDsVOS.add(paramsCheckDsVO);
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        paramsCheckVO.setDataSource(checkDsVOS);
        return paramsCheckVO;
    }

    @Override
    public SubSettleVO getSumSettleNumInfo(SubSettleVO settleVO) {
        List<SubSettleDetailVO> settleDetailList = settleVO.getSettleDetailList();
        if (CollectionUtils.isNotEmpty(settleDetailList)) {
            List cids = settleDetailList.stream().map(SubSettleDetailVO::getContractDetailId).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("contractDetailId", new Parameter("in", cids));
            QueryWrapper wrapper = SubSettleServiceImpl.changeToQueryWrapper((QueryParam)param);
            List<SubSettleDetailVO> list = ((SubSettleMapper)this.baseMapper).getSumSettleNumInfo(wrapper);
            Map<Long, SubSettleDetailVO> voMap = list.stream().collect(Collectors.toMap(SubSettleDetailVO::getContractDetailId, a -> a, (k1, k2) -> k1));
            if (voMap != null && voMap.size() > 0) {
                settleDetailList.forEach(t2 -> {
                    if (t2.getLeafFlag().booleanValue()) {
                        Long contractDetailId = t2.getContractDetailId();
                        SubSettleDetailVO settleDetailVO = (SubSettleDetailVO)voMap.get(contractDetailId);
                        t2.setSumSettleNum(settleDetailVO.getSumSettleNum() != null ? settleDetailVO.getSumSettleNum() : BigDecimal.ZERO);
                        t2.setSumSettleNumEndthis(settleDetailVO.getSumSettleNum() != null ? settleDetailVO.getSumSettleNum() : BigDecimal.ZERO);
                    }
                });
            }
        }
        return settleVO;
    }

    @Override
    public List<SubContractDetailVO> getSumSettleNum(List<SubContractDetailVO> contractDetailVOS) {
        if (CollectionUtils.isNotEmpty(contractDetailVOS)) {
            List cids = contractDetailVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("contractDetailId", new Parameter("in", cids));
            QueryWrapper wrapper = SubSettleServiceImpl.changeToQueryWrapper((QueryParam)param);
            List<SubSettleDetailVO> list = ((SubSettleMapper)this.baseMapper).getSumSettleNumInfo(wrapper);
            Map<Long, SubSettleDetailVO> voMap = list.stream().collect(Collectors.toMap(SubSettleDetailVO::getContractDetailId, a -> a, (k1, k2) -> k1));
            if (voMap != null && voMap.size() > 0) {
                contractDetailVOS.forEach(t2 -> {
                    if (t2.getLeafFlag().booleanValue()) {
                        Long contractDetailId = t2.getId();
                        SubSettleDetailVO settleDetailVO = (SubSettleDetailVO)voMap.get(contractDetailId);
                        t2.setSumSettleNum(settleDetailVO != null && settleDetailVO.getSumSettleNum() != null ? settleDetailVO.getSumSettleNum() : BigDecimal.ZERO);
                        t2.setSumSettleNumEndthis(settleDetailVO != null && settleDetailVO.getSumSettleNum() != null ? settleDetailVO.getSumSettleNum() : BigDecimal.ZERO);
                    }
                });
            }
        }
        return contractDetailVOS;
    }

    private void saveCost(SubSettleEntity settleEntity) {
        BigDecimal taxRate = settleEntity.getTaxRate().divide(new BigDecimal(100));
        BigDecimal number = taxRate.add(new BigDecimal(1));
        List<SubSettleDetailEntity> detailEntities = settleEntity.getSettleDetailList();
        SubContractEntity contractEntity = (SubContractEntity)((Object)this.contractService.selectById(settleEntity.getContractId()));
        Long contractType = contractEntity.getContractType();
        String contractTypeName = "";
        Integer costType = null;
        String sourceType = "SUB_SETTLE_PRO";
        if (contractType.equals(1270328729526124545L)) {
            sourceType = "SUB_SETTLE_LAB";
            contractTypeName = SubCostTypeEnum.LABOR_COST_TYPE.getName();
            costType = SubCostTypeEnum.LABOR_COST_TYPE.getType();
        } else {
            contractTypeName = SubCostTypeEnum.MAJOR_COST_TYPE.getName();
            costType = SubCostTypeEnum.MAJOR_COST_TYPE.getType();
        }
        String period = "";
        if (settleEntity.getSettleDate() != null) {
            SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM");
            period = ft.format(settleEntity.getSettleDate());
        }
    }

    private Boolean checkFinishContract(SubSettleVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BaseEntity::getId, (Object)finishVO.getContractId());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.eq(SubContractEntity::getFinishFlag, (Object)true);
        return this.contractService.list((Wrapper)lambda).size() > 0;
    }

    @Override
    public JSONObject querySettleDetailHistory(SubSettleDetailVO settleDetailVO) {
        QueryParam queryParam = new QueryParam();
        BigDecimal sumSettleNumEndthis = new BigDecimal(0);
        if (StringUtils.isNotBlank((CharSequence)settleDetailVO.getCode()) && StringUtils.isNotBlank((CharSequence)settleDetailVO.getName())) {
            settleDetailVO.setSourceType(2);
            List<SubSettleDetailVO> settleDetailList = ((SubSettleMapper)this.baseMapper).querySettleDetailHistory(settleDetailVO);
            if (CollectionUtils.isNotEmpty(settleDetailList)) {
                for (SubSettleDetailVO settleDetailVO1 : settleDetailList) {
                    sumSettleNumEndthis = BigDecimalUtils.safeAdd(sumSettleNumEndthis, settleDetailVO1.getSettleNum());
                }
            }
        }
        JSONObject jo = new JSONObject();
        jo.put("sumSettleNumEndthis", (Object)sumSettleNumEndthis);
        System.out.print(sumSettleNumEndthis.toString());
        return jo;
    }

    @Override
    public void updateSettleDetailHistory() {
        SubSettleDetailVO settleDetailVO = new SubSettleDetailVO();
        List<SubSettleDetailVO> settleDetailList = ((SubSettleMapper)this.baseMapper).querySettleDetailList(settleDetailVO);
        for (SubSettleDetailVO sd : settleDetailList) {
            SubSettleDetailVO sd_tmp = new SubSettleDetailVO();
            sd_tmp.setContractDetailId(sd.getContractDetailId());
            sd_tmp.setCreateTime(sd.getSettleCreateTime());
            String settleNumSum = ((SubSettleMapper)this.baseMapper).querySettleDetailSum(sd_tmp);
            if (StringUtils.isEmpty((CharSequence)settleNumSum)) {
                settleNumSum = "0";
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(SubSettleDetailEntity::getSumSettleNumEndthis, (Object)BigDecimalUtils.safeAdd(new BigDecimal(settleNumSum), sd.getSettleNum()));
            updateWrapper.set(SubSettleDetailEntity::getSumSettleNum, (Object)settleNumSum);
            updateWrapper.eq(BaseEntity::getId, (Object)sd.getId());
            boolean update = this.settleDetailService.update((Wrapper)updateWrapper);
            System.out.println("update:id=" + sd.getId() + ",settleNumSumEndthis=" + BigDecimalUtils.safeAdd(new BigDecimal(settleNumSum), sd.getSettleNum()) + ",settleNumSum=" + settleNumSum);
        }
    }

    @Override
    public SubSettleVO queryProjectAndLaborMny(Long projectId, String settleDate) {
        SubSettleVO settleVO = new SubSettleVO();
        BigDecimal total = BigDecimal.ZERO;
        ArrayList<Integer> stateList = new ArrayList<Integer>();
        stateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        stateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SubSettleEntity::getProjectId, (Object)projectId);
        queryWrapper.in(SubSettleEntity::getBillState, stateList);
        List settleEntities = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)settleEntities)) {
            for (SubSettleEntity settleEntity : settleEntities) {
                total = BigDecimalUtils.safeAdd(total, settleEntity.getSettleTaxMny());
            }
        }
        settleVO.setProjectSumMny(total);
        return settleVO;
    }

    @Override
    public SubParamsCheckVO checkParamsByContractNumAndMny(SubSettleCheckParamsVO settleCheckParamsVO) {
        Long curOrgId = Optional.ofNullable(settleCheckParamsVO.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        HashMap<String, List<SubParamsCheckDsVO>> paramsCheckVOMap = new HashMap<String, List<SubParamsCheckDsVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        BigDecimal contractTaxMny = settleCheckParamsVO.getContractTaxMny();
        Integer purchaseType = settleCheckParamsVO.getPurchaseType();
        BigDecimal sumSettleMentTaxMny = settleCheckParamsVO.getSumSettleMentTaxMny();
        int controlTypeIndex = 0;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        SubParamsCheckVO paramsCheckVO = new SubParamsCheckVO();
        ArrayList<SubParamsCheckDsVO> checkDsVOS = new ArrayList<SubParamsCheckDsVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, curOrgId);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            for (BillParamVO datum : data) {
                if (0 == datum.getControlType()) continue;
                BigDecimal roleValue = datum.getRoleValue();
                BigDecimal comMny = contractTaxMny.multiply(roleValue.divide(BigDecimal.valueOf(100L), 2, 4));
                if (2 == purchaseType) {
                    paramsCheckVO.setWarnType(paramsArray[controlTypeIndex]);
                    return paramsCheckVO;
                }
                if (sumSettleMentTaxMny.compareTo(comMny) <= 0) continue;
                controlTypeIndex = datum.getControlType() > controlTypeIndex ? datum.getControlType() : controlTypeIndex;
                SubParamsCheckDsVO paramsCheckDsVO = new SubParamsCheckDsVO();
                paramsCheckDsVO.setOrgName(datum.getOrgName());
                paramsCheckDsVO.setWarnItem("\u5408\u540c\u8d85\u7ed3");
                paramsCheckDsVO.setWarnName("\u8fc7\u7a0b\u7ed3\u7b97\u91d1\u989d\u8d85\u51fa\u5408\u540c\u91d1\u989d");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u672c\u6b21\u8fc7\u7a0b\u7ed3\u7b97\u91d1\u989d\uff1a").append(settleCheckParamsVO.getSettleTaxMny().setScale(2, 4)).append("\u5143,").append("\u542b\u672c\u6b21\u7d2f\u8ba1\u8fc7\u7a0b\u7ed3\u7b97\u91d1\u989d\uff1a").append(sumSettleMentTaxMny.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u7ed3\u91d1\u989d\uff1a").append(sumSettleMentTaxMny.subtract(comMny).setScale(2, 4)).append("\u5143");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                checkDsVOS.add(paramsCheckDsVO);
                SubSettleServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, datum, paramsCheckDsVO);
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        List<SubSettleDetailVO> detail = settleCheckParamsVO.getDetail();
        if (CollectionUtils.isNotEmpty(detail)) {
            CommonResponse billParamByCodeNum = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE_NUM, curOrgId);
            if (billParamByCodeNum.isSuccess() && null != billParamByCodeNum.getData()) {
                List data = (List)billParamByCodeNum.getData();
                for (BillParamVO datum : data) {
                    if (0 == datum.getControlType()) continue;
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal ratio = roleValue.divide(BigDecimal.valueOf(100L));
                    ArrayList<SubContractDetailVO> contractDetailVOList = new ArrayList<SubContractDetailVO>();
                    detail.forEach(t2 -> {
                        if (t2.getContractDetailId() != null) {
                            SubContractDetailVO contractDetailVO = new SubContractDetailVO();
                            contractDetailVO.setId(t2.getContractDetailId());
                            contractDetailVO.setLeafFlag(t2.getLeafFlag());
                            contractDetailVO.setNum(t2.getNum());
                            contractDetailVOList.add(contractDetailVO);
                        }
                    });
                    this.getSumSettleNum(contractDetailVOList);
                    if (!CollectionUtils.isNotEmpty(contractDetailVOList)) continue;
                    Map<Long, SubContractDetailVO> numMap = contractDetailVOList.stream().collect(Collectors.toMap(BaseVO::getId, a -> a, (k1, k2) -> k1));
                    for (SubSettleDetailVO settleDetailVO : detail) {
                        BigDecimal contractNumRatio;
                        BigDecimal contractNum;
                        Long contractDetailId = settleDetailVO.getContractDetailId();
                        if (contractDetailId == null) continue;
                        BigDecimal settleNum = settleDetailVO.getSettleNum();
                        SubContractDetailVO contractDetailVO = numMap.get(contractDetailId);
                        BigDecimal contractSumSettleNum = contractDetailVO != null ? contractDetailVO.getSumSettleNum() : BigDecimal.ZERO;
                        BigDecimal bigDecimal = contractNum = contractDetailVO != null ? contractDetailVO.getNum() : BigDecimal.ZERO;
                        BigDecimal sumHaveThis = com.ejianc.business.utils.ComputeUtil.safeAdd(settleNum, contractSumSettleNum);
                        if (!com.ejianc.business.utils.ComputeUtil.isGreaterThan(sumHaveThis, contractNumRatio = com.ejianc.business.utils.ComputeUtil.safeMultiply(contractNum, ratio))) continue;
                        controlTypeIndex = datum.getControlType() > controlTypeIndex ? datum.getControlType() : controlTypeIndex;
                        SubParamsCheckDsVO paramsCheckDsVO = new SubParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u6e05\u5355\u540d\u79f0\uff1a" + settleDetailVO.getName() + "\uff0c\u8ba1\u91cf\u5355\u4f4d\uff1a" + (StringUtils.isNotEmpty((CharSequence)settleDetailVO.getUnit()) ? settleDetailVO.getUnit() : "\u65e0"));
                        paramsCheckDsVO.setWarnName("\u8fc7\u7a0b\u7ed3\u7b97\u6570\u91cf\u5927\u4e8e\u5408\u540c\u6570\u91cf");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u8fc7\u7a0b\u7ed3\u7b97\u6570\u91cf\uff1a").append(ComputeUtil.scaleStripTrailingZeros((BigDecimal)settleNum, (int)4)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u8fc7\u7a0b\u7ed3\u7b97\u6570\u91cf\uff1a").append(ComputeUtil.scaleStripTrailingZeros((BigDecimal)sumHaveThis, (int)4)).append("\uff0c\u5408\u540c\u6570\u91cf*").append(roleValue).append("%:").append(ComputeUtil.scaleStripTrailingZeros((BigDecimal)contractNumRatio, (int)4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(ComputeUtil.scaleStripTrailingZeros((BigDecimal)com.ejianc.business.utils.ComputeUtil.safeSub(sumHaveThis, contractNumRatio), (int)4));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                        SubSettleServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, datum, paramsCheckDsVO);
                    }
                }
            } else {
                this.logger.info(billParamByCode.getMsg());
                throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
            }
        }
        SubParamsCheckVO pc = new SubParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            pc.setWarnType("alert");
            pc.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            pc.setWarnType("warn");
            pc.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<SubSettleDetailVO> detailVoList = new ArrayList<SubSettleDetailVO>();
            HashMap<String, String> tidMap = new HashMap<String, String>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                SubSettleDetailVO vo = new SubSettleDetailVO();
                boolean flag = false;
                boolean parentWarn = false;
                String warnType = "";
                String detailIndex = (String)datas.get(0);
                vo.setTreeIndex(detailIndex);
                Long id = IdWorker.getId();
                if (StringUtils.isNotEmpty((CharSequence)detailIndex)) {
                    String[] split = detailIndex.split("[-/.]");
                    vo.setTid(String.valueOf(id));
                    vo.setId(id);
                    tidMap.put(detailIndex, String.valueOf(id));
                    if (split.length > 1) {
                        vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                    }
                } else {
                    vo.setTid(String.valueOf(id));
                    vo.setId(id);
                    vo.setTpid("");
                }
                if (indexMap.containsKey(detailIndex)) {
                    return CommonResponse.error((String)("\u7b2c" + (i + 2) + "\u884c\u5e8f\u53f7\u548c\u7b2c" + ((Integer)indexMap.get(detailIndex) + 2) + "\u884c\u91cd\u590d"));
                }
                indexMap.put(detailIndex, i);
                vo.setCode((String)datas.get(1));
                vo.setName((String)datas.get(2));
                vo.setSpec((String)datas.get(3));
                vo.setUnit((String)datas.get(4));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(5)))) {
                    vo.setSettleNum(null);
                    warnType = warnType + "\u672c\u671f\u7ed3\u7b97\u91cf\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setSettleNum(new BigDecimal((String)datas.get(5)));
                    }
                    catch (Exception e) {
                        vo.setSettleNum(null);
                        warnType = warnType + "\u672c\u671f\u7ed3\u7b97\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                try {
                    vo.setPrice(new BigDecimal((String)datas.get(6)));
                }
                catch (Exception e) {
                    vo.setPrice(null);
                    warnType = warnType + "\u7efc\u5408\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                    flag = true;
                }
                if (!flag) {
                    BigDecimal scale = ComputeUtil.scale((BigDecimal)com.ejianc.business.utils.ComputeUtil.safeMultiply(vo.getSettleNum(), vo.getPrice()), (int)2);
                    vo.setSettleMny(scale);
                }
                vo.setMemo((String)datas.get(7));
                vo.setImportFlag(!flag);
                vo.setParentWarn(parentWarn);
                if (flag) {
                    warnType = warnType.substring(0, warnType.length() - 1);
                }
                vo.setWarnType(warnType);
                vo.setRowState("add");
                vo.setShadowId(vo.getTid());
                vo.setSourceType(2);
                detailVoList.add(vo);
            }
            for (SubSettleDetailVO tVo : detailVoList) {
                tVo.setTpid((String)tidMap.get(tVo.getTpid()));
            }
            List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
            List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
            ArrayList<Map<String, Object>> falseList = new ArrayList<Map<String, Object>>();
            List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
            List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
            resp.put("successList", allList.get(0));
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)(result.size() - errorList.size()));
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<SubParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, SubParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<SubParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<SubParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }
}

