package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.bean.MaterialContractDetailSubEntity;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.mapper.InstoreMapper;
import com.ejianc.business.material.mapper.InstoreMaterialMapper;
import com.ejianc.business.material.pub.MaterialStoreState;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.service.IInstoreMaterialService;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.vo.InstoreAccountSumVO;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.*;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;


@Service
public class InstoreService  extends BaseServiceImpl<InstoreMapper, InstoreEntity> implements IInstoreService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IOutStoreService iOutStoreService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IInstoreMaterialService materialService;

    @Autowired
    private InstoreMaterialMapper instoreMaterialMapper;


    @Override
    public IPage<InstoreVO> queryForList(QueryParam queryParam, boolean isEs) {
        IPage<InstoreVO> voPage = null;
        IPage<InstoreEntity> entityPage = super.queryPage(queryParam,isEs);
        if(entityPage!=null){
            voPage = new Page<>();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize(queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList(entityPage.getRecords(),InstoreVO.class));
        }
        return voPage;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void sureToReceive(InstoreEntity entity) {
        entity.getInstoreMaterialList().forEach(e->{
            e.setStoreId(entity.getStoreId());
            e.setStoreState(MaterialStoreState.STORED.getCode());
        });
        super.saveOrUpdate(entity,false);
        OutStoreEntity outStoreEntity = iOutStoreService.selectById(entity.getOutId());
        if(outStoreEntity == null ){
            throw new BusinessException("没有找到对应调拨出库单，确认收料失败！");
        }
        outStoreEntity.setReceiveState(entity.getReceiveState());
        outStoreEntity.setReceivePerson(entity.getReceivePerson());
        outStoreEntity.getOutStoreSubEntities().forEach(o-> o.setStoreState(MaterialStoreState.USED.getCode()));
        iOutStoreService.saveOrUpdate(outStoreEntity,false);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void sureToReturn(InstoreEntity entity) {
        super.saveOrUpdate(entity,false);
        OutStoreEntity outStoreEntity = iOutStoreService.selectById(entity.getOutId());
        if(outStoreEntity == null ){
            throw new BusinessException("没有找到对应调拨出库单，确认收料失败！");
        }
        outStoreEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        outStoreEntity.setReceiveState(entity.getReceiveState());
        outStoreEntity.setReceivePerson(entity.getReceivePerson());
        outStoreEntity.setReturnReason(entity.getPickReturnReason());
        outStoreEntity.getOutStoreSubEntities().forEach(o-> o.setStoreState(MaterialStoreState.OCCUPY.getCode()));
        iOutStoreService.saveOrUpdate(outStoreEntity,false);
    }

    @Override
    public void processCost(InstoreEntity entity) {
        String factor = "1";
        if(MaterialStoreType.RETURN_IN_STORE.getCode().equals(entity.getInstoreType())){
            factor = "-1";
        }
    }

    @Override
    public List<InstoreMaterialVO> instoreNumCount(Map<String, Object> queryParam) {
        return instoreMaterialMapper.instoreNumCount(queryParam);
    }

    @Override
    public List<InstoreAccountSumVO> amountSum(List<Long> projectIds) {
        return instoreMaterialMapper.amountSum(projectIds);
    }

    @Override
    public BigDecimal calculateTotalSettlement(QueryParam queryParam) {
        QueryWrapper<InstoreEntity> query = changeToQueryWrapper(queryParam);
        query.select("sum(total_amount) as totalAmount");
        Map<String, Object> amount = super.getMap(query);
        return null != amount ? new BigDecimal(amount.get("totalAmount").toString()) : BigDecimal.ZERO.setScale(8);
    }

    @Override
    public List<MaterialContractDetailSubEntity> totalResidualQuantity(List<MaterialContractDetailSubEntity> records ){
        Map<Long, MaterialContractDetailSubEntity> detailMap = records.stream().collect(Collectors.toMap(MaterialContractDetailSubEntity::getId, e -> e));
        List<Long> ids=new ArrayList(detailMap.keySet());
        //查询对应清单的入库数量
        QueryWrapper<InstoreMaterialEntity> query = new QueryWrapper<>();
        query.select("source_id as sourceId,sum(instore_number) as instoreNumber");
        query.eq("source_type","contractMaterial");
        query.in("source_id",ids);
        query.groupBy("source_id");
        List<InstoreMaterialEntity> list = materialService.list(query);
        if (CollectionUtils.isEmpty(list)){
            for (MaterialContractDetailSubEntity entity:records){
                entity.setResidualQuantity(entity.getCount());
            }
            return records;
        }
        Map<Long, BigDecimal> collect = list.stream().collect(Collectors.toMap(InstoreMaterialEntity::getSourceId, InstoreMaterialEntity::getInstoreNumber));
        for (Long id:ids){
            BigDecimal bigDecimal = BigDecimal.ZERO;
            if (collect.containsKey(id)){
                bigDecimal= collect.get(id).compareTo(new BigDecimal(0E-8))==0?new BigDecimal(0):collect.get(id);;
            }
            MaterialContractDetailSubEntity detailSub = detailMap.get(id);
            if (bigDecimal.compareTo(detailSub.getCount())>-1){
                detailMap.remove(id);
            }else {
                detailSub.setResidualQuantity(detailSub.getCount().subtract(bigDecimal));
                detailMap.put(id,detailSub);
            }
        }
        Collection<MaterialContractDetailSubEntity> values = detailMap.values();
        return new ArrayList<>(values);
    }


    @Override
    public CommonResponse<String> updateInStoreSettleFlag(List<InstoreMaterialVO> vos){
        Map<String, List<InstoreMaterialVO>> groupList = vos.stream().collect(Collectors.groupingBy(InstoreMaterialVO::getSettleFlag));
        if (groupList.containsKey("1")){
            List<InstoreMaterialVO> settleTrueList = groupList.get("1");
            List<Long> settleTrueIds = settleTrueList.stream().map(e -> e.getId()).collect(Collectors.toList());
            LambdaUpdateWrapper<InstoreMaterialEntity> wrapper = new LambdaUpdateWrapper();
            wrapper.in(InstoreMaterialEntity::getId,settleTrueIds);
            wrapper.set(InstoreMaterialEntity::getSettleFlag,"1");
            materialService.update(wrapper);
        }
        if (groupList.containsKey("0")){
            List<InstoreMaterialVO> settleFalseList = groupList.get("0");
            List<Long> settleFalseIds = settleFalseList.stream().map(e -> e.getId()).collect(Collectors.toList());
            LambdaUpdateWrapper<InstoreMaterialEntity> wrapper = new LambdaUpdateWrapper();
            wrapper.in(InstoreMaterialEntity::getId,settleFalseIds);
            wrapper.set(InstoreMaterialEntity::getSettleFlag,"0");
            materialService.update(wrapper);
        }
        return CommonResponse.success("保存或修改单据成功！","");
    }

}
