package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.sub.bean.SubRecordDetailEntity;
import com.ejianc.business.sub.bean.SubRecordEntity;
import com.ejianc.business.sub.enums.ChangeTypeEnum;
import com.ejianc.business.sub.mapper.SubRecordMapper;
import com.ejianc.business.sub.service.ISubRecordDetailService;
import com.ejianc.business.sub.service.ISubRecordService;
import com.ejianc.business.sub.utils.TreeNodeBUtil;
import com.ejianc.business.sub.vo.SubContractDetailVO;
import com.ejianc.business.sub.vo.SubContractVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 分包合同记录表 服务实现类
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@Service("SubRecordServiceImpl")
public class SubRecordServiceImpl extends BaseServiceImpl<SubRecordMapper, SubRecordEntity> implements ISubRecordService {

    @Autowired
    ISubRecordDetailService recordDetailService;

    @Override
    public SubContractVO queryDetail(Long id, Boolean detailHasChildren) {
//        RecordEntity contractEntity = super.selectById(id);
        LambdaQueryWrapper<SubRecordEntity> lambda = Wrappers.<SubRecordEntity>lambdaQuery();
        lambda.eq(SubRecordEntity::getChangeId, id);
        SubRecordEntity contractEntity1 = super.getOne(lambda);
        SubRecordEntity contractEntity = super.selectById(contractEntity1.getId());
        SubContractVO contractVO =  BeanMapper.map(contractEntity, SubContractVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("recordId", new Parameter(QueryParam.EQ, contractEntity.getId()));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List<SubRecordDetailEntity> detailEntityListDb = recordDetailService.queryList(queryParam, false);
        List<SubRecordDetailEntity> detailEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity ->{
                if(null == entity.getChangeType() || ChangeTypeEnum.中止.getCode() != entity.getChangeType()){
                    detailEntityList.add(entity);
                }
            });
        }
        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(SubRecordDetailEntity cdEntity : detailEntityList){
                cdEntity.setTid(cdEntity.getContractDetailId().toString());
                cdEntity.setId(cdEntity.getContractDetailId());
                cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
                cdEntity.setRowState("edit");
            }
            List<SubContractDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, SubContractDetailVO.class);
            if(detailHasChildren){
                contractVO.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
            }else {
                contractVO.setDetailList(resultMapList);
            }
        }

        return contractVO;
    }
}
