package com.ejianc.business.sub.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 分包完工结算表
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
public class SubFinishRecordDetailVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 结算单号
     */
    private String  billCode;

    /**
     * 合同主键
     */
    private Long contractId;

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 项目
     */
    private Long projectId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 组织
     */
    private Long orgId;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 经办人
     */
    private Long employeeId;

    /**
     * 经办人名称
     */
    private String employeeName;

    /**
     * 分包供应商
     */
    private Long supplierId;

    /**
     * 分包供应商名称
     */
    private String supplierName;

    /**
     * 结算日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settleDate;

    /**
     * 分包类型
     */
    private Long contractType;

    /**
     * 分包合同金额(不含税)
     */
    private BigDecimal contractMny;

    /**
     * 分包合同金额
     */
    private BigDecimal contractTaxMny;

    /**
     * 合同税率
     */
    private BigDecimal taxRate;

    /**
     * 完工结算金额(不含税)
     */
    private BigDecimal settleMny;

    /**
     * 完工结算金额(含税)
     */
    private BigDecimal settleTaxMny;

    /**
     * 税金
     */
    private BigDecimal taxMny;

    /**
     * 累计结算金额(不含税)
     */
    private BigDecimal sumSettleMny;

    /**
     * 累计结算金额
     */
    private BigDecimal sumSettleTaxMny;

    /**
     * 累计零工结算金额（含税）
     */
    private BigDecimal sumOddjobTaxMny;

    /**
     * 累计零工结算金额
     */
    private BigDecimal sumOddjobMny;

    /**
     * 本次零工结算金额（含税）
     */
    private BigDecimal oddjobTaxMny;

    /**
     * 本次零工结算金额
     */
    private BigDecimal oddjobMny;

    /**
     * 累计其他结算金额（含税）
     */
    private BigDecimal sumOtherTaxMny;

    /**
     * 累计其他结算金额
     */
    private BigDecimal sumOtherMny;

    /**
     * 本次其他结算金额（含税）
     */
    private BigDecimal otherTaxMny;

    /**
     * 本次其他结算金额
     */
    private BigDecimal otherMny;

    /**
     * 完工结算应付金额（含税）
     */
    private BigDecimal shouldPayTaxMny;

    /**
     * 完工结算应付金额
     */
    private BigDecimal shouldPayMny;

    /**
     * 单据状态（审批必须字段）
     */
    private Integer billState;

    private BigDecimal sumScale;

    /**
     * 备注
     */
    private String memo;

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode="zydx-subContract")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractType() {
        return contractType;
    }
    @ReferDeserialTransfer
    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }
    public BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    public void setSettleTaxMny(BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getSumSettleMny() {
        return sumSettleMny;
    }

    public void setSumSettleMny(BigDecimal sumSettleMny) {
        this.sumSettleMny = sumSettleMny;
    }
    public BigDecimal getSumSettleTaxMny() {
        return sumSettleTaxMny;
    }

    public void setSumSettleTaxMny(BigDecimal sumSettleTaxMny) {
        this.sumSettleTaxMny = sumSettleTaxMny;
    }
    public BigDecimal getSumOddjobTaxMny() {
        return sumOddjobTaxMny;
    }

    public void setSumOddjobTaxMny(BigDecimal sumOddjobTaxMny) {
        this.sumOddjobTaxMny = sumOddjobTaxMny;
    }
    public BigDecimal getSumOddjobMny() {
        return sumOddjobMny;
    }

    public void setSumOddjobMny(BigDecimal sumOddjobMny) {
        this.sumOddjobMny = sumOddjobMny;
    }
    public BigDecimal getSumOtherTaxMny() {
        return sumOtherTaxMny;
    }

    public void setSumOtherTaxMny(BigDecimal sumOtherTaxMny) {
        this.sumOtherTaxMny = sumOtherTaxMny;
    }
    public BigDecimal getSumOtherMny() {
        return sumOtherMny;
    }

    public void setSumOtherMny(BigDecimal sumOtherMny) {
        this.sumOtherMny = sumOtherMny;
    }

    public BigDecimal getOddjobTaxMny() {
        return oddjobTaxMny;
    }

    public void setOddjobTaxMny(BigDecimal oddjobTaxMny) {
        this.oddjobTaxMny = oddjobTaxMny;
    }

    public BigDecimal getOddjobMny() {
        return oddjobMny;
    }

    public void setOddjobMny(BigDecimal oddjobMny) {
        this.oddjobMny = oddjobMny;
    }

    public BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    public void setOtherTaxMny(BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }

    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }

    public BigDecimal getShouldPayTaxMny() {
        return shouldPayTaxMny;
    }

    public void setShouldPayTaxMny(BigDecimal shouldPayTaxMny) {
        this.shouldPayTaxMny = shouldPayTaxMny;
    }

    public BigDecimal getShouldPayMny() {
        return shouldPayMny;
    }

    public void setShouldPayMny(BigDecimal shouldPayMny) {
        this.shouldPayMny = shouldPayMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public BigDecimal getSumScale() {
        return sumScale;
    }

    public void setSumScale(BigDecimal sumScale) {
        this.sumScale = sumScale;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
}
