package com.ejianc.business.asset.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.asset.bean.AssetInDetailEntity;
/**
 * 固定资产调入
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zypms_asset_in")
public class AssetInEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="receive_person_id")
    private Long receivePersonId; // 收料人
    @TableField(value="receive_person_name")
    private String receivePersonName; // 收料人
    @TableField(value="receive_state")
    private String receiveState; // 收料状态 1-待收料 2-已收料 3-已退回
    @TableField(value="receive_date")
    private Date receiveDate; // 调拨入库时候，记录收料日期
    @TableField(value="out_id")
    private Long outId; // 调拨入库时候，记录调拨出库主表id
    @TableField(value="out_date")
    private Date outDate; // 调出日期
    @TableField(value="out_org_id")
    private Long outOrgId; // 调拨入库时候，记录调拨出库主表调出组织id
    @TableField(value="out_org_name")
    private String outOrgName; // 调拨入库时候，记录调拨出库主表调出组织
    @TableField(value="out_project_id")
    private Long outProjectId; // 调拨入库时候，记录调拨出库主表调出项目id
    @TableField(value="out_project_name")
    private String outProjectName; // 调拨入库时候，记录调拨出库主表调出项目名称
    @TableField(value="out_project_code")
    private String outProjectCode; // 调拨入库时候，记录调拨出库主表调出项目编码
    @TableField(value="out_mny")
    private BigDecimal outMny; // 调出金额
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="out_depend_on_project")
    private Integer outDependOnProject; // 是否属于项目: 默认为true
    @TableField(value="depend_on_project")
    private Integer dependOnProject; // 是否属于项目: 默认为true
    @TableField(value="project_name")
    private String projectName; // 调入项目名称
    @TableField(value="project_code")
    private String projectCode; // 调入项目编码
    @TableField(value="project_id")
    private Long projectId; // 调入项目id
    @TableField(value="org_id")
    private Long orgId; // 调入组织id
    @TableField(value="org_name")
    private String orgName; // 调入组织名称
    @TableField(value="note")
    private String note; // 备注
    @TableField(value="pick_return_person")
    private String pickReturnPerson; // 退料人
    @TableField(value="pick_return_reason")
    private String pickReturnReason; // 退料原因
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="assetInDetailService", pidName = "assetInId")
    private List<AssetInDetailEntity> detailList = new ArrayList<>(); // 固定资产调入-子实体
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getReceivePersonId() {
        return receivePersonId;
    }

    public void setReceivePersonId(Long receivePersonId) {
        this.receivePersonId = receivePersonId;
    }
    public String getReceivePersonName() {
        return receivePersonName;
    }

    public void setReceivePersonName(String receivePersonName) {
        this.receivePersonName = receivePersonName;
    }
    public String getReceiveState() {
        return receiveState;
    }

    public void setReceiveState(String receiveState) {
        this.receiveState = receiveState;
    }
    public Date getReceiveDate() {
        return receiveDate;
    }

    public void setReceiveDate(Date receiveDate) {
        this.receiveDate = receiveDate;
    }
    public Long getOutId() {
        return outId;
    }

    public void setOutId(Long outId) {
        this.outId = outId;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    public Long getOutOrgId() {
        return outOrgId;
    }

    public void setOutOrgId(Long outOrgId) {
        this.outOrgId = outOrgId;
    }
    public String getOutOrgName() {
        return outOrgName;
    }

    public void setOutOrgName(String outOrgName) {
        this.outOrgName = outOrgName;
    }
    public Long getOutProjectId() {
        return outProjectId;
    }

    public void setOutProjectId(Long outProjectId) {
        this.outProjectId = outProjectId;
    }
    public String getOutProjectName() {
        return outProjectName;
    }

    public void setOutProjectName(String outProjectName) {
        this.outProjectName = outProjectName;
    }
    public String getOutProjectCode() {
        return outProjectCode;
    }

    public void setOutProjectCode(String outProjectCode) {
        this.outProjectCode = outProjectCode;
    }
    public BigDecimal getOutMny() {
        return outMny;
    }

    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getOutDependOnProject() {
        return outDependOnProject;
    }

    public void setOutDependOnProject(Integer outDependOnProject) {
        this.outDependOnProject = outDependOnProject;
    }
    public Integer getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(Integer dependOnProject) {
        this.dependOnProject = dependOnProject;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }
    public String getPickReturnPerson() {
        return pickReturnPerson;
    }

    public void setPickReturnPerson(String pickReturnPerson) {
        this.pickReturnPerson = pickReturnPerson;
    }
    public String getPickReturnReason() {
        return pickReturnReason;
    }

    public void setPickReturnReason(String pickReturnReason) {
        this.pickReturnReason = pickReturnReason;
    }


    public List<AssetInDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<AssetInDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
