package com.ejianc.business.income.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * <p>
 * 产值进度-签证索赔
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@TableName("ejc_zypms_income_production_claim")
public class ProductionClaimEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 产值进度主键
     */
    @TableField("production_id")
    private Long productionId;

    /**
     * 签证变更主键
     */
    @TableField("claim_id")
    private Long claimId;

    /**
     * 签证变更单号
     */
    @TableField("claim_code")
    private String claimCode;

    /**
     * 变更摘要
     */
    @TableField("change_summary")
    private String changeSummary;

    /**
     * 变更类型，1-现场签证，2-变更洽商，3-索赔
     */
    @TableField("change_type")
    private Integer changeType;

    /**
     * 批复金额
     */
    @TableField("reply_mny")
    private BigDecimal replyMny;

    /**
     * 本期统计金额
     */
    @TableField("occur_mny")
    private BigDecimal occurMny;

    /**
     * 累计统计金额
     */
    @TableField("sum_occur_mny")
    private BigDecimal sumOccurMny;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    public Long getProductionId() {
        return productionId;
    }

    public void setProductionId(Long productionId) {
        this.productionId = productionId;
    }
    public Long getClaimId() {
        return claimId;
    }

    public void setClaimId(Long claimId) {
        this.claimId = claimId;
    }
    public String getClaimCode() {
        return claimCode;
    }

    public void setClaimCode(String claimCode) {
        this.claimCode = claimCode;
    }
    public String getChangeSummary() {
        return changeSummary;
    }

    public void setChangeSummary(String changeSummary) {
        this.changeSummary = changeSummary;
    }
    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }
    public BigDecimal getReplyMny() {
        return replyMny;
    }

    public void setReplyMny(BigDecimal replyMny) {
        this.replyMny = replyMny;
    }
    public BigDecimal getOccurMny() {
        return occurMny;
    }

    public void setOccurMny(BigDecimal occurMny) {
        this.occurMny = occurMny;
    }
    public BigDecimal getSumOccurMny() {
        return sumOccurMny;
    }

    public void setSumOccurMny(BigDecimal sumOccurMny) {
        this.sumOccurMny = sumOccurMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @Override
    public String toString() {
        return "ProductionClaimEntity{" +
            "productionId=" + productionId +
            ", claimId=" + claimId +
            ", claimCode=" + claimCode +
            ", changeSummary=" + changeSummary +
            ", changeType=" + changeType +
            ", replyMny=" + replyMny +
            ", occurMny=" + occurMny +
            ", sumOccurMny=" + sumOccurMny +
            ", memo=" + memo +
        "}";
    }
}
