package com.ejianc.business.income.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.vo.report.IncomeReportMnyVo;
import com.ejianc.business.income.vo.report.ProjectMnyVO;
import com.ejianc.business.income.vo.report.ProjectReportVo;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;

public interface IReportService extends IBaseService<ContractEntity> {
    JSONObject pageList(QueryParam param);

    JSONObject monthPageList(QueryParam param);

    ProjectReportVo projectMonth(Long projectId, Integer lastDay);

    BigDecimal sumContractMny(Long projectId);

    List<ProjectReportVo> getMonthProductionMny(Long projectId, Integer lastDay);

    IncomeReportMnyVo getIncomeMny(Long projectId);

    List<ProjectReportVo> getMonthProduction(Long projectId);


    List<ProjectMnyVO> queryProjectMnyList(Page<ProjectMnyVO> page,QueryWrapper wrapper);
}
