package com.ejianc.business.other.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;


/**
 * 结算清单
 * 
 * @author generator
 * 
 */
public class OtherSettleDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long settleId; // 结算主键
    private String code; // 清单编号
    private String name; // 清单名称
    private String unit; // 计量单位
    private BigDecimal num; // 工程量
    private BigDecimal settleNum; // 本期结算量
    private BigDecimal detailTaxRate; // 税率
    private BigDecimal detailPrice; // 单价(无税)
    private BigDecimal detailTaxPrice; // 单价(含税)
    private BigDecimal detailMny; // 结算金额(无税)
    private BigDecimal detailTaxMny; // 结算金额(含税)
    private BigDecimal detailTax; // 税额
    private String detailMemo; // 备注
    private String sourceType; // 来源,0-合同内，1-合同外
    private String sourceTypeName;
    private Long sourceId; // 来源主键
    private Long sourceDetailId; // 来源预算id
    /**
     * 成本科目主键
     */
    private Long subjectId;

    /**
     * 成本科目名称
     */
    private String subjectName;

    /**
     * 成本科目集团主键
     */
    private Long orgSubjectId;

    /**
     * 核算对象主键
     */
    private Long accountingId;

    /**
     * 核算对象名称
     */
    private String accountingName;

    /**
     * 核算对象集团主键
     */
    private Long orgAccountingId;

    private String settlementCode;

    private BigDecimal sumNum;


    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }

    public BigDecimal getSumNum() {
		return sumNum;
	}
	public void setSumNum(BigDecimal sumNum) {
		this.sumNum = sumNum;
	}


    public String getSourceTypeName() {
		return sourceTypeName;
	}

	public void setSourceTypeName(String sourceTypeName) {
		this.sourceTypeName = sourceTypeName;
	}

	public String getSettlementCode() {
		return settlementCode;
	}

	public void setSettlementCode(String settlementCode) {
		this.settlementCode = settlementCode;
	}

    @ReferSerialTransfer(referCode="cost-subject-set")
    public Long getSubjectId() {
        return subjectId;
    }

    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public Long getOrgSubjectId() {
        return orgSubjectId;
    }

    public void setOrgSubjectId(Long orgSubjectId) {
        this.orgSubjectId = orgSubjectId;
    }

    @ReferSerialTransfer(referCode="accounting-project-ref")
    public Long getAccountingId() {
        return accountingId;
    }
    @ReferDeserialTransfer
    public void setAccountingId(Long accountingId) {
        this.accountingId = accountingId;
    }

    public String getAccountingName() {
        return accountingName;
    }

    public void setAccountingName(String accountingName) {
        this.accountingName = accountingName;
    }

    public Long getOrgAccountingId() {
        return orgAccountingId;
    }

    public void setOrgAccountingId(Long orgAccountingId) {
        this.orgAccountingId = orgAccountingId;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    /**
     * 结算主键
     */
    public Long getSettleId() {
        return settleId;
    }

    /**
     * 结算主键
     */
    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }
    /**
     * 清单编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 清单编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 清单名称
     */
    public String getName() {
        return name;
    }

    /**
     * 清单名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 工程量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 工程量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }
    /**
     * 本期结算量
     */
    public BigDecimal getSettleNum() {
        return settleNum;
    }

    /**
     * 本期结算量
     */
    public void setSettleNum(BigDecimal settleNum) {
        this.settleNum = settleNum;
    }
    /**
     * 税率
     */
    public BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    /**
     * 税率
     */
    public void setDetailTaxRate(BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }
    /**
     * 单价(无税)
     */
    public BigDecimal getDetailPrice() {
        return detailPrice;
    }

    /**
     * 单价(无税)
     */
    public void setDetailPrice(BigDecimal detailPrice) {
        this.detailPrice = detailPrice;
    }
    /**
     * 单价(含税)
     */
    public BigDecimal getDetailTaxPrice() {
        return detailTaxPrice;
    }

    /**
     * 单价(含税)
     */
    public void setDetailTaxPrice(BigDecimal detailTaxPrice) {
        this.detailTaxPrice = detailTaxPrice;
    }
    /**
     * 结算金额(无税)
     */
    public BigDecimal getDetailMny() {
        return detailMny;
    }

    /**
     * 结算金额(无税)
     */
    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }
    /**
     * 结算金额(含税)
     */
    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    /**
     * 结算金额(含税)
     */
    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }
    /**
     * 税额
     */
    public BigDecimal getDetailTax() {
        return detailTax;
    }

    /**
     * 税额
     */
    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }
    /**
     * 备注
     */
    public String getDetailMemo() {
        return detailMemo;
    }

    /**
     * 备注
     */
    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }
    /**
     * 来源,0-合同内，1-合同外
     */
    public String getSourceType() {
        return sourceType;
    }

    /**
     * 来源,0-合同内，1-合同外
     */
    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    
}
