/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.other.bean.OtherSettleEntity;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.IOtherSettleService;
import com.ejianc.business.other.vo.OtherContractPayPlanVO;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.business.other.vo.OtherSettleDetailVO;
import com.ejianc.business.other.vo.OtherSettleVO;
import com.ejianc.business.other.vo.SettleHistoryVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"otherSettle"})
public class OtherSettleController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOtherContractService otherContractService;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IOtherSettleService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OtherSettleVO> saveOrUpdate(@RequestBody OtherSettleVO saveorUpdateVO) {
        CommonResponse<OtherSettleVO> response = this.service.saveOrUpdate(saveorUpdateVO);
        return response;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OtherSettleVO> queryDetail(Long id) {
        OtherSettleVO vo = this.service.queryDetail(id);
        return CommonResponse.success((Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OtherSettleVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OtherSettleVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        boolean payApplyFlagHasFree = param.getParams().containsKey("payApplyFlagHasFree");
        param.getParams().remove("payApplyFlagHasFree");
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List voList = BeanMapper.mapList((Iterable)page.getRecords(), OtherSettleVO.class);
        pageData.setRecords(voList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List entityList = this.service.queryList(param);
        List list = BeanMapper.mapList((Iterable)entityList, OtherSettleVO.class);
        list.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("OtherSettle-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refOtherSettleData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OtherSettleVO>> refOtherSettleData(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="condition", required=false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("supplierName");
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        queryParam.getOrderMap().put("create_time", "desc");
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            JSONObject con = JSONObject.parseObject((String)condition);
            if (condition.contains("contractId")) {
                queryParam.getParams().put("contractId", new Parameter("eq", (Object)con.getLong("contractId")));
            }
            if (condition.contains("orgId")) {
                queryParam.getParams().put("orgId", new Parameter("eq", (Object)con.getLong("orgId")));
            }
            if (condition.contains("supplierId")) {
                queryParam.getParams().put("supplierId", new Parameter("eq", (Object)con.getLong("supplierId")));
            }
        }
        IPage pageData = this.service.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        List voList = BeanMapper.mapList((Iterable)pageData.getRecords(), OtherSettleVO.class);
        result.setRecords(voList);
        return CommonResponse.success((String)"\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }

    @RequestMapping(value={"/querySettleHistory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleHistoryVo> querySettleHistory(@RequestParam Long id) {
        SettleHistoryVo vo = this.service.querySettleHistory(id);
        return CommonResponse.success((Object)((Object)vo));
    }

    @RequestMapping(value={"/querySumSettlementTaxMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OtherSettleVO> querySumSettlementTaxMny(@RequestParam Long contractId, @RequestParam Long orgId) {
        OtherSettleVO vo = new OtherSettleVO();
        Object sumPayMny = null;
        Object sumPrePayMny = null;
        vo.setSumPayMny(sumPayMny == null ? BigDecimal.ZERO : sumPayMny);
        vo.setSumPrepayMny(sumPrePayMny == null ? BigDecimal.ZERO : sumPrePayMny);
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambdachange.eq(OtherSettleEntity::getContractId, (Object)contractId);
        lambdachange.eq(OtherSettleEntity::getOrgId, (Object)orgId);
        lambdachange.in(OtherSettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = this.service.list((Wrapper)lambdachange);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal[] alreadyRentMoney = new BigDecimal[]{new BigDecimal("0.00").setScale(2, 4), new BigDecimal("0.00").setScale(2, 4)};
            list.forEach(e -> {
                alreadyRentMoney[0] = alreadyRentMoney[0].add(e.getSettleTaxMny() == null ? BigDecimal.ZERO : e.getSettleTaxMny());
                alreadyRentMoney[1] = alreadyRentMoney[1].add(e.getThisOffsetMny() == null ? BigDecimal.ZERO : e.getThisOffsetMny());
            });
            vo.setSumSettleTaxMny(alreadyRentMoney[0]);
            vo.setSumOffsetMny(alreadyRentMoney[1]);
        }
        BigDecimal sumOffsetMnys = vo.getSumOffsetMny() == null ? BigDecimal.ZERO : vo.getSumOffsetMny();
        OtherContractVO otherContractVO = this.otherContractService.queryDetail(contractId);
        List<OtherContractPayPlanVO> payPlanVos = otherContractVO.getPayPlanVos();
        if (CollectionUtils.isNotEmpty(payPlanVos)) {
            for (OtherContractPayPlanVO payPlanVo : payPlanVos) {
                payPlanVo.setName(payPlanVo.getPayPlanName());
                payPlanVo.setScale(payPlanVo.getPayRate());
            }
        }
        vo.setStageList(payPlanVos);
        return CommonResponse.success((Object)((Object)vo));
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage pageData = this.service.queryPage(param, false);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), OtherSettleVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/pushToCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OtherSettleVO> pushToCost(@RequestBody OtherSettleVO otherSettleVO) {
        CommonResponse<OtherSettleVO> response = this.service.pushToCost(otherSettleVO);
        return response;
    }

    @GetMapping(value={"/calculateAlreadyPurchaseMoney"})
    @ResponseBody
    public CommonResponse<JSONObject> calculateAlreadyPurchaseMoney(@RequestParam Long contractId, @RequestParam Long orgId) {
        if (contractId == null || orgId == null) {
            return CommonResponse.error((String)"\u53c2\u6570\u9519\u8bef\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getOrderMap().put("signDate", "desc");
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List entities = this.service.queryList(param, false);
        String lastTime = null;
        BigDecimal[] alreadyPurchaseMoney = new BigDecimal[]{new BigDecimal("0.00").setScale(2, 4), new BigDecimal("0.00").setScale(2, 4), new BigDecimal("0.00").setScale(2, 4)};
        if (ListUtil.isNotEmpty((List)entities)) {
            lastTime = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)((OtherSettleEntity)((Object)entities.get(0))).getSignDate());
            entities.forEach(e -> {
                alreadyPurchaseMoney[0] = alreadyPurchaseMoney[0].add(e.getSettleTaxMny() == null && !orgId.equals(e.getOrgId()) ? new BigDecimal("0.00").setScale(2, 4) : e.getSettleTaxMny());
                alreadyPurchaseMoney[1] = alreadyPurchaseMoney[1].add(e.getSettleMny() == null && !orgId.equals(e.getOrgId()) ? new BigDecimal("0.00").setScale(2, 4) : e.getSettleMny());
                alreadyPurchaseMoney[2] = alreadyPurchaseMoney[2].add(e.getThisOffsetMny() == null ? new BigDecimal("0.00").setScale(2, 4) : e.getThisOffsetMny());
            });
        }
        JSONObject data = new JSONObject();
        data.put("sumSettleTaxMny", (Object)alreadyPurchaseMoney[0].toString());
        data.put("sumSettleMny", (Object)alreadyPurchaseMoney[1].toString());
        data.put("sumOffsetMny", (Object)alreadyPurchaseMoney[2].toString());
        data.put("lastTime", (Object)lastTime);
        return CommonResponse.success((Object)data);
    }

    @PostMapping(value={"/settleExcelDownload"})
    public void settlementExcelDownload(HttpServletResponse response, @RequestBody OtherSettleVO vo) {
        HashMap<String, List<OtherSettleDetailVO>> beans = new HashMap<String, List<OtherSettleDetailVO>>();
        List<OtherSettleDetailVO> list = this.service.settlementExcelDownload(vo);
        beans.put("records", list);
        ExcelExport.getInstance().export("otherSettlement-detail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/downloadDescription"}, method={RequestMethod.POST})
    @ResponseBody
    public void downloadDescription(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"subject-description.xlsx", (String)"\u6210\u672c\u79d1\u76ee\u6302\u63a5\u8bf4\u660e");
    }
}

