package com.ejianc.business.othprice.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 报价记录-报价清单
 *
 * @author baipengyan
 */
@ApiModel(value = "OtherQuoteDetailVO", description = "报价记录-报价清单")
public class OtherQuoteDetailVO extends BaseVO {
	private static final long serialVersionUID = -1660360193572855729L;

	@ApiModelProperty(value = "报价单id")
	private Long quoteId;
	@ApiModelProperty(value = "询价单id")
	private Long inquiryId;
	@ApiModelProperty(value = "来源采购清单id")
	private Long sourceId;
	private String detailCode; // 编码
	private String detailName; // 名称
	@ApiModelProperty(value = "规格型号")
	private String spec;
	@ApiModelProperty(value = "计量单位")
	private String unit;
	@ApiModelProperty(value = "计划使用日期")
	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date planUseDate;
	@ApiModelProperty(value = "数量")
	private BigDecimal num;
	@ApiModelProperty(value = "参考价")
	private BigDecimal referPrice;
	@ApiModelProperty(value = "报价")
	private BigDecimal purchaseQuotePrice;
	@ApiModelProperty(value = "金额（询价单）")
	private BigDecimal purchaseInquiryMny;
	@ApiModelProperty(value = "金额")
	private BigDecimal purchaseMny;
	private BigDecimal purchaseQuotePriceNoTax; // 报价
	private BigDecimal purchaseMnyNoTax; // 金额
	@ApiModelProperty(value = "备注（询价单）")
	private String purchaseInquiryMemo;
	@ApiModelProperty(value = "备注")
	private String purchaseMemo;
	//供应商名称 冗余主表便于前端显示
	private String supplierName;

	private BigDecimal bidNum; // 中标数量
	private BigDecimal bidPrice; // 中标单价
	private BigDecimal bidMny; // 中标金额
	private BigDecimal residueNum; // 剩余采购数量

	private BigDecimal purchaseRate; // 报价税率


	public BigDecimal getPurchaseRate() {
		return purchaseRate;
	}

	public void setPurchaseRate(BigDecimal purchaseRate) {
		this.purchaseRate = purchaseRate;
	}


	public BigDecimal getPurchaseQuotePriceNoTax() {
		return purchaseQuotePriceNoTax;
	}

	public void setPurchaseQuotePriceNoTax(BigDecimal purchaseQuotePriceNoTax) {
		this.purchaseQuotePriceNoTax = purchaseQuotePriceNoTax;
	}

	public BigDecimal getPurchaseMnyNoTax() {
		return purchaseMnyNoTax;
	}

	public void setPurchaseMnyNoTax(BigDecimal purchaseMnyNoTax) {
		this.purchaseMnyNoTax = purchaseMnyNoTax;
	}

	public BigDecimal getResidueNum() {
		return residueNum;
	}

	public void setResidueNum(BigDecimal residueNum) {
		this.residueNum = residueNum;
	}

	public BigDecimal getBidNum() {
		return bidNum;
	}

	public void setBidNum(BigDecimal bidNum) {
		this.bidNum = bidNum;
	}

	public BigDecimal getBidPrice() {
		return bidPrice;
	}

	public void setBidPrice(BigDecimal bidPrice) {
		this.bidPrice = bidPrice;
	}

	public BigDecimal getBidMny() {
		return bidMny;
	}

	public void setBidMny(BigDecimal bidMny) {
		this.bidMny = bidMny;
	}
	public String getSupplierName() {
		return supplierName;
	}

	public void setSupplierName(String supplierName) {
		this.supplierName = supplierName;
	}

	public Long getQuoteId() {
		return quoteId;
	}

	public void setQuoteId(Long quoteId) {
		this.quoteId = quoteId;
	}

	public Long getInquiryId() {
		return inquiryId;
	}

	public void setInquiryId(Long inquiryId) {
		this.inquiryId = inquiryId;
	}

	public Long getSourceId() {
		return sourceId;
	}

	public void setSourceId(Long sourceId) {
		this.sourceId = sourceId;
	}


	public String getDetailCode() {
		return detailCode;
	}

	public void setDetailCode(String detailCode) {
		this.detailCode = detailCode;
	}

	public String getDetailName() {
		return detailName;
	}

	public void setDetailName(String detailName) {
		this.detailName = detailName;
	}

	public String getSpec() {
		return spec;
	}

	public void setSpec(String spec) {
		this.spec = spec;
	}

	public String getUnit() {
		return unit;
	}

	public void setUnit(String unit) {
		this.unit = unit;
	}

	public Date getPlanUseDate() {
		return planUseDate;
	}

	public void setPlanUseDate(Date planUseDate) {
		this.planUseDate = planUseDate;
	}

	public BigDecimal getNum() {
		return num;
	}

	public void setNum(BigDecimal num) {
		this.num = num;
	}

	public BigDecimal getReferPrice() {
		return referPrice;
	}

	public void setReferPrice(BigDecimal referPrice) {
		this.referPrice = referPrice;
	}

	public BigDecimal getPurchaseQuotePrice() {
		return purchaseQuotePrice;
	}

	public void setPurchaseQuotePrice(BigDecimal purchaseQuotePrice) {
		this.purchaseQuotePrice = purchaseQuotePrice;
	}

	public BigDecimal getPurchaseInquiryMny() {
		return purchaseInquiryMny;
	}

	public void setPurchaseInquiryMny(BigDecimal purchaseInquiryMny) {
		this.purchaseInquiryMny = purchaseInquiryMny;
	}

	public BigDecimal getPurchaseMny() {
		return purchaseMny;
	}

	public void setPurchaseMny(BigDecimal purchaseMny) {
		this.purchaseMny = purchaseMny;
	}

	public String getPurchaseInquiryMemo() {
		return purchaseInquiryMemo;
	}

	public void setPurchaseInquiryMemo(String purchaseInquiryMemo) {
		this.purchaseInquiryMemo = purchaseInquiryMemo;
	}

	public String getPurchaseMemo() {
		return purchaseMemo;
	}

	public void setPurchaseMemo(String purchaseMemo) {
		this.purchaseMemo = purchaseMemo;
	}

}
