package com.ejianc.business.material.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/1  采购结算单 物资明细表
 * @Description PurchaseSettlementMaterialDetailVO
 */
public class PurchaseSettlementMaterialDetailVO extends BaseVO {

    private static final long serialVersionUID = 2779265683203439571L;

    /**
     * 主表id
     */
    private Long pid;

    /**
     * 物资分类名称
     */
    private String materialTypeName;


    /**
     * 物资分类id
     */
    private Long materialTypeId;

    /**
     * 物资名称
     */
    private String materialName;

    /**
     * 物资id
     */
    private Long materialId;

    /**
     * 规格型号
     */
    private String model;

    /**
     * 计量单位
     */
    private String unit;
    private BigDecimal thisAddSettleNum;//已结算量(含本次)
    private BigDecimal settleNum;//已结算量(不含本次)
    /**
     * 结算数量
     */
    private BigDecimal num;

    /**
     * 结算单价
     */
    private BigDecimal price;

    /**
     * 金额
     */
    private BigDecimal money;

    /**
     * 备注
     */
    private String memo;

    /**
     * 数据来源类型
     */
    private String sourceType;

    /**
     * 数据来源类型
     */
    private String sourceTypeName;

    /**
     * 数据来源主表id
     */
    private Long sourceMainId;

    /**
     * 数据来源子表id
     */
    private Long sourceSubId;

    /**
     * 成本科目主键
     */
    private Long subjectId;

    /**
     * 成本科目名称
     */
    private String subjectName;

    /**
     * 税率
     */
    private BigDecimal taxRate;

    private BigDecimal planNum = BigDecimal.ZERO;;
    /**
     *
     */
    private BigDecimal planPrice = BigDecimal.ZERO;


    private BigDecimal minPrice;

    private BigDecimal maxPrice;


    private String materialInfo; // 采购物资名称
    private Long brandId; // 供应商品牌id
    private String brandName; // 供应商品牌
    private Long modelId; // 规格型号id
    private String thickness; // 厚度
    private String colour; // 色号/容重


    /**
     * 物资编码
     */
    private String materialCode;
    private String fixedMaterial;//是否固定资产1是0否

    public String getFixedMaterial() {
        return fixedMaterial;
    }

    public void setFixedMaterial(String fixedMaterial) {
        this.fixedMaterial = fixedMaterial;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }

    public BigDecimal getPlanPrice() {
        return planPrice;
    }

    public void setPlanPrice(BigDecimal planPrice) {
        this.planPrice = planPrice;
    }

    public BigDecimal getMinPrice() {
        return minPrice;
    }

    public void setMinPrice(BigDecimal minPrice) {
        this.minPrice = minPrice;
    }

    public BigDecimal getMaxPrice() {
        return maxPrice;
    }

    public void setMaxPrice(BigDecimal maxPrice) {
        this.maxPrice = maxPrice;
    }

    public String getPriceArea() {
        return priceArea;
    }

    public void setPriceArea(String priceArea) {
        this.priceArea = priceArea;
    }

    private String priceArea;

    public BigDecimal getThisAddSettleNum() {
        return thisAddSettleNum;
    }

    public void setThisAddSettleNum(BigDecimal thisAddSettleNum) {
        this.thisAddSettleNum = thisAddSettleNum;
    }

    public BigDecimal getSettleNum() {
        return settleNum;
    }

    public void setSettleNum(BigDecimal settleNum) {
        this.settleNum = settleNum;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceTypeName() {
        return sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    public Long getSourceMainId() {
        return sourceMainId;
    }

    public void setSourceMainId(Long sourceMainId) {
        this.sourceMainId = sourceMainId;
    }

    public Long getSourceSubId() {
        return sourceSubId;
    }

    public void setSourceSubId(Long sourceSubId) {
        this.sourceSubId = sourceSubId;
    }

    @ReferSerialTransfer(referCode="cost-subject-set")
    public Long getSubjectId() {
        return subjectId;
    }

    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getMaterialInfo() {
        return materialInfo;
    }

    public void setMaterialInfo(String materialInfo) {
        this.materialInfo = materialInfo;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getBrandId() {
        return brandId;
    }
    @ReferDeserialTransfer
    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }
    @ReferDeserialTransfer@ReferSerialTransfer(referCode = "support-defdoc")
    public Long getModelId() {
        return modelId;
    }
    @ReferDeserialTransfer
    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public String getThickness() {
        return thickness;
    }

    public void setThickness(String thickness) {
        this.thickness = thickness;
    }

    public String getColour() {
        return colour;
    }

    public void setColour(String colour) {
        this.colour = colour;
    }
}
