package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.cost.bean.EngdepartRespcostDetailEntity;
/**
 * 工程部责任成本
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zypms_cost_engdepart_respcost")
public class EngdepartRespcostEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="prjcontract_targetcost_id")
    private Long projectTargetcostId; // 项目目标成本
    @TableField(value="bill_state")
    private Integer billState; // 单据审批状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="org_id")
    private Long orgId; // 组织ID
    @TableField(value="allocate_contract_mny")
    private BigDecimal allocateContractMny; // 分配合同额
    @TableField(value="pub_unit_name")
    private String pubUnitName; // 发包单位名称
    @TableField(value="contract_unit_name")
    private String contractUnitName; // 承包单位名称
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 含税合同额
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 不含税合同额
    @TableField(value="start_date")
    private Date startDate; // 项目开工时间
    @TableField(value="finish_date")
    private Date finishDate; // 项目完工时间
    @TableField(value="establishment_org_id")
    private Long establishmentOrgId; // 编制单位ID
    @TableField(value="establishment_org_name")
    private String establishmentOrgName; // 编制单位名称
    @TableField(value="establishment_user_id")
    private Long establishmentUserId; // 编制人ID
    @TableField(value="establishment_user_name")
    private String establishmentUserName; // 编制人名称
    @TableField(value="establishment_date")
    private Date establishmentDate; // 编制日期
    @TableField(value="prebid_cost")
    private BigDecimal prebidCost; // 责任成本总金额
    @TableField(value="respcost_total")
    private BigDecimal respcostTotal; // 项目成本总额
    @TableField(value="prjsale_cost")
    private BigDecimal prjsaleCost; // 工程部销售费用
    @TableField(value="prjcost_gross_profit")
    private BigDecimal prjcostGrossProfit; // 项目毛利润
    @TableField(value="prjcost_rate")
    private String prjcostRate; // 项目毛利率
    @TableField(value="remark")
    private String remark; // 备注

    @TableField(exist=false)
    @SubEntity(serviceName="engdepartRespcostDetailService", pidName="respcostId")
    private List<EngdepartRespcostDetailEntity> engdepartRespcostDetailList = new ArrayList<>(); // 工程部责任成本明细


    public BigDecimal getPrebidCost() {
        return prebidCost;
    }

    public void setPrebidCost(BigDecimal prebidCost) {
        this.prebidCost = prebidCost;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getPubUnitName() {
        return pubUnitName;
    }

    public void setPubUnitName(String pubUnitName) {
        this.pubUnitName = pubUnitName;
    }
    public String getContractUnitName() {
        return contractUnitName;
    }

    public void setContractUnitName(String contractUnitName) {
        this.contractUnitName = contractUnitName;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }
    public Long getEstablishmentOrgId() {
        return establishmentOrgId;
    }

    public void setEstablishmentOrgId(Long establishmentOrgId) {
        this.establishmentOrgId = establishmentOrgId;
    }
    public String getEstablishmentOrgName() {
        return establishmentOrgName;
    }

    public void setEstablishmentOrgName(String establishmentOrgName) {
        this.establishmentOrgName = establishmentOrgName;
    }
    public Long getEstablishmentUserId() {
        return establishmentUserId;
    }

    public void setEstablishmentUserId(Long establishmentUserId) {
        this.establishmentUserId = establishmentUserId;
    }
    public String getEstablishmentUserName() {
        return establishmentUserName;
    }

    public void setEstablishmentUserName(String establishmentUserName) {
        this.establishmentUserName = establishmentUserName;
    }
    public Date getEstablishmentDate() {
        return establishmentDate;
    }

    public void setEstablishmentDate(Date establishmentDate) {
        this.establishmentDate = establishmentDate;
    }
    public BigDecimal getRespcostTotal() {
        return respcostTotal;
    }

    public void setRespcostTotal(BigDecimal respcostTotal) {
        this.respcostTotal = respcostTotal;
    }
    public BigDecimal getPrjsaleCost() {
        return prjsaleCost;
    }

    public void setPrjsaleCost(BigDecimal prjsaleCost) {
        this.prjsaleCost = prjsaleCost;
    }
    public BigDecimal getPrjcostGrossProfit() {
        return prjcostGrossProfit;
    }

    public void setPrjcostGrossProfit(BigDecimal prjcostGrossProfit) {
        this.prjcostGrossProfit = prjcostGrossProfit;
    }
    public String getPrjcostRate() {
        return prjcostRate;
    }

    public void setPrjcostRate(String prjcostRate) {
        this.prjcostRate = prjcostRate;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    

    public List<EngdepartRespcostDetailEntity> getEngdepartRespcostDetailList() {
        return engdepartRespcostDetailList;
    }

    public void setEngdepartRespcostDetailList(List<EngdepartRespcostDetailEntity> engdepartRespcostDetailList) {
        this.engdepartRespcostDetailList = engdepartRespcostDetailList;
    }

    public Long getProjectTargetcostId() {
        return projectTargetcostId;
    }

    public void setProjectTargetcostId(Long projectTargetcostId) {
        this.projectTargetcostId = projectTargetcostId;
    }

    public BigDecimal getAllocateContractMny() {
        return allocateContractMny;
    }

    public void setAllocateContractMny(BigDecimal allocateContractMny) {
        this.allocateContractMny = allocateContractMny;
    }
}
