package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.bean.OutStoreSubEntity;
import com.ejianc.business.material.mapper.InstoreBillMaterialMapper;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.mapper.OutStoreMapper;
import com.ejianc.business.material.mapper.OutStoreSubMapper;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.service.IPickRegisterService;
import com.ejianc.business.material.vo.*;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class OutStoreService extends BaseServiceImpl<OutStoreMapper, OutStoreEntity> implements IOutStoreService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private OutStoreSubMapper outStoreSubMapper;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static String PARAM_PLAN_COUNT = "P-72Q53Y26";
    @Autowired
    private MaterialContractMapper materialContractMapper;
    @Autowired
    private InstoreBillMaterialMapper instoreBillMaterialMapper;

    // 劳务队伍领料限额量控制材料出库量
    private static String PARAM_LABOR_LIMIT_COUNT = "P-29E6rb74";

    @Autowired
    private IPickRegisterService pickRegisterService;


    @Override
    public IPage<OutStoreVO> queryForList(QueryParam queryParam, boolean isEs) {
        IPage<OutStoreVO> voPage = null;
        IPage<OutStoreEntity> entityPage = super.queryPage(queryParam, isEs);
        if (entityPage != null) {
            voPage = new Page<>();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize(queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList(entityPage.getRecords(), OutStoreVO.class));
        }
        return voPage;
    }

    @Override
    public void processCost(OutStoreEntity entity) {
        String factor = "1";
    }

    /**
     * @param topN
     * @param type
     * @Author mrsir_wxp
     * @Date 2021/2/21 查询物资开累年累消耗top n
     * @Description queryMaterialCostTopN
     * @Param topN 消耗前几位
     * @Param type 1、开累，2、年累  默认年累top5
     * @Return java.util.List<com.alibaba.fastjson.JSONObject>
     */
    @Override
    public CommonResponse<List<JSONObject>> queryMaterialCostTopN(Integer topN, Integer type) {
        List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        String startDate = DateFormatUtil.formatDate("yyyy-MM-dd", DateUtil.beginOfYear(new Date()));
        startDate = "'" + startDate + "'";
//        List<OutStoreSubVO> outStoreSubEntities = outStoreSubMapper.queryMaterialCostTopN(topN,type,startDate,orgIds);
        List<OutStoreSubVO> outStoreSubEntities = outStoreSubMapper.queryMaterialCategoryCostTopN(topN, type, startDate, orgIds);
        List<JSONObject> result = new ArrayList<>();
        logger.info("查询物资开累年累消耗top n outStoreSubEntities 数量：" + (ListUtil.isNotEmpty(outStoreSubEntities) ? outStoreSubEntities.size() : "空") + " 当前orgId：" + InvocationInfoProxy.getOrgId());
        if (ListUtil.isNotEmpty(outStoreSubEntities)) {
            outStoreSubEntities.forEach(en -> {
                JSONObject object = new JSONObject();
//                object.put("materialName",en.getMaterialName());
//                object.put("materialSpec",en.getMaterialSpec());
//                object.put("materialUnit",en.getMaterialUnit());
                object.put("materialCategoryName", en.getMaterialCategoryName());
                object.put("outStoreNumber", en.getOutStoreNumber());
                object.put("amount", en.getAmount());
                object.put("weight", ComputeUtil.safeMultiply(en.getUnitPrice(), new BigDecimal("100")).setScale(0, BigDecimal.ROUND_HALF_UP) + "%");
                result.add(object);
            });
        }
        return CommonResponse.success(result);
    }


    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public ParamsCheckVO checkParams(MaterialPriceVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = {"none", "warn", "alert"};
        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType(paramsArray[0]);

        List<MaterialPriceVO> detailList = vo.getDetail();
        Integer instoreType = vo.getInstoreType();
        if (CollectionUtils.isNotEmpty(detailList) && (int) detailList.stream().filter(in -> in.getMaterialId() != null).count() > 0) {
            detailList = detailList.stream().filter(in -> in.getMaterialId() != null).collect(Collectors.toList());

            //当前表单同类物资合计
            Map<Long, MaterialPriceVO> thisMap = new HashMap<>();
            detailList.forEach(item -> {
                if (thisMap.containsKey(item.getMaterialId())) {
                    MaterialPriceVO materialPriceVO = thisMap.get(item.getMaterialId());
                    materialPriceVO.setNum(ComputeUtil.nullToZero(ComputeUtil.safeAdd(materialPriceVO.getNum(), item.getNum())));
                } else {
                    thisMap.put(item.getMaterialId(), item);
                }
            });

            List<Long> materialIds = new ArrayList<>(thisMap.keySet());
            Long projectId = vo.getProjectId();
            Long supplierId = vo.getLabourArmyId();
            // 领料出库
            if (instoreType != null && instoreType.intValue() == 5 && supplierId != null) {
                // 劳务队伍领料限额量控制材料出库量
                CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_LABOR_LIMIT_COUNT, curOrgId);
                if (!response.isSuccess()) {
                    throw new BusinessException("劳务队伍领料限额量控制材料出库量，获取控制参数失败，失败原因：" + response.getMsg());
                }
                List<BillParamVO> billParamVOS = response.getData();
                if (CollectionUtils.isNotEmpty(billParamVOS)) {
                    // 根据项目和劳务队获取限量登记
                    Map<Long, BigDecimal> planMap = pickRegisterService.queryLaborLimitMaterialCount(projectId, supplierId, materialIds);

                    //获取已生效的量
                    List<MaterialPriceVO> vos = baseMapper.queryLaborMaterialCount(vo.getId(), projectId, supplierId, materialIds);
                    Map<Long, BigDecimal> numVOMap = CollectionUtils.isEmpty(vos) ? new HashMap<>() : vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));

                    for (BillParamVO billParamVO : billParamVOS) {
                        if (0 != billParamVO.getControlType()) {
                            BigDecimal roleValue = billParamVO.getRoleValue();
                            BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                            thisMap.forEach((k, d) -> {
                                BigDecimal num = d.getNum();
                                BigDecimal applyNum = ComputeUtil.nullToZero(planMap.get(d.getMaterialId()));
                                BigDecimal hasNum = ComputeUtil.nullToZero(numVOMap.get(d.getMaterialId()));
                                BigDecimal allNum = ComputeUtil.safeAdd(hasNum, num);
                                //百分比数量
                                BigDecimal _applyNum = applyNum.multiply(divide);
                                if (allNum.compareTo(_applyNum) > 0) {
                                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "outStoreNumber");
                                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                    paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                    paramsCheckDsVO.setWarnName("劳务队伍领料出库量大于领料限额量");
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append("该材料本次出库数量：").append(num.setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString())
                                            .append("，含本次累计出库数量：").append(allNum.setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString())
                                            .append("，领料限额数量*").append(roleValue.setScale(8,4).stripTrailingZeros().toPlainString())
                                            .append("%: ").append(_applyNum.setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString())
                                            .append("。超出数量：").append(ComputeUtil.safeSub(allNum, _applyNum).setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString());
                                    paramsCheckDsVO.setContent(stringBuffer.toString());
                                    updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                }
                            });
                        }
                    }
                }
            }

        }

        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            pc.setWarnType("alert");
            pc.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            pc.setWarnType("warn");
            pc.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    @Override
    public List<PickRegisterDetailVO> queryPickDeductList(Page<PickRegisterDetailVO> page, QueryWrapper wrapper,
                                                          Long projectId, Long supplierId) {
        return baseMapper.queryPickDeductList(page, wrapper, projectId, supplierId);
    }

    @Override
    public boolean codeCheck(Long id, String code) {
        QueryParam check = new QueryParam();
        if (id != null) {
            check.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        check.getParams().put("bill_code", new Parameter(QueryParam.EQ, code));
        check.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<OutStoreEntity> entityList = super.queryList(check, false);
        if (CollectionUtils.isNotEmpty(entityList)) {
            return false;
        }
        return true;
    }

    @Override
    public List<MaterialPriceVO> queryLaborMaterialCount(Long id, Long projectId, Long supplierId, List<Long> materialIds) {
        return baseMapper.queryLaborMaterialCount(id, projectId, supplierId, materialIds);
    }
}
