/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.controller.api;

import com.ejianc.business.income.service.IReportService;
import com.ejianc.business.income.vo.report.IncomeReportMnyVo;
import com.ejianc.business.income.vo.report.ProjectReportVo;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/report/"})
public class ReportApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IReportService reportService;

    @RequestMapping(value={"/projectMonth"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectReportVo> projectMonth(@RequestParam(value="projectId") Long projectId, @RequestParam(value="lastDay") Integer lastDay) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.reportService.projectMonth(projectId, lastDay));
    }

    @RequestMapping(value={"/sumContractMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> sumContractMny(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.reportService.sumContractMny(projectId));
    }

    @RequestMapping(value={"/getMonthProductionMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ProjectReportVo>> getMonthProductionMny(@RequestParam(value="projectId") Long projectId, @RequestParam(value="lastDay") Integer lastDay) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", this.reportService.getMonthProductionMny(projectId, lastDay));
    }

    @RequestMapping(value={"/getIncomeMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IncomeReportMnyVo> getIncomeMny(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.reportService.getIncomeMny(projectId));
    }

    @RequestMapping(value={"/getMonthProduction"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ProjectReportVo>> getMonthProduction(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", this.reportService.getMonthProduction(projectId));
    }
}

