package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 领料登记
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_pick_register")
public class PickRegisterEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 申请单号
    @TableField(value="org_id")
    private Long orgId; // 所属项目部
    @TableField(value="org_name")
    private String orgName; // 所属项目部名称
    @TableField(value="org_code")
    private String orgCode; // 所属项目部编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 组织
    @TableField(value="parent_org_name")
    private String parentOrgName; // 组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 组织编码
    @TableField(value="project_id")
    private Long projectId; // 项目名称参照
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="supplier_id")
    private Long supplierId; // 领料单位
    @TableField(value="supplier_name")
    private String supplierName; // 领料单位
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="total_deduct_mny")
    private BigDecimal totalDeductMny; // 累计已扣金额
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="pickRegisterDetailService",pidName = "registerId")//此处有pid="xxx"，默认值pid="pid"
    private List<PickRegisterDetailEntity> pickRegisterDetailList = new ArrayList<>(); // 领料登记明细
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getTotalDeductMny() {
        return totalDeductMny;
    }

    public void setTotalDeductMny(BigDecimal totalDeductMny) {
        this.totalDeductMny = totalDeductMny;
    }
    
    public List<PickRegisterDetailEntity> getPickRegisterDetailList() {
        return pickRegisterDetailList;
    }

    public void setPickRegisterDetailList(List<PickRegisterDetailEntity> pickRegisterDetailList) {
        this.pickRegisterDetailList = pickRegisterDetailList;
    }
}
