package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.StoreEntity;
import com.ejianc.business.material.pub.MaterialStoreState;
import com.ejianc.business.material.service.IInstoreMaterialService;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.StoreExportVO;
import com.ejianc.business.material.vo.StoreVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * @Author liyongjia
 * @Date 2020/6/6 仓库管理请控制器
 * @Description storeController
 */

@Controller
@RequestMapping("/store/")
public class StoreController {

    @Autowired
    IStoreService storeService;
    @Autowired
    IInstoreMaterialService iInstoreMaterialService;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private SessionManager sessionManager;


    /**
     * @Author liyongjia
     * @Date 2020/6/10  保存修改
     * @Description saveOrUpdate
     * @Param [vo]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.storeVO>
     */
    @RequestMapping(value = "saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<StoreVO> saveOrUpdate(@RequestBody StoreVO vo) {
        StoreEntity entity = BeanMapper.map(vo, StoreEntity.class);
        storeService.saveOrUpdate(entity, false);
        StoreVO backVo = BeanMapper.map(entity, StoreVO.class);
        return CommonResponse.success("保存或修改单据成功！", backVo);
    }

    /**
     * @Author liyongjia
     * @Date 2020/6/2 查询详情
     * @Description queryDetail
     * @Param [id]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.storeVO>
     */
    @RequestMapping(value = "queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StoreVO> queryDetail(Long id) {
        StoreEntity entity = storeService.selectById(id);
        StoreVO vo = BeanMapper.map(entity, StoreVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    @RequestMapping(value = "storematerialList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InstoreMaterialVO>> storematerialList(@RequestBody Map<String, Object> params) {
        if (params.get("storeId") == null) {
            return CommonResponse.error("仓库id不能为空");
        }
        Long storeId = Long.parseLong(params.get("storeId").toString());
        Integer pageNumber = Integer.valueOf(params.get("pageIndex").toString());
        Integer pageSize = Integer.valueOf(params.get("pageSize").toString());
        String searchText = null;
        if (params.get("searchText") != null) {
            searchText = params.get("searchText").toString();
        }
        IPage<InstoreMaterialVO> page = iInstoreMaterialService.storematerialList(storeId, searchText, pageNumber, pageSize);
        return CommonResponse.success(page);
    }

    /**
     * @Author liyongjia
     * @Date 2020/6/10 导出
     * @Description excelExport
     * @Param [queryParam, response]
     * @Return void
     */
    @RequestMapping(value = "excelStoreMaterialList", method = RequestMethod.POST)
    @ResponseBody
    public void excelStoreMaterialList(@RequestBody Map<String, Object> params, HttpServletResponse response) {
        if (params.get("storeId") == null) {
            throw new BusinessException("仓库id不能为空");
        }
        Long storeId = Long.parseLong(params.get("storeId").toString());
        String searchText = null;
        if (params.get("searchText") != null) {
            searchText = params.get("searchText").toString();
        }
        IPage<InstoreMaterialVO> page = iInstoreMaterialService.storematerialList(storeId, searchText, null, null);
        List<InstoreMaterialVO> list = page.getRecords();
        for (InstoreMaterialVO vo : list) {
            vo.setStoreNum(ComputeUtil.nullToZero(vo.getStoreNum()).setScale(4,4).stripTrailingZeros());
            vo.setStorePrice(ComputeUtil.nullToZero(vo.getStorePrice()).setScale(4,4).stripTrailingZeros());
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        String fileName = "storeMaterialExport.xlsx";
        ExcelExport.getInstance().export(fileName, beans, response);
    }

    @SuppressWarnings("unused")
    private String getText(String str, String pat, int num) {
        Pattern pattern = Pattern.compile(pat);
        Matcher findMatcher = pattern.matcher(str);
        int number = 0;
        while (findMatcher.find()) {
            number++;
            if (number == num) {//
                break;
            }
        }
        int i = findMatcher.start();//第num次出现的位置
        return str.substring(0, i);
    }

    @RequestMapping(value = "queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<StoreVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("orgName");
//        fuzzyFields.add("projectTypeName");
        //租户隔离
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 */
        //param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<StoreVO> page = storeService.queryForList(param, false);
        List<StoreVO> list = page.getRecords();
        for (StoreVO vo : list) {
            //入库物资统计
            InstoreMaterialVO pageInstoreMaterial = iInstoreMaterialService.censusStorematerial(vo.getId());
            if (pageInstoreMaterial != null) {
                String name = pageInstoreMaterial.getMaterialName();
                int count = name.length() - name.replace("、", "").length();
                if (count > 2) {
                    vo.setStoreMaterialName(getText(name, "、", 3) + "等" + (count + 1) + "种");
                } else {
                    vo.setStoreMaterialName(name);
                }
                vo.setStoreAmount(pageInstoreMaterial.getStoreAmount());
            }
        	/*IPage<InstoreMaterialVO> pageInstoreMaterial = iInstoreMaterialService.storematerialList(vo.getId(), null, 1, 3);
            BigDecimal amount = new BigDecimal(0);//库存金额
            String name = "";//库存物资种类
            if(pageInstoreMaterial.getTotal()>0){
                for(InstoreMaterialVO material : pageInstoreMaterial.getRecords()){
                	if(name.length()>0){
                		name += "、"+material.getMaterialName();
                	}else{
                		name += material.getMaterialName();
                	}
                	amount = amount.add(material.getStoreAmount());
                }
                if(pageInstoreMaterial.getTotal()>3){
                	name += ("等" + pageInstoreMaterial.getTotal() + "种");
                }

            }
            vo.setStoreMaterialName(name);
            vo.setStoreAmount(amount);*/
        }
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @Author liyongjia
     * @Date 2020/6/10 查询打印数据
     * @Description queryPrint
     * @Param [id]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     */
    @RequestMapping(value = "queryPrint", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("store", storeService.selectById(id));
        return CommonResponse.success("查询打印数据成功！", json);
    }

    /**
     * @Author liyongjia
     * @Date 2020/6/10 删除
     * @Description delete
     * @Param [vos]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<StoreVO> vos) {
        return storeService.delete(vos);
    }


    /**
     * @Author liyongjia
     * @Date 2020/6/10 导出
     * @Description excelExport
     * @Param [queryParam, response]
     * @Return void
     */
    @RequestMapping(value = "excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(10000);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");

        /** 数据隔离 本下 */
        queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<StoreVO> voPage = storeService.queryForList(queryParam, false);
        List<StoreVO> list = voPage.getRecords();
        List<StoreExportVO> exportVOS = new ArrayList<>();
        list.forEach(vo -> {
            //入库物资统计
            IPage<InstoreMaterialVO> pageInstoreMaterial = iInstoreMaterialService.storematerialList(vo.getId(), null, 1, 3);
            BigDecimal amount = new BigDecimal(0.00);//库存金额
            String name = "";//库存物资种类
            if (pageInstoreMaterial.getTotal() > 0) {
                for (InstoreMaterialVO material : pageInstoreMaterial.getRecords()) {
                    if (name.length() > 0) {
                        name += "、" + material.getMaterialName();
                    } else {
                        name += material.getMaterialName();
                    }
                    amount = amount.add(material.getStoreAmount().setScale(2, BigDecimal.ROUND_HALF_UP));
                }
                if (pageInstoreMaterial.getTotal() > 3) {
                    name += ("等" + pageInstoreMaterial.getTotal() + "种");
                }

            }
            vo.setStoreMaterialName(name);
            vo.setStoreAmount(amount);
            StoreExportVO exportVO = BeanMapper.map(vo, StoreExportVO.class);
            exportVO.setCreateTime(DateFormatUtil.formatDate("yyyy-MM-dd", vo.getCreateTime()));
            if (exportVO.getState() != null) {
                if ("1".equals(vo.getState())) {
                    exportVO.setState("启用");
                } else if ("0".equals(vo.getState())) {
                    exportVO.setState("停用");
                }
            }
            if ("1".equals(exportVO.getProjectType())) {
                exportVO.setProjectType("组织仓库");
            }
            if ("2".equals(exportVO.getProjectType())) {
                exportVO.setProjectType("公司仓库");
            }
            exportVOS.add(exportVO);
        });

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", exportVOS);
        ExcelExport.getInstance().export("storeListExport.xlsx", beans, response);
    }

    @RequestMapping(value = "queryRefList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<StoreVO>> queryRefList(
            @RequestParam(defaultValue = "1") int pageNumber, @RequestParam(defaultValue = "10") int pageSize,
            @RequestParam(required = false) String searchText, @RequestParam(required = false) String condition
            , @RequestParam(required = false) String searchObject) {
        Long orgId = null;
        QueryParam param = new QueryParam();

        if (StringUtils.isNotBlank(condition)) {
            JSONObject json = JSONObject.parseObject(condition);
            if (json.get("orgId") != null) {
                orgId = Long.parseLong(json.get("orgId").toString());
                if (null != json.get("selfAndUnderData")) {
                    UserContext userContext = sessionManager.getUserContext();
                    String authOrgIds = userContext.getAuthOrgIds();
                    if (StringUtils.isNotEmpty(authOrgIds)){
                        CommonResponse<List<OrgVO>> authResponse =
                                iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong)
                                        .collect(Collectors.toList()));
                        param.getParams().put("orgId",new Parameter("in",authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
                    }else{
                        param.getParams().put("orgId",new Parameter("in",iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
                    }
                } else if (null != json.get("isFindParentsData")) {
                    //2022-09-06 领料退库，领料出库使用，查询本上
                    param.getParams().put("orgId", new Parameter(QueryParam.IN,
                            iOrgApi.findParentsByOrgId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
                } else {
                    //默认查本组织的
                    /** 数据隔离 所选组织 */
                    param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
                }
            } else {
                return CommonResponse.error("condition条件缺少orgId！");
            }
            if (null != json.get("sort")) {
                Map<String, Object> sort = JSONObject.parseObject(json.getString("sort"), Map.class);
                for (String key : sort.keySet()) {
                    param.getOrderMap().put(key, sort.get(key).toString());
                }
            }
        } else {
            return CommonResponse.error("缺少condition条件");
        }

        if (StringUtils.isNotBlank(searchObject)) {
            JSONObject search = JSONObject.parseObject(searchObject);
            for (String key : search.keySet()) {
                param.getParams().put(key, new Parameter(QueryParam.LIKE, search.get(key).toString()));
            }
        }
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        if (StringUtils.isNotBlank(searchText)) {
            param.setSearchText(searchText);
            /** 模糊搜索配置字段示例 */
            List<String> fuzzyFields = param.getFuzzyFields();
            fuzzyFields.add("name");
            fuzzyFields.add("projectName");
            fuzzyFields.add("orgName");
        }

        //启用的仓库
        param.getParams().put("state", new Parameter(QueryParam.EQ, 1));
        return CommonResponse.success("查询仓库数据成功！", storeService.queryForList(param, false));
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/13 根据入库子表计算该入库子表出库时候可用数量
     * @Description calculateCanUseNum
     * @Param [inStoreSubId, materialId]
     * @Return CommonResponse<BigDecimal>
     */
    @RequestMapping(value = "calculateCanUseNum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> calculateCanUseNum(@RequestParam Long inStoreSubId, @RequestParam Long materialId, @RequestParam Long outSubId) {
        return CommonResponse.success("计算可用库存成功！", storeService.calculateCanUseNum(inStoreSubId, materialId, outSubId).toString());
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/17 根据组织查询最新仓库数据
     * @Description queryNewestStoreByOrgId
     * @Param [orgId]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.StoreVO>
     */
    @RequestMapping(value = "queryNewestStoreByOrgId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StoreVO> queryNewestStoreByOrgId(@RequestParam Long orgId) {
        return CommonResponse.success("查询组织最新仓库成功！", storeService.queryNewestStoreByOrgId(orgId));
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/17
     * @Description refCanUseNumData 查询库存可用数量参照
     * @Param [pageNumber, pageSize, condition, searchText]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage < com.ejianc.business.material.vo.InstoreMaterialVO>>
     */
    @RequestMapping(value = "refCanUseNumData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InstoreMaterialVO>> refCanUseNumData(@RequestParam Integer pageNumber,
                                                                     @RequestParam Integer pageSize,
                                                                     String condition,
                                                                     String searchText, String searchObject) {
        if (StringUtils.isBlank(condition)) {
            return CommonResponse.error("查询条件condition不能为空");
        }
        JSONObject con = JSONObject.parseObject(condition);
        if (StringUtils.isBlank(con.getString("storeId"))) {
            return CommonResponse.error("查询条件【仓库】不能为空");
        }
        if (StringUtils.isBlank(con.getString("outDate"))) {
            return CommonResponse.error("查询条件【出库日期】不能为空");
        }

        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getParams().put("storeId", new Parameter(QueryParam.EQ, con.getString("storeId")));
        queryParam.getParams().put("instoreDate", new Parameter(QueryParam.LE, con.getString("outDate")));
        queryParam.getParams().put("storeState", new Parameter(QueryParam.EQ, MaterialStoreState.STORED.getCode()));

        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialUnit");
        IPage<InstoreMaterialVO> pageVo = new Page<>();
        IPage<InstoreMaterialVO> entityPage =
                iInstoreMaterialService.queryStoreCanUseNumPageData(
                        searchText,
                        searchObject,
                        con.getString("outDate"),
                        con.getLong("storeId"), pageNumber, pageSize);
        if (entityPage != null) {
            List<InstoreMaterialVO> voList = new ArrayList<>();
            entityPage.getRecords().forEach(e -> {
                InstoreMaterialVO vo = BeanMapper.map(e, InstoreMaterialVO.class);
                vo.setCanUseNumber(storeService.calculateCanUseNum(vo.getId(), vo.getMaterialId(), null));
                voList.add(vo);
            });
            pageVo.setRecords(voList);
            pageVo.setSize(queryParam.getPageSize());
            pageVo.setCurrent(entityPage.getCurrent());
            pageVo.setPages(entityPage.getPages());
            pageVo.setTotal(entityPage.getTotal());
        }
        return CommonResponse.success("查询出库可用物资参照成功！", entityPage);
    }

    /**
     * 查询指定仓库中可用的物资列表，同一物资数量、总价进行合并，供盘点使用
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "refUsableSubMaterialList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InstoreMaterialVO>> refUsableSubMaterialList(@RequestParam Integer pageNumber,
                                                                             @RequestParam Integer pageSize,
                                                                             String condition,
                                                                             String searchText, @RequestParam(required = false) String searchObject) {
        if (StringUtils.isBlank(condition)) {
            return CommonResponse.error("查询条件condition不能为空");
        }
        HashMap<String, String> map = null;
        if (StringUtils.isNotBlank(searchObject)) {
            JSONObject search = JSONObject.parseObject(searchObject);
            map = new HashMap<>();
            if (search.get("materialCategoryName") != null) {
                map.put("material_category_name", search.get("materialCategoryName").toString());
            }
            if (search.get("materialName") != null) {
                map.put("material_name", search.get("materialName").toString());
            }
            if (search.get("materialSpec") != null) {
                map.put("material_spec", search.get("materialSpec").toString());
            }
        }
        JSONObject con = JSONObject.parseObject(condition);
        if (StringUtils.isBlank(con.getString("storeId"))) {
            return CommonResponse.error("查询条件【仓库】不能为空");
        }
        if (StringUtils.isBlank(con.getString("outDate"))) {
            return CommonResponse.error("查询条件【出库日期】不能为空");
        }

        List<Long> materialIds = null;
        if (null != con.get("materialIds")) {
            materialIds = JSONArray.parseArray(con.getString("materialIds"), Long.class);
        }

        IPage<InstoreMaterialVO> pageVo = new Page<>();
        IPage<InstoreMaterialVO> entityPage =
                iInstoreMaterialService.queryUsableSubMaterialList(
                        searchText,
                        con.getString("outDate"),
                        con.getLong("storeId"), pageNumber, pageSize, materialIds, map);
        if (entityPage != null) {
            List<InstoreMaterialVO> voList = new ArrayList<>();
            entityPage.getRecords().forEach(e -> {
                InstoreMaterialVO vo = BeanMapper.map(e, InstoreMaterialVO.class);
                vo.setCanUseNumber(storeService.calculateCanUseNum(vo.getId(), vo.getMaterialId(), null));
                voList.add(vo);
            });
            pageVo.setRecords(voList);
            pageVo.setSize(pageSize);
            pageVo.setCurrent(entityPage.getCurrent());
            pageVo.setPages(entityPage.getPages());
            pageVo.setTotal(entityPage.getTotal());
        }
        return CommonResponse.success("查询出库可用物资参照成功！", pageVo);
    }


    /**
     * @description: 查询仓库可用数量
     *
     * @param condition
     * @return {@link CommonResponse< IPage<com.ejianc.business.material.vo.InstoreMaterialVO>>}
     * @author songlx
     * @date: 2023/2/8
     */
    @RequestMapping(value = "queryStoreMaterialList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InstoreMaterialVO>> queryStoreMaterialList(@RequestBody String condition) {
        if (StringUtils.isBlank(condition)) {
            return CommonResponse.error("查询条件condition不能为空");
        }
        JSONObject con = JSONObject.parseObject(condition);
        if (StringUtils.isBlank(con.getString("storeId"))) {
            return CommonResponse.error("查询条件【仓库】不能为空");
        }
        if (StringUtils.isBlank(con.getString("outDate"))) {
            return CommonResponse.error("查询条件【出库日期】不能为空");
        }
        List<Long> materialIds = null;
        if (null != con.get("materialIds")) {
            materialIds = JSONArray.parseArray(con.getString("materialIds"), Long.class);
        }
        IPage<InstoreMaterialVO> pageVo = new Page<>();
        IPage<InstoreMaterialVO> entityPage =
                iInstoreMaterialService.queryUsableSubMaterialList(
                        null,
                        con.getString("outDate"),
                        con.getLong("storeId"), 1, 10000, materialIds, null);
        if (entityPage != null) {
            List<InstoreMaterialVO> voList = new ArrayList<>();
            entityPage.getRecords().forEach(e -> {
                InstoreMaterialVO vo = BeanMapper.map(e, InstoreMaterialVO.class);
                vo.setCanUseNumber(storeService.calculateCanUseNum(vo.getId(), vo.getMaterialId(), null));
                voList.add(vo);
            });
            pageVo.setRecords(voList);
            pageVo.setSize(10000);
            pageVo.setCurrent(entityPage.getCurrent());
            pageVo.setPages(entityPage.getPages());
            pageVo.setTotal(entityPage.getTotal());
        }
        return CommonResponse.success("查询仓库可用数量成功！", pageVo);
    }
}
