package com.ejianc.business.othprice.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 其他询价申请
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zypms_othprice_other_apply")
public class OtherApplyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 申请单号
    @TableField(value="apply_title")
    private String applyTitle; // 申请主题
    @TableField(value="name")
    private String name; // 申请单名称
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_id")
    private Long projectId; // 项目名称参照
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="org_id")
    private Long orgId; // 组织参照
    @TableField(value="detail_names")
    private String detailNames; // 申请材料种类
    @TableField(value="apply_person")
    private String applyPerson; // 申请人
    @TableField(value="apply_person_id")
    private Long applyPersonId; // 申请人
    @TableField(value="apply_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate; // 申请时间
    @TableField(value="memo")
    private String memo; // 招标要求
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="otherApplySubService")
    private List<OtherApplySubEntity> otherApplySubList = new ArrayList<>(); // 其他询价申请-详情
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public Long getApplyPersonId() {
        return applyPersonId;
    }

    public void setApplyPersonId(Long applyPersonId) {
        this.applyPersonId = applyPersonId;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getApplyTitle() {
        return applyTitle;
    }

    public void setApplyTitle(String applyTitle) {
        this.applyTitle = applyTitle;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getDetailNames() {
        return detailNames;
    }

    public void setDetailNames(String detailNames) {
        this.detailNames = detailNames;
    }
    public String getApplyPerson() {
        return applyPerson;
    }

    public void setApplyPerson(String applyPerson) {
        this.applyPerson = applyPerson;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    

    public List<OtherApplySubEntity> getOtherApplySubList() {
        return otherApplySubList;
    }

    public void setOtherApplySubList(List<OtherApplySubEntity> otherApplySubList) {
        this.otherApplySubList = otherApplySubList;
    }
}
