package com.ejianc.business.othprice.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 其他询价申请
 * 
 * @author generator
 * 
 */
public class OtherApplyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 申请单号
    private String applyTitle; // 申请主题
    private String name; // 申请单名称
    private String projectName; // 项目名称
    private Long projectId; // 项目名称参照
    private String orgName; // 组织名称
    private Long orgId; // 组织参照
    private String detailNames; // 申请材料种类
    private String applyPerson; // 申请人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate; // 申请时间
    private String memo; // 招标要求
    private Long applyPersonId; // 申请人
    
    private List<OtherApplySubVO> otherApplySubList = new ArrayList<>(); // 其他询价申请-详情

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getApplyTitle() {
        return applyTitle;
    }

    public void setApplyTitle(String applyTitle) {
        this.applyTitle = applyTitle;
    }
    public String getName() {
        return name;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getApplyPersonId() {
        return applyPersonId;
    }
    @ReferDeserialTransfer
    public void setApplyPersonId(Long applyPersonId) {
        this.applyPersonId = applyPersonId;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getDetailNames() {
        return detailNames;
    }

    public void setDetailNames(String detailNames) {
        this.detailNames = detailNames;
    }
    public String getApplyPerson() {
        return applyPerson;
    }

    public void setApplyPerson(String applyPerson) {
        this.applyPerson = applyPerson;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<OtherApplySubVO> getOtherApplySubList() {
        return otherApplySubList;
    }

    public void setOtherApplySubList(List<OtherApplySubVO> otherApplySubList) {
        this.otherApplySubList = otherApplySubList;
    }
}
