package com.ejianc.business.sub.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.sub.bean.SubSettleEntity;
import com.ejianc.business.sub.vo.*;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 分包过程结算表 服务类
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
public interface ISubSettleService extends IBaseService<SubSettleEntity> {

    SubSettleVO insertOrUpdate(SubSettleVO settleVO);

    SubSettleVO queryDetail(Long id, Boolean detailHasChildren);

    CommonResponse<IPage<SubSettleVO>> queryListVOs(QueryParam param);

    CommonResponse<String> deleteByIds(List<SubSettleVO> vos);

    SubSettleRecordVO queryDetailRecord(Long id);

    SubSettleVO queryDetailAdd(Long contractId);

    JSONObject querySubSettleVOList(QueryParam param, boolean isEs);

    CommonResponse<SubSettleVO> pushCost(SubSettleVO settleVO);

    void costPush(SubSettleEntity settleEntity);

    void pullCost(Long id);

    SubParamsCheckVO checkParams(Integer purchaseType, BigDecimal sumSettleMentTaxMny, BigDecimal contractTaxMny);

    SubSettleVO getSumSettleNumInfo(SubSettleVO settleVO);

    List<SubContractDetailVO> getSumSettleNum(List<SubContractDetailVO> contractDetailVOS);

    /**
     * 根据清单编码和名称查询历史数据的含本期累计结算工程量
     * @param settleDetailVO
     * @return
     */
    JSONObject querySettleDetailHistory(SubSettleDetailVO settleDetailVO);
    /**
     * 查询合同内的历史数据集合，修改含本期累计结算工程量和不含本期累计结算工程量
     * @return
     */
    void updateSettleDetailHistory();

    SubSettleVO queryProjectAndLaborMny(Long projectId, String settleDate);

    SubParamsCheckVO checkParamsByContractNumAndMny(SubSettleCheckParamsVO settleCheckParamsVO);

    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response);

}
