package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.vo.ProjectTaskBookDetailVO;
import com.ejianc.business.sub.bean.SubContractDetailEntity;
import com.ejianc.business.sub.bean.SubContractEntity;
import com.ejianc.business.sub.enums.ChangeStatusEnum;
import com.ejianc.business.sub.enums.ChangeTypeEnum;
import com.ejianc.business.sub.mapper.SubContractMapper;
import com.ejianc.business.sub.service.IChangeService;
import com.ejianc.business.sub.service.IContractDetailService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISubSettleService;
import com.ejianc.business.sub.utils.BigDecimalUtils;
import com.ejianc.business.sub.utils.ExcelImportUtil;
import com.ejianc.business.sub.utils.TreeNodeBUtil;
import com.ejianc.business.sub.vo.*;
import com.ejianc.business.sub.vo.warn.SubWarnVo;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
public class SubContractServiceImpl extends BaseServiceImpl<SubContractMapper, SubContractEntity> implements IContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String SUB_CONTRACT_BILL_CODE = "SUB_CONTRACT";
    private static final String SGHTZJE_K_SJZCJE = "P-nkX4Sk61";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IContractDetailService contractDetailService;

    @Autowired
    private ISubSettleService settleService;

    @Autowired
    private IChangeService changeService;



    //【预算人工费总金额】控【劳务分包合同总金额】
    private static String PARAM_LABOR_MNY = "P-9P63m148";
    //预算人工费清单量控
    private static String PARAM_LABOR_DETAIL_NUM = "P-J7c50750";
    //预算人工费清单金额控
    private static String PARAM_LABOR_DETAIL_MNY = "P-rj09ju51";
    //【预算专业分包总金额】控 【专业分包合同总金额】
    private static String PARAM_MAJOR_MNY = "P-k3cSoQ49";
    //预算专业分包清单量控
    private static String PARAM_MAJOR_DETAIL_NUM = "P-5Z9ASh54";
    //预算专业分包清单金额控
    private static String PARAM_MAJOR_DETAIL_MNY = "P-RjM0C653";


    private static final String PARAM_BUDGE_MNY = "P-z3eQ6q89"; // 【项目预算总金额】控【项目总支出金额】

    @Override
    public SubContractVO insertOrUpdate(SubContractVO contractVO) {
        if (StringUtils.isBlank(contractVO.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(SUB_CONTRACT_BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                contractVO.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        LambdaQueryWrapper<SubContractEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(SubContractEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambda.eq(SubContractEntity::getBillCode, contractVO.getBillCode());
        lambda.ne(contractVO.getId() != null && contractVO.getId() > 0, SubContractEntity::getId, contractVO.getId());
        List<SubContractEntity> entities = super.list(lambda);
        if (CollectionUtils.isNotEmpty(entities)) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }

        SubContractEntity contractEntity = BeanMapper.map(contractVO, SubContractEntity.class);
        contractEntity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
        contractEntity.setBeforeChangeMny(contractEntity.getContractMny());
        contractEntity.setBeforeChangeTaxMny(contractEntity.getContractTaxMny());
        contractEntity.setBaseMoney(contractEntity.getContractMny());
        contractEntity.setBaseTaxMoney(contractEntity.getContractTaxMny());
        boolean b = this.saveOrUpdateNoES(contractEntity);
        List<SubContractDetailEntity> contractDetailEntityList = contractEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(contractDetailEntityList)) {
            Map<String, Long> idMap = new HashMap<>();
            for (SubContractDetailEntity cdEntity : contractDetailEntityList) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (SubContractDetailEntity cdEntity : contractDetailEntityList) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            contractDetailService.saveOrUpdateBatch(contractDetailEntityList);
        }
        return queryDetail(contractEntity.getId(), true);
    }

    @Override
    public SubContractVO queryDetail(Long id, Boolean detailHasChildren) {
        SubContractEntity contractEntity = super.selectById(id);
        SubContractVO contractVO = BeanMapper.map(contractEntity, SubContractVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List<SubContractDetailEntity> detailEntityListDb = contractDetailService.queryList(queryParam, false);
        List<SubContractDetailEntity> detailEntityList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType() || ChangeTypeEnum.中止.getCode() != entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {


            for (SubContractDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List<SubContractDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, SubContractDetailVO.class);
            sortIntMethod(resultMapList);
            if (detailHasChildren) {
                contractVO.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
            } else {
                contractVO.setDetailList(resultMapList);
            }
        } else {
            contractVO.setDetailList(BeanMapper.mapList(detailEntityList, SubContractDetailVO.class));
        }
        return contractVO;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<SubContractVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            List<Long> ids = vos.stream().map(SubContractVO::getId).collect(Collectors.toList());
            //删除后如果是定标新增的则更新定标的签订合同金额
            LambdaQueryWrapper<SubContractEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.in(SubContractEntity::getId, ids);
            queryWrapper.isNotNull(SubContractEntity::getEnquiryPriceBillId);
            List<SubContractEntity> materialContractEntities = this.list(queryWrapper);
            boolean b = this.removeByIds(ids, false);
        }
        return CommonResponse.success("删除成功！");
    }

    @Override
    public CommonResponse<IPage<SubContractVO>> queryListVOs(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        IPage<SubContractEntity> page = queryPage(param, false);
        List<SubContractVO> contractVOList = BeanMapper.mapList(page.getRecords(), SubContractVO.class);
        IPage<SubContractVO> contractVOIPage = new Page<>();
        contractVOIPage.setCurrent(page.getCurrent());
        contractVOIPage.setRecords(contractVOList);
        contractVOIPage.setSize(page.getSize());
        contractVOIPage.setTotal(page.getTotal());
        contractVOIPage.setPages(page.getPages());
        return CommonResponse.success("查询成功！", contractVOIPage);
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(base_tax_money) as baseTaxMoney, sum(contract_tax_mny) as contractTaxMny");
        resp = super.getMap(wrapper);
        if (null == resp) {
            resp = new HashMap<>();
            resp.put("baseTaxMoney", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;

    }

    @Override
    public SubContractVO queryRecordDetail(Long id, boolean b) {
        return null;
    }

    @Override
    public List<SubContractDetailVO> refContractDetail(Long contractId, String condition) {
        // 树形根据code和name过滤子项
        String code = null;
        String name = null;
        boolean filterFlag = false;
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, String> conditionMap = JSONObject.parseObject(condition, Map.class);
            String codeStr = conditionMap.get("code");
            String nameStr = conditionMap.get("name");
            code = StringUtils.isNotBlank(codeStr) ? codeStr : null;
            name = StringUtils.isNotBlank(nameStr) ? nameStr : null;
            filterFlag = code != null || name != null;
        }
        //根据code和name过滤出来的叶子节点
        HashMap<Long, SubContractDetailEntity> leafMap = new HashMap<>();
        QueryWrapper<SubContractDetailEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("contract_id", contractId);
////        select * from 表名 ORDER BY
//        wrapper.orderBy(true, true, "cast(concat(left(tree_index,INSTR(tree_index,'.')),replace(subString(tree_index,instr(tree_index,'.')+1),'.',''))");
//        wrapper.orderBy(true, true, "cast(concat(left(表名,INSTR(表名,'.')),replace(subString(表名,instr(tree_index,'.')+1),'.',''))");
        List<SubContractDetailEntity> detailEntityListDb = contractDetailService.list(wrapper);
        List<SubContractDetailEntity> entities = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(detailEntityListDb)) {
            for (SubContractDetailEntity entity : detailEntityListDb) {
                if (entity.getLeafFlag()) {
                    if (code != null && StringUtils.isNotEmpty(entity.getCode()) && !entity.getCode().contains(code))
                        continue;
                    if (name != null && StringUtils.isNotEmpty(entity.getName()) && !entity.getName().contains(name))
                        continue;
                }
                if (null == entity.getChangeType() || ChangeTypeEnum.中止.getCode() != entity.getChangeType()) {
                    entities.add(entity);
                    if (entity.getLeafFlag()) {
                        leafMap.put(entity.getId(), entity);
                    }
                }
            }
        }
        List<SubContractDetailEntity> resList = null;
        //如果带有搜索，递归找叶子节点的父级
        if (filterFlag) {
            resList = handleFilterData(entities, leafMap);
        } else {
            resList = entities;
        }
        List<SubContractDetailVO> detailVos = BeanMapper.mapList(resList, SubContractDetailVO.class);
        if (CollectionUtils.isNotEmpty(detailVos)) {
            for (SubContractDetailVO cdEntity : detailVos) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
            }
        }
        settleService.getSumSettleNum(detailVos);
        List<SubContractDetailVO> contractDetailVOS = TreeNodeBUtil.buildTree(detailVos);
        sortIntMethod(contractDetailVOS);
        return contractDetailVOS;
    }
    private static void sortIntMethod(List<SubContractDetailVO> list){
        Collections.sort(list, new Comparator(){
            @Override
            public int compare(Object o1, Object o2) {
                ObjectMapper objectMapper = new ObjectMapper();
                SubContractDetailVO o1Detail = objectMapper.convertValue(o1, SubContractDetailVO.class);
                SubContractDetailVO o2Detail = objectMapper.convertValue(o2, SubContractDetailVO.class);
                String[] strs1 = o1Detail.getTreeIndex().split("\\.");
                String[] strs2 = o2Detail.getTreeIndex().split("\\.");
                int length = strs1.length > strs2.length ? strs1.length : strs2.length;
                for (int i = 0; i < length; i++) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    } catch (Exception e) {

                    }
                    if (num1 < num2)
                        return -1;
                    if (num1 > num2)
                        return 1;
                }
                return 0;
            }
        });
    }
    private List<SubContractDetailEntity> handleFilterData(List<SubContractDetailEntity> entities, HashMap<Long, SubContractDetailEntity> leafMap) {

        if (MapUtils.isEmpty(leafMap)) {
            entities.clear();
            return entities;
        }
        Map<Long, SubContractDetailEntity> map = entities.stream().collect(Collectors.toMap(SubContractDetailEntity::getId, Function.identity()));
        ArrayList<SubContractDetailEntity> resList = new ArrayList<>();
        for (Long id : leafMap.keySet()) {
            SubContractDetailEntity leafContractDetailEntity = leafMap.get(id);
            resList.add(leafContractDetailEntity);
            getContractDetaiParent(leafContractDetailEntity, map, resList);
        }
        return resList;
    }

    private void getContractDetaiParent(SubContractDetailEntity leafContractDetailEntity, Map<Long, SubContractDetailEntity> map, List<SubContractDetailEntity> resList) {
        Long parentId = leafContractDetailEntity.getParentId();
        if(null != parentId){
            resList.add(map.get(parentId));
            getContractDetaiParent(map.get(parentId), map , resList);
        }

    }


    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //筛选重复序号
                Map<String, Integer> indexMap = new HashMap<>();
                List<SubContractDetailVO> detailVoList = new ArrayList<>();
                Map<String, String> tidMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    SubContractDetailVO vo = new SubContractDetailVO();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";

                    String detailIndex = datas.get(0);
                    vo.setTreeIndex(detailIndex);
                    //维护父子关系
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    if (StringUtils.isNotEmpty(detailIndex)) {//序号不为空
                        String[] split = detailIndex.split("[-/.]");
                        vo.setTid(id);
                        tidMap.put(detailIndex, id);
                        if (split.length > 1) {
                            vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                        }
                    } else {
                        vo.setTid(id);
                        vo.setTpid("");
                    }

                    if (indexMap.containsKey(detailIndex)) {//序号重复
                        return CommonResponse.error("第" + (i + 2) + "行序号和第" + (indexMap.get(detailIndex) + 2) + "行重复");
                    } else {
                        indexMap.put(detailIndex, i);
                    }

                    if (StringUtils.isEmpty(datas.get(1))) {// 清单编码为空
                        vo.setCode(null);
                        warnType = warnType + "清单编码为空,";
                        flag = true;
                        parentWarn = true;
                    } else {
                        vo.setCode(datas.get(1));
                    }

                    if (StringUtils.isEmpty(datas.get(2))) {//清单名称为空
                        vo.setName(null);
                        warnType = warnType + "清单名称为空,";
                        flag = true;
                        parentWarn = true;
                    } else {
                        vo.setName(datas.get(2));
                    }
                    if(StringUtils.isNotEmpty(datas.get(3)) && datas.get(3).length() > 2000){
                        flag = true;
                        warnType = warnType + "特征描述/规格型号超过2000字,";
                    }
                    vo.setSpec(datas.get(3));
                    vo.setUnit(datas.get(4));//计量单位

                    if (StringUtils.isEmpty(datas.get(5))) {
                        vo.setNum(null);
                        warnType = warnType + "工程量为空,";
                        flag = true;
                    } else {
                        try {
                            vo.setNum(new BigDecimal(datas.get(5)));
                        } catch (Exception e) {
                            vo.setNum(null);
                            warnType = warnType + "工程量只能为数字或小数,";
                            flag = true;
                        }
                    }

                    // 修改由合价计算综合单价
                    if (StringUtils.isEmpty(datas.get(6))) {
                        vo.setPrice(null);
                        warnType = warnType + "综合单价为空,";
                        flag = true;
                    } else {
                        try {
                            vo.setPrice(new BigDecimal(datas.get(6)));
                        } catch (Exception e) {
                            vo.setPrice(null);
                            warnType = warnType + "综合单价只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if(!flag){
                        vo.setMoney(vo.getPrice().multiply(vo.getNum()).setScale(2, BigDecimal.ROUND_HALF_UP));
                    }
                    if ((null == vo.getPrice() || vo.getPrice().compareTo(BigDecimal.ZERO) == 0) && null != vo.getMoney()) {
                        vo.setPrice(BigDecimalUtils.safeDiv(vo.getMoney(), vo.getNum()).setScale(2, BigDecimal.ROUND_HALF_UP));
                    }

                    if ((null == vo.getMoney() || vo.getMoney().compareTo(BigDecimal.ZERO) == 0) && null != vo.getPrice()) {
                        BigDecimal decimal = BigDecimalUtils.safeMultiply(vo.getNum(), vo.getPrice()).setScale(2, BigDecimal.ROUND_HALF_UP);
                        vo.setMoney(ComputeUtil.scale(decimal,2));
                    }
                    vo.setMemo(datas.get(8));

                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    vo.setParentWarn(parentWarn);
                    if (flag) {
                        warnType = warnType.substring(0, warnType.length() - 1);
                    }
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    vo.setShadowId(vo.getTid());
                    vo.setChangeType(3);//增补项
                    detailVoList.add(vo);
                }

                for (SubContractDetailVO tVo : detailVoList) {
                    tVo.setTpid(tidMap.get(tVo.getTpid()));
                }
                List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
                resp.put("successList", allList.get(0));
                resp.put("errorList", errorList);
                resp.put("successNum", result.size() - errorList.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    @Override
    public List<Map<String, Object>> payMnyWarn(List<SubSqlParam> sqlParamList) {
        return baseMapper.payMnyWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> prePayMnyWarn(List<SubSqlParam> sqlParamList) {
        return baseMapper.prePayMnyWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> finishMnyWarn(List<SubSqlParam> sqlParamList) {
        return baseMapper.finishMnyWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> invoicePayMnyWarn(List<SubSqlParam> sqlParamList) {
        return baseMapper.invoicePayMnyWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> invoiceContractMnyWarn(List<SubSqlParam> sqlParamList) {
        return baseMapper.invoiceContractMnyWarn(sqlParamList);
    }

    @Override
    public List<SubWarnVo> subProjectOutMny(List<Long> tenantIds) {
        return baseMapper.subProjectOutMny(tenantIds);
    }

    @Override
    public List<SubProjectReportVo> getMonthSubMny(Long projectId, Integer lastDay) {
        return baseMapper.getMonthSubMny(projectId, lastDay);
    }

    @Override
    public SubProjectReportVo getSubContract(Long projectId) {
        BigDecimal mny = BigDecimal.ZERO;
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper<SubContractEntity> lambda = Wrappers.<SubContractEntity>lambdaQuery();
        lambda.eq(SubContractEntity::getProjectId, projectId);
        lambda.eq(SubContractEntity::getDr, 0);
        lambda.in(SubContractEntity::getBillState, billStatus);
        List<SubContractEntity> entities = super.list(lambda);
        for (SubContractEntity ce : entities) {
            mny = mny.add(ce.getContractTaxMny() == null ? BigDecimal.ZERO : ce.getContractTaxMny());
        }
        BigDecimal settleMny = baseMapper.getSubContract(projectId);
        SubProjectReportVo vo = new SubProjectReportVo();
        vo.setNum(entities.size());
        vo.setMny(mny);
        vo.setSettleMny(settleMny);
        return vo;
    }

    @Override
    public List<SubProjectSettleNumVO> getSubSettleNum(List<Long> projectIds) {
        return baseMapper.getSubSettleNum(projectIds);
    }


    @Override
    public BigDecimal fetchSjzcje(Long projectId) {
        Assert.notNull(projectId, "项目id不能为空");
        return baseMapper.fetchSjzcje(projectId, null, null);
    }

    @Override
    public List<SubContractDetailVO> queryApplySubCount(IPage page,QueryParam queryApplySubParam) {
        QueryWrapper qw = changeToQueryWrapper(queryApplySubParam);
        List<SubContractDetailVO> list = baseMapper.queryApplySubCount(page,qw);
        return list;
    }
}
