package com.ejianc.business.bidprice.common.vo;

import com.ejianc.business.bidprice.material.vo.MaterialInquiryPurchaseDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryRentDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialQuoteVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 材料询价
 *
 * @author generator
 *
 */
@ApiModel("询价公共VO")
public class InquiryCommonVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer billState; // 单据状态
    private String billCode; // 单据编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 组织id
    private String orgName; // 组织id
    private Long parentOrgId; // 项目部所属组织id
    private String parentOrgName; // 项目部所属组织
    private String purchaseSubject; // 采购主题
    private Integer purchaseType; // 采购方式：1-项目自采；2-集中采购
    private String purchaseTypeName; // 采购方式名称
    private Integer pricingType; // 计价方式：1-采购；2-租赁
    private String pricingTypeName; // 计价方式名称
    private Integer quotationAuthority; // 报价权限：1-指定供应商；2-所有供应商
    private String quotationAuthorityName; // 报价权限名称
    private Integer viewAuthority; // 查看权限：1-指定供应商：2-所有供应商登录后查看；3-所有供应商免登录查看
    private String viewAuthorityName; // 查看权限名称
    private BigDecimal inquiryMny; // 询价金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planUseDate; // 计划使用日期
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人
    private Long departmentId; // 经办人部门id
    private String departmentName; // 经办人部门
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date inquiryDate; // 询价日期
    private Long contactsId; // 联系人
    private String contactsName; // 联系人姓名
    private String phone; // 联系电话
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date quoteEndDate; // 报价截止日期
    private String invoiceRequirement; // 发票要求
    private String paymentMethod; // 付款方式
    private String memo; // 询价说明
    private Integer inquiryState; // 询价状态：1-未开始；2-报价中；3-已截止；4-已定标

    @ApiModelProperty("材料询价-采购清单")
    private List<MaterialInquiryPurchaseDetailVO> materialInquiryPurchaseDetailList = new ArrayList<>();
    @ApiModelProperty("材料询价-租赁清单")
    private List<MaterialInquiryRentDetailVO> materialInquiryRentDetailList = new ArrayList<>();
    @ApiModelProperty("材料询价-候选供应商")
    private List<MaterialQuoteVO> materialQuoteVOList = new ArrayList<>();

    private BigDecimal sumBidMny; // 中标金额

    @ApiModelProperty("招标流程：1询价2开标，默认取系统参数设置")
    private Integer bidProcess;

    @ApiModelProperty("开标状态")
    private Integer bidOpenState;


    public Integer getBidProcess() {
        return bidProcess;
    }

    public void setBidProcess(Integer bidProcess) {
        this.bidProcess = bidProcess;
    }

    public Integer getBidOpenState() {
        return bidOpenState;
    }

    public void setBidOpenState(Integer bidOpenState) {
        this.bidOpenState = bidOpenState;
    }

    public BigDecimal getSumBidMny() {
        return sumBidMny;
    }

    public void setSumBidMny(BigDecimal sumBidMny) {
        this.sumBidMny = sumBidMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 组织id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getPurchaseSubject() {
        return purchaseSubject;
    }

    public void setPurchaseSubject(String purchaseSubject) {
        this.purchaseSubject = purchaseSubject;
    }

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public Integer getPricingType() {
        return pricingType;
    }

    public void setPricingType(Integer pricingType) {
        this.pricingType = pricingType;
    }

    public String getPricingTypeName() {
        return pricingTypeName;
    }

    public void setPricingTypeName(String pricingTypeName) {
        this.pricingTypeName = pricingTypeName;
    }

    public Integer getQuotationAuthority() {
        return quotationAuthority;
    }

    public void setQuotationAuthority(Integer quotationAuthority) {
        this.quotationAuthority = quotationAuthority;
    }

    public String getQuotationAuthorityName() {
        return quotationAuthorityName;
    }

    public void setQuotationAuthorityName(String quotationAuthorityName) {
        this.quotationAuthorityName = quotationAuthorityName;
    }

    public Integer getViewAuthority() {
        return viewAuthority;
    }

    public void setViewAuthority(Integer viewAuthority) {
        this.viewAuthority = viewAuthority;
    }

    public String getViewAuthorityName() {
        return viewAuthorityName;
    }

    public void setViewAuthorityName(String viewAuthorityName) {
        this.viewAuthorityName = viewAuthorityName;
    }

    public BigDecimal getInquiryMny() {
        return inquiryMny;
    }

    public void setInquiryMny(BigDecimal inquiryMny) {
        this.inquiryMny = inquiryMny;
    }

    public Date getPlanUseDate() {
        return planUseDate;
    }

    public void setPlanUseDate(Date planUseDate) {
        this.planUseDate = planUseDate;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public Date getInquiryDate() {
        return inquiryDate;
    }

    public void setInquiryDate(Date inquiryDate) {
        this.inquiryDate = inquiryDate;
    }

    public Long getContactsId() {
        return contactsId;
    }

    public void setContactsId(Long contactsId) {
        this.contactsId = contactsId;
    }

    public String getContactsName() {
        return contactsName;
    }

    public void setContactsName(String contactsName) {
        this.contactsName = contactsName;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Date getQuoteEndDate() {
        return quoteEndDate;
    }

    public void setQuoteEndDate(Date quoteEndDate) {
        this.quoteEndDate = quoteEndDate;
    }

    public String getInvoiceRequirement() {
        return invoiceRequirement;
    }

    public void setInvoiceRequirement(String invoiceRequirement) {
        this.invoiceRequirement = invoiceRequirement;
    }

    public String getPaymentMethod() {
        return paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getInquiryState() {
        return inquiryState;
    }

    public void setInquiryState(Integer inquiryState) {
        this.inquiryState = inquiryState;
    }

    public List<MaterialInquiryPurchaseDetailVO> getMaterialInquiryPurchaseDetailList() {
        return materialInquiryPurchaseDetailList;
    }

    public void setMaterialInquiryPurchaseDetailList(List<MaterialInquiryPurchaseDetailVO> materialInquiryPurchaseDetailList) {
        this.materialInquiryPurchaseDetailList = materialInquiryPurchaseDetailList;
    }

    public List<MaterialInquiryRentDetailVO> getMaterialInquiryRentDetailList() {
        return materialInquiryRentDetailList;
    }

    public void setMaterialInquiryRentDetailList(List<MaterialInquiryRentDetailVO> materialInquiryRentDetailList) {
        this.materialInquiryRentDetailList = materialInquiryRentDetailList;
    }

    public List<MaterialQuoteVO> getMaterialQuoteVOList() {
        return materialQuoteVOList;
    }

    public void setMaterialQuoteVOList(List<MaterialQuoteVO> materialQuoteVOList) {
        this.materialQuoteVOList = materialQuoteVOList;
    }
}
