package com.ejianc.business.bidprice.material.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 材料询价
 * 
 * @author generator
 * 
 */
@ApiModel("材料询价")
public class MaterialInquiryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("单据编码")
    private String billCode;
    @ApiModelProperty("项目id")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("组织id")
    private Long orgId;
    @ApiModelProperty("组织")
    private String orgName;
    @ApiModelProperty("项目部所属组织id")
    private Long parentOrgId;
    @ApiModelProperty("项目部所属组织")
    private String parentOrgName;
    @ApiModelProperty("采购主题")
    private String purchaseSubject;
    @ApiModelProperty("采购方式：1-项目自采；2-集中采购")
    private Integer purchaseType;
    @ApiModelProperty("采购方式名称")
    private String purchaseTypeName;
    @ApiModelProperty("计价方式：1-采购；2-租赁")
    private Integer pricingType;
    @ApiModelProperty("计价方式名称")
    private String pricingTypeName;
    @ApiModelProperty("报价权限：1-指定供应商；2-所有供应商")
    private Integer quotationAuthority;
    @ApiModelProperty("报价权限名称")
    private String quotationAuthorityName;
    @ApiModelProperty("查看权限：1-指定供应商：2-所有供应商登录后查看；3-所有供应商免登录查看")
    private Integer viewAuthority;
    @ApiModelProperty("查看权限名称")
    private String viewAuthorityName;
    @ApiModelProperty("询价金额")
    private BigDecimal inquiryMny;
    @ApiModelProperty("计划使用日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planUseDate;
    @ApiModelProperty("经办人id")
    private Long employeeId;
    @ApiModelProperty("经办人")
    private String employeeName;
    @ApiModelProperty("经办人部门id")
    private Long departmentId;
    @ApiModelProperty("经办人部门")
    private String departmentName;
    @ApiModelProperty("询价日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date inquiryDate;
    @ApiModelProperty("联系人")
    private Long contactsId;
    @ApiModelProperty("联系人姓名")
    private String contactsName;
    @ApiModelProperty("联系电话")
    private String phone;
    @ApiModelProperty("报价截止日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date quoteEndDate;
    @ApiModelProperty("发票要求")
    private String invoiceRequirement;
    @ApiModelProperty("付款方式")
    private String paymentMethod;
    @ApiModelProperty("询价说明")
    private String memo;
    @ApiModelProperty("询价状态：1-未开始；2-报价中；3-已截止；4-已定标")
    private Integer inquiryState;
    @ApiModelProperty("询价状态")
    private String inquiryStateName;

    @ApiModelProperty("材料询价-采购清单")
    private List<MaterialInquiryPurchaseDetailVO> materialInquiryPurchaseDetailList = new ArrayList<>();
    @ApiModelProperty("材料询价-租赁清单")
    private List<MaterialInquiryRentDetailVO> materialInquiryRentDetailList = new ArrayList<>();
    @ApiModelProperty("材料询价-候选供应商")
    private List<MaterialInquirySupplierVO> materialInquirySupplierList = new ArrayList<>();

    @ApiModelProperty("单据状态名称")
    private String billStateName;

    @ApiModelProperty("是否截止")
    private Boolean quoteEndFlag;


    @ApiModelProperty("招标流程：1询价2开标，默认取系统参数设置")
    private Integer bidProcess;

    @ApiModelProperty("开标状态")
    private Integer bidOpenState;


    public Integer getBidProcess() {
        return bidProcess;
    }

    public void setBidProcess(Integer bidProcess) {
        this.bidProcess = bidProcess;
    }

    public Integer getBidOpenState() {
        return bidOpenState;
    }

    public void setBidOpenState(Integer bidOpenState) {
        this.bidOpenState = bidOpenState;
    }

    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织id
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织id
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部所属组织id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部所属组织id
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部所属组织
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部所属组织
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 采购主题
     */
    public String getPurchaseSubject() {
        return purchaseSubject;
    }

    /**
     * 采购主题
     */
    public void setPurchaseSubject(String purchaseSubject) {
        this.purchaseSubject = purchaseSubject;
    }
    /**
     * 采购方式：1-项目自采；2-集中采购
     */
    public Integer getPurchaseType() {
        return purchaseType;
    }

    /**
     * 采购方式：1-项目自采；2-集中采购
     */
    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    /**
     * 计价方式：1-采购；2-租赁
     */
    public Integer getPricingType() {
        return pricingType;
    }

    /**
     * 计价方式：1-采购；2-租赁
     */
    public void setPricingType(Integer pricingType) {
        this.pricingType = pricingType;
    }

    public String getPricingTypeName() {
        return pricingTypeName;
    }

    public void setPricingTypeName(String pricingTypeName) {
        this.pricingTypeName = pricingTypeName;
    }

    /**
     * 报价权限：1-指定供应商；2-所有供应商
     */
    public Integer getQuotationAuthority() {
        return quotationAuthority;
    }

    /**
     * 报价权限：1-指定供应商；2-所有供应商
     */
    public void setQuotationAuthority(Integer quotationAuthority) {
        this.quotationAuthority = quotationAuthority;
    }

    public String getQuotationAuthorityName() {
        return quotationAuthorityName;
    }

    public void setQuotationAuthorityName(String quotationAuthorityName) {
        this.quotationAuthorityName = quotationAuthorityName;
    }

    /**
     * 查看权限：1-指定供应商：2-所有供应商登录后查看；3-所有供应商免登录查看
     */
    public Integer getViewAuthority() {
        return viewAuthority;
    }

    /**
     * 查看权限：1-指定供应商：2-所有供应商登录后查看；3-所有供应商免登录查看
     */
    public void setViewAuthority(Integer viewAuthority) {
        this.viewAuthority = viewAuthority;
    }

    public String getViewAuthorityName() {
        return viewAuthorityName;
    }

    public void setViewAuthorityName(String viewAuthorityName) {
        this.viewAuthorityName = viewAuthorityName;
    }

    /**
     * 询价金额
     */
    public BigDecimal getInquiryMny() {
        return inquiryMny;
    }

    /**
     * 询价金额
     */
    public void setInquiryMny(BigDecimal inquiryMny) {
        this.inquiryMny = inquiryMny;
    }
    /**
     * 计划使用日期
     */
    public Date getPlanUseDate() {
        return planUseDate;
    }

    /**
     * 计划使用日期
     */
    public void setPlanUseDate(Date planUseDate) {
        this.planUseDate = planUseDate;
    }
    /**
     * 经办人id
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人id
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办人部门id
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办人部门id
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办人部门
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办人部门
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 询价日期
     */
    public Date getInquiryDate() {
        return inquiryDate;
    }

    /**
     * 询价日期
     */
    public void setInquiryDate(Date inquiryDate) {
        this.inquiryDate = inquiryDate;
    }
    /**
     * 联系人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getContactsId() {
        return contactsId;
    }

    /**
     * 联系人
     */
    @ReferDeserialTransfer
    public void setContactsId(Long contactsId) {
        this.contactsId = contactsId;
    }
    /**
     * 联系人姓名
     */
    public String getContactsName() {
        return contactsName;
    }

    /**
     * 联系人姓名
     */
    public void setContactsName(String contactsName) {
        this.contactsName = contactsName;
    }
    /**
     * 联系电话
     */
    public String getPhone() {
        return phone;
    }

    /**
     * 联系电话
     */
    public void setPhone(String phone) {
        this.phone = phone;
    }
    /**
     * 报价截止日期
     */
    public Date getQuoteEndDate() {
        return quoteEndDate;
    }

    /**
     * 报价截止日期
     */
    public void setQuoteEndDate(Date quoteEndDate) {
        this.quoteEndDate = quoteEndDate;
    }
    /**
     * 发票要求
     */
    public String getInvoiceRequirement() {
        return invoiceRequirement;
    }

    /**
     * 发票要求
     */
    public void setInvoiceRequirement(String invoiceRequirement) {
        this.invoiceRequirement = invoiceRequirement;
    }
    /**
     * 付款方式
     */
    public String getPaymentMethod() {
        return paymentMethod;
    }

    /**
     * 付款方式
     */
    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }
    /**
     * 询价说明
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 询价说明
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 询价状态：1-未开始；2-报价中；3-已截止；4-已定标
     */
    public Integer getInquiryState() {
        return inquiryState;
    }

    /**
     * 询价状态：1-未开始；2-报价中；3-已截止；4-已定标
     */
    public void setInquiryState(Integer inquiryState) {
        this.inquiryState = inquiryState;
    }

    public String getInquiryStateName() {
        return inquiryStateName;
    }

    public void setInquiryStateName(String inquiryStateName) {
        this.inquiryStateName = inquiryStateName;
    }

    /**
      * 材料询价-采购清单
      */
      public List<MaterialInquiryPurchaseDetailVO> getMaterialInquiryPurchaseDetailList() {
         return materialInquiryPurchaseDetailList;
      }
     /**
      * 材料询价-采购清单
      */
     public void setMaterialInquiryPurchaseDetailList(List<MaterialInquiryPurchaseDetailVO> materialInquiryPurchaseDetailList) {
         this.materialInquiryPurchaseDetailList = materialInquiryPurchaseDetailList;
     }
     /**
      * 材料询价-租赁清单
      */
      public List<MaterialInquiryRentDetailVO> getMaterialInquiryRentDetailList() {
         return materialInquiryRentDetailList;
      }
     /**
      * 材料询价-租赁清单
      */
     public void setMaterialInquiryRentDetailList(List<MaterialInquiryRentDetailVO> materialInquiryRentDetailList) {
         this.materialInquiryRentDetailList = materialInquiryRentDetailList;
     }
     /**
      * 材料询价-候选供应商
      */
      public List<MaterialInquirySupplierVO> getMaterialInquirySupplierList() {
         return materialInquirySupplierList;
      }
     /**
      * 材料询价-候选供应商
      */
     public void setMaterialInquirySupplierList(List<MaterialInquirySupplierVO> materialInquirySupplierList) {
         this.materialInquirySupplierList = materialInquirySupplierList;
     }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Boolean getQuoteEndFlag() {
        return quoteEndFlag;
    }

    public void setQuoteEndFlag(Boolean quoteEndFlag) {
        this.quoteEndFlag = quoteEndFlag;
    }
}
